/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import com.mixpanel.android.util.MPLog;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class ConfigurationChecker {
    public static String LOGTAG = "MixpanelAPI.ConfigurationChecker";

    ConfigurationChecker() {
    }

    public static boolean checkBasicConfiguration(Context context) {
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        if (packageManager == null || packageName == null) {
            MPLog.w(LOGTAG, "Can't check configuration when using a Context with null packageManager or packageName");
            return false;
        }
        if (0 != packageManager.checkPermission("android.permission.INTERNET", packageName)) {
            MPLog.w(LOGTAG, "Package does not have permission android.permission.INTERNET - Mixpanel will not work at all!");
            MPLog.i(LOGTAG, "You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.INTERNET\" />");
            return false;
        }
        return true;
    }

    public static boolean checkInstallReferrerConfiguration(Future<SharedPreferences> referrerPrefs) {
        try {
            SharedPreferences refPrefs;
            Class.forName("com.android.installreferrer.api.InstallReferrerStateListener");
            if (referrerPrefs != null && (refPrefs = referrerPrefs.get()).getAll().size() == 0) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            MPLog.d(LOGTAG, "Missing com.android.installreferrer dependency. Google Play Store referrer information won't be available.");
        }
        catch (InterruptedException e) {
            MPLog.w(LOGTAG, "Could not read referrer shared preferences.");
        }
        catch (ExecutionException e) {
            MPLog.w(LOGTAG, "Could not read referrer shared preferences.");
        }
        return false;
    }
}

