/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.Nullable;
import com.mixpanel.android.util.MPLog;

public class ActivityImageUtils {
    private static final String LOGTAG = "MixpanelAPI.ActImgUtils";

    @Nullable
    public static Bitmap getScaledScreenshot(Activity activity, int scaleWidth, int scaleHeight, boolean relativeScaleIfTrue) {
        View someView = activity.findViewById(0x1020002);
        View rootView = someView.getRootView();
        if (rootView.getWidth() <= 0 || rootView.getHeight() <= 0) {
            return null;
        }
        Bitmap original = Bitmap.createBitmap((int)rootView.getWidth(), (int)rootView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(original);
        Drawable backgroundDrawable = rootView.getBackground();
        if (backgroundDrawable != null) {
            backgroundDrawable.draw(canvas);
        } else {
            canvas.drawColor(-1);
        }
        rootView.draw(canvas);
        Bitmap scaled = null;
        if (null != original && original.getWidth() > 0 && original.getHeight() > 0) {
            if (relativeScaleIfTrue) {
                scaleWidth = original.getWidth() / scaleWidth;
                scaleHeight = original.getHeight() / scaleHeight;
            }
            if (scaleWidth > 0 && scaleHeight > 0) {
                try {
                    scaled = Bitmap.createScaledBitmap((Bitmap)original, (int)scaleWidth, (int)scaleHeight, (boolean)false);
                }
                catch (OutOfMemoryError error) {
                    MPLog.i(LOGTAG, "Not enough memory to produce scaled image, returning a null screenshot");
                }
            }
        }
        return scaled;
    }

    public static int getHighlightColorFromBackground(Activity activity) {
        int incolor = -16777216;
        Bitmap screenshot1px = ActivityImageUtils.getScaledScreenshot(activity, 1, 1, false);
        if (null != screenshot1px) {
            incolor = screenshot1px.getPixel(0, 0);
        }
        return ActivityImageUtils.getHighlightColor(incolor);
    }

    public static int getHighlightColorFromBitmap(Bitmap bitmap) {
        int incolor = -16777216;
        if (null != bitmap) {
            Bitmap bitmap1px = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)1, (int)1, (boolean)false);
            incolor = bitmap1px.getPixel(0, 0);
        }
        return ActivityImageUtils.getHighlightColor(incolor);
    }

    public static int getHighlightColor(int sampleColor) {
        float[] hsvBackground = new float[3];
        Color.colorToHSV((int)sampleColor, (float[])hsvBackground);
        hsvBackground[2] = 0.3f;
        return Color.HSVToColor((int)242, (float[])hsvBackground);
    }
}

