/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.mixpanel.android.util.MPLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

class SystemInformation {
    private final Context mContext;
    private final Boolean mHasNFC;
    private final Boolean mHasTelephony;
    private final DisplayMetrics mDisplayMetrics;
    private final String mAppVersionName;
    private final Integer mAppVersionCode;
    private final String mAppName;
    private static SystemInformation sInstance;
    private static final Object sInstanceLock;
    private static final String LOGTAG = "MixpanelAPI.SysInfo";
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static SystemInformation getInstance(Context context) {
        boolean[] blArray = SystemInformation.$jacocoInit();
        Object object = sInstanceLock;
        synchronized (object) {
            try {
                blArray[0] = true;
                if (null != sInstance) {
                    blArray[1] = true;
                } else {
                    void appContext;
                    Context context2;
                    blArray[2] = true;
                    Context context3 = context2.getApplicationContext();
                    blArray[3] = true;
                    sInstance = new SystemInformation((Context)appContext);
                    blArray[4] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[5] = true;
                throw throwable;
            }
        }
        blArray[6] = true;
        return sInstance;
    }

    /*
     * WARNING - void declaration
     */
    private SystemInformation(Context context) {
        void display;
        Method hasSystemFeatureMethod;
        String string;
        Integer foundAppVersionCode;
        void context2;
        boolean[] blArray = SystemInformation.$jacocoInit();
        this.mContext = context2;
        blArray[7] = true;
        PackageManager packageManager = this.mContext.getPackageManager();
        String foundAppVersionName = null;
        Object var5_5 = null;
        try {
            blArray[8] = true;
            PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
            foundAppVersionName = packageInfo.versionName;
            blArray[9] = true;
            foundAppVersionCode = packageInfo.versionCode;
            blArray[10] = true;
        }
        catch (PackageManager.NameNotFoundException packageInfo) {
            blArray[11] = true;
            MPLog.w(LOGTAG, "System information constructed with a context that apparently doesn't exist.");
            blArray[12] = true;
        }
        ApplicationInfo applicationInfo = context2.getApplicationInfo();
        int appNameStringId = applicationInfo.labelRes;
        this.mAppVersionName = foundAppVersionName;
        this.mAppVersionCode = foundAppVersionCode;
        blArray[13] = true;
        if (appNameStringId == 0) {
            if (applicationInfo.nonLocalizedLabel == null) {
                string = "Misc";
                blArray[14] = true;
            } else {
                string = applicationInfo.nonLocalizedLabel.toString();
                blArray[15] = true;
            }
        } else {
            string = context2.getString(appNameStringId);
            blArray[16] = true;
        }
        this.mAppName = string;
        blArray[17] = true;
        Class<?> packageManagerClass = packageManager.getClass();
        Object var9_10 = null;
        try {
            blArray[18] = true;
            hasSystemFeatureMethod = packageManagerClass.getMethod("hasSystemFeature", String.class);
            blArray[19] = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            blArray[20] = true;
        }
        Boolean foundNFC = null;
        Boolean foundTelephony = null;
        if (null == hasSystemFeatureMethod) {
            blArray[21] = true;
        } else {
            try {
                blArray[22] = true;
                foundNFC = (Boolean)hasSystemFeatureMethod.invoke((Object)packageManager, "android.hardware.nfc");
                blArray[23] = true;
                foundTelephony = (Boolean)hasSystemFeatureMethod.invoke((Object)packageManager, "android.hardware.telephony");
                blArray[24] = true;
            }
            catch (InvocationTargetException invocationTargetException) {
                blArray[25] = true;
                MPLog.w(LOGTAG, "System version appeared to support PackageManager.hasSystemFeature, but we were unable to call it.");
                blArray[26] = true;
            }
            catch (IllegalAccessException e) {
                blArray[27] = true;
                MPLog.w(LOGTAG, "System version appeared to support PackageManager.hasSystemFeature, but we were unable to call it.");
                blArray[28] = true;
            }
        }
        this.mHasNFC = foundNFC;
        this.mHasTelephony = foundTelephony;
        blArray[29] = true;
        this.mDisplayMetrics = new DisplayMetrics();
        blArray[30] = true;
        Display e = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
        blArray[31] = true;
        display.getMetrics(this.mDisplayMetrics);
        blArray[32] = true;
    }

    public String getAppVersionName() {
        boolean[] blArray = SystemInformation.$jacocoInit();
        blArray[33] = true;
        return this.mAppVersionName;
    }

    public Integer getAppVersionCode() {
        boolean[] blArray = SystemInformation.$jacocoInit();
        blArray[34] = true;
        return this.mAppVersionCode;
    }

    public String getAppName() {
        boolean[] blArray = SystemInformation.$jacocoInit();
        blArray[35] = true;
        return this.mAppName;
    }

    public boolean hasNFC() {
        boolean[] blArray = SystemInformation.$jacocoInit();
        blArray[36] = true;
        return this.mHasNFC;
    }

    public boolean hasTelephony() {
        boolean[] blArray = SystemInformation.$jacocoInit();
        blArray[37] = true;
        return this.mHasTelephony;
    }

    public DisplayMetrics getDisplayMetrics() {
        boolean[] blArray = SystemInformation.$jacocoInit();
        blArray[38] = true;
        return this.mDisplayMetrics;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"MissingPermission"})
    public String getPhoneRadioType(Context context) {
        void packageManager;
        String packageName;
        block27: {
            block26: {
                block25: {
                    void context2;
                    boolean[] blArray = SystemInformation.$jacocoInit();
                    PackageManager packageManager2 = context2.getPackageManager();
                    blArray[39] = true;
                    packageName = context2.getPackageName();
                    if (packageManager != null) break block25;
                    blArray[40] = true;
                    break block26;
                }
                if (packageName != null) break block27;
                blArray[41] = true;
            }
            blArray[42] = true;
            return null;
        }
        if (0 != packageManager.checkPermission("android.permission.READ_PHONE_STATE", packageName)) {
            blArray[43] = true;
            MPLog.w(LOGTAG, "Permission READ_PHONE_STATE not granted. Property $radio will not be available.");
            blArray[44] = true;
            return null;
        }
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (null != telephonyManager) {
            int networkType;
            if (Build.VERSION.SDK_INT >= 24) {
                blArray[45] = true;
                networkType = telephonyManager.getDataNetworkType();
                blArray[46] = true;
            } else {
                networkType = telephonyManager.getNetworkType();
                blArray[47] = true;
            }
            switch (networkType) {
                case 7: {
                    blArray[48] = true;
                    return "1xRTT";
                }
                case 4: {
                    blArray[49] = true;
                    return "CDMA";
                }
                case 2: {
                    blArray[50] = true;
                    return "EDGE";
                }
                case 14: {
                    blArray[51] = true;
                    return "eHRPD";
                }
                case 5: {
                    blArray[52] = true;
                    return "EVDO rev. 0";
                }
                case 6: {
                    blArray[53] = true;
                    return "EVDO rev. A";
                }
                case 12: {
                    blArray[54] = true;
                    return "EVDO rev. B";
                }
                case 1: {
                    blArray[55] = true;
                    return "GPRS";
                }
                case 8: {
                    blArray[56] = true;
                    return "HSDPA";
                }
                case 10: {
                    blArray[57] = true;
                    return "HSPA";
                }
                case 15: {
                    blArray[58] = true;
                    return "HSPA+";
                }
                case 9: {
                    blArray[59] = true;
                    return "HSUPA";
                }
                case 11: {
                    blArray[60] = true;
                    return "iDen";
                }
                case 13: {
                    blArray[61] = true;
                    return "LTE";
                }
                case 3: {
                    blArray[62] = true;
                    return "UMTS";
                }
                case 0: {
                    blArray[63] = true;
                    return "Unknown";
                }
            }
            blArray[64] = true;
            return null;
        }
        blArray[65] = true;
        return null;
    }

    public String getCurrentNetworkOperator() {
        String ret;
        boolean[] blArray = SystemInformation.$jacocoInit();
        Object var2_2 = null;
        blArray[66] = true;
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (null == telephonyManager) {
            blArray[67] = true;
        } else {
            blArray[68] = true;
            ret = telephonyManager.getNetworkOperatorName();
            blArray[69] = true;
        }
        blArray[70] = true;
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"MissingPermission"})
    public Boolean isWifiConnected() {
        block3: {
            block5: {
                block4: {
                    block2: {
                        var1_1 = SystemInformation.$jacocoInit();
                        var2_2 = null;
                        var1_1[71] = true;
                        if (0 == this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE")) break block2;
                        var1_1[72] = true;
                        break block3;
                    }
                    var1_1[73] = true;
                    var3_3 = (ConnectivityManager)this.mContext.getSystemService("connectivity");
                    var1_1[74] = true;
                    var4_4 = connManager.getActiveNetworkInfo();
                    var1_1[75] = true;
                    if (networkInfo != null) break block4;
                    var1_1[76] = true;
                    ** GOTO lbl25
                }
                if (networkInfo.getType() == 1) break block5;
                var1_1[77] = true;
                ** GOTO lbl25
            }
            if (networkInfo.isConnected()) {
                v0 = var1_1[79] = true;
            } else {
                var1_1[78] = true;
lbl25:
                // 3 sources

                v0 = false;
                var1_1[80] = true;
            }
            ret = v0;
            var1_1[81] = true;
        }
        var1_1[82] = true;
        return ret;
    }

    @SuppressLint(value={"MissingPermission"})
    public Boolean isBluetoothEnabled() {
        Boolean isBluetoothEnabled;
        block5: {
            boolean[] blArray = SystemInformation.$jacocoInit();
            Object var2_2 = null;
            try {
                blArray[83] = true;
                PackageManager pm = this.mContext.getPackageManager();
                blArray[84] = true;
                blArray[85] = true;
                int hasBluetoothPermission = pm.checkPermission("android.permission.BLUETOOTH", this.mContext.getPackageName());
                if (hasBluetoothPermission != 0) {
                    blArray[86] = true;
                    break block5;
                }
                blArray[87] = true;
                BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (bluetoothAdapter == null) {
                    blArray[88] = true;
                    break block5;
                }
                blArray[89] = true;
                isBluetoothEnabled = bluetoothAdapter.isEnabled();
                blArray[90] = true;
            }
            catch (SecurityException securityException) {
                blArray[92] = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                blArray[93] = true;
            }
        }
        blArray[91] = true;
        blArray[94] = true;
        return isBluetoothEnabled;
    }

    /*
     * Unable to fully structure code
     */
    public String getBluetoothVersion() {
        block4: {
            var1_1 = SystemInformation.$jacocoInit();
            bluetoothVersion = "none";
            if (Build.VERSION.SDK_INT >= 18) break block4;
            var1_1[95] = true;
            ** GOTO lbl13
        }
        var1_1[96] = true;
        if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            bluetoothVersion = "ble";
            var1_1[98] = true;
        } else {
            var1_1[97] = true;
lbl13:
            // 2 sources

            if (!this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                var1_1[99] = true;
            } else {
                bluetoothVersion = "classic";
                var1_1[100] = true;
            }
        }
        var1_1[101] = true;
        return bluetoothVersion;
    }

    static {
        boolean[] blArray = SystemInformation.$jacocoInit();
        sInstanceLock = new Object();
        blArray[102] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)367613058206253159L, (String)"com/mixpanel/android/mpmetrics/SystemInformation", (int)103);
        }
        return blArray;
    }
}

