/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import java.lang.ref.WeakReference;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=14)
class MixpanelActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private Handler mHandler;
    private Runnable check;
    private boolean mIsForeground;
    private boolean mPaused;
    private static Double sStartSessionTime;
    public static final int CHECK_DELAY = 500;
    private final MixpanelAPI mMpInstance;
    private final MPConfig mConfig;
    private WeakReference<Activity> mCurrentActivity;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public MixpanelActivityLifecycleCallbacks(MixpanelAPI mixpanelAPI, MPConfig mPConfig) {
        void config;
        void mpInstance;
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[0] = true;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mIsForeground = false;
        this.mPaused = true;
        this.mMpInstance = mpInstance;
        this.mConfig = config;
        if (sStartSessionTime != null) {
            blArray[1] = true;
        } else {
            blArray[2] = true;
            sStartSessionTime = System.currentTimeMillis();
            blArray[3] = true;
        }
        blArray[4] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void onActivityStarted(Activity activity) {
        void activity2;
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        this.trackCampaignOpenedIfNeeded(activity2.getIntent());
        blArray[5] = true;
        if (Build.VERSION.SDK_INT < 16) {
            blArray[6] = true;
        } else if (!this.mConfig.getAutoShowMixpanelUpdates()) {
            blArray[7] = true;
        } else {
            blArray[8] = true;
            this.mMpInstance.getPeople().showNotificationIfAvailable((Activity)activity2);
            blArray[9] = true;
        }
        blArray[10] = true;
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[11] = true;
    }

    public void onActivityPaused(Activity activity) {
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        this.mPaused = true;
        if (this.check == null) {
            blArray[12] = true;
        } else {
            blArray[13] = true;
            this.mHandler.removeCallbacks(this.check);
            blArray[14] = true;
        }
        this.mCurrentActivity = null;
        blArray[15] = true;
        this.check = new Runnable(this){
            final /* synthetic */ MixpanelActivityLifecycleCallbacks this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                boolean[] blArray = 1.$jacocoInit();
                if (!MixpanelActivityLifecycleCallbacks.access$000(this.this$0)) {
                    blArray[1] = true;
                } else if (!MixpanelActivityLifecycleCallbacks.access$100(this.this$0)) {
                    blArray[2] = true;
                } else {
                    blArray[3] = true;
                    MixpanelActivityLifecycleCallbacks.access$002(this.this$0, false);
                    try {
                        void sessionLength;
                        blArray[4] = true;
                        double d = (double)System.currentTimeMillis() - MixpanelActivityLifecycleCallbacks.access$200();
                        blArray[5] = true;
                        if (!(sessionLength >= (double)MixpanelActivityLifecycleCallbacks.access$300(this.this$0).getMinimumSessionDuration())) {
                            blArray[6] = true;
                        } else if (!(sessionLength < (double)MixpanelActivityLifecycleCallbacks.access$300(this.this$0).getSessionTimeoutDuration())) {
                            blArray[7] = true;
                        } else {
                            void elapsedTimeRounded;
                            void sessionProperties;
                            void elapsedTime;
                            void var4_4 = sessionLength / 1000.0;
                            blArray[8] = true;
                            double d2 = (double)Math.round((double)(elapsedTime * 10.0)) / 10.0;
                            blArray[9] = true;
                            JSONObject jSONObject = new JSONObject();
                            blArray[10] = true;
                            sessionProperties.put("$ae_session_length", (double)elapsedTimeRounded);
                            blArray[11] = true;
                            MixpanelActivityLifecycleCallbacks.access$400(this.this$0).getPeople().increment("$ae_total_app_sessions", 1.0);
                            blArray[12] = true;
                            MixpanelActivityLifecycleCallbacks.access$400(this.this$0).getPeople().increment("$ae_total_app_session_length", (double)elapsedTimeRounded);
                            blArray[13] = true;
                            MixpanelActivityLifecycleCallbacks.access$400(this.this$0).track("$ae_session", (JSONObject)sessionProperties, true);
                            blArray[14] = true;
                        }
                        blArray[15] = true;
                    }
                    catch (JSONException sessionLength) {
                        void e;
                        blArray[16] = true;
                        e.printStackTrace();
                        blArray[17] = true;
                    }
                    MixpanelActivityLifecycleCallbacks.access$400(this.this$0).onBackground();
                    blArray[18] = true;
                }
                blArray[19] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-2811621277285778775L, (String)"com/mixpanel/android/mpmetrics/MixpanelActivityLifecycleCallbacks$1", (int)20);
                }
                return blArray;
            }
        };
        this.mHandler.postDelayed(this.check, 500L);
        blArray[16] = true;
    }

    public void onActivityDestroyed(Activity activity) {
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[17] = true;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[18] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void onActivityResumed(Activity activity) {
        boolean bl;
        void activity2;
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        if (Build.VERSION.SDK_INT < 16) {
            blArray[19] = true;
        } else if (!this.mConfig.getAutoShowMixpanelUpdates()) {
            blArray[20] = true;
        } else {
            blArray[21] = true;
            this.mMpInstance.getPeople().joinExperimentIfAvailable();
            blArray[22] = true;
        }
        this.mCurrentActivity = new WeakReference<void>(activity2);
        this.mPaused = false;
        if (!this.mIsForeground) {
            bl = blArray[23] = true;
        } else {
            bl = false;
            blArray[24] = true;
        }
        boolean wasBackground = bl;
        this.mIsForeground = true;
        if (this.check == null) {
            blArray[25] = true;
        } else {
            blArray[26] = true;
            this.mHandler.removeCallbacks(this.check);
            blArray[27] = true;
        }
        if (!wasBackground) {
            blArray[28] = true;
        } else {
            blArray[29] = true;
            sStartSessionTime = System.currentTimeMillis();
            blArray[30] = true;
            this.mMpInstance.onForeground();
            blArray[31] = true;
        }
        blArray[32] = true;
    }

    public void onActivityStopped(Activity activity) {
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[33] = true;
    }

    protected boolean isInForeground() {
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[34] = true;
        return this.mIsForeground;
    }

    protected Activity getCurrentActivity() {
        Activity activity;
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        if (this.mCurrentActivity != null) {
            activity = (Activity)this.mCurrentActivity.get();
            blArray[35] = true;
        } else {
            activity = null;
            blArray[36] = true;
        }
        blArray[37] = true;
        return activity;
    }

    /*
     * WARNING - void declaration
     */
    private void trackCampaignOpenedIfNeeded(Intent intent) {
        void intent2;
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        if (intent2 == null) {
            blArray[38] = true;
            return;
        }
        if (!intent2.hasExtra("mp_campaign_id")) {
            blArray[39] = true;
        } else if (!intent2.hasExtra("mp_message_id")) {
            blArray[40] = true;
        } else {
            blArray[41] = true;
            MixpanelAPI.trackPushNotificationEventFromIntent(this.mMpInstance.getContext(), (Intent)intent2, "$app_open");
            blArray[42] = true;
        }
        blArray[43] = true;
    }

    static /* synthetic */ boolean access$000(MixpanelActivityLifecycleCallbacks mixpanelActivityLifecycleCallbacks) {
        MixpanelActivityLifecycleCallbacks x0;
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[44] = true;
        return x0.mIsForeground;
    }

    static /* synthetic */ boolean access$100(MixpanelActivityLifecycleCallbacks mixpanelActivityLifecycleCallbacks) {
        MixpanelActivityLifecycleCallbacks x0;
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[45] = true;
        return x0.mPaused;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$002(MixpanelActivityLifecycleCallbacks mixpanelActivityLifecycleCallbacks, boolean bl) {
        MixpanelActivityLifecycleCallbacks x0;
        void x1;
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        x0.mIsForeground = x1;
        blArray[46] = true;
        return x0.mIsForeground;
    }

    static /* synthetic */ Double access$200() {
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[47] = true;
        return sStartSessionTime;
    }

    static /* synthetic */ MPConfig access$300(MixpanelActivityLifecycleCallbacks mixpanelActivityLifecycleCallbacks) {
        MixpanelActivityLifecycleCallbacks x0;
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[48] = true;
        return x0.mConfig;
    }

    static /* synthetic */ MixpanelAPI access$400(MixpanelActivityLifecycleCallbacks mixpanelActivityLifecycleCallbacks) {
        MixpanelActivityLifecycleCallbacks x0;
        boolean[] blArray = MixpanelActivityLifecycleCallbacks.$jacocoInit();
        blArray[49] = true;
        return x0.mMpInstance;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-6204521402539324502L, (String)"com/mixpanel/android/mpmetrics/MixpanelActivityLifecycleCallbacks", (int)50);
        }
        return blArray;
    }
}

