/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import com.google.android.gms.common.GoogleApiAvailability;
import com.mixpanel.android.mpmetrics.DecideChecker;
import com.mixpanel.android.mpmetrics.DecideMessages;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MPDbAdapter;
import com.mixpanel.android.mpmetrics.SystemInformation;
import com.mixpanel.android.util.Base64Coder;
import com.mixpanel.android.util.HttpService;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.RemoteService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;
import org.json.JSONException;
import org.json.JSONObject;

class AnalyticsMessages {
    private final Worker mWorker;
    protected final Context mContext;
    protected final MPConfig mConfig;
    private static final int ENQUEUE_PEOPLE = 0;
    private static final int ENQUEUE_EVENTS = 1;
    private static final int FLUSH_QUEUE = 2;
    private static final int ENQUEUE_GROUP = 3;
    private static final int PUSH_ANONYMOUS_PEOPLE_RECORDS = 4;
    private static final int KILL_WORKER = 5;
    private static final int EMPTY_QUEUES = 6;
    private static final int CLEAR_ANONYMOUS_UPDATES = 7;
    private static final int REWRITE_EVENT_PROPERTIES = 8;
    private static final int INSTALL_DECIDE_CHECK = 12;
    private static final String LOGTAG = "MixpanelAPI.Messages";
    private static final Map<Context, AnalyticsMessages> sInstances;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    AnalyticsMessages(Context context) {
        void context2;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        this.mContext = context2;
        blArray[0] = true;
        this.mConfig = this.getConfig((Context)context2);
        blArray[1] = true;
        this.mWorker = this.createWorker();
        blArray[2] = true;
        this.getPoster().checkIsMixpanelBlocked();
        blArray[3] = true;
    }

    protected Worker createWorker() {
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        blArray[4] = true;
        return new Worker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static AnalyticsMessages getInstance(Context context) {
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Map<Context, AnalyticsMessages> map = sInstances;
        synchronized (map) {
            try {
                AnalyticsMessages ret;
                void appContext;
                Context messageContext;
                blArray[5] = true;
                Context context2 = messageContext.getApplicationContext();
                blArray[6] = true;
                if (!sInstances.containsKey(appContext)) {
                    blArray[7] = true;
                    AnalyticsMessages analyticsMessages = new AnalyticsMessages((Context)appContext);
                    blArray[8] = true;
                    sInstances.put((Context)appContext, ret);
                    blArray[9] = true;
                } else {
                    ret = sInstances.get(appContext);
                    blArray[10] = true;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[11] = true;
                return ret;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl22 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[12] = true;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void eventsMessage(EventDescription eventDescription) {
        void eventDescription2;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Message m = Message.obtain();
        m.what = 1;
        m.obj = eventDescription2;
        blArray[13] = true;
        this.mWorker.runMessage(m);
        blArray[14] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void peopleMessage(PeopleDescription peopleDescription) {
        void peopleDescription2;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Message m = Message.obtain();
        m.what = 0;
        m.obj = peopleDescription2;
        blArray[15] = true;
        this.mWorker.runMessage(m);
        blArray[16] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void groupMessage(GroupDescription groupDescription) {
        void groupDescription2;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Message m = Message.obtain();
        m.what = 3;
        m.obj = groupDescription2;
        blArray[17] = true;
        this.mWorker.runMessage(m);
        blArray[18] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void pushAnonymousPeopleMessage(PushAnonymousPeopleDescription pushAnonymousPeopleDescription) {
        void pushAnonymousPeopleDescription2;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Message m = Message.obtain();
        m.what = 4;
        m.obj = pushAnonymousPeopleDescription2;
        blArray[19] = true;
        this.mWorker.runMessage(m);
        blArray[20] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void clearAnonymousUpdatesMessage(MixpanelDescription mixpanelDescription) {
        void clearAnonymousUpdatesDescription;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Message m = Message.obtain();
        m.what = 7;
        m.obj = clearAnonymousUpdatesDescription;
        blArray[21] = true;
        this.mWorker.runMessage(m);
        blArray[22] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void postToServer(FlushDescription flushDescription) {
        int n;
        void flushDescription2;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Message m = Message.obtain();
        m.what = 2;
        blArray[23] = true;
        m.obj = flushDescription2.getToken();
        blArray[24] = true;
        if (flushDescription2.shouldCheckDecide()) {
            n = blArray[25] = 1;
        } else {
            n = 0;
            blArray[26] = true;
        }
        m.arg1 = n;
        blArray[27] = true;
        this.mWorker.runMessage(m);
        blArray[28] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void installDecideCheck(DecideMessages decideMessages) {
        void check;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Message m = Message.obtain();
        m.what = 12;
        m.obj = check;
        blArray[29] = true;
        this.mWorker.runMessage(m);
        blArray[30] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void emptyTrackingQueues(MixpanelDescription mixpanelDescription) {
        void mixpanelDescription2;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Message m = Message.obtain();
        m.what = 6;
        m.obj = mixpanelDescription2;
        blArray[31] = true;
        this.mWorker.runMessage(m);
        blArray[32] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void updateEventProperties(UpdateEventsPropertiesDescription updateEventsPropertiesDescription) {
        void updateEventsProperties;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Message m = Message.obtain();
        m.what = 8;
        m.obj = updateEventsProperties;
        blArray[33] = true;
        this.mWorker.runMessage(m);
        blArray[34] = true;
    }

    public void hardKill() {
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        Message m = Message.obtain();
        m.what = 5;
        blArray[35] = true;
        this.mWorker.runMessage(m);
        blArray[36] = true;
    }

    boolean isDead() {
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        blArray[37] = true;
        return this.mWorker.isDead();
    }

    /*
     * WARNING - void declaration
     */
    protected MPDbAdapter makeDbAdapter(Context context) {
        void context2;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        blArray[38] = true;
        return MPDbAdapter.getInstance((Context)context2);
    }

    /*
     * WARNING - void declaration
     */
    protected MPConfig getConfig(Context context) {
        void context2;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        blArray[39] = true;
        return MPConfig.getInstance((Context)context2);
    }

    protected RemoteService getPoster() {
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        blArray[40] = true;
        return new HttpService();
    }

    /*
     * WARNING - void declaration
     */
    private void logAboutMessageToMixpanel(String string) {
        void message;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        MPLog.v(LOGTAG, (String)message + " (Thread " + Thread.currentThread().getId() + ")");
        blArray[41] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void logAboutMessageToMixpanel(String string, Throwable throwable) {
        void e;
        void message;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        MPLog.v(LOGTAG, (String)message + " (Thread " + Thread.currentThread().getId() + ")", (Throwable)e);
        blArray[42] = true;
    }

    public long getTrackEngageRetryAfter() {
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        blArray[43] = true;
        return ((Worker.AnalyticsMessageHandler)Worker.access$400(this.mWorker)).getTrackEngageRetryAfter();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(AnalyticsMessages analyticsMessages, String string) {
        void x1;
        AnalyticsMessages x0;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        x0.logAboutMessageToMixpanel((String)x1);
        blArray[44] = true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(AnalyticsMessages analyticsMessages, String string, Throwable throwable) {
        void x2;
        void x1;
        AnalyticsMessages x0;
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        x0.logAboutMessageToMixpanel((String)x1, (Throwable)x2);
        blArray[45] = true;
    }

    static {
        boolean[] blArray = AnalyticsMessages.$jacocoInit();
        sInstances = new HashMap<Context, AnalyticsMessages>();
        blArray[46] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)671292404383085159L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages", (int)47);
        }
        return blArray;
    }

    class Worker {
        private final Object mHandlerLock;
        private Handler mHandler;
        private long mFlushCount;
        private long mAveFlushFrequency;
        private long mLastFlushTime;
        private SystemInformation mSystemInformation;
        final /* synthetic */ AnalyticsMessages this$0;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public Worker(AnalyticsMessages analyticsMessages) {
            void this$0;
            boolean[] blArray = Worker.$jacocoInit();
            this.this$0 = this$0;
            blArray[0] = true;
            this.mHandlerLock = new Object();
            this.mFlushCount = 0L;
            this.mAveFlushFrequency = 0L;
            this.mLastFlushTime = -1L;
            blArray[1] = true;
            this.mHandler = this.restartWorkerThread();
            blArray[2] = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isDead() {
            boolean[] blArray = Worker.$jacocoInit();
            Object object = this.mHandlerLock;
            synchronized (object) {
                try {
                    boolean bl;
                    blArray[3] = true;
                    if (this.mHandler == null) {
                        bl = blArray[4] = true;
                    } else {
                        bl = false;
                        blArray[5] = true;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : object
                    blArray[6] = true;
                    return bl;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : object
                    blArray[7] = true;
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void runMessage(Message message) {
            boolean[] blArray = Worker.$jacocoInit();
            Object object = this.mHandlerLock;
            synchronized (object) {
                try {
                    void msg;
                    blArray[8] = true;
                    if (this.mHandler == null) {
                        blArray[9] = true;
                        AnalyticsMessages.access$000(this.this$0, "Dead mixpanel worker dropping a message: " + msg.what);
                        blArray[10] = true;
                    } else {
                        this.mHandler.sendMessage((Message)msg);
                        blArray[11] = true;
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var3_3
                    blArray[12] = true;
                    throw throwable;
                }
            }
            blArray[13] = true;
        }

        /*
         * WARNING - void declaration
         */
        protected Handler restartWorkerThread() {
            void thread;
            boolean[] blArray = Worker.$jacocoInit();
            HandlerThread handlerThread = new HandlerThread("com.mixpanel.android.AnalyticsWorker", 10);
            blArray[14] = true;
            thread.start();
            blArray[15] = true;
            AnalyticsMessageHandler ret = new AnalyticsMessageHandler(this, thread.getLooper());
            blArray[16] = true;
            return ret;
        }

        /*
         * WARNING - void declaration
         */
        private void updateFlushFrequency() {
            boolean[] blArray = Worker.$jacocoInit();
            long now = System.currentTimeMillis();
            long newFlushCount = this.mFlushCount + 1L;
            if (this.mLastFlushTime <= 0L) {
                blArray[17] = true;
            } else {
                void seconds;
                long flushInterval = now - this.mLastFlushTime;
                long totalFlushTime = flushInterval + this.mAveFlushFrequency * this.mFlushCount;
                this.mAveFlushFrequency = totalFlushTime / newFlushCount;
                long l = this.mAveFlushFrequency / 1000L;
                blArray[18] = true;
                AnalyticsMessages.access$000(this.this$0, "Average send frequency approximately " + (long)seconds + " seconds.");
                blArray[19] = true;
            }
            this.mLastFlushTime = now;
            this.mFlushCount = newFlushCount;
            blArray[20] = true;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ SystemInformation access$102(Worker worker, SystemInformation systemInformation) {
            Worker x0;
            void x1;
            boolean[] blArray = Worker.$jacocoInit();
            x0.mSystemInformation = x1;
            blArray[21] = true;
            return x0.mSystemInformation;
        }

        static /* synthetic */ void access$200(Worker worker) {
            Worker x0;
            boolean[] blArray = Worker.$jacocoInit();
            x0.updateFlushFrequency();
            blArray[22] = true;
        }

        static /* synthetic */ Object access$300(Worker worker) {
            Worker x0;
            boolean[] blArray = Worker.$jacocoInit();
            blArray[23] = true;
            return x0.mHandlerLock;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Handler access$402(Worker worker, Handler handler) {
            Worker x0;
            void x1;
            boolean[] blArray = Worker.$jacocoInit();
            x0.mHandler = x1;
            blArray[24] = true;
            return x0.mHandler;
        }

        static /* synthetic */ SystemInformation access$100(Worker worker) {
            Worker x0;
            boolean[] blArray = Worker.$jacocoInit();
            blArray[25] = true;
            return x0.mSystemInformation;
        }

        static /* synthetic */ Handler access$400(Worker worker) {
            Worker x0;
            boolean[] blArray = Worker.$jacocoInit();
            blArray[26] = true;
            return x0.mHandler;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-535171681133916522L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages$Worker", (int)27);
            }
            return blArray;
        }

        class AnalyticsMessageHandler
        extends Handler {
            private MPDbAdapter mDbAdapter;
            private final DecideChecker mDecideChecker;
            private final long mFlushInterval;
            private long mDecideRetryAfter;
            private long mTrackEngageRetryAfter;
            private int mFailedRetries;
            final /* synthetic */ Worker this$1;
            private static transient /* synthetic */ boolean[] $jacocoData;

            /*
             * WARNING - void declaration
             */
            public AnalyticsMessageHandler(Worker worker, Looper looper) {
                void looper2;
                void this$1;
                boolean[] blArray = AnalyticsMessageHandler.$jacocoInit();
                this.this$1 = this$1;
                blArray[0] = true;
                super((Looper)looper2);
                this.mDbAdapter = null;
                blArray[1] = true;
                Worker.access$102((Worker)this$1, SystemInformation.getInstance(this$1.this$0.mContext));
                blArray[2] = true;
                this.mDecideChecker = this.createDecideChecker();
                blArray[3] = true;
                this.mFlushInterval = this$1.this$0.mConfig.getFlushInterval();
                blArray[4] = true;
            }

            protected DecideChecker createDecideChecker() {
                boolean[] blArray = AnalyticsMessageHandler.$jacocoInit();
                blArray[5] = true;
                return new DecideChecker(this.this$1.this$0.mContext, this.this$1.this$0.mConfig);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void handleMessage(Message var1_1) {
                block64: {
                    block71: {
                        block69: {
                            block70: {
                                block68: {
                                    block60: {
                                        block61: {
                                            block63: {
                                                block62: {
                                                    block66: {
                                                        var2_2 = AnalyticsMessageHandler.$jacocoInit();
                                                        if (this.mDbAdapter == null) break block66;
                                                        var2_2[6] = true;
                                                        ** GOTO lbl14
                                                    }
                                                    var2_2[7] = true;
                                                    this.mDbAdapter = this.this$1.this$0.makeDbAdapter(this.this$1.this$0.mContext);
                                                    var2_2[8] = true;
                                                    this.mDbAdapter.cleanupEvents(System.currentTimeMillis() - this.this$1.this$0.mConfig.getDataExpiration(), MPDbAdapter.Table.EVENTS);
                                                    var2_2[9] = true;
                                                    this.mDbAdapter.cleanupEvents(System.currentTimeMillis() - this.this$1.this$0.mConfig.getDataExpiration(), MPDbAdapter.Table.PEOPLE);
                                                    try {
                                                        var2_2[10] = true;
lbl14:
                                                        // 2 sources

                                                        returnCode = -3;
                                                        token = null;
                                                        if (msg.what == 0) {
                                                            var5_6 = (PeopleDescription)msg.obj;
                                                            var2_2[11] = true;
                                                            if (message.isAnonymous()) {
                                                                v0 = MPDbAdapter.Table.ANONYMOUS_PEOPLE;
                                                                var2_2[12] = true;
                                                            } else {
                                                                v0 = MPDbAdapter.Table.PEOPLE;
                                                                var2_2[13] = true;
                                                            }
                                                            var6_19 = v0;
                                                            var2_2[14] = true;
                                                            AnalyticsMessages.access$000(this.this$1.this$0, "Queuing people record for sending later");
                                                            var2_2[15] = true;
                                                            AnalyticsMessages.access$000(this.this$1.this$0, "    " + message.toString());
                                                            var2_2[16] = true;
                                                            token = message.getToken();
                                                            var2_2[17] = true;
                                                            var7_26 = this.mDbAdapter.addJSON(message.getMessage(), token, (MPDbAdapter.Table)peopleTable, false);
                                                            var2_2[18] = true;
                                                            if (message.isAnonymous()) {
                                                                v1 = 0;
                                                                var2_2[19] = true;
                                                            } else {
                                                                v1 = numRowsTable;
                                                                var2_2[20] = true;
                                                            }
                                                            returnCode = v1;
                                                            var2_2[21] = true;
                                                            break block60;
                                                        }
                                                        if (msg.what == 3) {
                                                            message = (GroupDescription)msg.obj;
                                                            var2_2[22] = true;
                                                            AnalyticsMessages.access$000(this.this$1.this$0, "Queuing group record for sending later");
                                                            var2_2[23] = true;
                                                            AnalyticsMessages.access$000(this.this$1.this$0, "    " + message.toString());
                                                            var2_2[24] = true;
                                                            token = message.getToken();
                                                            var2_2[25] = true;
                                                            returnCode = this.mDbAdapter.addJSON(message.getMessage(), token, MPDbAdapter.Table.GROUPS, false);
                                                            var2_2[26] = true;
                                                            break block60;
                                                        }
                                                        if (msg.what != 1) break block61;
                                                        message = (EventDescription)msg.obj;
                                                        try {
                                                            block67: {
                                                                var2_2[27] = true;
                                                                peopleTable = this.prepareEventObject((EventDescription)eventDescription);
                                                                var2_2[28] = true;
                                                                AnalyticsMessages.access$000(this.this$1.this$0, "Queuing event for sending later");
                                                                var2_2[29] = true;
                                                                AnalyticsMessages.access$000(this.this$1.this$0, "    " + message.toString());
                                                                var2_2[30] = true;
                                                                token = eventDescription.getToken();
                                                                var2_2[31] = true;
                                                                numRowsTable = this.mDecideChecker.getDecideMessages(token);
                                                                var2_2[32] = true;
                                                                if (decide != null) break block67;
                                                                var2_2[33] = true;
                                                                ** GOTO lbl-1000
                                                            }
                                                            if (!eventDescription.isAutomatic()) {
                                                                var2_2[34] = true;
                                                            } else {
                                                                if (!decide.shouldTrackAutomaticEvent()) break block62;
                                                                var2_2[35] = true;
                                                            }
                                                            ** GOTO lbl-1000
                                                        }
                                                        catch (JSONException message) {
                                                            var2_2[38] = true;
                                                            MPLog.e("MixpanelAPI.Messages", "Exception tracking event " + eventDescription.getEventName(), (Throwable)e);
                                                            var2_2[39] = true;
                                                            break block63;
                                                        }
                                                    }
                                                    catch (RuntimeException returnCode) {
                                                        var2_2[109] = true;
                                                        MPLog.e("MixpanelAPI.Messages", "Worker threw an unhandled exception", (Throwable)e);
                                                        var2_2[110] = true;
                                                        var4_5 = Worker.access$300(this.this$1);
                                                        synchronized (var4_5) {
                                                            try {
                                                                var2_2[111] = true;
                                                                Worker.access$402(this.this$1, null);
                                                                try {
                                                                    var2_2[112] = true;
                                                                    Looper.myLooper().quit();
                                                                    var2_2[113] = true;
                                                                    MPLog.e("MixpanelAPI.Messages", "Mixpanel will not process any more analytics messages", (Throwable)e);
                                                                    var2_2[114] = true;
                                                                }
                                                                catch (Exception flushMessage) {
                                                                    var2_2[115] = true;
                                                                    MPLog.e("MixpanelAPI.Messages", "Could not halt looper", (Throwable)tooLate);
                                                                    var2_2[116] = true;
                                                                }
                                                                var2_2[117] = true;
                                                                break block64;
                                                            }
                                                            catch (Throwable var9_29) {
                                                                // MONITOREXIT @DISABLED, blocks:[17, 19, 10] lbl108 : MonitorExitStatement: MONITOREXIT : var4_5
                                                                var2_2[118] = true;
                                                                throw var9_29;
                                                            }
                                                        }
                                                    }
                                                }
                                                var2_2[36] = true;
                                                return;
lbl-1000:
                                                // 3 sources

                                                {
                                                    returnCode = this.mDbAdapter.addJSON((JSONObject)message, token, MPDbAdapter.Table.EVENTS, eventDescription.isAutomatic());
                                                    var2_2[37] = true;
                                                }
                                            }
                                            var2_2[40] = true;
                                            break block60;
                                        }
                                        if (msg.what == 4) {
                                            eventDescription = (PushAnonymousPeopleDescription)msg.obj;
                                            var2_2[41] = true;
                                            e = pushAnonymousPeopleDescription.getDistinctId();
                                            var2_2[42] = true;
                                            token = pushAnonymousPeopleDescription.getToken();
                                            var2_2[43] = true;
                                            returnCode = this.mDbAdapter.pushAnonymousUpdatesToPeopleDb(token, (String)distinctId);
                                            var2_2[44] = true;
                                        } else if (msg.what == 7) {
                                            pushAnonymousPeopleDescription = (MixpanelDescription)msg.obj;
                                            var2_2[45] = true;
                                            token = mixpanelDescription.getToken();
                                            var2_2[46] = true;
                                            this.mDbAdapter.cleanupAllEvents(MPDbAdapter.Table.ANONYMOUS_PEOPLE, token);
                                            var2_2[47] = true;
                                        } else if (msg.what == 8) {
                                            mixpanelDescription = (UpdateEventsPropertiesDescription)msg.obj;
                                            var2_2[48] = true;
                                            distinctId = this.mDbAdapter.rewriteEventDataWithProperties(description.getProperties(), description.getToken());
                                            var2_2[49] = true;
                                            MPLog.d("MixpanelAPI.Messages", (int)updatedEvents + " stored events were updated with new properties.");
                                            var2_2[50] = true;
                                        } else if (msg.what == 2) {
                                            var2_2[51] = true;
                                            AnalyticsMessages.access$000(this.this$1.this$0, "Flushing queue due to scheduled or forced flush");
                                            var2_2[52] = true;
                                            Worker.access$200(this.this$1);
                                            token = (String)msg.obj;
                                            if (msg.arg1 == 1) {
                                                v2 = var2_2[53] = true;
                                            } else {
                                                v2 = false;
                                                var2_2[54] = true;
                                            }
                                            description = v2;
                                            var2_2[55] = true;
                                            this.sendAllData(this.mDbAdapter, token);
                                            var2_2[56] = true;
                                            if (shouldCheckDecide == false) {
                                                var2_2[57] = true;
                                            } else if (SystemClock.elapsedRealtime() < this.mDecideRetryAfter) {
                                                var2_2[58] = true;
                                            } else {
                                                try {
                                                    var2_2[59] = true;
                                                    this.mDecideChecker.runDecideCheck(token, this.this$1.this$0.getPoster());
                                                    var2_2[60] = true;
                                                }
                                                catch (RemoteService.ServiceUnavailableException updatedEvents) {
                                                    var2_2[61] = true;
                                                    this.mDecideRetryAfter = SystemClock.elapsedRealtime() + (long)(e.getRetryAfter() * 1000);
                                                    var2_2[62] = true;
                                                }
                                            }
                                            var2_2[63] = true;
                                        } else if (msg.what == 12) {
                                            var2_2[64] = true;
                                            AnalyticsMessages.access$000(this.this$1.this$0, "Installing a check for in-app notifications");
                                            shouldCheckDecide = (DecideMessages)msg.obj;
                                            var2_2[65] = true;
                                            this.mDecideChecker.addDecideCheck((DecideMessages)check);
                                            var2_2[66] = true;
                                            if (SystemClock.elapsedRealtime() < this.mDecideRetryAfter) {
                                                var2_2[67] = true;
                                            } else {
                                                try {
                                                    var2_2[68] = true;
                                                    this.mDecideChecker.runDecideCheck(check.getToken(), this.this$1.this$0.getPoster());
                                                    var2_2[69] = true;
                                                }
                                                catch (RemoteService.ServiceUnavailableException e) {
                                                    var2_2[70] = true;
                                                    this.mDecideRetryAfter = SystemClock.elapsedRealtime() + (long)(e.getRetryAfter() * 1000);
                                                    var2_2[71] = true;
                                                }
                                            }
                                            var2_2[72] = true;
                                        } else if (msg.what == 6) {
                                            check = (MixpanelDescription)msg.obj;
                                            var2_2[73] = true;
                                            token = message.getToken();
                                            var2_2[74] = true;
                                            this.mDbAdapter.cleanupAllEvents(MPDbAdapter.Table.EVENTS, token);
                                            var2_2[75] = true;
                                            this.mDbAdapter.cleanupAllEvents(MPDbAdapter.Table.PEOPLE, token);
                                            var2_2[76] = true;
                                            this.mDbAdapter.cleanupAllEvents(MPDbAdapter.Table.GROUPS, token);
                                            var2_2[77] = true;
                                            this.mDbAdapter.cleanupAllEvents(MPDbAdapter.Table.ANONYMOUS_PEOPLE, token);
                                            var2_2[78] = true;
                                        } else if (msg.what == 5) {
                                            var2_2[79] = true;
                                            MPLog.w("MixpanelAPI.Messages", "Worker received a hard kill. Dumping all events and force-killing. Thread id " + Thread.currentThread().getId());
                                            var2_2[80] = true;
                                            message = Worker.access$300(this.this$1);
                                            synchronized (message) {
                                                try {
                                                    var2_2[81] = true;
                                                    this.mDbAdapter.deleteDB();
                                                    var2_2[82] = true;
                                                    Worker.access$402(this.this$1, null);
                                                    var2_2[83] = true;
                                                    Looper.myLooper().quit();
                                                }
                                                catch (Throwable var8_28) {
                                                    // MONITOREXIT @DISABLED, blocks:[48, 50, 52, 37, 54, 38, 42, 11, 15] lbl227 : MonitorExitStatement: MONITOREXIT : message
                                                    var2_2[84] = true;
                                                    throw var8_28;
                                                }
                                            }
                                            var2_2[85] = true;
                                        } else {
                                            MPLog.e("MixpanelAPI.Messages", "Unexpected message received by Mixpanel worker: " + msg);
                                            var2_2[86] = true;
                                        }
                                    }
                                    if (returnCode < this.this$1.this$0.mConfig.getBulkUploadLimit()) break block68;
                                    var2_2[87] = true;
                                    break block69;
                                }
                                if (returnCode == -2) break block70;
                                var2_2[88] = true;
                                ** GOTO lbl275
                            }
                            var2_2[89] = true;
                        }
                        if (this.mFailedRetries <= 0) break block71;
                        var2_2[90] = true;
                        ** GOTO lbl275
                    }
                    if (token != null) {
                        var2_2[92] = true;
                        AnalyticsMessages.access$000(this.this$1.this$0, "Flushing queue due to bulk upload limit (" + returnCode + ") for project " + token);
                        var2_2[93] = true;
                        Worker.access$200(this.this$1);
                        var2_2[94] = true;
                        this.sendAllData(this.mDbAdapter, token);
                        var2_2[95] = true;
                        if (SystemClock.elapsedRealtime() < this.mDecideRetryAfter) {
                            var2_2[96] = true;
                        } else {
                            try {
                                var2_2[97] = true;
                                this.mDecideChecker.runDecideCheck(token, this.this$1.this$0.getPoster());
                                var2_2[98] = true;
                            }
                            catch (RemoteService.ServiceUnavailableException message) {
                                var2_2[99] = true;
                                this.mDecideRetryAfter = SystemClock.elapsedRealtime() + (long)(e.getRetryAfter() * 1000);
                                var2_2[100] = true;
                            }
                        }
                    } else {
                        var2_2[91] = true;
lbl275:
                        // 3 sources

                        if (returnCode <= 0) {
                            var2_2[101] = true;
                        } else if (this.hasMessages(2, token)) {
                            var2_2[102] = true;
                        } else {
                            var2_2[103] = true;
                            AnalyticsMessages.access$000(this.this$1.this$0, "Queue depth " + returnCode + " - Adding flush in " + this.mFlushInterval);
                            if (this.mFlushInterval < 0L) {
                                var2_2[104] = true;
                            } else {
                                var2_2[105] = true;
                                flushMessage = Message.obtain();
                                flushMessage.what = 2;
                                flushMessage.obj = token;
                                flushMessage.arg1 = 1;
                                var2_2[106] = true;
                                this.sendMessageDelayed(flushMessage, this.mFlushInterval);
                                var2_2[107] = true;
                            }
                        }
                    }
                    var2_2[108] = true;
                }
                var2_2[119] = true;
            }

            protected long getTrackEngageRetryAfter() {
                boolean[] blArray = AnalyticsMessageHandler.$jacocoInit();
                blArray[120] = true;
                return this.mTrackEngageRetryAfter;
            }

            /*
             * WARNING - void declaration
             */
            private void sendAllData(MPDbAdapter mPDbAdapter, String string) {
                void token;
                void dbAdapter;
                void poster;
                boolean[] blArray = AnalyticsMessageHandler.$jacocoInit();
                RemoteService remoteService = this.this$1.this$0.getPoster();
                blArray[121] = true;
                if (!poster.isOnline(this.this$1.this$0.mContext, this.this$1.this$0.mConfig.getOfflineMode())) {
                    blArray[122] = true;
                    AnalyticsMessages.access$000(this.this$1.this$0, "Not flushing data to Mixpanel because the device is not connected to the internet.");
                    blArray[123] = true;
                    return;
                }
                this.sendData((MPDbAdapter)dbAdapter, (String)token, MPDbAdapter.Table.EVENTS, this.this$1.this$0.mConfig.getEventsEndpoint());
                blArray[124] = true;
                this.sendData((MPDbAdapter)dbAdapter, (String)token, MPDbAdapter.Table.PEOPLE, this.this$1.this$0.mConfig.getPeopleEndpoint());
                blArray[125] = true;
                this.sendData((MPDbAdapter)dbAdapter, (String)token, MPDbAdapter.Table.GROUPS, this.this$1.this$0.mConfig.getGroupsEndpoint());
                blArray[126] = true;
            }

            /*
             * Unable to fully structure code
             */
            private void sendData(MPDbAdapter var1_1, String var2_2, MPDbAdapter.Table var3_3, String var4_4) {
                block24: {
                    var5_5 = AnalyticsMessageHandler.$jacocoInit();
                    var6_6 = this.this$1.this$0.getPoster();
                    var5_5[127] = true;
                    decideMessages = this.mDecideChecker.getDecideMessages((String)token);
                    var8_8 = true;
                    var5_5[128] = true;
                    if (decideMessages != null) break block24;
                    var5_5[129] = true;
                    ** GOTO lbl15
                }
                if (decideMessages.isAutomaticEventsEnabled() != null) {
                    var5_5[130] = true;
                } else {
                    var5_5[131] = true;
lbl15:
                    // 2 sources

                    includeAutomaticEvents = false;
                    var5_5[132] = true;
                }
                var9_9 = dbAdapter.generateDataString((MPDbAdapter.Table)table, (String)token, includeAutomaticEvents);
                var5_5[133] = true;
                queueCount = 0;
                if (eventsData == null) {
                    var5_5[134] = true;
                } else {
                    var5_5[135] = true;
                    queueCount = Integer.valueOf((String)eventsData[2]);
                    var5_5[136] = true;
                }
                while (true) {
                    if (eventsData == null) {
                        var5_5[137] = true;
                        break;
                    }
                    if (queueCount <= 0) {
                        var5_5[138] = true;
                        break;
                    }
                    lastId = eventsData[0];
                    var12_12 = eventsData[1];
                    var5_5[139] = true;
                    var13_13 = Base64Coder.encodeString((String)rawMessage);
                    var5_5[140] = true;
                    var14_14 = new HashMap<K, V>();
                    var5_5[141] = true;
                    params.put("data", encodedData);
                    if (!MPConfig.DEBUG) {
                        var5_5[142] = true;
                    } else {
                        var5_5[143] = true;
                        params.put("verbose", "1");
                        var5_5[144] = true;
                    }
                    var15_15 = true;
                    try {
                        var5_5[145] = true;
                        var17_17 = this.this$1.this$0.mConfig.getSSLSocketFactory();
                        var5_5[146] = true;
                        response = poster.performRequest((String)url, (Map<String, Object>)params, (SSLSocketFactory)socketFactory);
                        if (null == response) {
                            deleteEvents = false;
                            var5_5[147] = true;
                            AnalyticsMessages.access$000(this.this$1.this$0, "Response was null, unexpected failure posting to " + (String)url + ".");
                            var5_5[148] = true;
                        } else {
                            deleteEvents = true;
                            try {
                                var5_5[149] = true;
                                parsedResponse = new String(response, "UTF-8");
                            }
                            catch (UnsupportedEncodingException var19_24) {
                                var5_5[150] = true;
                                var5_5[151] = true;
                                throw new RuntimeException("UTF not supported on this platform?", (Throwable)e);
                            }
                            if (this.mFailedRetries <= 0) {
                                var5_5[152] = true;
                            } else {
                                this.mFailedRetries = 0;
                                var5_5[153] = true;
                                this.removeMessages(2, token);
                                var5_5[154] = true;
                            }
                            AnalyticsMessages.access$000(this.this$1.this$0, "Successfully posted to " + (String)url + ": \n" + (String)rawMessage);
                            var5_5[155] = true;
                            AnalyticsMessages.access$000(this.this$1.this$0, "Response was " + parsedResponse);
                            var5_5[156] = true;
                        }
                        var5_5[157] = true;
                    }
                    catch (OutOfMemoryError socketFactory) {
                        var5_5[158] = true;
                        MPLog.e("MixpanelAPI.Messages", "Out of memory when posting to " + (String)url + ".", (Throwable)e);
                        var5_5[159] = true;
                    }
                    catch (MalformedURLException e) {
                        var5_5[160] = true;
                        MPLog.e("MixpanelAPI.Messages", "Cannot interpret " + (String)url + " as a URL.", e);
                        var5_5[161] = true;
                    }
                    catch (RemoteService.ServiceUnavailableException e) {
                        var5_5[162] = true;
                        AnalyticsMessages.access$500(this.this$1.this$0, "Cannot post message to " + (String)url + ".", e);
                        deleteEvents = false;
                        var5_5[163] = true;
                        this.mTrackEngageRetryAfter = e.getRetryAfter() * 1000;
                        var5_5[164] = true;
                    }
                    catch (SocketTimeoutException e) {
                        var5_5[165] = true;
                        AnalyticsMessages.access$500(this.this$1.this$0, "Cannot post message to " + (String)url + ".", e);
                        deleteEvents = false;
                        var5_5[166] = true;
                    }
                    catch (IOException e) {
                        var5_5[167] = true;
                        AnalyticsMessages.access$500(this.this$1.this$0, "Cannot post message to " + (String)url + ".", e);
                        deleteEvents = false;
                        var5_5[168] = true;
                    }
                    if (!deleteEvents) {
                        this.removeMessages(2, token);
                        var5_5[171] = true;
                        this.mTrackEngageRetryAfter = Math.max((long)Math.pow(2.0, this.mFailedRetries) * 60000L, this.mTrackEngageRetryAfter);
                        var5_5[172] = true;
                        this.mTrackEngageRetryAfter = Math.min(this.mTrackEngageRetryAfter, 600000L);
                        var5_5[173] = true;
                        flushMessage = Message.obtain();
                        flushMessage.what = 2;
                        flushMessage.obj = token;
                        var5_5[174] = true;
                        this.sendMessageDelayed(flushMessage, this.mTrackEngageRetryAfter);
                        ++this.mFailedRetries;
                        var5_5[175] = true;
                        AnalyticsMessages.access$000(this.this$1.this$0, "Retrying this batch of events in " + this.mTrackEngageRetryAfter + " ms");
                        var5_5[176] = true;
                        break;
                    }
                    var5_5[169] = true;
                    AnalyticsMessages.access$000(this.this$1.this$0, "Not retrying this batch of events, deleting them from DB.");
                    var5_5[170] = true;
                    dbAdapter.cleanupEvents((String)lastId, (MPDbAdapter.Table)table, (String)token, includeAutomaticEvents);
                    eventsData = dbAdapter.generateDataString((MPDbAdapter.Table)table, (String)token, includeAutomaticEvents);
                    if (eventsData == null) {
                        var5_5[177] = true;
                    } else {
                        var5_5[178] = true;
                        queueCount = Integer.valueOf(eventsData[2]);
                        var5_5[179] = true;
                    }
                    var5_5[180] = true;
                }
                var5_5[181] = true;
            }

            /*
             * WARNING - void declaration
             */
            private JSONObject getDefaultEventProperties() throws JSONException {
                void carrier;
                void displayMetrics;
                String string;
                String string2;
                String string3;
                String string4;
                void ret;
                boolean[] blArray = AnalyticsMessageHandler.$jacocoInit();
                JSONObject jSONObject = new JSONObject();
                blArray[182] = true;
                ret.put("mp_lib", (Object)"android");
                blArray[183] = true;
                ret.put("$lib_version", (Object)"5.9.3");
                blArray[184] = true;
                ret.put("$os", (Object)"Android");
                blArray[185] = true;
                if (Build.VERSION.RELEASE == null) {
                    string4 = "UNKNOWN";
                    blArray[186] = true;
                } else {
                    string4 = Build.VERSION.RELEASE;
                    blArray[187] = true;
                }
                ret.put("$os_version", (Object)string4);
                blArray[188] = true;
                if (Build.MANUFACTURER == null) {
                    string3 = "UNKNOWN";
                    blArray[189] = true;
                } else {
                    string3 = Build.MANUFACTURER;
                    blArray[190] = true;
                }
                ret.put("$manufacturer", (Object)string3);
                blArray[191] = true;
                if (Build.BRAND == null) {
                    string2 = "UNKNOWN";
                    blArray[192] = true;
                } else {
                    string2 = Build.BRAND;
                    blArray[193] = true;
                }
                ret.put("$brand", (Object)string2);
                blArray[194] = true;
                if (Build.MODEL == null) {
                    string = "UNKNOWN";
                    blArray[195] = true;
                } else {
                    string = Build.MODEL;
                    blArray[196] = true;
                }
                ret.put("$model", (Object)string);
                try {
                    try {
                        blArray[197] = true;
                        int servicesAvailable = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.this$1.this$0.mContext);
                        switch (servicesAvailable) {
                            default: {
                                blArray[198] = true;
                                break;
                            }
                            case 0: {
                                ret.put("$google_play_services", (Object)"available");
                                blArray[199] = true;
                                break;
                            }
                            case 1: {
                                ret.put("$google_play_services", (Object)"missing");
                                blArray[200] = true;
                                break;
                            }
                            case 2: {
                                ret.put("$google_play_services", (Object)"out of date");
                                blArray[201] = true;
                                break;
                            }
                            case 3: {
                                ret.put("$google_play_services", (Object)"disabled");
                                blArray[202] = true;
                                break;
                            }
                            case 9: {
                                ret.put("$google_play_services", (Object)"invalid");
                                blArray[203] = true;
                            }
                        }
                    }
                    catch (RuntimeException servicesAvailable) {
                        blArray[205] = true;
                        ret.put("$google_play_services", (Object)"not configured");
                        blArray[206] = true;
                    }
                    blArray[204] = true;
                    blArray[207] = true;
                }
                catch (NoClassDefFoundError e) {
                    blArray[208] = true;
                    ret.put("$google_play_services", (Object)"not included");
                    blArray[209] = true;
                }
                DisplayMetrics e = Worker.access$100(this.this$1).getDisplayMetrics();
                blArray[210] = true;
                ret.put("$screen_dpi", displayMetrics.densityDpi);
                blArray[211] = true;
                ret.put("$screen_height", displayMetrics.heightPixels);
                blArray[212] = true;
                ret.put("$screen_width", displayMetrics.widthPixels);
                blArray[213] = true;
                String applicationVersionName = Worker.access$100(this.this$1).getAppVersionName();
                if (null == applicationVersionName) {
                    blArray[214] = true;
                } else {
                    blArray[215] = true;
                    ret.put("$app_version", (Object)applicationVersionName);
                    blArray[216] = true;
                    ret.put("$app_version_string", (Object)applicationVersionName);
                    blArray[217] = true;
                }
                Integer applicationVersionCode = Worker.access$100(this.this$1).getAppVersionCode();
                if (null == applicationVersionCode) {
                    blArray[218] = true;
                } else {
                    void applicationVersion;
                    blArray[219] = true;
                    String string5 = String.valueOf(applicationVersionCode);
                    blArray[220] = true;
                    ret.put("$app_release", (Object)applicationVersion);
                    blArray[221] = true;
                    ret.put("$app_build_number", (Object)applicationVersion);
                    blArray[222] = true;
                }
                Boolean hasNFC = Worker.access$100(this.this$1).hasNFC();
                if (null == hasNFC) {
                    blArray[223] = true;
                } else {
                    blArray[224] = true;
                    ret.put("$has_nfc", hasNFC.booleanValue());
                    blArray[225] = true;
                }
                Boolean hasTelephony = Worker.access$100(this.this$1).hasTelephony();
                if (null == hasTelephony) {
                    blArray[226] = true;
                } else {
                    blArray[227] = true;
                    ret.put("$has_telephone", hasTelephony.booleanValue());
                    blArray[228] = true;
                }
                String string6 = Worker.access$100(this.this$1).getCurrentNetworkOperator();
                blArray[229] = true;
                if (null == carrier) {
                    blArray[230] = true;
                } else if (carrier.trim().isEmpty()) {
                    blArray[231] = true;
                } else {
                    blArray[232] = true;
                    ret.put("$carrier", (Object)carrier);
                    blArray[233] = true;
                }
                Boolean isWifi = Worker.access$100(this.this$1).isWifiConnected();
                if (null == isWifi) {
                    blArray[234] = true;
                } else {
                    blArray[235] = true;
                    ret.put("$wifi", isWifi.booleanValue());
                    blArray[236] = true;
                }
                String radio = Worker.access$100(this.this$1).getPhoneRadioType(this.this$1.this$0.mContext);
                if (null == radio) {
                    blArray[237] = true;
                } else {
                    blArray[238] = true;
                    ret.put("$radio", (Object)radio);
                    blArray[239] = true;
                }
                Boolean isBluetoothEnabled = Worker.access$100(this.this$1).isBluetoothEnabled();
                if (isBluetoothEnabled == null) {
                    blArray[240] = true;
                } else {
                    blArray[241] = true;
                    ret.put("$bluetooth_enabled", (Object)isBluetoothEnabled);
                    blArray[242] = true;
                }
                String bluetoothVersion = Worker.access$100(this.this$1).getBluetoothVersion();
                if (bluetoothVersion == null) {
                    blArray[243] = true;
                } else {
                    blArray[244] = true;
                    ret.put("$bluetooth_version", (Object)bluetoothVersion);
                    blArray[245] = true;
                }
                blArray[246] = true;
                return ret;
            }

            /*
             * WARNING - void declaration
             */
            private JSONObject prepareEventObject(EventDescription eventDescription) throws JSONException {
                void eventObj;
                void eventProperties;
                void sendProperties;
                void eventDescription2;
                boolean[] blArray = AnalyticsMessageHandler.$jacocoInit();
                JSONObject jSONObject = new JSONObject();
                blArray[247] = true;
                JSONObject jSONObject2 = eventDescription2.getProperties();
                blArray[248] = true;
                JSONObject jSONObject3 = this.getDefaultEventProperties();
                blArray[249] = true;
                sendProperties.put("token", (Object)eventDescription2.getToken());
                if (eventProperties == null) {
                    blArray[250] = true;
                } else {
                    blArray[251] = true;
                    Iterator iterator = eventProperties.keys();
                    blArray[252] = true;
                    while (true) {
                        void key;
                        void iter;
                        if (!iter.hasNext()) {
                            blArray[253] = true;
                            break;
                        }
                        blArray[254] = true;
                        String string = (String)iter.next();
                        blArray[255] = true;
                        sendProperties.put((String)key, eventProperties.get((String)key));
                        blArray[256] = true;
                    }
                }
                eventObj.put("event", (Object)eventDescription2.getEventName());
                blArray[257] = true;
                eventObj.put("properties", (Object)sendProperties);
                blArray[258] = true;
                eventObj.put("$mp_metadata", (Object)eventDescription2.getSessionMetadata());
                blArray[259] = true;
                return eventObj;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-1413408066298714989L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages$Worker$AnalyticsMessageHandler", (int)260);
                }
                return blArray;
            }
        }
    }

    static class MixpanelDescription {
        private final String mToken;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public MixpanelDescription(String string) {
            void token;
            boolean[] blArray = MixpanelDescription.$jacocoInit();
            this.mToken = token;
            blArray[0] = true;
        }

        public String getToken() {
            boolean[] blArray = MixpanelDescription.$jacocoInit();
            blArray[1] = true;
            return this.mToken;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)7766617191639777723L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages$MixpanelDescription", (int)2);
            }
            return blArray;
        }
    }

    static class UpdateEventsPropertiesDescription
    extends MixpanelDescription {
        private Map<String, String> mProps;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public UpdateEventsPropertiesDescription(String string, Map<String, String> map) {
            void props;
            void token;
            boolean[] blArray = UpdateEventsPropertiesDescription.$jacocoInit();
            super((String)token);
            this.mProps = props;
            blArray[0] = true;
        }

        public Map<String, String> getProperties() {
            boolean[] blArray = UpdateEventsPropertiesDescription.$jacocoInit();
            blArray[1] = true;
            return this.mProps;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)4028302981706534706L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages$UpdateEventsPropertiesDescription", (int)2);
            }
            return blArray;
        }
    }

    static class MixpanelMessageDescription
    extends MixpanelDescription {
        private final JSONObject mMessage;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public MixpanelMessageDescription(String string, JSONObject jSONObject) {
            void message;
            void token;
            boolean[] blArray = MixpanelMessageDescription.$jacocoInit();
            super((String)token);
            blArray[0] = true;
            if (message == null) {
                blArray[1] = true;
            } else if (message.length() <= 0) {
                blArray[2] = true;
            } else {
                blArray[3] = true;
                Iterator iterator = message.keys();
                blArray[4] = true;
                while (true) {
                    void jsonKey;
                    void it;
                    if (!it.hasNext()) {
                        blArray[5] = true;
                        break;
                    }
                    blArray[6] = true;
                    String string2 = (String)it.next();
                    try {
                        blArray[7] = true;
                        message.get((String)jsonKey).toString();
                        blArray[8] = true;
                    }
                    catch (AssertionError assertionError) {
                        void e;
                        blArray[9] = true;
                        message.remove((String)jsonKey);
                        blArray[10] = true;
                        MPLog.e(AnalyticsMessages.LOGTAG, "Removing people profile property from update (see https://github.com/mixpanel/mixpanel-android/issues/567)", (Throwable)e);
                        blArray[11] = true;
                    }
                    catch (JSONException jSONException) {
                        blArray[12] = true;
                    }
                    blArray[13] = true;
                }
            }
            this.mMessage = message;
            blArray[14] = true;
        }

        public JSONObject getMessage() {
            boolean[] blArray = MixpanelMessageDescription.$jacocoInit();
            blArray[15] = true;
            return this.mMessage;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-3103639030093982669L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages$MixpanelMessageDescription", (int)16);
            }
            return blArray;
        }
    }

    static class FlushDescription
    extends MixpanelDescription {
        private final boolean checkDecide;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public FlushDescription(String string) {
            void token;
            boolean[] blArray = FlushDescription.$jacocoInit();
            this((String)token, true);
            blArray[0] = true;
        }

        /*
         * WARNING - void declaration
         */
        protected FlushDescription(String string, boolean bl) {
            void checkDecide;
            void token;
            boolean[] blArray = FlushDescription.$jacocoInit();
            super((String)token);
            this.checkDecide = checkDecide;
            blArray[1] = true;
        }

        public boolean shouldCheckDecide() {
            boolean[] blArray = FlushDescription.$jacocoInit();
            blArray[2] = true;
            return this.checkDecide;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)589304129946140285L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages$FlushDescription", (int)3);
            }
            return blArray;
        }
    }

    static class PushAnonymousPeopleDescription
    extends MixpanelDescription {
        private final String mDistinctId;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public PushAnonymousPeopleDescription(String string, String string2) {
            void distinctId;
            void token;
            boolean[] blArray = PushAnonymousPeopleDescription.$jacocoInit();
            super((String)token);
            this.mDistinctId = distinctId;
            blArray[0] = true;
        }

        public String toString() {
            boolean[] blArray = PushAnonymousPeopleDescription.$jacocoInit();
            blArray[1] = true;
            return this.mDistinctId;
        }

        public String getDistinctId() {
            boolean[] blArray = PushAnonymousPeopleDescription.$jacocoInit();
            blArray[2] = true;
            return this.mDistinctId;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)2119905847039754841L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages$PushAnonymousPeopleDescription", (int)3);
            }
            return blArray;
        }
    }

    static class GroupDescription
    extends MixpanelMessageDescription {
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public GroupDescription(JSONObject jSONObject, String string) {
            void message;
            void token;
            boolean[] blArray = GroupDescription.$jacocoInit();
            super((String)token, (JSONObject)message);
            blArray[0] = true;
        }

        public String toString() {
            boolean[] blArray = GroupDescription.$jacocoInit();
            blArray[1] = true;
            return this.getMessage().toString();
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-8638480187265499073L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages$GroupDescription", (int)2);
            }
            return blArray;
        }
    }

    static class PeopleDescription
    extends MixpanelMessageDescription {
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public PeopleDescription(JSONObject jSONObject, String string) {
            void message;
            void token;
            boolean[] blArray = PeopleDescription.$jacocoInit();
            super((String)token, (JSONObject)message);
            blArray[0] = true;
        }

        public String toString() {
            boolean[] blArray = PeopleDescription.$jacocoInit();
            blArray[1] = true;
            return this.getMessage().toString();
        }

        public boolean isAnonymous() {
            boolean bl;
            boolean[] blArray = PeopleDescription.$jacocoInit();
            if (!this.getMessage().has("$distinct_id")) {
                bl = blArray[2] = true;
            } else {
                bl = false;
                blArray[3] = true;
            }
            blArray[4] = true;
            return bl;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-1364532907419093276L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages$PeopleDescription", (int)5);
            }
            return blArray;
        }
    }

    static class EventDescription
    extends MixpanelMessageDescription {
        private final String mEventName;
        private final JSONObject mSessionMetadata;
        private final boolean mIsAutomatic;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public EventDescription(String string, JSONObject jSONObject, String string2) {
            void token;
            void properties;
            void eventName;
            boolean[] blArray = EventDescription.$jacocoInit();
            this((String)eventName, (JSONObject)properties, (String)token, false, new JSONObject());
            blArray[0] = true;
        }

        /*
         * WARNING - void declaration
         */
        public EventDescription(String string, JSONObject jSONObject, String string2, boolean bl, JSONObject jSONObject2) {
            void sessionMetada;
            void isAutomatic;
            void eventName;
            void properties;
            void token;
            boolean[] blArray = EventDescription.$jacocoInit();
            super((String)token, (JSONObject)properties);
            this.mEventName = eventName;
            this.mIsAutomatic = isAutomatic;
            this.mSessionMetadata = sessionMetada;
            blArray[1] = true;
        }

        public String getEventName() {
            boolean[] blArray = EventDescription.$jacocoInit();
            blArray[2] = true;
            return this.mEventName;
        }

        public JSONObject getProperties() {
            boolean[] blArray = EventDescription.$jacocoInit();
            blArray[3] = true;
            return this.getMessage();
        }

        public JSONObject getSessionMetadata() {
            boolean[] blArray = EventDescription.$jacocoInit();
            blArray[4] = true;
            return this.mSessionMetadata;
        }

        public boolean isAutomatic() {
            boolean[] blArray = EventDescription.$jacocoInit();
            blArray[5] = true;
            return this.mIsAutomatic;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)6552132823475627912L, (String)"com/mixpanel/android/mpmetrics/AnalyticsMessages$EventDescription", (int)6);
            }
            return blArray;
        }
    }
}

