/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.R;
import android.content.Context;
import android.util.SparseArray;
import com.mixpanel.android.mpmetrics.ResourceIds;
import com.mixpanel.android.util.MPLog;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public abstract class ResourceReader
implements ResourceIds {
    private final Context mContext;
    private final Map<String, Integer> mIdNameToId;
    private final SparseArray<String> mIdToIdName;
    private static final String LOGTAG = "MixpanelAPI.RsrcReader";
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    protected ResourceReader(Context context) {
        void context2;
        boolean[] blArray = ResourceReader.$jacocoInit();
        this.mContext = context2;
        blArray[0] = true;
        this.mIdNameToId = new HashMap<String, Integer>();
        blArray[1] = true;
        this.mIdToIdName = new SparseArray();
        blArray[2] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean knownIdName(String string) {
        void name;
        boolean[] blArray = ResourceReader.$jacocoInit();
        blArray[3] = true;
        return this.mIdNameToId.containsKey(name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int idFromName(String string) {
        void name;
        boolean[] blArray = ResourceReader.$jacocoInit();
        blArray[4] = true;
        return this.mIdNameToId.get(name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String nameForId(int n) {
        void id2;
        boolean[] blArray = ResourceReader.$jacocoInit();
        blArray[5] = true;
        return (String)this.mIdToIdName.get((int)id2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readClassIds(Class<?> clazz, String string, Map<String, Integer> map) {
        Class<?> platformIdClass;
        boolean[] blArray = ResourceReader.$jacocoInit();
        try {
            void i;
            Field[] fields = platformIdClass.getFields();
            boolean bl = false;
            blArray[6] = true;
            while (i < fields.length) {
                block11: {
                    void modifiers;
                    void field;
                    Field field2 = fields[i];
                    blArray[7] = true;
                    int n = field.getModifiers();
                    blArray[8] = true;
                    if (!Modifier.isStatic((int)modifiers)) {
                        blArray[9] = true;
                    } else {
                        blArray[10] = true;
                        Class<?> fieldType = field.getType();
                        if (fieldType != Integer.TYPE) {
                            blArray[11] = true;
                        } else {
                            try {
                                void namesToIds;
                                String namespacedName;
                                void name;
                                void namespace;
                                blArray[12] = true;
                                String string2 = field.getName();
                                blArray[13] = true;
                                int value = field.getInt(null);
                                if (null == namespace) {
                                    namespacedName = name;
                                    blArray[14] = true;
                                } else {
                                    namespacedName = (String)namespace + ":" + (String)name;
                                    blArray[15] = true;
                                }
                                namesToIds.put(namespacedName, value);
                            }
                            catch (ArrayIndexOutOfBoundsException name) {
                                void e;
                                blArray[17] = true;
                                MPLog.e(LOGTAG, "Can't read built-in id name from " + platformIdClass.getName(), (Throwable)e);
                                blArray[18] = true;
                                break block11;
                            }
                            blArray[16] = true;
                        }
                    }
                }
                ++i;
                blArray[19] = true;
            }
            blArray[20] = true;
        }
        catch (IllegalAccessException fields) {
            void e;
            blArray[21] = true;
            MPLog.e(LOGTAG, "Can't read built-in id names from " + platformIdClass.getName(), (Throwable)e);
            blArray[22] = true;
        }
        blArray[23] = true;
    }

    protected abstract Class<?> getSystemClass();

    protected abstract String getLocalClassName(Context var1);

    /*
     * WARNING - void declaration
     */
    protected void initialize() {
        Object object;
        void localClassName;
        void sysIdClass;
        boolean[] blArray = ResourceReader.$jacocoInit();
        this.mIdNameToId.clear();
        blArray[24] = true;
        this.mIdToIdName.clear();
        blArray[25] = true;
        Class<?> clazz = this.getSystemClass();
        blArray[26] = true;
        ResourceReader.readClassIds(sysIdClass, "android", this.mIdNameToId);
        blArray[27] = true;
        String string = this.getLocalClassName(this.mContext);
        try {
            void rIdClass;
            blArray[28] = true;
            object = Class.forName((String)localClassName);
            blArray[29] = true;
            ResourceReader.readClassIds(rIdClass, null, this.mIdNameToId);
            blArray[30] = true;
        }
        catch (ClassNotFoundException rIdClass) {
            blArray[31] = true;
            MPLog.w(LOGTAG, "Can't load names for Android view ids from '" + (String)localClassName + "', ids by name will not be available in the events editor.");
            blArray[32] = true;
            MPLog.i(LOGTAG, "You may be missing a Resources class for your package due to your proguard configuration, or you may be using an applicationId in your build that isn't the same as the package declared in your AndroidManifest.xml file.\nIf you're using proguard, you can fix this issue by adding the following to your proguard configuration:\n\n-keep class **.R$* {\n    <fields>;\n}\n\nIf you're not using proguard, or if your proguard configuration already contains the directive above, you can add the following to your AndroidManifest.xml file to explicitly point the Mixpanel library to the appropriate library for your resources class:\n\n<meta-data android:name=\"com.mixpanel.android.MPConfig.ResourcePackageName\" android:value=\"YOUR_PACKAGE_NAME\" />\n\nwhere YOUR_PACKAGE_NAME is the same string you use for the \"package\" attribute in your <manifest> tag.");
            blArray[33] = true;
        }
        object = this.mIdNameToId.entrySet().iterator();
        blArray[34] = true;
        while (object.hasNext()) {
            void idMapping;
            Map.Entry entry = (Map.Entry)object.next();
            blArray[35] = true;
            this.mIdToIdName.put(((Integer)idMapping.getValue()).intValue(), idMapping.getKey());
            blArray[36] = true;
        }
        blArray[37] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)5040877088121570704L, (String)"com/mixpanel/android/mpmetrics/ResourceReader", (int)38);
        }
        return blArray;
    }

    public static class Drawables
    extends ResourceReader {
        private final String mResourcePackageName;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        protected Drawables(String string, Context context) {
            void resourcePackageName;
            void context2;
            boolean[] blArray = Drawables.$jacocoInit();
            super((Context)context2);
            this.mResourcePackageName = resourcePackageName;
            blArray[0] = true;
            this.initialize();
            blArray[1] = true;
        }

        @Override
        protected Class<?> getSystemClass() {
            boolean[] blArray = Drawables.$jacocoInit();
            blArray[2] = true;
            return R.drawable.class;
        }

        @Override
        protected String getLocalClassName(Context context) {
            boolean[] blArray = Drawables.$jacocoInit();
            blArray[3] = true;
            return this.mResourcePackageName + ".R$drawable";
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)7556005411000086934L, (String)"com/mixpanel/android/mpmetrics/ResourceReader$Drawables", (int)4);
            }
            return blArray;
        }
    }

    public static class Ids
    extends ResourceReader {
        private final String mResourcePackageName;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public Ids(String string, Context context) {
            void resourcePackageName;
            void context2;
            boolean[] blArray = Ids.$jacocoInit();
            super((Context)context2);
            this.mResourcePackageName = resourcePackageName;
            blArray[0] = true;
            this.initialize();
            blArray[1] = true;
        }

        @Override
        protected Class<?> getSystemClass() {
            boolean[] blArray = Ids.$jacocoInit();
            blArray[2] = true;
            return R.id.class;
        }

        @Override
        protected String getLocalClassName(Context context) {
            boolean[] blArray = Ids.$jacocoInit();
            blArray[3] = true;
            return this.mResourcePackageName + ".R$id";
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)7325121436865571591L, (String)"com/mixpanel/android/mpmetrics/ResourceReader$Ids", (int)4);
            }
            return blArray;
        }
    }
}

