/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.java_websocket.client;

import android.annotation.SuppressLint;
import com.mixpanel.android.java_websocket.WebSocket;
import com.mixpanel.android.java_websocket.WebSocketAdapter;
import com.mixpanel.android.java_websocket.WebSocketImpl;
import com.mixpanel.android.java_websocket.WebSocketListener;
import com.mixpanel.android.java_websocket.drafts.Draft;
import com.mixpanel.android.java_websocket.drafts.Draft_17;
import com.mixpanel.android.java_websocket.exceptions.InvalidHandshakeException;
import com.mixpanel.android.java_websocket.framing.Framedata;
import com.mixpanel.android.java_websocket.handshake.ClientHandshakeBuilder;
import com.mixpanel.android.java_websocket.handshake.HandshakeImpl1Client;
import com.mixpanel.android.java_websocket.handshake.Handshakedata;
import com.mixpanel.android.java_websocket.handshake.ServerHandshake;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

@SuppressLint(value={"Assert"})
public abstract class WebSocketClient
extends WebSocketAdapter
implements Runnable,
WebSocket {
    protected URI uri;
    private WebSocketImpl engine;
    private Socket socket;
    private InputStream istream;
    private OutputStream ostream;
    private Proxy proxy;
    private Thread writeThread;
    private Draft draft;
    private Map<String, String> headers;
    private CountDownLatch connectLatch;
    private CountDownLatch closeLatch;
    private int connectTimeout;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public WebSocketClient(URI uRI) {
        void serverURI;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this((URI)serverURI, new Draft_17());
        blArray[0] = true;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClient(URI uRI, Draft draft) {
        void draft2;
        void serverUri;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this((URI)serverUri, (Draft)draft2, null, 0);
        blArray[1] = true;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClient(URI uRI, Draft draft, Map<String, String> map, int n) {
        void connectTimeout;
        void httpHeaders;
        void protocolDraft;
        void serverUri;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.uri = null;
        this.engine = null;
        this.socket = null;
        this.proxy = Proxy.NO_PROXY;
        blArray[2] = true;
        this.connectLatch = new CountDownLatch(1);
        blArray[3] = true;
        this.closeLatch = new CountDownLatch(1);
        this.connectTimeout = 0;
        if (serverUri == null) {
            blArray[4] = true;
            blArray[5] = true;
            throw new IllegalArgumentException();
        }
        if (protocolDraft == null) {
            blArray[6] = true;
            blArray[7] = true;
            throw new IllegalArgumentException("null as draft is permitted for `WebSocketServer` only!");
        }
        this.uri = serverUri;
        this.draft = protocolDraft;
        this.headers = httpHeaders;
        this.connectTimeout = connectTimeout;
        blArray[8] = true;
        this.engine = new WebSocketImpl((WebSocketListener)this, (Draft)protocolDraft);
        blArray[9] = true;
    }

    public URI getURI() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[10] = true;
        return this.uri;
    }

    @Override
    public Draft getDraft() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[11] = true;
        return this.draft;
    }

    public void connect() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        if (this.writeThread != null) {
            blArray[12] = true;
            blArray[13] = true;
            throw new IllegalStateException("WebSocketClient objects are not reuseable");
        }
        this.writeThread = new Thread(this);
        blArray[14] = true;
        this.writeThread.start();
        blArray[15] = true;
    }

    public boolean connectBlocking() throws InterruptedException {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.connect();
        blArray[16] = true;
        this.connectLatch.await();
        blArray[17] = true;
        blArray[18] = true;
        return this.engine.isOpen();
    }

    @Override
    public void close() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        if (this.writeThread == null) {
            blArray[19] = true;
        } else {
            blArray[20] = true;
            this.engine.close(1000);
            blArray[21] = true;
        }
        blArray[22] = true;
    }

    public void closeBlocking() throws InterruptedException {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.close();
        blArray[23] = true;
        this.closeLatch.await();
        blArray[24] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(String string) throws NotYetConnectedException {
        void text;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.engine.send((String)text);
        blArray[25] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(byte[] byArray) throws NotYetConnectedException {
        void data;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.engine.send((byte[])data);
        blArray[26] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        try {
            if (this.socket == null) {
                blArray[27] = true;
                this.socket = new Socket(this.proxy);
                blArray[28] = true;
            } else if (!this.socket.isClosed()) {
                blArray[29] = true;
            } else {
                blArray[30] = true;
                blArray[31] = true;
                throw new IOException();
            }
            if (this.socket.isBound()) {
                blArray[32] = true;
            } else {
                blArray[33] = true;
                this.socket.connect(new InetSocketAddress(this.uri.getHost(), this.getPort()), this.connectTimeout);
                blArray[34] = true;
            }
            this.istream = this.socket.getInputStream();
            blArray[35] = true;
            this.ostream = this.socket.getOutputStream();
            blArray[36] = true;
            this.sendHandshake();
        }
        catch (Exception exception) {
            void e;
            blArray[37] = true;
            this.onWebsocketError(this.engine, (Exception)e);
            blArray[38] = true;
            this.engine.closeConnection(-1, e.getMessage());
            blArray[39] = true;
            return;
        }
        this.writeThread = new Thread(new WebsocketWriteThread(this, null));
        blArray[40] = true;
        this.writeThread.start();
        byte[] e = new byte[WebSocketImpl.RCVBUF];
        try {
            blArray[41] = true;
            while (true) {
                void rawbuffer;
                if (this.isClosed()) {
                    blArray[42] = true;
                    break;
                }
                int readBytes = this.istream.read((byte[])rawbuffer);
                if (readBytes == -1) {
                    blArray[43] = true;
                    break;
                }
                blArray[44] = true;
                this.engine.decode(ByteBuffer.wrap((byte[])rawbuffer, 0, readBytes));
                blArray[45] = true;
            }
            this.engine.eot();
        }
        catch (IOException iOException) {
            blArray[47] = true;
            this.engine.eot();
            blArray[48] = true;
        }
        catch (RuntimeException e2) {
            blArray[49] = true;
            this.onError(e2);
            blArray[50] = true;
            this.engine.closeConnection(1006, e2.getMessage());
            blArray[51] = true;
        }
        blArray[46] = true;
        if ($assertionsDisabled) {
            blArray[52] = true;
        } else if (this.socket.isClosed()) {
            blArray[53] = true;
        } else {
            blArray[54] = true;
            throw new AssertionError();
        }
        blArray[55] = true;
    }

    /*
     * WARNING - void declaration
     */
    private int getPort() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        int port = this.uri.getPort();
        if (port == -1) {
            void scheme;
            blArray[56] = true;
            String string = this.uri.getScheme();
            blArray[57] = true;
            if (scheme.equals("wss")) {
                blArray[58] = true;
                return 443;
            }
            if (scheme.equals("ws")) {
                blArray[59] = true;
                return 80;
            }
            blArray[60] = true;
            throw new RuntimeException("unkonow scheme" + (String)scheme);
        }
        blArray[61] = true;
        return port;
    }

    /*
     * Unable to fully structure code
     */
    private void sendHandshake() throws InvalidHandshakeException {
        block10: {
            var1_1 = WebSocketClient.$jacocoInit();
            var3_2 = this.uri.getPath();
            var1_1[62] = true;
            var4_3 = this.uri.getQuery();
            var1_1[63] = true;
            if (part1 != null) break block10;
            var1_1[64] = true;
            ** GOTO lbl12
        }
        if (part1.length() == 0) {
            var1_1[65] = true;
lbl12:
            // 2 sources

            path = "/";
            var1_1[66] = true;
        } else {
            path = part1;
            var1_1[67] = true;
        }
        if (part2 == null) {
            var1_1[68] = true;
        } else {
            var1_1[69] = true;
            path = path + "?" + (String)part2;
            var1_1[70] = true;
        }
        var5_5 = this.getPort();
        var1_1[71] = true;
        v0 = new StringBuilder().append(this.uri.getHost());
        if (port != 80) {
            v1 = ":" + (int)port;
            var1_1[72] = true;
        } else {
            v1 = "";
            var1_1[73] = true;
        }
        var6_6 = v0.append(v1).toString();
        var1_1[74] = true;
        var7_7 = new HandshakeImpl1Client();
        var1_1[75] = true;
        handshake.setResourceDescriptor(path);
        var1_1[76] = true;
        handshake.put("Host", (String)host);
        if (this.headers == null) {
            var1_1[77] = true;
        } else {
            var1_1[78] = true;
            var8_8 = this.headers.entrySet().iterator();
            var1_1[79] = true;
            while (true) {
                if (!var8_8.hasNext()) {
                    var1_1[80] = true;
                    break;
                }
                var9_9 = var8_8.next();
                var1_1[81] = true;
                handshake.put((String)kv.getKey(), (String)kv.getValue());
                var1_1[82] = true;
            }
        }
        this.engine.startHandshake((ClientHandshakeBuilder)handshake);
        var1_1[83] = true;
    }

    @Override
    public WebSocket.READYSTATE getReadyState() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[84] = true;
        return this.engine.getReadyState();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onWebsocketMessage(WebSocket webSocket, String string) {
        void message;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.onMessage((String)message);
        blArray[85] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onWebsocketMessage(WebSocket webSocket, ByteBuffer byteBuffer) {
        void blob;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.onMessage((ByteBuffer)blob);
        blArray[86] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onWebsocketMessageFragment(WebSocket webSocket, Framedata framedata) {
        void frame;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.onFragment((Framedata)frame);
        blArray[87] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onWebsocketOpen(WebSocket webSocket, Handshakedata handshakedata) {
        void handshake;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.connectLatch.countDown();
        blArray[88] = true;
        this.onOpen((ServerHandshake)handshake);
        blArray[89] = true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void onWebsocketClose(WebSocket var1_1, int var2_2, String var3_3, boolean var4_4) {
        block4: {
            var5_5 = WebSocketClient.$jacocoInit();
            this.connectLatch.countDown();
            var5_5[90] = true;
            this.closeLatch.countDown();
            if (this.writeThread != null) break block4;
            var5_5[91] = true;
            ** GOTO lbl13
        }
        var5_5[92] = true;
        this.writeThread.interrupt();
        try {
            var5_5[93] = true;
lbl13:
            // 2 sources

            if (this.socket == null) {
                var5_5[94] = true;
            } else {
                var5_5[95] = true;
                this.socket.close();
                var5_5[96] = true;
            }
            var5_5[97] = true;
        }
        catch (IOException var6_6) {
            var5_5[98] = true;
            this.onWebsocketError(this, (Exception)e);
            var5_5[99] = true;
        }
        this.onClose((int)code, (String)reason, (boolean)remote);
        var5_5[100] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onWebsocketError(WebSocket webSocket, Exception exception) {
        void ex;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.onError((Exception)ex);
        blArray[101] = true;
    }

    @Override
    public final void onWriteDemand(WebSocket webSocket) {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[102] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onWebsocketCloseInitiated(WebSocket webSocket, int n, String string) {
        void reason;
        void code;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.onCloseInitiated((int)code, (String)reason);
        blArray[103] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onWebsocketClosing(WebSocket webSocket, int n, String string, boolean bl) {
        void remote;
        void reason;
        void code;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.onClosing((int)code, (String)reason, (boolean)remote);
        blArray[104] = true;
    }

    public void onCloseInitiated(int n, String string) {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[105] = true;
    }

    public void onClosing(int n, String string, boolean bl) {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[106] = true;
    }

    public WebSocket getConnection() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[107] = true;
        return this.engine;
    }

    @Override
    public InetSocketAddress getLocalSocketAddress(WebSocket webSocket) {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        if (this.socket != null) {
            blArray[108] = true;
            blArray[109] = true;
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }
        blArray[110] = true;
        return null;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress(WebSocket webSocket) {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        if (this.socket != null) {
            blArray[111] = true;
            blArray[112] = true;
            return (InetSocketAddress)this.socket.getRemoteSocketAddress();
        }
        blArray[113] = true;
        return null;
    }

    public abstract void onOpen(ServerHandshake var1);

    public abstract void onMessage(String var1);

    public abstract void onClose(int var1, String var2, boolean var3);

    public abstract void onError(Exception var1);

    public void onMessage(ByteBuffer byteBuffer) {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[114] = true;
    }

    public void onFragment(Framedata framedata) {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[115] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setProxy(Proxy proxy) {
        void proxy2;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        if (proxy2 == null) {
            blArray[116] = true;
            blArray[117] = true;
            throw new IllegalArgumentException();
        }
        this.proxy = proxy2;
        blArray[118] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setSocket(Socket socket) {
        void socket2;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        if (this.socket != null) {
            blArray[119] = true;
            blArray[120] = true;
            throw new IllegalStateException("socket has already been set");
        }
        this.socket = socket2;
        blArray[121] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendFragmentedFrame(Framedata.Opcode opcode, ByteBuffer byteBuffer, boolean bl) {
        void fin;
        void buffer;
        void op;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.engine.sendFragmentedFrame((Framedata.Opcode)op, (ByteBuffer)buffer, (boolean)fin);
        blArray[122] = true;
    }

    @Override
    public boolean isOpen() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[123] = true;
        return this.engine.isOpen();
    }

    @Override
    public boolean isFlushAndClose() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[124] = true;
        return this.engine.isFlushAndClose();
    }

    @Override
    public boolean isClosed() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[125] = true;
        return this.engine.isClosed();
    }

    @Override
    public boolean isClosing() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[126] = true;
        return this.engine.isClosing();
    }

    @Override
    public boolean isConnecting() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[127] = true;
        return this.engine.isConnecting();
    }

    @Override
    public boolean hasBufferedData() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[128] = true;
        return this.engine.hasBufferedData();
    }

    @Override
    public void close(int n) {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.engine.close();
        blArray[129] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close(int n, String string) {
        void message;
        void code;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.engine.close((int)code, (String)message);
        blArray[130] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeConnection(int n, String string) {
        void message;
        void code;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.engine.closeConnection((int)code, (String)message);
        blArray[131] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(ByteBuffer byteBuffer) throws IllegalArgumentException, NotYetConnectedException {
        void bytes;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.engine.send((ByteBuffer)bytes);
        blArray[132] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendFrame(Framedata framedata) {
        void framedata2;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        this.engine.sendFrame((Framedata)framedata2);
        blArray[133] = true;
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[134] = true;
        return this.engine.getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[135] = true;
        return this.engine.getRemoteSocketAddress();
    }

    @Override
    public String getResourceDescriptor() {
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[136] = true;
        return this.uri.getPath();
    }

    static /* synthetic */ WebSocketImpl access$100(WebSocketClient webSocketClient) {
        WebSocketClient x0;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[137] = true;
        return x0.engine;
    }

    static /* synthetic */ OutputStream access$200(WebSocketClient webSocketClient) {
        WebSocketClient x0;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        blArray[138] = true;
        return x0.ostream;
    }

    static {
        boolean bl;
        boolean[] blArray = WebSocketClient.$jacocoInit();
        if (!WebSocketClient.class.desiredAssertionStatus()) {
            bl = blArray[139] = true;
        } else {
            bl = false;
            blArray[140] = true;
        }
        $assertionsDisabled = bl;
        blArray[141] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-5566240659459279120L, (String)"com/mixpanel/android/java_websocket/client/WebSocketClient", (int)142);
        }
        return blArray;
    }

    private class WebsocketWriteThread
    implements Runnable {
        final /* synthetic */ WebSocketClient this$0;
        private static transient /* synthetic */ boolean[] $jacocoData;

        private WebsocketWriteThread(WebSocketClient webSocketClient) {
            boolean[] blArray = WebsocketWriteThread.$jacocoInit();
            this.this$0 = webSocketClient;
            blArray[0] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            boolean[] blArray = WebsocketWriteThread.$jacocoInit();
            Thread.currentThread().setName("WebsocketWriteThread");
            try {
                blArray[1] = true;
                while (!Thread.interrupted()) {
                    void buffer;
                    blArray[2] = true;
                    ByteBuffer byteBuffer = WebSocketClient.access$100((WebSocketClient)this.this$0).outQueue.take();
                    blArray[3] = true;
                    WebSocketClient.access$200(this.this$0).write(buffer.array(), 0, buffer.limit());
                    blArray[4] = true;
                    WebSocketClient.access$200(this.this$0).flush();
                    blArray[5] = true;
                }
                blArray[6] = true;
            }
            catch (IOException buffer) {
                blArray[7] = true;
                WebSocketClient.access$100(this.this$0).eot();
                blArray[8] = true;
            }
            catch (InterruptedException interruptedException) {
                blArray[9] = true;
            }
            blArray[10] = true;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ WebsocketWriteThread(WebSocketClient webSocketClient, 1 var2_2) {
            void x0;
            boolean[] blArray = WebsocketWriteThread.$jacocoInit();
            this((WebSocketClient)x0);
            blArray[11] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-5078051803535300618L, (String)"com/mixpanel/android/java_websocket/client/WebSocketClient$WebsocketWriteThread", (int)12);
            }
            return blArray;
        }
    }
}

