/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.mixpanel.android.mpmetrics.BadDecideObjectException;
import com.mixpanel.android.mpmetrics.DecideMessages;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MiniInAppNotification;
import com.mixpanel.android.mpmetrics.SystemInformation;
import com.mixpanel.android.mpmetrics.TakeoverInAppNotification;
import com.mixpanel.android.util.ImageStore;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.RemoteService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DecideChecker {
    private static final String LOGTAG = "MixpanelAPI.DChecker";
    private final MPConfig mConfig;
    private final Context mContext;
    private final Map<String, DecideMessages> mChecks;
    private final ImageStore mImageStore;
    private final SystemInformation mSystemInformation;
    private static final JSONArray EMPTY_JSON_ARRAY = new JSONArray();
    private static final String NOTIFICATIONS = "notifications";
    private static final String EVENT_BINDINGS = "event_bindings";
    private static final String VARIANTS = "variants";
    private static final String AUTOMATIC_EVENTS = "automatic_events";
    private static final String INTEGRATIONS = "integrations";

    public DecideChecker(Context context, MPConfig config) {
        this.mContext = context;
        this.mConfig = config;
        this.mChecks = new HashMap<String, DecideMessages>();
        this.mImageStore = this.createImageStore(context);
        this.mSystemInformation = SystemInformation.getInstance(context);
    }

    protected ImageStore createImageStore(Context context) {
        return new ImageStore(context, "DecideChecker");
    }

    public void addDecideCheck(DecideMessages check) {
        this.mChecks.put(check.getToken(), check);
    }

    public void runDecideCheck(String token, RemoteService poster) throws RemoteService.ServiceUnavailableException {
        DecideMessages updates = this.mChecks.get(token);
        if (updates != null) {
            String distinctId = updates.getDistinctId();
            try {
                Result result = this.runDecideCheck(updates.getToken(), distinctId, poster);
                if (result != null) {
                    updates.reportResults(result.notifications, result.eventTriggeredNotifications, result.eventBindings, result.variants, result.automaticEvents, result.integrations);
                }
            }
            catch (UnintelligibleMessageException e) {
                MPLog.e(LOGTAG, e.getMessage(), e);
            }
        }
    }

    private void setImages(Iterator<InAppNotification> notificationIterator) throws RemoteService.ServiceUnavailableException {
        while (notificationIterator.hasNext()) {
            InAppNotification notification = notificationIterator.next();
            Bitmap image = this.getNotificationImage(notification, this.mContext);
            if (null == image) {
                MPLog.i(LOGTAG, "Could not retrieve image for notification " + notification.getId() + ", will not show the notification.");
                notificationIterator.remove();
                continue;
            }
            notification.setImage(image);
        }
    }

    private Result runDecideCheck(String token, String distinctId, RemoteService poster) throws RemoteService.ServiceUnavailableException, UnintelligibleMessageException {
        String responseString = this.getDecideResponseFromServer(token, distinctId, poster);
        MPLog.v(LOGTAG, "Mixpanel decide server response was:\n" + responseString);
        Result parsedResult = null;
        if (responseString != null) {
            parsedResult = DecideChecker.parseDecideResponse(responseString);
            this.setImages(parsedResult.notifications.iterator());
            this.setImages(parsedResult.eventTriggeredNotifications.iterator());
        }
        return parsedResult;
    }

    private static List<InAppNotification> parseInAppNotifications(JSONObject response) {
        JSONArray notifications = null;
        ArrayList<InAppNotification> ret = new ArrayList<InAppNotification>();
        if (response.has(NOTIFICATIONS)) {
            try {
                notifications = response.getJSONArray(NOTIFICATIONS);
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Mixpanel endpoint returned non-array JSON for notifications: " + response);
            }
        }
        if (null != notifications) {
            int triggeredCount = 0;
            int normalCount = 0;
            for (int i = 0; i < notifications.length(); ++i) {
                try {
                    InAppNotification notification;
                    JSONObject notificationJson = notifications.getJSONObject(i);
                    if (notificationJson.has("display_triggers")) {
                        if (triggeredCount >= 2) continue;
                        ++triggeredCount;
                    } else {
                        if (normalCount >= 2) continue;
                        ++normalCount;
                    }
                    String notificationType = notificationJson.getString("type");
                    if (notificationType.equalsIgnoreCase("takeover")) {
                        notification = new TakeoverInAppNotification(notificationJson);
                        ret.add(notification);
                        continue;
                    }
                    if (!notificationType.equalsIgnoreCase("mini")) continue;
                    notification = new MiniInAppNotification(notificationJson);
                    ret.add(notification);
                    continue;
                }
                catch (JSONException e) {
                    MPLog.e(LOGTAG, "Received a strange response from notifications service: " + notifications.toString(), e);
                    continue;
                }
                catch (BadDecideObjectException e) {
                    MPLog.e(LOGTAG, "Received a strange response from notifications service: " + notifications.toString(), e);
                    continue;
                }
                catch (OutOfMemoryError e) {
                    MPLog.e(LOGTAG, "Not enough memory to show load notification from package: " + notifications.toString(), e);
                }
            }
        }
        return ret;
    }

    static Result parseDecideResponse(String responseString) throws UnintelligibleMessageException {
        JSONObject response;
        Result ret = new Result();
        try {
            response = new JSONObject(responseString);
        }
        catch (JSONException e) {
            String message = "Mixpanel endpoint returned unparsable result:\n" + responseString;
            throw new UnintelligibleMessageException(message, e);
        }
        for (InAppNotification notif : DecideChecker.parseInAppNotifications(response)) {
            if (notif.isEventTriggered()) {
                ret.eventTriggeredNotifications.add(notif);
                continue;
            }
            ret.notifications.add(notif);
        }
        if (response.has(EVENT_BINDINGS)) {
            try {
                ret.eventBindings = response.getJSONArray(EVENT_BINDINGS);
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Mixpanel endpoint returned non-array JSON for event bindings: " + response);
            }
        }
        if (response.has(VARIANTS)) {
            try {
                ret.variants = response.getJSONArray(VARIANTS);
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Mixpanel endpoint returned non-array JSON for variants: " + response);
            }
        }
        if (response.has(AUTOMATIC_EVENTS)) {
            try {
                ret.automaticEvents = response.getBoolean(AUTOMATIC_EVENTS);
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Mixpanel endpoint returned a non boolean value for automatic events: " + response);
            }
        }
        if (response.has(INTEGRATIONS)) {
            try {
                ret.integrations = response.getJSONArray(INTEGRATIONS);
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Mixpanel endpoint returned a non-array JSON for integrations: " + response);
            }
        }
        return ret;
    }

    private String getDecideResponseFromServer(String unescapedToken, String unescapedDistinctId, RemoteService poster) throws RemoteService.ServiceUnavailableException {
        String escapedId;
        String escapedToken;
        try {
            escapedToken = URLEncoder.encode(unescapedToken, "utf-8");
            escapedId = null != unescapedDistinctId ? URLEncoder.encode(unescapedDistinctId, "utf-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Mixpanel library requires utf-8 string encoding to be available", e);
        }
        StringBuilder queryBuilder = new StringBuilder().append("?version=1&lib=android&token=").append(escapedToken);
        if (null != escapedId) {
            queryBuilder.append("&distinct_id=").append(escapedId);
        }
        queryBuilder.append("&properties=");
        JSONObject properties = new JSONObject();
        try {
            properties.putOpt("$android_lib_version", (Object)"5.8.8");
            properties.putOpt("$android_app_version", (Object)this.mSystemInformation.getAppVersionName());
            properties.putOpt("$android_version", (Object)Build.VERSION.RELEASE);
            properties.putOpt("$android_app_release", (Object)this.mSystemInformation.getAppVersionCode());
            properties.putOpt("$android_device_model", (Object)Build.MODEL);
            queryBuilder.append(URLEncoder.encode(properties.toString(), "utf-8"));
        }
        catch (Exception e) {
            MPLog.e(LOGTAG, "Exception constructing properties JSON", e.getCause());
        }
        String checkQuery = queryBuilder.toString();
        String url = this.mConfig.getDecideEndpoint() + checkQuery;
        MPLog.v(LOGTAG, "Querying decide server, url: " + url);
        byte[] response = DecideChecker.checkDecide(poster, this.mContext, url);
        if (null == response) {
            return null;
        }
        try {
            return new String(response, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF not supported on this platform?", e);
        }
    }

    private Bitmap getNotificationImage(InAppNotification notification, Context context) throws RemoteService.ServiceUnavailableException {
        String[] urls = new String[]{notification.getImage2xUrl(), notification.getImageUrl()};
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int displayWidth = DecideChecker.getDisplayWidth(display);
        if (notification.getType() == InAppNotification.Type.TAKEOVER && displayWidth >= 720) {
            urls = new String[]{notification.getImage4xUrl(), notification.getImage2xUrl(), notification.getImageUrl()};
        }
        for (String url : urls) {
            try {
                return this.mImageStore.getImage(url);
            }
            catch (ImageStore.CantGetImageException e) {
                MPLog.v(LOGTAG, "Can't load image " + url + " for a notification", e);
            }
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private static int getDisplayWidth(Display display) {
        if (Build.VERSION.SDK_INT < 13) {
            return display.getWidth();
        }
        Point displaySize = new Point();
        display.getSize(displaySize);
        return displaySize.x;
    }

    private static byte[] checkDecide(RemoteService poster, Context context, String url) throws RemoteService.ServiceUnavailableException {
        MPConfig config = MPConfig.getInstance(context);
        if (!poster.isOnline(context, config.getOfflineMode())) {
            return null;
        }
        byte[] response = null;
        try {
            SSLSocketFactory socketFactory = config.getSSLSocketFactory();
            response = poster.performRequest(url, null, socketFactory);
        }
        catch (MalformedURLException e) {
            MPLog.e(LOGTAG, "Cannot interpret " + url + " as a URL.", e);
        }
        catch (FileNotFoundException e) {
            MPLog.v(LOGTAG, "Cannot get " + url + ", file not found.", e);
        }
        catch (IOException e) {
            MPLog.v(LOGTAG, "Cannot get " + url + ".", e);
        }
        catch (OutOfMemoryError e) {
            MPLog.e(LOGTAG, "Out of memory when getting to " + url + ".", e);
        }
        return response;
    }

    public DecideMessages getDecideMessages(String token) {
        return this.mChecks.get(token);
    }

    static /* synthetic */ JSONArray access$000() {
        return EMPTY_JSON_ARRAY;
    }

    static class UnintelligibleMessageException
    extends Exception {
        private static final long serialVersionUID = -6501269367559104957L;

        public UnintelligibleMessageException(String message, JSONException cause) {
            super(message, cause);
        }
    }

    static class Result {
        public final List<InAppNotification> notifications = new ArrayList<InAppNotification>();
        public final List<InAppNotification> eventTriggeredNotifications = new ArrayList<InAppNotification>();
        public JSONArray eventBindings = DecideChecker.access$000();
        public JSONArray variants = DecideChecker.access$000();
        public boolean automaticEvents = false;
        public JSONArray integrations;
    }
}

