/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class InAppButton
implements Parcelable {
    private static final String LOGTAG = "MixpanelAPI.InAppButton";
    private JSONObject mDescription;
    private String mText;
    private int mTextColor;
    private int mBackgroundColor;
    private int mBorderColor;
    private String mCtaUrl;
    public static final Parcelable.Creator<InAppButton> CREATOR = new Parcelable.Creator<InAppButton>(){

        public InAppButton createFromParcel(Parcel source) {
            return new InAppButton(source);
        }

        public InAppButton[] newArray(int size) {
            return new InAppButton[size];
        }
    };

    public InAppButton(Parcel in) {
        JSONObject temp = new JSONObject();
        try {
            temp = new JSONObject(in.readString());
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Error reading JSON when creating InAppButton from Parcel");
        }
        this.mDescription = temp;
        this.mText = in.readString();
        this.mTextColor = in.readInt();
        this.mBackgroundColor = in.readInt();
        this.mBorderColor = in.readInt();
        this.mCtaUrl = in.readString();
    }

    InAppButton(JSONObject description) throws JSONException {
        this.mDescription = description;
        this.mText = description.getString("text");
        this.mTextColor = description.getInt("text_color");
        this.mBackgroundColor = description.getInt("bg_color");
        this.mBorderColor = description.getInt("border_color");
        this.mCtaUrl = description.getString("cta_url");
    }

    public String getText() {
        return this.mText;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public String getCtaUrl() {
        return this.mCtaUrl;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mDescription.toString());
        dest.writeString(this.mText);
        dest.writeInt(this.mTextColor);
        dest.writeInt(this.mBackgroundColor);
        dest.writeInt(this.mBorderColor);
        dest.writeString(this.mCtaUrl);
    }

    public String toString() {
        return this.mDescription.toString();
    }
}

