/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import com.mixpanel.android.mpmetrics.AnalyticsMessages;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MPDbAdapter;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.viewcrawler.UpdatesFromMixpanel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DecideMessages {
    private String mDistinctId;
    private final String mToken;
    private final Set<Integer> mNotificationIds;
    private final List<InAppNotification> mUnseenNotifications;
    private final List<InAppNotification> mUnseenEventTriggeredNotifications;
    private final OnNewResultsListener mListener;
    private final UpdatesFromMixpanel mUpdatesFromMixpanel;
    private JSONArray mVariants;
    private static final Set<Integer> mLoadedVariants = new HashSet<Integer>();
    private Boolean mAutomaticEventsEnabled;
    private Context mContext;
    private Set<String> mIntegrations;
    private static final String LOGTAG = "MixpanelAPI.DecideUpdts";

    public DecideMessages(Context context, String token, OnNewResultsListener listener, UpdatesFromMixpanel updatesFromMixpanel, HashSet<Integer> notificationIds) {
        this.mContext = context;
        this.mToken = token;
        this.mListener = listener;
        this.mUpdatesFromMixpanel = updatesFromMixpanel;
        this.mDistinctId = null;
        this.mUnseenNotifications = new LinkedList<InAppNotification>();
        this.mNotificationIds = new HashSet<Integer>(notificationIds);
        this.mUnseenEventTriggeredNotifications = new LinkedList<InAppNotification>();
        this.mVariants = null;
        this.mIntegrations = new HashSet<String>();
    }

    public String getToken() {
        return this.mToken;
    }

    public synchronized void setDistinctId(String distinctId) {
        if (this.mDistinctId == null || !this.mDistinctId.equals(distinctId)) {
            this.mUnseenNotifications.clear();
        }
        this.mDistinctId = distinctId;
    }

    public synchronized String getDistinctId() {
        return this.mDistinctId;
    }

    public synchronized void reportResults(List<InAppNotification> newNotifications, List<InAppNotification> newTriggeredNotifications, JSONArray eventBindings, JSONArray variants, boolean automaticEvents, JSONArray integrations) {
        JSONObject variant;
        int i;
        int id2;
        boolean newContent = false;
        int newVariantsLength = variants.length();
        boolean hasNewVariants = false;
        this.mUpdatesFromMixpanel.setEventBindings(eventBindings);
        for (InAppNotification n : newNotifications) {
            id2 = n.getId();
            if (this.mNotificationIds.contains(id2)) continue;
            this.mNotificationIds.add(id2);
            this.mUnseenNotifications.add(n);
            newContent = true;
        }
        for (InAppNotification n : newTriggeredNotifications) {
            id2 = n.getId();
            if (this.mNotificationIds.contains(id2)) continue;
            this.mNotificationIds.add(id2);
            this.mUnseenEventTriggeredNotifications.add(n);
            newContent = true;
        }
        this.mVariants = variants;
        for (i = 0; i < newVariantsLength; ++i) {
            try {
                variant = variants.getJSONObject(i);
                if (mLoadedVariants.contains(variant.getInt("id"))) continue;
                newContent = true;
                hasNewVariants = true;
                break;
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Could not convert variants[" + i + "] into a JSONObject while comparing the new variants", e);
            }
        }
        if (hasNewVariants && this.mVariants != null) {
            mLoadedVariants.clear();
            for (i = 0; i < newVariantsLength; ++i) {
                try {
                    variant = this.mVariants.getJSONObject(i);
                    mLoadedVariants.add(variant.getInt("id"));
                    continue;
                }
                catch (JSONException e) {
                    MPLog.e(LOGTAG, "Could not convert variants[" + i + "] into a JSONObject while updating the map", e);
                }
            }
        }
        if (newVariantsLength == 0) {
            this.mVariants = new JSONArray();
            if (mLoadedVariants.size() > 0) {
                mLoadedVariants.clear();
                newContent = true;
            }
        }
        this.mUpdatesFromMixpanel.storeVariants(this.mVariants);
        if (this.mAutomaticEventsEnabled == null && !automaticEvents) {
            MPDbAdapter.getInstance(this.mContext).cleanupAutomaticEvents(this.mToken);
        }
        this.mAutomaticEventsEnabled = automaticEvents;
        if (integrations != null) {
            try {
                HashSet<String> integrationsSet = new HashSet<String>();
                for (int i2 = 0; i2 < integrations.length(); ++i2) {
                    integrationsSet.add(integrations.getString(i2));
                }
                if (!this.mIntegrations.equals(integrationsSet)) {
                    this.mIntegrations = integrationsSet;
                    newContent = true;
                }
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Got an integration id from " + integrations.toString() + " that wasn't an int", e);
            }
        }
        MPLog.v(LOGTAG, "New Decide content has become available. " + newNotifications.size() + " notifications and " + variants.length() + " experiments have been added.");
        if (newContent && null != this.mListener) {
            this.mListener.onNewResults();
        }
    }

    public synchronized JSONArray getVariants() {
        return this.mVariants;
    }

    public synchronized InAppNotification getNotification(boolean replace) {
        if (this.mUnseenNotifications.isEmpty()) {
            MPLog.v(LOGTAG, "No unseen notifications exist, none will be returned.");
            return null;
        }
        InAppNotification n = this.mUnseenNotifications.remove(0);
        if (replace) {
            this.mUnseenNotifications.add(n);
        } else {
            MPLog.v(LOGTAG, "Recording notification " + n + " as seen.");
        }
        return n;
    }

    public synchronized InAppNotification getNotification(int id2, boolean replace) {
        InAppNotification notif = null;
        for (int i = 0; i < this.mUnseenNotifications.size(); ++i) {
            if (this.mUnseenNotifications.get(i).getId() != id2) continue;
            notif = this.mUnseenNotifications.get(i);
            if (replace) break;
            this.mUnseenNotifications.remove(i);
            break;
        }
        return notif;
    }

    public synchronized InAppNotification getNotification(AnalyticsMessages.EventDescription eventDescription, boolean replace) {
        for (int i = 0; i < this.mUnseenEventTriggeredNotifications.size(); ++i) {
            InAppNotification n = this.mUnseenEventTriggeredNotifications.get(i);
            if (!n.matchesEventDescription(eventDescription)) continue;
            if (!replace) {
                this.mUnseenEventTriggeredNotifications.remove(i);
            }
            return n;
        }
        return null;
    }

    public synchronized Set<String> getIntegrations() {
        return this.mIntegrations;
    }

    public synchronized void markNotificationAsUnseen(InAppNotification notif) {
        if (!MPConfig.DEBUG) {
            if (notif.isEventTriggered()) {
                this.mUnseenEventTriggeredNotifications.add(notif);
            } else {
                this.mUnseenNotifications.add(notif);
            }
        }
    }

    public synchronized boolean hasUpdatesAvailable() {
        return !this.mUnseenNotifications.isEmpty() || this.mVariants != null && this.mVariants.length() > 0;
    }

    synchronized boolean hasNotificationsAvailable() {
        return !this.mUnseenEventTriggeredNotifications.isEmpty() || !this.mUnseenNotifications.isEmpty();
    }

    public Boolean isAutomaticEventsEnabled() {
        return this.mAutomaticEventsEnabled;
    }

    public boolean shouldTrackAutomaticEvent() {
        return this.isAutomaticEventsEnabled() == null ? true : this.isAutomaticEventsEnabled();
    }

    public static interface OnNewResultsListener {
        public void onNewResults();
    }
}

