/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.MixpanelNotificationData;
import com.mixpanel.android.mpmetrics.MixpanelWebViewActivity;
import com.mixpanel.android.util.MPLog;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelNotificationRouteActivity
extends Activity {
    protected final String LOGTAG = "MixpanelAPI.MixpanelNotificationRouteActivity";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent routeIntent = this.getIntent();
        Bundle extras = routeIntent.getExtras();
        if (null == routeIntent) {
            MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Notification route activity given null intent.");
            return;
        }
        this.trackAction(routeIntent);
        Intent notificationIntent = this.handleRouteIntent(routeIntent);
        if (!extras.getBoolean("sticky")) {
            this.cancelNotification(extras);
        }
        this.startActivity(notificationIntent);
    }

    protected Intent handleRouteIntent(Intent routeIntent) {
        MixpanelNotificationData.PushTapTarget target;
        CharSequence actionTypeChars = routeIntent.getExtras().getCharSequence("actionType");
        if (null == actionTypeChars) {
            MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Notification action click logged with no action type");
            target = MixpanelNotificationData.PushTapTarget.HOMESCREEN;
        } else {
            target = MixpanelNotificationData.PushTapTarget.fromString(actionTypeChars.toString());
        }
        CharSequence uri = routeIntent.getExtras().getCharSequence("uri");
        Intent defaultIntent = this.getPackageManager().getLaunchIntentForPackage(this.getPackageName());
        switch (target) {
            case HOMESCREEN: {
                return defaultIntent;
            }
            case URL_IN_BROWSER: {
                if (this.isValidURL(uri.toString(), false)) {
                    return new Intent("android.intent.action.VIEW", Uri.parse((String)uri.toString()));
                }
                MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Wanted to open url in browser but url is invalid: " + uri.toString() + ". Starting default intent");
                return defaultIntent;
            }
            case URL_IN_WEBVIEW: {
                if (this.isValidURL(uri.toString(), true)) {
                    return new Intent(this.getApplicationContext(), MixpanelWebViewActivity.class).putExtra("uri", uri.toString()).setFlags(0x4000000);
                }
                MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Wanted to open url in webview but url is invalid or not secure (http): " + uri.toString() + ". Starting default intent");
                return defaultIntent;
            }
            case DEEP_LINK: {
                return new Intent("android.intent.action.VIEW", Uri.parse((String)uri.toString()));
            }
        }
        return defaultIntent;
    }

    protected boolean isValidURL(CharSequence url, boolean requireHttps) {
        if (requireHttps) {
            return null != url && url.toString().startsWith("https");
        }
        return null != url && url.toString().startsWith("http");
    }

    protected void cancelNotification(Bundle extras) {
        int notificationId = extras.getInt("notificationId");
        Context context = this.getApplicationContext();
        this.getApplicationContext();
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(notificationId);
    }

    protected void trackAction(Intent routeIntent) {
        CharSequence campaignIdChars;
        String label;
        String buttonId;
        Bundle intentExtras = routeIntent.getExtras();
        CharSequence tapTargetChars = intentExtras.getCharSequence("tapTarget");
        if (null == tapTargetChars) {
            MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Notification action click logged with no tapTarget");
            return;
        }
        final String tapTarget = tapTargetChars.toString();
        if (tapTarget.equals("button")) {
            CharSequence labelChars;
            CharSequence buttonIdChars = intentExtras.getCharSequence("buttonId");
            if (null == buttonIdChars) {
                MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Notification action click logged with no buttonId");
            }
            if (null == (labelChars = intentExtras.getCharSequence("label"))) {
                MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Notification action click logged with no label");
            }
            buttonId = buttonIdChars == null ? null : buttonIdChars.toString();
            label = labelChars == null ? null : labelChars.toString();
        } else {
            buttonId = null;
            label = null;
        }
        CharSequence messageIdChars = intentExtras.getCharSequence("messageId");
        if (null == messageIdChars) {
            MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Notification action click logged with no messageId");
        }
        if (null == (campaignIdChars = intentExtras.getCharSequence("campaignId"))) {
            MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Notification action click logged with no campaignId");
        }
        final String messageId = messageIdChars == null ? null : messageIdChars.toString();
        final String campaignId = campaignIdChars == null ? null : campaignIdChars.toString();
        MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

            @Override
            public void process(MixpanelAPI api) {
                JSONObject pushProps = new JSONObject();
                try {
                    pushProps.put("tap_target", (Object)tapTarget);
                    if (tapTarget.equals("button")) {
                        pushProps.put("button_id", (Object)buttonId);
                        pushProps.put("button_label", (Object)label);
                    }
                    pushProps.put("message_id", (Object)messageId);
                    pushProps.put("campaign_id", (Object)campaignId);
                }
                catch (JSONException e) {
                    MPLog.e("MixpanelAPI.MixpanelNotificationRouteActivity", "Error loading tracking JSON properties.");
                }
                api.track("$push_notification_tap", pushProps);
            }
        });
    }
}

