/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.MixpanelNotificationData;
import com.mixpanel.android.mpmetrics.MixpanelPushNotification;
import com.mixpanel.android.util.MPLog;

public class MixpanelFCMMessagingService
extends FirebaseMessagingService {
    private static final String LOGTAG = "MixpanelAPI.MixpanelFCMMessagingService";
    private static final int NOTIFICATION_ID = 1;

    static void init() {
        FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

            public void onComplete(Task<InstanceIdResult> task) {
                if (task.isSuccessful()) {
                    String registrationId = ((InstanceIdResult)task.getResult()).getToken();
                    MixpanelFCMMessagingService.addToken(registrationId);
                }
            }
        });
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        MPLog.d(LOGTAG, "MP FCM on new message received");
        this.onMessageReceived(this.getApplicationContext(), remoteMessage.toIntent());
    }

    public void onNewToken(String token) {
        super.onNewToken(token);
        MPLog.d(LOGTAG, "MP FCM on new push token: " + token);
        MixpanelFCMMessagingService.addToken(token);
    }

    protected void onMessageReceived(Context context, Intent intent) {
        MixpanelFCMMessagingService.showPushNotification(context, intent);
    }

    public static void addToken(final String token) {
        MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

            @Override
            public void process(MixpanelAPI api) {
                api.getPeople().setPushRegistrationId(token);
            }
        });
    }

    public static void showPushNotification(Context context, Intent messageIntent) {
        MixpanelPushNotification mixpanelPushNotification = new MixpanelPushNotification(context.getApplicationContext());
        MixpanelFCMMessagingService.showPushNotification(context, messageIntent, mixpanelPushNotification);
    }

    public static void showPushNotification(Context context, Intent messageIntent, MixpanelPushNotification mixpanelPushNotification) {
        Notification notification = mixpanelPushNotification.createNotification(messageIntent);
        MixpanelNotificationData data = mixpanelPushNotification.getData();
        String message = data == null ? "null" : data.getMessage();
        MPLog.d(LOGTAG, "MP FCM notification received: " + message);
        if (null != notification) {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (null != data.getTag()) {
                notificationManager.notify(data.getTag(), 1, notification);
            } else {
                notificationManager.notify(mixpanelPushNotification.notificationId, notification);
            }
        }
    }
}

