/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import com.mixpanel.android.takeoverinapp.TakeoverInAppActivity;
import com.mixpanel.android.util.MPLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ConfigurationChecker {
    public static String LOGTAG = "MixpanelAPI.ConfigurationChecker";
    private static Boolean mTakeoverActivityAvailable;

    ConfigurationChecker() {
    }

    public static boolean checkBasicConfiguration(Context context) {
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        if (packageManager == null || packageName == null) {
            MPLog.w(LOGTAG, "Can't check configuration when using a Context with null packageManager or packageName");
            return false;
        }
        if (0 != packageManager.checkPermission("android.permission.INTERNET", packageName)) {
            MPLog.w(LOGTAG, "Package does not have permission android.permission.INTERNET - Mixpanel will not work at all!");
            MPLog.i(LOGTAG, "You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.INTERNET\" />");
            return false;
        }
        return true;
    }

    public static boolean checkTakeoverInAppActivityAvailable(Context context) {
        if (mTakeoverActivityAvailable == null) {
            if (Build.VERSION.SDK_INT < 16) {
                mTakeoverActivityAvailable = false;
                return mTakeoverActivityAvailable;
            }
            Intent takeoverInAppIntent = new Intent(context, TakeoverInAppActivity.class);
            takeoverInAppIntent.addFlags(0x10000000);
            takeoverInAppIntent.addFlags(131072);
            PackageManager packageManager = context.getPackageManager();
            List intentActivities = packageManager.queryIntentActivities(takeoverInAppIntent, 0);
            if (intentActivities.size() == 0) {
                MPLog.w(LOGTAG, TakeoverInAppActivity.class.getName() + " is not registered as an activity in your application, so takeover in-apps can't be shown.");
                MPLog.i(LOGTAG, "Please add the child tag <activity android:name=\"com.mixpanel.android.takeoverinapp.TakeoverInAppActivity\" /> to your <application> tag.");
                mTakeoverActivityAvailable = false;
                return mTakeoverActivityAvailable;
            }
            mTakeoverActivityAvailable = true;
        }
        return mTakeoverActivityAvailable;
    }

    public static boolean checkPushNotificationConfiguration(Context context) {
        PackageInfo servicesInfo;
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        if (packageManager == null || packageName == null) {
            return false;
        }
        if (0 != packageManager.checkPermission("android.permission.INTERNET", packageName)) {
            MPLog.w(LOGTAG, "Package does not have permission android.permission.INTERNET");
            MPLog.i(LOGTAG, "You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.INTERNET\" />");
            return false;
        }
        try {
            servicesInfo = packageManager.getPackageInfo(packageName, 4);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        ServiceInfo[] services = servicesInfo.services;
        if (services == null || services.length == 0) {
            return false;
        }
        Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
        intent.setPackage(packageName);
        List intentServices = packageManager.queryIntentServices(intent, 128);
        Iterator it = intentServices.iterator();
        while (it.hasNext()) {
            ResolveInfo resolveInfo = (ResolveInfo)it.next();
            if (!resolveInfo.serviceInfo.name.equals("com.google.firebase.messaging.FirebaseMessagingService")) continue;
            it.remove();
        }
        if (intentServices == null || intentServices.size() == 0) {
            return false;
        }
        ArrayList<ServiceInfo> registeredServices = new ArrayList<ServiceInfo>();
        for (ResolveInfo intentService : intentServices) {
            for (ServiceInfo serviceInfo : services) {
                if (!serviceInfo.name.equals(intentService.serviceInfo.name) || !serviceInfo.isEnabled()) continue;
                registeredServices.add(intentService.serviceInfo);
            }
        }
        if (registeredServices.size() > 1) {
            MPLog.w(LOGTAG, "You can't have more than one service handling \"com.google.firebase.MESSAGING_EVENT\" intent filter. Android will only use the first one that is declared on your AndroidManifest.xml. If you have more than one push provider you need to crate your own FirebaseMessagingService class.");
        }
        try {
            Class.forName("com.google.android.gms.common.GooglePlayServicesUtil");
        }
        catch (ClassNotFoundException e) {
            MPLog.w(LOGTAG, "Google Play Services aren't included in your build- push notifications won't work on Lollipop/API 21 or greater");
            MPLog.i(LOGTAG, "You can fix this by adding com.google.android.gms:play-services as a dependency of your gradle or maven project");
        }
        return true;
    }
}

