/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.JsonWriter;
import android.util.Pair;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.OnMixpanelTweaksUpdatedListener;
import com.mixpanel.android.mpmetrics.ResourceReader;
import com.mixpanel.android.mpmetrics.SuperPropertyUpdate;
import com.mixpanel.android.mpmetrics.Tweaks;
import com.mixpanel.android.util.ImageStore;
import com.mixpanel.android.util.JSONUtils;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.viewcrawler.DynamicEventTracker;
import com.mixpanel.android.viewcrawler.EditProtocol;
import com.mixpanel.android.viewcrawler.EditState;
import com.mixpanel.android.viewcrawler.EditorConnection;
import com.mixpanel.android.viewcrawler.FlipGesture;
import com.mixpanel.android.viewcrawler.TrackingDebug;
import com.mixpanel.android.viewcrawler.UpdatesFromMixpanel;
import com.mixpanel.android.viewcrawler.ViewSnapshot;
import com.mixpanel.android.viewcrawler.ViewVisitor;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=16)
public class ViewCrawler
implements UpdatesFromMixpanel,
TrackingDebug,
ViewVisitor.OnLayoutErrorListener {
    private final MPConfig mConfig;
    private final Context mContext;
    private final MixpanelAPI mMixpanel;
    private final DynamicEventTracker mDynamicEventTracker;
    private final EditState mEditState;
    private final Tweaks mTweaks;
    private final Map<String, String> mDeviceInfo;
    private final ViewCrawlerHandler mMessageThreadHandler;
    private final float mScaledDensity;
    private final Set<OnMixpanelTweaksUpdatedListener> mTweaksUpdatedListeners;
    private static final String SHARED_PREF_EDITS_FILE = "mixpanel.viewcrawler.changes";
    private static final String SHARED_PREF_CHANGES_KEY = "mixpanel.viewcrawler.changes";
    private static final String SHARED_PREF_BINDINGS_KEY = "mixpanel.viewcrawler.bindings";
    private static final int MESSAGE_INITIALIZE_CHANGES = 0;
    private static final int MESSAGE_CONNECT_TO_EDITOR = 1;
    private static final int MESSAGE_SEND_STATE_FOR_EDITING = 2;
    private static final int MESSAGE_HANDLE_EDITOR_CHANGES_RECEIVED = 3;
    private static final int MESSAGE_SEND_DEVICE_INFO = 4;
    private static final int MESSAGE_EVENT_BINDINGS_RECEIVED = 5;
    private static final int MESSAGE_HANDLE_EDITOR_BINDINGS_RECEIVED = 6;
    private static final int MESSAGE_SEND_EVENT_TRACKED = 7;
    private static final int MESSAGE_HANDLE_EDITOR_CLOSED = 8;
    private static final int MESSAGE_VARIANTS_RECEIVED = 9;
    private static final int MESSAGE_HANDLE_EDITOR_CHANGES_CLEARED = 10;
    private static final int MESSAGE_HANDLE_EDITOR_TWEAKS_RECEIVED = 11;
    private static final int MESSAGE_SEND_LAYOUT_ERROR = 12;
    private static final int MESSAGE_PERSIST_VARIANTS_RECEIVED = 13;
    private static final int EMULATOR_CONNECT_ATTEMPT_INTERVAL_MILLIS = 30000;
    private static final String LOGTAG = "MixpanelAPI.ViewCrawler";

    public ViewCrawler(Context context, String token, MixpanelAPI mixpanel, Tweaks tweaks) {
        this.mConfig = MPConfig.getInstance(context);
        this.mContext = context;
        this.mEditState = new EditState();
        this.mTweaks = tweaks;
        this.mDeviceInfo = mixpanel.getDeviceInfo();
        this.mScaledDensity = Resources.getSystem().getDisplayMetrics().scaledDensity;
        this.mTweaksUpdatedListeners = Collections.newSetFromMap(new ConcurrentHashMap());
        HandlerThread thread = new HandlerThread(ViewCrawler.class.getCanonicalName());
        thread.setPriority(10);
        thread.start();
        this.mMessageThreadHandler = new ViewCrawlerHandler(context, token, thread.getLooper(), this);
        this.mDynamicEventTracker = new DynamicEventTracker(mixpanel, this.mMessageThreadHandler);
        this.mMixpanel = mixpanel;
        Application app = (Application)context.getApplicationContext();
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new LifecycleCallbacks());
        this.mTweaks.addOnTweakDeclaredListener(new Tweaks.OnTweakDeclaredListener(){

            @Override
            public void onTweakDeclared() {
                Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(4);
                ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
            }
        });
    }

    @Override
    public void startUpdates() {
        this.mMessageThreadHandler.start();
        this.applyPersistedUpdates();
    }

    @Override
    public void applyPersistedUpdates() {
        this.mMessageThreadHandler.sendMessage(this.mMessageThreadHandler.obtainMessage(0));
    }

    @Override
    public void storeVariants(JSONArray variants) {
        if (variants != null) {
            Message msg = this.mMessageThreadHandler.obtainMessage(13);
            msg.obj = variants;
            this.mMessageThreadHandler.sendMessage(msg);
        }
    }

    @Override
    public Tweaks getTweaks() {
        return this.mTweaks;
    }

    @Override
    public void setEventBindings(JSONArray bindings) {
        if (bindings != null) {
            Message msg = this.mMessageThreadHandler.obtainMessage(5);
            msg.obj = bindings;
            this.mMessageThreadHandler.sendMessage(msg);
        }
    }

    @Override
    public void setVariants(JSONArray variants) {
        if (variants != null) {
            Message msg = this.mMessageThreadHandler.obtainMessage(9);
            msg.obj = variants;
            this.mMessageThreadHandler.sendMessage(msg);
        }
    }

    @Override
    public void addOnMixpanelTweaksUpdatedListener(OnMixpanelTweaksUpdatedListener listener) {
        if (null == listener) {
            throw new NullPointerException("Listener cannot be null");
        }
        this.mTweaksUpdatedListeners.add(listener);
    }

    @Override
    public void removeOnMixpanelTweaksUpdatedListener(OnMixpanelTweaksUpdatedListener listener) {
        this.mTweaksUpdatedListeners.remove(listener);
    }

    @Override
    public void reportTrack(String eventName) {
        Message m = this.mMessageThreadHandler.obtainMessage();
        m.what = 7;
        m.obj = eventName;
        this.mMessageThreadHandler.sendMessage(m);
    }

    @Override
    public void onLayoutError(ViewVisitor.LayoutErrorMessage e) {
        Message m = this.mMessageThreadHandler.obtainMessage();
        m.what = 12;
        m.obj = e;
        this.mMessageThreadHandler.sendMessage(m);
    }

    private static class VariantTweak {
        public final String tweakName;
        public final JSONObject tweak;
        public final Pair<Integer, Integer> variantId;

        public VariantTweak(String aTweakName, JSONObject aTweak, Pair<Integer, Integer> aVariantId) {
            this.tweakName = aTweakName;
            this.tweak = aTweak;
            this.variantId = aVariantId;
        }

        public int hashCode() {
            return this.tweakName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof VariantTweak) {
                return obj.hashCode() == this.hashCode();
            }
            return false;
        }
    }

    private static class VariantChange {
        public final String name;
        public final String activityName;
        public final JSONObject change;
        public final Pair<Integer, Integer> variantId;

        public VariantChange(String aName, String anActivityName, JSONObject someChange, Pair<Integer, Integer> aVariantId) {
            this.name = aName;
            this.activityName = anActivityName;
            this.change = someChange;
            this.variantId = aVariantId;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof VariantChange) {
                return obj.hashCode() == this.hashCode();
            }
            return false;
        }
    }

    private class Editor
    implements EditorConnection.Editor {
        private Editor() {
        }

        @Override
        public void sendSnapshot(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(2);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void performEdit(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(3);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void clearEdits(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(10);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void setTweaks(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(11);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void bindEvents(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(6);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void sendDeviceInfo() {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(4);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void cleanup() {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(8);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }
    }

    private class ViewCrawlerHandler
    extends Handler {
        private EditorConnection mEditorConnection;
        private ViewSnapshot mSnapshot;
        private final String mToken;
        private final Lock mStartLock;
        private final EditProtocol mProtocol;
        private final ImageStore mImageStore;
        private final Map<String, Pair<String, JSONObject>> mEditorChanges;
        private final List<JSONObject> mEditorTweaks;
        private final List<String> mEditorAssetUrls;
        private final Map<String, Pair<String, JSONObject>> mEditorEventBindings;
        private final Set<VariantChange> mAppliedVisualChanges;
        private final Set<VariantTweak> mAppliedTweaks;
        private final Set<Pair<Integer, Integer>> mEmptyExperiments;
        private final Set<Pair<String, JSONObject>> mPersistentEventBindings;
        private final Set<Pair<String, JSONObject>> mOriginalEventBindings;
        private final Set<Pair<Integer, Integer>> mSeenExperiments;

        public ViewCrawlerHandler(Context context, String token, Looper looper, ViewVisitor.OnLayoutErrorListener layoutErrorListener) {
            super(looper);
            this.mToken = token;
            this.mSnapshot = null;
            String resourcePackage = ViewCrawler.this.mConfig.getResourcePackageName();
            if (null == resourcePackage) {
                resourcePackage = context.getPackageName();
            }
            ResourceReader.Ids resourceIds = new ResourceReader.Ids(resourcePackage, context);
            this.mImageStore = new ImageStore(context, "ViewCrawler");
            this.mProtocol = new EditProtocol(context, resourceIds, this.mImageStore, layoutErrorListener);
            this.mOriginalEventBindings = new HashSet<Pair<String, JSONObject>>();
            this.mEditorChanges = new HashMap<String, Pair<String, JSONObject>>();
            this.mEditorTweaks = new ArrayList<JSONObject>();
            this.mEditorAssetUrls = new ArrayList<String>();
            this.mEditorEventBindings = new HashMap<String, Pair<String, JSONObject>>();
            this.mAppliedVisualChanges = new HashSet<VariantChange>();
            this.mAppliedTweaks = new HashSet<VariantTweak>();
            this.mEmptyExperiments = new HashSet<Pair<Integer, Integer>>();
            this.mPersistentEventBindings = new HashSet<Pair<String, JSONObject>>();
            this.mSeenExperiments = new HashSet<Pair<Integer, Integer>>();
            this.mStartLock = new ReentrantLock();
            this.mStartLock.lock();
        }

        public void start() {
            this.mStartLock.unlock();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message msg) {
            this.mStartLock.lock();
            try {
                int what = msg.what;
                switch (what) {
                    case 0: {
                        this.loadKnownChanges();
                        return;
                    }
                    case 1: {
                        this.connectToEditor();
                        return;
                    }
                    case 4: {
                        this.sendDeviceInfo();
                        return;
                    }
                    case 2: {
                        this.sendSnapshot((JSONObject)msg.obj);
                        return;
                    }
                    case 7: {
                        this.sendReportTrackToEditor((String)msg.obj);
                        return;
                    }
                    case 12: {
                        this.sendLayoutError((ViewVisitor.LayoutErrorMessage)msg.obj);
                        return;
                    }
                    case 9: {
                        this.handleVariantsReceived((JSONArray)msg.obj);
                        return;
                    }
                    case 3: {
                        this.handleEditorChangeReceived((JSONObject)msg.obj);
                        return;
                    }
                    case 5: {
                        this.handleEventBindingsReceived((JSONArray)msg.obj);
                        return;
                    }
                    case 6: {
                        this.handleEditorBindingsReceived((JSONObject)msg.obj);
                        return;
                    }
                    case 10: {
                        this.handleEditorBindingsCleared((JSONObject)msg.obj);
                        return;
                    }
                    case 11: {
                        this.handleEditorTweaksReceived((JSONObject)msg.obj);
                        return;
                    }
                    case 8: {
                        this.handleEditorClosed();
                        return;
                    }
                    case 13: {
                        this.persistVariants((JSONArray)msg.obj);
                        return;
                    }
                }
                return;
            }
            finally {
                this.mStartLock.unlock();
            }
        }

        private void loadKnownChanges() {
            SharedPreferences preferences = this.getSharedPreferences();
            String storedChanges = preferences.getString("mixpanel.viewcrawler.changes", null);
            String storedBindings = preferences.getString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, null);
            this.mAppliedVisualChanges.clear();
            this.mAppliedTweaks.clear();
            this.mSeenExperiments.clear();
            this.loadVariants(storedChanges, false);
            this.mPersistentEventBindings.clear();
            this.loadEventBindings(storedBindings);
            this.applyVariantsAndEventBindings();
        }

        private void persistVariants(JSONArray variants) {
            SharedPreferences preferences = this.getSharedPreferences();
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString("mixpanel.viewcrawler.changes", variants.toString());
            editor.apply();
        }

        private void loadVariants(String variants, boolean newVariants) {
            if (null != variants) {
                try {
                    JSONArray variantsJson = new JSONArray(variants);
                    int variantsLength = variantsJson.length();
                    for (int variantIx = 0; variantIx < variantsLength; ++variantIx) {
                        JSONObject nextVariant = variantsJson.getJSONObject(variantIx);
                        int variantIdPart = nextVariant.getInt("id");
                        int experimentIdPart = nextVariant.getInt("experiment_id");
                        Pair variantId = new Pair((Object)experimentIdPart, (Object)variantIdPart);
                        JSONArray actions = nextVariant.getJSONArray("actions");
                        int actionsLength = actions.length();
                        for (int i = 0; i < actionsLength; ++i) {
                            JSONObject change = actions.getJSONObject(i);
                            String targetActivity = JSONUtils.optionalStringKey(change, "target_activity");
                            String name = change.getString("name");
                            VariantChange variantChange = new VariantChange(name, targetActivity, change, (Pair<Integer, Integer>)variantId);
                            this.mAppliedVisualChanges.add(variantChange);
                        }
                        JSONArray tweaks = nextVariant.getJSONArray("tweaks");
                        int tweaksLength = tweaks.length();
                        for (int i = 0; i < tweaksLength; ++i) {
                            JSONObject tweakDesc = tweaks.getJSONObject(i);
                            String tweakName = tweakDesc.getString("name");
                            VariantTweak variantTweak = new VariantTweak(tweakName, tweakDesc, (Pair<Integer, Integer>)variantId);
                            this.mAppliedTweaks.add(variantTweak);
                        }
                        if (!newVariants) {
                            this.mSeenExperiments.add((Pair<Integer, Integer>)variantId);
                        }
                        if (tweaksLength != 0 || actionsLength != 0) continue;
                        this.mEmptyExperiments.add((Pair<Integer, Integer>)variantId);
                    }
                }
                catch (JSONException e) {
                    MPLog.i(ViewCrawler.LOGTAG, "JSON error when loading ab tests / tweaks, clearing persistent memory", e);
                    SharedPreferences preferences = this.getSharedPreferences();
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove("mixpanel.viewcrawler.changes");
                    editor.apply();
                }
            }
        }

        private void loadEventBindings(String eventBindings) {
            if (null != eventBindings) {
                try {
                    JSONArray bindings = new JSONArray(eventBindings);
                    this.mPersistentEventBindings.clear();
                    for (int i = 0; i < bindings.length(); ++i) {
                        JSONObject event = bindings.getJSONObject(i);
                        String targetActivity = JSONUtils.optionalStringKey(event, "target_activity");
                        this.mPersistentEventBindings.add((Pair<String, JSONObject>)new Pair((Object)targetActivity, (Object)event));
                    }
                }
                catch (JSONException e) {
                    MPLog.i(ViewCrawler.LOGTAG, "JSON error when loading event bindings, clearing persistent memory", e);
                    SharedPreferences preferences = this.getSharedPreferences();
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove(ViewCrawler.SHARED_PREF_BINDINGS_KEY);
                    editor.apply();
                }
            }
        }

        private void connectToEditor() {
            MPLog.v(ViewCrawler.LOGTAG, "connecting to editor");
            if (this.mEditorConnection != null && this.mEditorConnection.isValid()) {
                MPLog.v(ViewCrawler.LOGTAG, "There is already a valid connection to an events editor.");
                return;
            }
            SSLSocketFactory socketFactory = ViewCrawler.this.mConfig.getSSLSocketFactory();
            if (null == socketFactory) {
                MPLog.v(ViewCrawler.LOGTAG, "SSL is not available on this device, no connection will be attempted to the events editor.");
                return;
            }
            String url = MPConfig.getInstance(ViewCrawler.this.mContext).getEditorUrl() + this.mToken;
            try {
                Socket sslSocket = socketFactory.createSocket();
                this.mEditorConnection = new EditorConnection(new URI(url), new Editor(), sslSocket);
            }
            catch (URISyntaxException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Error parsing URI " + url + " for editor websocket", e);
            }
            catch (EditorConnection.EditorConnectionException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Error connecting to URI " + url, e);
            }
            catch (IOException e) {
                MPLog.i(ViewCrawler.LOGTAG, "Can't create SSL Socket to connect to editor service", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendError(String errorMessage) {
            if (this.mEditorConnection == null || !this.mEditorConnection.isValid() || !this.mEditorConnection.isConnected()) {
                return;
            }
            JSONObject errorObject = new JSONObject();
            try {
                errorObject.put("error_message", (Object)errorMessage);
            }
            catch (JSONException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Apparently impossible JSONException", e);
            }
            OutputStreamWriter writer = new OutputStreamWriter(this.mEditorConnection.getBufferedOutputStream());
            try {
                writer.write("{\"type\": \"error\", ");
                writer.write("\"payload\": ");
                writer.write(errorObject.toString());
                writer.write("}");
            }
            catch (IOException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Can't write error message to editor", e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    MPLog.e(ViewCrawler.LOGTAG, "Could not close output writer to editor", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendDeviceInfo() {
            if (this.mEditorConnection == null || !this.mEditorConnection.isValid() || !this.mEditorConnection.isConnected()) {
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            JsonWriter j = new JsonWriter((Writer)new OutputStreamWriter(out));
            try {
                j.beginObject();
                j.name("type").value("device_info_response");
                j.name("payload").beginObject();
                j.name("device_type").value("Android");
                j.name("device_name").value(Build.BRAND + "/" + Build.MODEL);
                j.name("scaled_density").value((double)ViewCrawler.this.mScaledDensity);
                for (Map.Entry entry : ViewCrawler.this.mDeviceInfo.entrySet()) {
                    j.name((String)entry.getKey()).value((String)entry.getValue());
                }
                Map<String, Tweaks.TweakValue> tweakDescs = ViewCrawler.this.mTweaks.getAllValues();
                j.name("tweaks").beginArray();
                for (Map.Entry<String, Tweaks.TweakValue> tweak : tweakDescs.entrySet()) {
                    Tweaks.TweakValue desc = tweak.getValue();
                    String tweakName = tweak.getKey();
                    j.beginObject();
                    j.name("name").value(tweakName);
                    j.name("minimum").value(desc.getMinimum());
                    j.name("maximum").value(desc.getMaximum());
                    switch (desc.type) {
                        case 1: {
                            j.name("type").value("boolean");
                            j.name("value").value(desc.getBooleanValue().booleanValue());
                            j.name("default").value(((Boolean)desc.getDefaultValue()).booleanValue());
                            break;
                        }
                        case 2: {
                            j.name("type").value("number");
                            j.name("encoding").value("d");
                            j.name("value").value(desc.getNumberValue().doubleValue());
                            j.name("default").value(((Number)desc.getDefaultValue()).doubleValue());
                            break;
                        }
                        case 3: {
                            j.name("type").value("number");
                            j.name("encoding").value("l");
                            j.name("value").value(desc.getNumberValue().longValue());
                            j.name("default").value(((Number)desc.getDefaultValue()).longValue());
                            break;
                        }
                        case 4: {
                            j.name("type").value("string");
                            j.name("value").value(desc.getStringValue());
                            j.name("default").value((String)desc.getDefaultValue());
                            break;
                        }
                        default: {
                            MPLog.wtf(ViewCrawler.LOGTAG, "Unrecognized Tweak Type " + desc.type + " encountered.");
                        }
                    }
                    j.endObject();
                }
                j.endArray();
                j.endObject();
                j.endObject();
            }
            catch (IOException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Can't write device_info to server", e);
            }
            finally {
                try {
                    j.close();
                }
                catch (IOException e) {
                    MPLog.e(ViewCrawler.LOGTAG, "Can't close websocket writer", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendSnapshot(JSONObject message) {
            long startSnapshot = System.currentTimeMillis();
            try {
                JSONObject payload = message.getJSONObject("payload");
                if (payload.has("config")) {
                    this.mSnapshot = this.mProtocol.readSnapshotConfig(payload);
                    MPLog.v(ViewCrawler.LOGTAG, "Initializing snapshot with configuration");
                }
            }
            catch (JSONException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Payload with snapshot config required with snapshot request", e);
                this.sendError("Payload with snapshot config required with snapshot request");
                return;
            }
            catch (EditProtocol.BadInstructionsException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Editor sent malformed message with snapshot request", e);
                this.sendError(e.getMessage());
                return;
            }
            if (null == this.mSnapshot) {
                this.sendError("No snapshot configuration (or a malformed snapshot configuration) was sent.");
                MPLog.w(ViewCrawler.LOGTAG, "Mixpanel editor is misconfigured, sent a snapshot request without a valid configuration.");
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                writer.write("{");
                writer.write("\"type\": \"snapshot_response\",");
                writer.write("\"payload\": {");
                writer.write("\"activities\":");
                writer.flush();
                this.mSnapshot.snapshots(ViewCrawler.this.mEditState, out);
                long snapshotTime = System.currentTimeMillis() - startSnapshot;
                writer.write(",\"snapshot_time_millis\": ");
                writer.write(Long.toString(snapshotTime));
                writer.write("}");
                writer.write("}");
            }
            catch (IOException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Can't write snapshot request to server", e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendReportTrackToEditor(String eventName) {
            if (this.mEditorConnection == null || !this.mEditorConnection.isValid() || !this.mEditorConnection.isConnected()) {
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            JsonWriter j = new JsonWriter((Writer)writer);
            try {
                j.beginObject();
                j.name("type").value("track_message");
                j.name("payload");
                j.beginObject();
                j.name("event_name").value(eventName);
                j.endObject();
                j.endObject();
                j.flush();
            }
            catch (IOException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Can't write track_message to server", e);
            }
            finally {
                try {
                    j.close();
                }
                catch (IOException e) {
                    MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendLayoutError(ViewVisitor.LayoutErrorMessage exception) {
            if (this.mEditorConnection == null || !this.mEditorConnection.isValid() || !this.mEditorConnection.isConnected()) {
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            JsonWriter j = new JsonWriter((Writer)writer);
            try {
                j.beginObject();
                j.name("type").value("layout_error");
                j.name("exception_type").value(exception.getErrorType());
                j.name("cid").value(exception.getName());
                j.endObject();
            }
            catch (IOException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Can't write track_message to server", e);
            }
            finally {
                try {
                    j.close();
                }
                catch (IOException e) {
                    MPLog.e(ViewCrawler.LOGTAG, "Can't close writer.", e);
                }
            }
        }

        private void handleEditorChangeReceived(JSONObject changeMessage) {
            try {
                JSONObject payload = changeMessage.getJSONObject("payload");
                JSONArray actions = payload.getJSONArray("actions");
                for (int i = 0; i < actions.length(); ++i) {
                    JSONObject change = actions.getJSONObject(i);
                    String targetActivity = JSONUtils.optionalStringKey(change, "target_activity");
                    String name = change.getString("name");
                    this.mEditorChanges.put(name, (Pair<String, JSONObject>)new Pair((Object)targetActivity, (Object)change));
                }
                this.applyVariantsAndEventBindings();
            }
            catch (JSONException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Bad change request received", e);
            }
        }

        private void handleEditorBindingsCleared(JSONObject clearMessage) {
            try {
                JSONObject payload = clearMessage.getJSONObject("payload");
                JSONArray actions = payload.getJSONArray("actions");
                for (int i = 0; i < actions.length(); ++i) {
                    String changeId = actions.getString(i);
                    this.mEditorChanges.remove(changeId);
                }
            }
            catch (JSONException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Bad clear request received", e);
            }
            this.applyVariantsAndEventBindings();
        }

        private void handleEditorTweaksReceived(JSONObject tweaksMessage) {
            try {
                this.mEditorTweaks.clear();
                JSONObject payload = tweaksMessage.getJSONObject("payload");
                JSONArray tweaks = payload.getJSONArray("tweaks");
                int length = tweaks.length();
                for (int i = 0; i < length; ++i) {
                    JSONObject tweakDesc = tweaks.getJSONObject(i);
                    this.mEditorTweaks.add(tweakDesc);
                }
            }
            catch (JSONException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Bad tweaks received", e);
            }
            this.applyVariantsAndEventBindings();
        }

        private void handleVariantsReceived(JSONArray variants) {
            this.persistVariants(variants);
            this.loadVariants(variants.toString(), true);
            this.applyVariantsAndEventBindings();
        }

        private void handleEventBindingsReceived(JSONArray eventBindings) {
            SharedPreferences preferences = this.getSharedPreferences();
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, eventBindings.toString());
            editor.apply();
            this.loadEventBindings(eventBindings.toString());
            this.applyVariantsAndEventBindings();
        }

        private void handleEditorBindingsReceived(JSONObject message) {
            JSONArray eventBindings;
            try {
                JSONObject payload = message.getJSONObject("payload");
                eventBindings = payload.getJSONArray("events");
            }
            catch (JSONException e) {
                MPLog.e(ViewCrawler.LOGTAG, "Bad event bindings received", e);
                return;
            }
            int eventCount = eventBindings.length();
            this.mEditorEventBindings.clear();
            if (!this.mPersistentEventBindings.isEmpty() && this.mOriginalEventBindings.isEmpty()) {
                this.mOriginalEventBindings.addAll(this.mPersistentEventBindings);
                for (Pair<String, JSONObject> eventBinding : this.mPersistentEventBindings) {
                    try {
                        this.mEditorEventBindings.put(((JSONObject)eventBinding.second).get("path").toString(), eventBinding);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                this.mPersistentEventBindings.clear();
            }
            for (int i = 0; i < eventCount; ++i) {
                try {
                    JSONObject event = eventBindings.getJSONObject(i);
                    String targetActivity = JSONUtils.optionalStringKey(event, "target_activity");
                    this.mEditorEventBindings.put(event.get("path").toString(), (Pair<String, JSONObject>)new Pair((Object)targetActivity, (Object)event));
                    continue;
                }
                catch (JSONException e) {
                    MPLog.e(ViewCrawler.LOGTAG, "Bad event binding received from editor in " + eventBindings.toString(), e);
                }
            }
            this.applyVariantsAndEventBindings();
        }

        private void handleEditorClosed() {
            this.mEditorChanges.clear();
            this.mEditorEventBindings.clear();
            this.mEditorTweaks.clear();
            this.mPersistentEventBindings.addAll(this.mOriginalEventBindings);
            this.mOriginalEventBindings.clear();
            this.mSnapshot = null;
            MPLog.v(ViewCrawler.LOGTAG, "Editor closed- freeing snapshot");
            this.applyVariantsAndEventBindings();
            for (String assetUrl : this.mEditorAssetUrls) {
                this.mImageStore.deleteStorage(assetUrl);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void applyVariantsAndEventBindings() {
            void var6_50;
            void var5_16;
            Pair<String, Object> tweakValue;
            ArrayList<Pair> newVisitors = new ArrayList<Pair>();
            HashSet<Pair<Integer, Integer>> toTrack = new HashSet<Pair<Integer, Integer>>();
            HashSet<String> updatedTweaks = new HashSet<String>();
            for (VariantChange variantChange : this.mAppliedVisualChanges) {
                try {
                    EditProtocol.Edit edit = this.mProtocol.readEdit(variantChange.change);
                    newVisitors.add(new Pair((Object)variantChange.activityName, (Object)edit.visitor));
                    if (this.mSeenExperiments.contains(variantChange.variantId)) continue;
                    toTrack.add(variantChange.variantId);
                }
                catch (EditProtocol.CantGetEditAssetsException cantGetEditAssetsException) {
                    MPLog.v(ViewCrawler.LOGTAG, "Can't load assets for an edit, won't apply the change now", cantGetEditAssetsException);
                }
                catch (EditProtocol.InapplicableInstructionsException inapplicableInstructionsException) {
                    MPLog.i(ViewCrawler.LOGTAG, inapplicableInstructionsException.getMessage());
                }
                catch (EditProtocol.BadInstructionsException badInstructionsException) {
                    MPLog.e(ViewCrawler.LOGTAG, "Bad persistent change request cannot be applied.", badInstructionsException);
                }
            }
            for (VariantTweak variantTweak : this.mAppliedTweaks) {
                try {
                    Tweaks.TweakValue persistedTweak;
                    Pair<String, Object> pair = this.mProtocol.readTweak(variantTweak.tweak);
                    if (!this.mSeenExperiments.contains(variantTweak.variantId)) {
                        toTrack.add(variantTweak.variantId);
                        updatedTweaks.add((String)pair.first);
                    } else if (ViewCrawler.this.mTweaks.isNewValue((String)pair.first, pair.second)) {
                        updatedTweaks.add((String)pair.first);
                    }
                    if (!ViewCrawler.this.mTweaks.getAllValues().containsKey(pair.first) && (persistedTweak = Tweaks.TweakValue.fromJson(variantTweak.tweak)) != null) {
                        ViewCrawler.this.mTweaks.declareTweak((String)pair.first, persistedTweak.getDefaultValue(), persistedTweak.getMinimum(), persistedTweak.getMaximum(), persistedTweak.type);
                    }
                    ViewCrawler.this.mTweaks.set((String)pair.first, pair.second);
                }
                catch (EditProtocol.BadInstructionsException badInstructionsException) {
                    MPLog.e(ViewCrawler.LOGTAG, "Bad editor tweak cannot be applied.", badInstructionsException);
                }
            }
            if (this.mAppliedTweaks.size() == 0) {
                Map<String, Tweaks.TweakValue> tweakDefaults = ViewCrawler.this.mTweaks.getDefaultValues();
                for (Map.Entry entry : tweakDefaults.entrySet()) {
                    tweakValue = (Pair<String, Object>)entry.getValue();
                    String tweakName = (String)entry.getKey();
                    if (!ViewCrawler.this.mTweaks.isNewValue(tweakName, tweakValue.getValue())) continue;
                    ViewCrawler.this.mTweaks.set(tweakName, tweakValue.getValue());
                    updatedTweaks.add(tweakName);
                }
            }
            for (Pair pair : this.mEditorChanges.values()) {
                try {
                    EditProtocol.Edit edit = this.mProtocol.readEdit((JSONObject)pair.second);
                    newVisitors.add(new Pair(pair.first, (Object)edit.visitor));
                    this.mEditorAssetUrls.addAll(edit.imageUrls);
                }
                catch (EditProtocol.CantGetEditAssetsException cantGetEditAssetsException) {
                    MPLog.v(ViewCrawler.LOGTAG, "Can't load assets for an edit, won't apply the change now", cantGetEditAssetsException);
                }
                catch (EditProtocol.InapplicableInstructionsException inapplicableInstructionsException) {
                    MPLog.i(ViewCrawler.LOGTAG, inapplicableInstructionsException.getMessage());
                }
                catch (EditProtocol.BadInstructionsException badInstructionsException) {
                    MPLog.e(ViewCrawler.LOGTAG, "Bad editor change request cannot be applied.", badInstructionsException);
                }
            }
            int size = this.mEditorTweaks.size();
            boolean bl = false;
            while (var5_16 < size) {
                JSONObject jSONObject = this.mEditorTweaks.get((int)var5_16);
                try {
                    tweakValue = this.mProtocol.readTweak(jSONObject);
                    if (ViewCrawler.this.mTweaks.isNewValue((String)tweakValue.first, tweakValue.second)) {
                        updatedTweaks.add((String)tweakValue.first);
                    }
                    ViewCrawler.this.mTweaks.set((String)tweakValue.first, tweakValue.second);
                }
                catch (EditProtocol.BadInstructionsException e) {
                    MPLog.e(ViewCrawler.LOGTAG, "Strange tweaks received", e);
                }
                ++var5_16;
            }
            if (this.mEditorEventBindings.size() == 0 && this.mOriginalEventBindings.size() == 0) {
                for (Pair<String, JSONObject> pair : this.mPersistentEventBindings) {
                    try {
                        ViewVisitor viewVisitor = this.mProtocol.readEventBinding((JSONObject)pair.second, ViewCrawler.this.mDynamicEventTracker);
                        newVisitors.add(new Pair(pair.first, (Object)viewVisitor));
                    }
                    catch (EditProtocol.InapplicableInstructionsException inapplicableInstructionsException) {
                        MPLog.i(ViewCrawler.LOGTAG, inapplicableInstructionsException.getMessage());
                    }
                    catch (EditProtocol.BadInstructionsException badInstructionsException) {
                        MPLog.e(ViewCrawler.LOGTAG, "Bad persistent event binding cannot be applied.", badInstructionsException);
                    }
                }
            }
            for (Pair<String, JSONObject> pair : this.mEditorEventBindings.values()) {
                try {
                    ViewVisitor viewVisitor = this.mProtocol.readEventBinding((JSONObject)pair.second, ViewCrawler.this.mDynamicEventTracker);
                    newVisitors.add(new Pair(pair.first, (Object)viewVisitor));
                }
                catch (EditProtocol.InapplicableInstructionsException inapplicableInstructionsException) {
                    MPLog.i(ViewCrawler.LOGTAG, inapplicableInstructionsException.getMessage());
                }
                catch (EditProtocol.BadInstructionsException badInstructionsException) {
                    MPLog.e(ViewCrawler.LOGTAG, "Bad editor event binding cannot be applied.", badInstructionsException);
                }
            }
            HashMap<String, List<ViewVisitor>> editMap = new HashMap<String, List<ViewVisitor>>();
            int n = newVisitors.size();
            boolean bl2 = false;
            while (var6_50 < n) {
                List<Object> mapElement;
                Pair next = (Pair)newVisitors.get((int)var6_50);
                if (editMap.containsKey(next.first)) {
                    mapElement = (List)editMap.get(next.first);
                } else {
                    mapElement = new ArrayList();
                    editMap.put((String)next.first, mapElement);
                }
                mapElement.add(next.second);
                ++var6_50;
            }
            ViewCrawler.this.mEditState.setEdits(editMap);
            this.mSeenExperiments.addAll(toTrack);
            toTrack.addAll(this.mEmptyExperiments);
            this.trackSeenExperiments(toTrack);
            this.mEmptyExperiments.clear();
            if (updatedTweaks.size() > 0) {
                for (OnMixpanelTweaksUpdatedListener listener : ViewCrawler.this.mTweaksUpdatedListeners) {
                    listener.onMixpanelTweakUpdated(updatedTweaks);
                }
            }
        }

        private void trackSeenExperiments(Set<Pair<Integer, Integer>> toTrack) {
            if (toTrack != null && toTrack.size() > 0) {
                final JSONObject variantObject = new JSONObject();
                try {
                    for (Pair<Integer, Integer> variant : toTrack) {
                        int experimentId = (Integer)variant.first;
                        int variantId = (Integer)variant.second;
                        JSONObject trackProps = new JSONObject();
                        trackProps.put("$experiment_id", experimentId);
                        trackProps.put("$variant_id", variantId);
                        variantObject.put(Integer.toString(experimentId), variantId);
                        ViewCrawler.this.mMixpanel.getPeople().merge("$experiments", variantObject);
                        ViewCrawler.this.mMixpanel.updateSuperProperties(new SuperPropertyUpdate(){

                            @Override
                            public JSONObject update(JSONObject in) {
                                try {
                                    in.put("$experiments", (Object)variantObject);
                                }
                                catch (JSONException e) {
                                    MPLog.wtf(ViewCrawler.LOGTAG, "Can't write $experiments super property", e);
                                }
                                return in;
                            }
                        });
                        ViewCrawler.this.mMixpanel.track("$experiment_started", trackProps);
                    }
                }
                catch (JSONException e) {
                    MPLog.wtf(ViewCrawler.LOGTAG, "Could not build JSON for reporting experiment start", e);
                }
            }
        }

        private SharedPreferences getSharedPreferences() {
            String sharedPrefsName = "mixpanel.viewcrawler.changes" + this.mToken;
            return ViewCrawler.this.mContext.getSharedPreferences(sharedPrefsName, 0);
        }
    }

    private class LifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks,
    FlipGesture.OnFlipGestureListener {
        private final FlipGesture mFlipGesture = new FlipGesture(this);
        private final EmulatorConnector mEmulatorConnector;

        public LifecycleCallbacks() {
            this.mEmulatorConnector = new EmulatorConnector();
        }

        @Override
        public void onFlipGesture() {
            ViewCrawler.this.mMixpanel.track("$ab_gesture3");
            Message message = ViewCrawler.this.mMessageThreadHandler.obtainMessage(1);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(message);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
            this.installConnectionSensor(activity);
            ViewCrawler.this.mEditState.add(activity);
        }

        public void onActivityPaused(Activity activity) {
            ViewCrawler.this.mEditState.remove(activity);
            this.uninstallConnectionSensor(activity);
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        private void installConnectionSensor(Activity activity) {
            if (this.isInEmulator() && !ViewCrawler.this.mConfig.getDisableEmulatorBindingUI()) {
                this.mEmulatorConnector.start();
            } else if (!ViewCrawler.this.mConfig.getDisableGestureBindingUI()) {
                SensorManager sensorManager = (SensorManager)activity.getSystemService("sensor");
                Sensor accelerometer = sensorManager.getDefaultSensor(1);
                sensorManager.registerListener((SensorEventListener)this.mFlipGesture, accelerometer, 3);
            }
        }

        private void uninstallConnectionSensor(Activity activity) {
            if (this.isInEmulator() && !ViewCrawler.this.mConfig.getDisableEmulatorBindingUI()) {
                this.mEmulatorConnector.stop();
            } else if (!ViewCrawler.this.mConfig.getDisableGestureBindingUI()) {
                SensorManager sensorManager = (SensorManager)activity.getSystemService("sensor");
                sensorManager.unregisterListener((SensorEventListener)this.mFlipGesture);
            }
        }

        private boolean isInEmulator() {
            if (!Build.HARDWARE.toLowerCase().equals("goldfish") && !Build.HARDWARE.toLowerCase().equals("ranchu")) {
                return false;
            }
            if (!(Build.BRAND.toLowerCase().startsWith("generic") || Build.BRAND.toLowerCase().equals("android") || Build.BRAND.toLowerCase().equals("google"))) {
                return false;
            }
            if (!Build.DEVICE.toLowerCase().startsWith("generic")) {
                return false;
            }
            if (!Build.PRODUCT.toLowerCase().contains("sdk")) {
                return false;
            }
            return Build.MODEL.toLowerCase(Locale.US).contains("sdk");
        }
    }

    private class EmulatorConnector
    implements Runnable {
        private volatile boolean mStopped = true;

        @Override
        public void run() {
            if (!this.mStopped) {
                Message message = ViewCrawler.this.mMessageThreadHandler.obtainMessage(1);
                ViewCrawler.this.mMessageThreadHandler.sendMessage(message);
            }
            ViewCrawler.this.mMessageThreadHandler.postDelayed(this, 30000L);
        }

        public void start() {
            this.mStopped = false;
            ViewCrawler.this.mMessageThreadHandler.post(this);
        }

        public void stop() {
            this.mStopped = true;
            ViewCrawler.this.mMessageThreadHandler.removeCallbacks(this);
        }
    }
}

