/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.viewcrawler.UpdatesFromMixpanel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DecideMessages {
    private String mDistinctId;
    private final String mToken;
    private final Set<Integer> mNotificationIds;
    private final List<InAppNotification> mUnseenNotifications;
    private final OnNewResultsListener mListener;
    private final UpdatesFromMixpanel mUpdatesFromMixpanel;
    private JSONArray mVariants;
    private static final Set<Integer> mLoadedVariants = new HashSet<Integer>();
    private static final String LOGTAG = "MixpanelAPI.DecideUpdts";
    @Deprecated
    private final List<Survey> mUnseenSurveys;
    @Deprecated
    private final Set<Integer> mSurveyIds;

    public DecideMessages(String token, OnNewResultsListener listener, UpdatesFromMixpanel updatesFromMixpanel) {
        this.mToken = token;
        this.mListener = listener;
        this.mUpdatesFromMixpanel = updatesFromMixpanel;
        this.mDistinctId = null;
        this.mUnseenSurveys = new LinkedList<Survey>();
        this.mUnseenNotifications = new LinkedList<InAppNotification>();
        this.mSurveyIds = new HashSet<Integer>();
        this.mNotificationIds = new HashSet<Integer>();
        this.mVariants = new JSONArray();
    }

    public String getToken() {
        return this.mToken;
    }

    public synchronized void setDistinctId(String distinctId) {
        if (this.mDistinctId == null || !this.mDistinctId.equals(distinctId)) {
            this.mUnseenSurveys.clear();
            this.mUnseenNotifications.clear();
        }
        this.mDistinctId = distinctId;
    }

    public synchronized String getDistinctId() {
        return this.mDistinctId;
    }

    public synchronized void reportResults(List<Survey> newSurveys, List<InAppNotification> newNotifications, JSONArray eventBindings, JSONArray variants) {
        JSONObject variant;
        int i;
        int id2;
        boolean newContent = false;
        this.mUpdatesFromMixpanel.setEventBindings(eventBindings);
        for (Survey s : newSurveys) {
            id2 = s.getId();
            if (this.mSurveyIds.contains(id2)) continue;
            this.mSurveyIds.add(id2);
            this.mUnseenSurveys.add(s);
            newContent = true;
        }
        for (InAppNotification n : newNotifications) {
            id2 = n.getId();
            if (this.mNotificationIds.contains(id2)) continue;
            this.mNotificationIds.add(id2);
            this.mUnseenNotifications.add(n);
            newContent = true;
        }
        int newVariantsLength = variants.length();
        boolean hasNewVariants = false;
        for (i = 0; i < newVariantsLength; ++i) {
            try {
                variant = variants.getJSONObject(i);
                if (mLoadedVariants.contains(variant.getInt("id"))) continue;
                this.mVariants = variants;
                newContent = true;
                hasNewVariants = true;
                break;
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Could not convert variants[" + i + "] into a JSONObject while comparing the new variants", e);
            }
        }
        if (hasNewVariants) {
            mLoadedVariants.clear();
            for (i = 0; i < newVariantsLength; ++i) {
                try {
                    variant = this.mVariants.getJSONObject(i);
                    mLoadedVariants.add(variant.getInt("id"));
                    continue;
                }
                catch (JSONException e) {
                    MPLog.e(LOGTAG, "Could not convert variants[" + i + "] into a JSONObject while updating the map", e);
                }
            }
        }
        if (newVariantsLength == 0 && mLoadedVariants.size() > 0) {
            mLoadedVariants.clear();
            this.mVariants = new JSONArray();
            newContent = true;
        }
        MPLog.v(LOGTAG, "New Decide content has become available. " + newSurveys.size() + " surveys, " + newNotifications.size() + " notifications and " + variants.length() + " experiments have been added.");
        if (newContent && null != this.mListener) {
            this.mListener.onNewResults();
        }
    }

    @Deprecated
    public synchronized Survey getSurvey(boolean replace) {
        if (this.mUnseenSurveys.isEmpty()) {
            return null;
        }
        Survey s = this.mUnseenSurveys.remove(0);
        if (replace) {
            this.mUnseenSurveys.add(s);
        }
        return s;
    }

    @Deprecated
    public synchronized Survey getSurvey(int id2, boolean replace) {
        Survey survey = null;
        for (int i = 0; i < this.mUnseenSurveys.size(); ++i) {
            if (this.mUnseenSurveys.get(i).getId() != id2) continue;
            survey = this.mUnseenSurveys.get(i);
            if (replace) break;
            this.mUnseenSurveys.remove(i);
            break;
        }
        return survey;
    }

    public synchronized JSONArray getVariants() {
        return this.mVariants;
    }

    public synchronized InAppNotification getNotification(boolean replace) {
        if (this.mUnseenNotifications.isEmpty()) {
            MPLog.v(LOGTAG, "No unseen notifications exist, none will be returned.");
            return null;
        }
        InAppNotification n = this.mUnseenNotifications.remove(0);
        if (replace) {
            this.mUnseenNotifications.add(n);
        } else {
            MPLog.v(LOGTAG, "Recording notification " + n + " as seen.");
        }
        return n;
    }

    public synchronized InAppNotification getNotification(int id2, boolean replace) {
        InAppNotification notif = null;
        for (int i = 0; i < this.mUnseenNotifications.size(); ++i) {
            if (this.mUnseenNotifications.get(i).getId() != id2) continue;
            notif = this.mUnseenNotifications.get(i);
            if (replace) break;
            this.mUnseenNotifications.remove(i);
            break;
        }
        return notif;
    }

    public synchronized void markNotificationAsUnseen(InAppNotification notif) {
        if (!MPConfig.DEBUG) {
            this.mUnseenNotifications.add(notif);
        }
    }

    public synchronized boolean hasUpdatesAvailable() {
        return !this.mUnseenNotifications.isEmpty() || !this.mUnseenSurveys.isEmpty() || this.mVariants.length() > 0;
    }

    public static interface OnNewResultsListener {
        public void onNewResults();
    }
}

