/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.JsonWriter;
import android.util.Log;
import android.util.Pair;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.OnMixpanelTweaksUpdatedListener;
import com.mixpanel.android.mpmetrics.ResourceReader;
import com.mixpanel.android.mpmetrics.SuperPropertyUpdate;
import com.mixpanel.android.mpmetrics.Tweaks;
import com.mixpanel.android.util.ImageStore;
import com.mixpanel.android.util.JSONUtils;
import com.mixpanel.android.viewcrawler.DynamicEventTracker;
import com.mixpanel.android.viewcrawler.EditProtocol;
import com.mixpanel.android.viewcrawler.EditState;
import com.mixpanel.android.viewcrawler.EditorConnection;
import com.mixpanel.android.viewcrawler.FlipGesture;
import com.mixpanel.android.viewcrawler.TrackingDebug;
import com.mixpanel.android.viewcrawler.UpdatesFromMixpanel;
import com.mixpanel.android.viewcrawler.ViewSnapshot;
import com.mixpanel.android.viewcrawler.ViewVisitor;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=16)
public class ViewCrawler
implements UpdatesFromMixpanel,
TrackingDebug,
ViewVisitor.OnLayoutErrorListener {
    private final MPConfig mConfig;
    private final Context mContext;
    private final MixpanelAPI mMixpanel;
    private final DynamicEventTracker mDynamicEventTracker;
    private final EditState mEditState;
    private final Tweaks mTweaks;
    private final Map<String, String> mDeviceInfo;
    private final ViewCrawlerHandler mMessageThreadHandler;
    private final float mScaledDensity;
    private final List<OnMixpanelTweaksUpdatedListener> mTweaksUpdatedListeners;
    private static final String SHARED_PREF_EDITS_FILE = "mixpanel.viewcrawler.changes";
    private static final String SHARED_PREF_CHANGES_KEY = "mixpanel.viewcrawler.changes";
    private static final String SHARED_PREF_BINDINGS_KEY = "mixpanel.viewcrawler.bindings";
    private static final int MESSAGE_INITIALIZE_CHANGES = 0;
    private static final int MESSAGE_CONNECT_TO_EDITOR = 1;
    private static final int MESSAGE_SEND_STATE_FOR_EDITING = 2;
    private static final int MESSAGE_HANDLE_EDITOR_CHANGES_RECEIVED = 3;
    private static final int MESSAGE_SEND_DEVICE_INFO = 4;
    private static final int MESSAGE_EVENT_BINDINGS_RECEIVED = 5;
    private static final int MESSAGE_HANDLE_EDITOR_BINDINGS_RECEIVED = 6;
    private static final int MESSAGE_SEND_EVENT_TRACKED = 7;
    private static final int MESSAGE_HANDLE_EDITOR_CLOSED = 8;
    private static final int MESSAGE_VARIANTS_RECEIVED = 9;
    private static final int MESSAGE_HANDLE_EDITOR_CHANGES_CLEARED = 10;
    private static final int MESSAGE_HANDLE_EDITOR_TWEAKS_RECEIVED = 11;
    private static final int MESSAGE_SEND_LAYOUT_ERROR = 12;
    private static final int EMULATOR_CONNECT_ATTEMPT_INTERVAL_MILLIS = 30000;
    private static final String LOGTAG = "MixpanelAPI.ViewCrawler";

    public ViewCrawler(Context context, String token, MixpanelAPI mixpanel, Tweaks tweaks) {
        this.mConfig = MPConfig.getInstance(context);
        this.mContext = context;
        this.mEditState = new EditState();
        this.mTweaks = tweaks;
        this.mDeviceInfo = mixpanel.getDeviceInfo();
        this.mScaledDensity = Resources.getSystem().getDisplayMetrics().scaledDensity;
        this.mTweaksUpdatedListeners = new ArrayList<OnMixpanelTweaksUpdatedListener>();
        Application app = (Application)context.getApplicationContext();
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new LifecycleCallbacks());
        HandlerThread thread = new HandlerThread(ViewCrawler.class.getCanonicalName());
        thread.setPriority(10);
        thread.start();
        this.mMessageThreadHandler = new ViewCrawlerHandler(context, token, thread.getLooper(), this);
        this.mDynamicEventTracker = new DynamicEventTracker(mixpanel, this.mMessageThreadHandler);
        this.mMixpanel = mixpanel;
        this.mTweaks.addOnTweakDeclaredListener(new Tweaks.OnTweakDeclaredListener(){

            @Override
            public void onTweakDeclared() {
                Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(4);
                ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
            }
        });
    }

    @Override
    public void startUpdates() {
        this.mMessageThreadHandler.start();
        this.mMessageThreadHandler.sendMessage(this.mMessageThreadHandler.obtainMessage(0));
    }

    @Override
    public Tweaks getTweaks() {
        return this.mTweaks;
    }

    @Override
    public void setEventBindings(JSONArray bindings) {
        Message msg = this.mMessageThreadHandler.obtainMessage(5);
        msg.obj = bindings;
        this.mMessageThreadHandler.sendMessage(msg);
    }

    @Override
    public void setVariants(JSONArray variants) {
        Message msg = this.mMessageThreadHandler.obtainMessage(9);
        msg.obj = variants;
        this.mMessageThreadHandler.sendMessage(msg);
    }

    @Override
    public void addOnMixpanelTweaksUpdatedListener(OnMixpanelTweaksUpdatedListener listener) {
        if (null == listener) {
            throw new NullPointerException("Listener cannot be null");
        }
        this.mTweaksUpdatedListeners.add(listener);
    }

    @Override
    public void removeOnMixpanelTweaksUpdatedListener(OnMixpanelTweaksUpdatedListener listener) {
        this.mTweaksUpdatedListeners.remove(listener);
    }

    @Override
    public void reportTrack(String eventName) {
        Message m = this.mMessageThreadHandler.obtainMessage();
        m.what = 7;
        m.obj = eventName;
        this.mMessageThreadHandler.sendMessage(m);
    }

    @Override
    public void onLayoutError(ViewVisitor.LayoutErrorMessage e) {
        Message m = this.mMessageThreadHandler.obtainMessage();
        m.what = 12;
        m.obj = e;
        this.mMessageThreadHandler.sendMessage(m);
    }

    private static class VariantTweak {
        public final JSONObject tweak;
        public final Pair<Integer, Integer> variantId;

        public VariantTweak(JSONObject aTweak, Pair<Integer, Integer> aVariantId) {
            this.tweak = aTweak;
            this.variantId = aVariantId;
        }
    }

    private static class VariantChange {
        public final String activityName;
        public final JSONObject change;
        public final Pair<Integer, Integer> variantId;

        public VariantChange(String anActivityName, JSONObject someChange, Pair<Integer, Integer> aVariantId) {
            this.activityName = anActivityName;
            this.change = someChange;
            this.variantId = aVariantId;
        }
    }

    private class Editor
    implements EditorConnection.Editor {
        private Editor() {
        }

        @Override
        public void sendSnapshot(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(2);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void performEdit(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(3);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void clearEdits(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(10);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void setTweaks(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(11);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void bindEvents(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(6);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void sendDeviceInfo() {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(4);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void cleanup() {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(8);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }
    }

    private class ViewCrawlerHandler
    extends Handler {
        private EditorConnection mEditorConnection;
        private ViewSnapshot mSnapshot;
        private final String mToken;
        private final Lock mStartLock;
        private final EditProtocol mProtocol;
        private final ImageStore mImageStore;
        private final Map<String, Pair<String, JSONObject>> mEditorChanges;
        private final List<JSONObject> mEditorTweaks;
        private final List<String> mEditorAssetUrls;
        private final List<Pair<String, JSONObject>> mEditorEventBindings;
        private final List<VariantChange> mPersistentChanges;
        private final List<VariantTweak> mPersistentTweaks;
        private final List<Pair<String, JSONObject>> mPersistentEventBindings;
        private final Set<Pair<Integer, Integer>> mSeenExperiments;

        public ViewCrawlerHandler(Context context, String token, Looper looper, ViewVisitor.OnLayoutErrorListener layoutErrorListener) {
            super(looper);
            this.mToken = token;
            this.mSnapshot = null;
            String resourcePackage = ViewCrawler.this.mConfig.getResourcePackageName();
            if (null == resourcePackage) {
                resourcePackage = context.getPackageName();
            }
            ResourceReader.Ids resourceIds = new ResourceReader.Ids(resourcePackage, context);
            this.mImageStore = new ImageStore(context, "ViewCrawler");
            this.mProtocol = new EditProtocol(context, resourceIds, this.mImageStore, layoutErrorListener);
            this.mEditorChanges = new HashMap<String, Pair<String, JSONObject>>();
            this.mEditorTweaks = new ArrayList<JSONObject>();
            this.mEditorAssetUrls = new ArrayList<String>();
            this.mEditorEventBindings = new ArrayList<Pair<String, JSONObject>>();
            this.mPersistentChanges = new ArrayList<VariantChange>();
            this.mPersistentTweaks = new ArrayList<VariantTweak>();
            this.mPersistentEventBindings = new ArrayList<Pair<String, JSONObject>>();
            this.mSeenExperiments = new HashSet<Pair<Integer, Integer>>();
            this.mStartLock = new ReentrantLock();
            this.mStartLock.lock();
        }

        public void start() {
            this.mStartLock.unlock();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message msg) {
            this.mStartLock.lock();
            try {
                int what = msg.what;
                switch (what) {
                    case 0: {
                        this.loadKnownChanges();
                        this.initializeChanges();
                        return;
                    }
                    case 1: {
                        this.connectToEditor();
                        return;
                    }
                    case 4: {
                        this.sendDeviceInfo();
                        return;
                    }
                    case 2: {
                        this.sendSnapshot((JSONObject)msg.obj);
                        return;
                    }
                    case 7: {
                        this.sendReportTrackToEditor((String)msg.obj);
                        return;
                    }
                    case 12: {
                        this.sendLayoutError((ViewVisitor.LayoutErrorMessage)msg.obj);
                        return;
                    }
                    case 9: {
                        this.handleVariantsReceived((JSONArray)msg.obj);
                        return;
                    }
                    case 3: {
                        this.handleEditorChangeReceived((JSONObject)msg.obj);
                        return;
                    }
                    case 5: {
                        this.handleEventBindingsReceived((JSONArray)msg.obj);
                        return;
                    }
                    case 6: {
                        this.handleEditorBindingsReceived((JSONObject)msg.obj);
                        return;
                    }
                    case 10: {
                        this.handleEditorBindingsCleared((JSONObject)msg.obj);
                        return;
                    }
                    case 11: {
                        this.handleEditorTweaksReceived((JSONObject)msg.obj);
                        return;
                    }
                    case 8: {
                        this.handleEditorClosed();
                        return;
                    }
                }
                return;
            }
            finally {
                this.mStartLock.unlock();
            }
        }

        private void loadKnownChanges() {
            SharedPreferences preferences = this.getSharedPreferences();
            String storedChanges = preferences.getString("mixpanel.viewcrawler.changes", null);
            if (null != storedChanges) {
                try {
                    JSONArray variants = new JSONArray(storedChanges);
                    int variantsLength = variants.length();
                    for (int i = 0; i < variantsLength; ++i) {
                        JSONObject variant = variants.getJSONObject(i);
                        int variantId = variant.getInt("id");
                        int experimentId = variant.getInt("experiment_id");
                        Pair sight = new Pair((Object)experimentId, (Object)variantId);
                        this.mSeenExperiments.add((Pair<Integer, Integer>)sight);
                    }
                }
                catch (JSONException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Malformed variants found in persistent storage, clearing all variants", (Throwable)e);
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove("mixpanel.viewcrawler.changes");
                    editor.remove(ViewCrawler.SHARED_PREF_BINDINGS_KEY);
                    editor.apply();
                }
            }
        }

        private void initializeChanges() {
            SharedPreferences preferences = this.getSharedPreferences();
            String storedChanges = preferences.getString("mixpanel.viewcrawler.changes", null);
            String storedBindings = preferences.getString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, null);
            ArrayList<Pair<Integer, Integer>> emptyVariantIds = new ArrayList<Pair<Integer, Integer>>();
            try {
                this.mPersistentChanges.clear();
                this.mPersistentTweaks.clear();
                if (null != storedChanges) {
                    JSONArray variants = new JSONArray(storedChanges);
                    int variantsLength = variants.length();
                    for (int variantIx = 0; variantIx < variantsLength; ++variantIx) {
                        JSONObject nextVariant = variants.getJSONObject(variantIx);
                        int variantIdPart = nextVariant.getInt("id");
                        int experimentIdPart = nextVariant.getInt("experiment_id");
                        Pair variantId = new Pair((Object)experimentIdPart, (Object)variantIdPart);
                        JSONArray actions = nextVariant.getJSONArray("actions");
                        int actionsLength = actions.length();
                        for (int i = 0; i < actionsLength; ++i) {
                            JSONObject change = actions.getJSONObject(i);
                            String targetActivity = JSONUtils.optionalStringKey(change, "target_activity");
                            VariantChange variantChange = new VariantChange(targetActivity, change, (Pair<Integer, Integer>)variantId);
                            this.mPersistentChanges.add(variantChange);
                        }
                        JSONArray tweaks = nextVariant.getJSONArray("tweaks");
                        int tweaksLength = tweaks.length();
                        for (int i = 0; i < tweaksLength; ++i) {
                            JSONObject tweakDesc = tweaks.getJSONObject(i);
                            VariantTweak variantTweak = new VariantTweak(tweakDesc, (Pair<Integer, Integer>)variantId);
                            this.mPersistentTweaks.add(variantTweak);
                        }
                        if (actionsLength != 0 || tweaksLength != 0) continue;
                        Pair emptyVariantId = new Pair((Object)experimentIdPart, (Object)variantIdPart);
                        emptyVariantIds.add((Pair<Integer, Integer>)emptyVariantId);
                    }
                }
                if (null != storedBindings) {
                    JSONArray bindings = new JSONArray(storedBindings);
                    this.mPersistentEventBindings.clear();
                    for (int i = 0; i < bindings.length(); ++i) {
                        JSONObject event = bindings.getJSONObject(i);
                        String targetActivity = JSONUtils.optionalStringKey(event, "target_activity");
                        this.mPersistentEventBindings.add((Pair<String, JSONObject>)new Pair((Object)targetActivity, (Object)event));
                    }
                }
            }
            catch (JSONException e) {
                Log.i((String)ViewCrawler.LOGTAG, (String)"JSON error when initializing saved changes, clearing persistent memory", (Throwable)e);
                SharedPreferences.Editor editor = preferences.edit();
                editor.remove("mixpanel.viewcrawler.changes");
                editor.remove(ViewCrawler.SHARED_PREF_BINDINGS_KEY);
                editor.apply();
            }
            this.applyVariantsAndEventBindings(emptyVariantIds);
        }

        private void connectToEditor() {
            if (MPConfig.DEBUG) {
                Log.v((String)ViewCrawler.LOGTAG, (String)"connecting to editor");
            }
            if (this.mEditorConnection != null && this.mEditorConnection.isValid()) {
                if (MPConfig.DEBUG) {
                    Log.v((String)ViewCrawler.LOGTAG, (String)"There is already a valid connection to an events editor.");
                }
                return;
            }
            SSLSocketFactory socketFactory = ViewCrawler.this.mConfig.getSSLSocketFactory();
            if (null == socketFactory) {
                if (MPConfig.DEBUG) {
                    Log.v((String)ViewCrawler.LOGTAG, (String)"SSL is not available on this device, no connection will be attempted to the events editor.");
                }
                return;
            }
            String url = MPConfig.getInstance(ViewCrawler.this.mContext).getEditorUrl() + this.mToken;
            try {
                Socket sslSocket = socketFactory.createSocket();
                this.mEditorConnection = new EditorConnection(new URI(url), new Editor(), sslSocket);
            }
            catch (URISyntaxException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)("Error parsing URI " + url + " for editor websocket"), (Throwable)e);
            }
            catch (EditorConnection.EditorConnectionException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)("Error connecting to URI " + url), (Throwable)e);
            }
            catch (IOException e) {
                Log.i((String)ViewCrawler.LOGTAG, (String)"Can't create SSL Socket to connect to editor service", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendError(String errorMessage) {
            if (this.mEditorConnection == null || !this.mEditorConnection.isValid()) {
                return;
            }
            JSONObject errorObject = new JSONObject();
            try {
                errorObject.put("error_message", (Object)errorMessage);
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Apparently impossible JSONException", (Throwable)e);
            }
            OutputStreamWriter writer = new OutputStreamWriter(this.mEditorConnection.getBufferedOutputStream());
            try {
                writer.write("{\"type\": \"error\", ");
                writer.write("\"payload\": ");
                writer.write(errorObject.toString());
                writer.write("}");
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write error message to editor", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Could not close output writer to editor", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendDeviceInfo() {
            if (this.mEditorConnection == null || !this.mEditorConnection.isValid()) {
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            JsonWriter j = new JsonWriter((Writer)new OutputStreamWriter(out));
            try {
                j.beginObject();
                j.name("type").value("device_info_response");
                j.name("payload").beginObject();
                j.name("device_type").value("Android");
                j.name("device_name").value(Build.BRAND + "/" + Build.MODEL);
                j.name("scaled_density").value((double)ViewCrawler.this.mScaledDensity);
                for (Map.Entry entry : ViewCrawler.this.mDeviceInfo.entrySet()) {
                    j.name((String)entry.getKey()).value((String)entry.getValue());
                }
                Map<String, Tweaks.TweakValue> tweakDescs = ViewCrawler.this.mTweaks.getAllValues();
                j.name("tweaks").beginArray();
                for (Map.Entry<String, Tweaks.TweakValue> tweak : tweakDescs.entrySet()) {
                    Tweaks.TweakValue desc = tweak.getValue();
                    String tweakName = tweak.getKey();
                    j.beginObject();
                    j.name("name").value(tweakName);
                    j.name("minimum").value((Number)null);
                    j.name("maximum").value((Number)null);
                    switch (desc.type) {
                        case 1: {
                            j.name("type").value("boolean");
                            j.name("value").value(desc.getBooleanValue().booleanValue());
                            break;
                        }
                        case 2: {
                            j.name("type").value("number");
                            j.name("encoding").value("d");
                            j.name("value").value(desc.getNumberValue().doubleValue());
                            break;
                        }
                        case 3: {
                            j.name("type").value("number");
                            j.name("encoding").value("l");
                            j.name("value").value(desc.getNumberValue().longValue());
                            break;
                        }
                        case 4: {
                            j.name("type").value("string");
                            j.name("value").value(desc.getStringValue());
                            break;
                        }
                        default: {
                            Log.wtf((String)ViewCrawler.LOGTAG, (String)("Unrecognized Tweak Type " + desc.type + " encountered."));
                        }
                    }
                    j.endObject();
                }
                j.endArray();
                j.endObject();
                j.endObject();
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write device_info to server", (Throwable)e);
            }
            finally {
                try {
                    j.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close websocket writer", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendSnapshot(JSONObject message) {
            long startSnapshot = System.currentTimeMillis();
            try {
                JSONObject payload = message.getJSONObject("payload");
                if (payload.has("config")) {
                    this.mSnapshot = this.mProtocol.readSnapshotConfig(payload);
                    if (MPConfig.DEBUG) {
                        Log.v((String)ViewCrawler.LOGTAG, (String)"Initializing snapshot with configuration");
                    }
                }
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Payload with snapshot config required with snapshot request", (Throwable)e);
                this.sendError("Payload with snapshot config required with snapshot request");
                return;
            }
            catch (EditProtocol.BadInstructionsException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Editor sent malformed message with snapshot request", (Throwable)e);
                this.sendError(e.getMessage());
                return;
            }
            if (null == this.mSnapshot) {
                this.sendError("No snapshot configuration (or a malformed snapshot configuration) was sent.");
                Log.w((String)ViewCrawler.LOGTAG, (String)"Mixpanel editor is misconfigured, sent a snapshot request without a valid configuration.");
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                writer.write("{");
                writer.write("\"type\": \"snapshot_response\",");
                writer.write("\"payload\": {");
                writer.write("\"activities\":");
                writer.flush();
                this.mSnapshot.snapshots(ViewCrawler.this.mEditState, out);
                long snapshotTime = System.currentTimeMillis() - startSnapshot;
                writer.write(",\"snapshot_time_millis\": ");
                writer.write(Long.toString(snapshotTime));
                writer.write("}");
                writer.write("}");
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write snapshot request to server", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close writer.", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendReportTrackToEditor(String eventName) {
            if (this.mEditorConnection == null || !this.mEditorConnection.isValid()) {
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            JsonWriter j = new JsonWriter((Writer)writer);
            try {
                j.beginObject();
                j.name("type").value("track_message");
                j.name("payload");
                j.beginObject();
                j.name("event_name").value(eventName);
                j.endObject();
                j.endObject();
                j.flush();
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write track_message to server", (Throwable)e);
            }
            finally {
                try {
                    j.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close writer.", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendLayoutError(ViewVisitor.LayoutErrorMessage exception) {
            if (this.mEditorConnection == null) {
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            JsonWriter j = new JsonWriter((Writer)writer);
            try {
                j.beginObject();
                j.name("type").value("layout_error");
                j.name("exception_type").value(exception.getErrorType());
                j.name("cid").value(exception.getName());
                j.endObject();
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write track_message to server", (Throwable)e);
            }
            finally {
                try {
                    j.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close writer.", (Throwable)e);
                }
            }
        }

        private void handleEditorChangeReceived(JSONObject changeMessage) {
            try {
                JSONObject payload = changeMessage.getJSONObject("payload");
                JSONArray actions = payload.getJSONArray("actions");
                for (int i = 0; i < actions.length(); ++i) {
                    JSONObject change = actions.getJSONObject(i);
                    String targetActivity = JSONUtils.optionalStringKey(change, "target_activity");
                    String name = change.getString("name");
                    this.mEditorChanges.put(name, (Pair<String, JSONObject>)new Pair((Object)targetActivity, (Object)change));
                }
                this.applyVariantsAndEventBindings(Collections.emptyList());
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad change request received", (Throwable)e);
            }
        }

        private void handleEditorBindingsCleared(JSONObject clearMessage) {
            try {
                JSONObject payload = clearMessage.getJSONObject("payload");
                JSONArray actions = payload.getJSONArray("actions");
                for (int i = 0; i < actions.length(); ++i) {
                    String changeId = actions.getString(i);
                    this.mEditorChanges.remove(changeId);
                }
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad clear request received", (Throwable)e);
            }
            this.applyVariantsAndEventBindings(Collections.emptyList());
        }

        private void handleEditorTweaksReceived(JSONObject tweaksMessage) {
            try {
                this.mEditorTweaks.clear();
                JSONObject payload = tweaksMessage.getJSONObject("payload");
                JSONArray tweaks = payload.getJSONArray("tweaks");
                int length = tweaks.length();
                for (int i = 0; i < length; ++i) {
                    JSONObject tweakDesc = tweaks.getJSONObject(i);
                    this.mEditorTweaks.add(tweakDesc);
                }
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad tweaks received", (Throwable)e);
            }
            this.applyVariantsAndEventBindings(Collections.emptyList());
        }

        private void handleVariantsReceived(JSONArray variants) {
            SharedPreferences preferences = this.getSharedPreferences();
            SharedPreferences.Editor editor = preferences.edit();
            if (variants.length() > 0) {
                editor.putString("mixpanel.viewcrawler.changes", variants.toString());
            } else {
                editor.remove("mixpanel.viewcrawler.changes");
            }
            editor.apply();
            this.initializeChanges();
        }

        private void handleEventBindingsReceived(JSONArray eventBindings) {
            SharedPreferences preferences = this.getSharedPreferences();
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, eventBindings.toString());
            editor.apply();
            this.initializeChanges();
        }

        private void handleEditorBindingsReceived(JSONObject message) {
            JSONArray eventBindings;
            try {
                JSONObject payload = message.getJSONObject("payload");
                eventBindings = payload.getJSONArray("events");
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad event bindings received", (Throwable)e);
                return;
            }
            int eventCount = eventBindings.length();
            this.mEditorEventBindings.clear();
            for (int i = 0; i < eventCount; ++i) {
                try {
                    JSONObject event = eventBindings.getJSONObject(i);
                    String targetActivity = JSONUtils.optionalStringKey(event, "target_activity");
                    this.mEditorEventBindings.add((Pair<String, JSONObject>)new Pair((Object)targetActivity, (Object)event));
                    continue;
                }
                catch (JSONException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)("Bad event binding received from editor in " + eventBindings.toString()), (Throwable)e);
                }
            }
            this.applyVariantsAndEventBindings(Collections.emptyList());
        }

        private void handleEditorClosed() {
            this.mEditorChanges.clear();
            this.mEditorEventBindings.clear();
            this.mSnapshot = null;
            if (MPConfig.DEBUG) {
                Log.v((String)ViewCrawler.LOGTAG, (String)"Editor closed- freeing snapshot");
            }
            this.applyVariantsAndEventBindings(Collections.emptyList());
            for (String assetUrl : this.mEditorAssetUrls) {
                this.mImageStore.deleteStorage(assetUrl);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void applyVariantsAndEventBindings(List<Pair<Integer, Integer>> emptyVariantIds) {
            int i;
            ArrayList<Pair> newVisitors = new ArrayList<Pair>();
            HashSet<Pair<Integer, Integer>> toTrack = new HashSet<Pair<Integer, Integer>>();
            int size = this.mPersistentChanges.size();
            for (i = 0; i < size; ++i) {
                VariantChange changeInfo = this.mPersistentChanges.get(i);
                try {
                    EditProtocol.Edit edit = this.mProtocol.readEdit(changeInfo.change);
                    newVisitors.add(new Pair((Object)changeInfo.activityName, (Object)edit.visitor));
                    if (this.mSeenExperiments.contains(changeInfo.variantId)) continue;
                    toTrack.add(changeInfo.variantId);
                    continue;
                }
                catch (EditProtocol.CantGetEditAssetsException cantGetEditAssetsException) {
                    Log.v((String)ViewCrawler.LOGTAG, (String)"Can't load assets for an edit, won't apply the change now", (Throwable)cantGetEditAssetsException);
                    continue;
                }
                catch (EditProtocol.InapplicableInstructionsException inapplicableInstructionsException) {
                    Log.i((String)ViewCrawler.LOGTAG, (String)inapplicableInstructionsException.getMessage());
                    continue;
                }
                catch (EditProtocol.BadInstructionsException badInstructionsException) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Bad persistent change request cannot be applied.", (Throwable)badInstructionsException);
                }
            }
            boolean isTweaksUpdated = false;
            int size2 = this.mPersistentTweaks.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                VariantTweak variantTweak = this.mPersistentTweaks.get(i2);
                try {
                    Pair<String, Object> pair = this.mProtocol.readTweak(variantTweak.tweak);
                    if (!this.mSeenExperiments.contains(variantTweak.variantId)) {
                        toTrack.add(variantTweak.variantId);
                        isTweaksUpdated = true;
                    } else if (ViewCrawler.this.mTweaks.isNewValue((String)pair.first, pair.second)) {
                        isTweaksUpdated = true;
                    }
                    ViewCrawler.this.mTweaks.set((String)pair.first, pair.second);
                    continue;
                }
                catch (EditProtocol.BadInstructionsException badInstructionsException) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Bad editor tweak cannot be applied.", (Throwable)badInstructionsException);
                }
            }
            if (isTweaksUpdated) {
                for (OnMixpanelTweaksUpdatedListener onMixpanelTweaksUpdatedListener : ViewCrawler.this.mTweaksUpdatedListeners) {
                    onMixpanelTweaksUpdatedListener.onMixpanelTweakUpdated();
                }
            }
            if (size2 == 0) {
                Map<String, Tweaks.TweakValue> tweakDefaults = ViewCrawler.this.mTweaks.getDefaultValues();
                for (Map.Entry<String, Tweaks.TweakValue> entry : tweakDefaults.entrySet()) {
                    Tweaks.TweakValue tweakValue = entry.getValue();
                    String tweakName = entry.getKey();
                    ViewCrawler.this.mTweaks.set(tweakName, tweakValue);
                }
            }
            for (Pair<String, JSONObject> changeInfo : this.mEditorChanges.values()) {
                try {
                    EditProtocol.Edit edit = this.mProtocol.readEdit((JSONObject)changeInfo.second);
                    newVisitors.add(new Pair(changeInfo.first, (Object)edit.visitor));
                    this.mEditorAssetUrls.addAll(edit.imageUrls);
                }
                catch (EditProtocol.CantGetEditAssetsException e) {
                    Log.v((String)ViewCrawler.LOGTAG, (String)"Can't load assets for an edit, won't apply the change now", (Throwable)e);
                }
                catch (EditProtocol.InapplicableInstructionsException e) {
                    Log.i((String)ViewCrawler.LOGTAG, (String)e.getMessage());
                }
                catch (EditProtocol.BadInstructionsException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Bad editor change request cannot be applied.", (Throwable)e);
                }
            }
            size = this.mEditorTweaks.size();
            for (i = 0; i < size; ++i) {
                JSONObject tweakDesc = this.mEditorTweaks.get(i);
                try {
                    Pair<String, Object> pair = this.mProtocol.readTweak(tweakDesc);
                    ViewCrawler.this.mTweaks.set((String)pair.first, pair.second);
                    continue;
                }
                catch (EditProtocol.BadInstructionsException badInstructionsException) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Strange tweaks received", (Throwable)badInstructionsException);
                }
            }
            size = this.mPersistentEventBindings.size();
            for (i = 0; i < size; ++i) {
                Pair<String, JSONObject> changeInfo = this.mPersistentEventBindings.get(i);
                try {
                    ViewVisitor viewVisitor = this.mProtocol.readEventBinding((JSONObject)changeInfo.second, ViewCrawler.this.mDynamicEventTracker);
                    newVisitors.add(new Pair(changeInfo.first, (Object)viewVisitor));
                    continue;
                }
                catch (EditProtocol.InapplicableInstructionsException inapplicableInstructionsException) {
                    Log.i((String)ViewCrawler.LOGTAG, (String)inapplicableInstructionsException.getMessage());
                    continue;
                }
                catch (EditProtocol.BadInstructionsException badInstructionsException) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Bad persistent event binding cannot be applied.", (Throwable)badInstructionsException);
                }
            }
            size = this.mEditorEventBindings.size();
            for (i = 0; i < size; ++i) {
                Pair<String, JSONObject> changeInfo = this.mEditorEventBindings.get(i);
                try {
                    ViewVisitor viewVisitor = this.mProtocol.readEventBinding((JSONObject)changeInfo.second, ViewCrawler.this.mDynamicEventTracker);
                    newVisitors.add(new Pair(changeInfo.first, (Object)viewVisitor));
                    continue;
                }
                catch (EditProtocol.InapplicableInstructionsException inapplicableInstructionsException) {
                    Log.i((String)ViewCrawler.LOGTAG, (String)inapplicableInstructionsException.getMessage());
                    continue;
                }
                catch (EditProtocol.BadInstructionsException badInstructionsException) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Bad editor event binding cannot be applied.", (Throwable)badInstructionsException);
                }
            }
            HashMap<String, List<ViewVisitor>> editMap = new HashMap<String, List<ViewVisitor>>();
            int totalEdits = newVisitors.size();
            for (int i3 = 0; i3 < totalEdits; ++i3) {
                void var8_62;
                Pair pair = (Pair)newVisitors.get(i3);
                if (editMap.containsKey(pair.first)) {
                    List list = (List)editMap.get(pair.first);
                } else {
                    ArrayList arrayList = new ArrayList();
                    editMap.put((String)pair.first, arrayList);
                }
                var8_62.add(pair.second);
            }
            ViewCrawler.this.mEditState.setEdits(editMap);
            for (Pair<Integer, Integer> pair : emptyVariantIds) {
                if (this.mSeenExperiments.contains(pair)) continue;
                toTrack.add(pair);
            }
            this.mSeenExperiments.addAll(toTrack);
            if (toTrack.size() > 0) {
                final JSONObject variantObject = new JSONObject();
                try {
                    for (Pair pair : toTrack) {
                        int experimentId = (Integer)pair.first;
                        int variantId = (Integer)pair.second;
                        JSONObject trackProps = new JSONObject();
                        trackProps.put("$experiment_id", experimentId);
                        trackProps.put("$variant_id", variantId);
                        variantObject.put(Integer.toString(experimentId), variantId);
                        ViewCrawler.this.mMixpanel.getPeople().merge("$experiments", variantObject);
                        ViewCrawler.this.mMixpanel.updateSuperProperties(new SuperPropertyUpdate(){

                            @Override
                            public JSONObject update(JSONObject in) {
                                try {
                                    in.put("$experiments", (Object)variantObject);
                                }
                                catch (JSONException e) {
                                    Log.wtf((String)ViewCrawler.LOGTAG, (String)"Can't write $experiments super property", (Throwable)e);
                                }
                                return in;
                            }
                        });
                        ViewCrawler.this.mMixpanel.track("$experiment_started", trackProps);
                    }
                }
                catch (JSONException jSONException) {
                    Log.wtf((String)ViewCrawler.LOGTAG, (String)"Could not build JSON for reporting experiment start", (Throwable)jSONException);
                }
            }
        }

        private SharedPreferences getSharedPreferences() {
            String sharedPrefsName = "mixpanel.viewcrawler.changes" + this.mToken;
            return ViewCrawler.this.mContext.getSharedPreferences(sharedPrefsName, 0);
        }
    }

    private class LifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks,
    FlipGesture.OnFlipGestureListener {
        private final FlipGesture mFlipGesture = new FlipGesture(this);
        private final EmulatorConnector mEmulatorConnector;

        public LifecycleCallbacks() {
            this.mEmulatorConnector = new EmulatorConnector();
        }

        @Override
        public void onFlipGesture() {
            ViewCrawler.this.mMixpanel.track("$ab_gesture3");
            Message message = ViewCrawler.this.mMessageThreadHandler.obtainMessage(1);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(message);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
            this.installConnectionSensor(activity);
            ViewCrawler.this.mEditState.add(activity);
        }

        public void onActivityPaused(Activity activity) {
            ViewCrawler.this.mEditState.remove(activity);
            this.uninstallConnectionSensor(activity);
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        private void installConnectionSensor(Activity activity) {
            if (this.isInEmulator() && !ViewCrawler.this.mConfig.getDisableEmulatorBindingUI()) {
                this.mEmulatorConnector.start();
            } else if (!ViewCrawler.this.mConfig.getDisableGestureBindingUI()) {
                SensorManager sensorManager = (SensorManager)activity.getSystemService("sensor");
                Sensor accelerometer = sensorManager.getDefaultSensor(1);
                sensorManager.registerListener((SensorEventListener)this.mFlipGesture, accelerometer, 3);
            }
        }

        private void uninstallConnectionSensor(Activity activity) {
            if (this.isInEmulator() && !ViewCrawler.this.mConfig.getDisableEmulatorBindingUI()) {
                this.mEmulatorConnector.stop();
            } else if (!ViewCrawler.this.mConfig.getDisableGestureBindingUI()) {
                SensorManager sensorManager = (SensorManager)activity.getSystemService("sensor");
                sensorManager.unregisterListener((SensorEventListener)this.mFlipGesture);
            }
        }

        private boolean isInEmulator() {
            if (!Build.HARDWARE.equals("goldfish") && !Build.HARDWARE.equals("ranchu")) {
                return false;
            }
            if (!Build.BRAND.startsWith("generic") && !Build.BRAND.equals("Android")) {
                return false;
            }
            if (!Build.DEVICE.startsWith("generic")) {
                return false;
            }
            if (!Build.PRODUCT.contains("sdk")) {
                return false;
            }
            return Build.MODEL.toLowerCase(Locale.US).contains("sdk");
        }
    }

    private class EmulatorConnector
    implements Runnable {
        private volatile boolean mStopped = true;

        @Override
        public void run() {
            if (!this.mStopped) {
                Message message = ViewCrawler.this.mMessageThreadHandler.obtainMessage(1);
                ViewCrawler.this.mMessageThreadHandler.sendMessage(message);
            }
            ViewCrawler.this.mMessageThreadHandler.postDelayed(this, 30000L);
        }

        public void start() {
            this.mStopped = false;
            ViewCrawler.this.mMessageThreadHandler.post(this);
        }

        public void stop() {
            this.mStopped = true;
            ViewCrawler.this.mMessageThreadHandler.removeCallbacks(this);
        }
    }
}

