/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v4.util.LruCache;
import android.util.Base64;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.util.HttpService;
import com.mixpanel.android.util.RemoteService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLSocketFactory;

public class ImageStore {
    private final File mDirectory;
    private final RemoteService mPoster;
    private final MessageDigest mDigest;
    private final MPConfig mConfig;
    private static LruCache<String, Bitmap> sMemoryCache;
    private static final String DEFAULT_DIRECTORY_PREFIX = "MixpanelAPI.Images.";
    private static final int MAX_BITMAP_SIZE = 10000000;
    private static final String FILE_PREFIX = "MP_IMG_";
    private static final String LOGTAG = "MixpanelAPI.ImageStore";

    public ImageStore(Context context, String moduleName) {
        this(context, DEFAULT_DIRECTORY_PREFIX + moduleName, new HttpService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageStore(Context context, String directoryName, RemoteService poster) {
        MessageDigest useDigest;
        this.mDirectory = context.getDir(directoryName, 0);
        this.mPoster = poster;
        this.mConfig = MPConfig.getInstance(context);
        try {
            useDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            Log.w((String)LOGTAG, (String)"Images won't be stored because this platform doesn't supply a SHA1 hash function");
            useDigest = null;
        }
        this.mDigest = useDigest;
        if (sMemoryCache != null) return;
        Class<ImageStore> clazz = ImageStore.class;
        synchronized (ImageStore.class) {
            if (sMemoryCache != null) return;
            int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
            int cacheSize = maxMemory / this.mConfig.getImageCacheMaxMemoryFactor();
            sMemoryCache = new LruCache<String, Bitmap>(cacheSize){

                protected int sizeOf(String key, Bitmap bitmap) {
                    return bitmap.getRowBytes() * bitmap.getHeight() / 1024;
                }
            };
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return;
        }
    }

    public File getImageFile(String url) throws CantGetImageException {
        File file = this.storedFile(url);
        byte[] bytes = null;
        if (file == null || !file.exists()) {
            try {
                SSLSocketFactory factory = this.mConfig.getSSLSocketFactory();
                bytes = this.mPoster.performRequest(url, null, factory);
            }
            catch (IOException e) {
                throw new CantGetImageException("Can't download bitmap", e);
            }
            catch (RemoteService.ServiceUnavailableException e) {
                throw new CantGetImageException("Couldn't download image due to service availability", e);
            }
            if (null != bytes && null != file && bytes.length < 10000000) {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(file);
                    ((OutputStream)out).write(bytes);
                }
                catch (FileNotFoundException e) {
                    throw new CantGetImageException("It appears that ImageStore is misconfigured, or disk storage is unavailable- can't write to bitmap directory", e);
                }
                catch (IOException e) {
                    throw new CantGetImageException("Can't store bitmap", e);
                }
                finally {
                    if (null != out) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException e) {
                            Log.w((String)LOGTAG, (String)"Problem closing output file", (Throwable)e);
                        }
                    }
                }
            }
        }
        return file;
    }

    public Bitmap getImage(String url) throws CantGetImageException {
        Bitmap cachedBitmap = ImageStore.getBitmapFromMemCache(url);
        if (cachedBitmap == null) {
            File imageFile = this.getImageFile(url);
            cachedBitmap = ImageStore.decodeImage(imageFile);
            ImageStore.addBitmapToMemoryCache(url, cachedBitmap);
        }
        return cachedBitmap;
    }

    private static Bitmap decodeImage(File file) throws CantGetImageException {
        BitmapFactory.Options option = new BitmapFactory.Options();
        option.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)option);
        float imageSize = (float)option.outHeight * (float)option.outWidth;
        if (imageSize > ImageStore.getAvailableMemory()) {
            throw new CantGetImageException("Do not have enough memory for the image");
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
        if (null == bitmap) {
            boolean ignored = file.delete();
            throw new CantGetImageException("Bitmap on disk can't be opened or was corrupt");
        }
        return bitmap;
    }

    private static float getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        float used = runtime.totalMemory() - runtime.freeMemory();
        return (float)runtime.maxMemory() - used;
    }

    public void clearStorage() {
        for (File file : this.mDirectory.listFiles()) {
            String filename = file.getName();
            if (!filename.startsWith(FILE_PREFIX)) continue;
            boolean ignored = file.delete();
        }
        ImageStore.clearMemCache();
    }

    public void deleteStorage(String url) {
        File file = this.storedFile(url);
        if (null != file) {
            boolean ignored = file.delete();
            ImageStore.removeBitmapFromMemCache(url);
        }
    }

    private File storedFile(String url) {
        if (null == this.mDigest) {
            return null;
        }
        byte[] hashed = this.mDigest.digest(url.getBytes());
        String safeName = FILE_PREFIX + Base64.encodeToString((byte[])hashed, (int)10);
        return new File(this.mDirectory, safeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBitmapToMemoryCache(String key, Bitmap bitmap) {
        if (ImageStore.getBitmapFromMemCache(key) == null) {
            LruCache<String, Bitmap> lruCache = sMemoryCache;
            synchronized (lruCache) {
                sMemoryCache.put((Object)key, (Object)bitmap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmapFromMemCache(String key) {
        LruCache<String, Bitmap> lruCache = sMemoryCache;
        synchronized (lruCache) {
            return (Bitmap)sMemoryCache.get((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBitmapFromMemCache(String key) {
        LruCache<String, Bitmap> lruCache = sMemoryCache;
        synchronized (lruCache) {
            sMemoryCache.remove((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMemCache() {
        LruCache<String, Bitmap> lruCache = sMemoryCache;
        synchronized (lruCache) {
            sMemoryCache.evictAll();
        }
    }

    public static class CantGetImageException
    extends Exception {
        public CantGetImageException(String message) {
            super(message);
        }

        public CantGetImageException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

