/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.content.Context;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public interface RemoteService {
    public boolean isOnline(Context var1);

    public void checkIsMixpanelBlocked();

    public byte[] performRequest(String var1, Map<String, Object> var2, SSLSocketFactory var3) throws ServiceUnavailableException, IOException;

    public static class ServiceUnavailableException
    extends Exception {
        private final int mRetryAfter;

        public ServiceUnavailableException(String message, String strRetryAfter) {
            super(message);
            int retry;
            try {
                retry = Integer.parseInt(strRetryAfter);
            }
            catch (NumberFormatException e) {
                retry = 0;
            }
            this.mRetryAfter = retry;
        }

        public int getRetryAfter() {
            return this.mRetryAfter;
        }
    }
}

