/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.ResourceIds;
import com.mixpanel.android.mpmetrics.ResourceReader;

public class GCMReceiver
extends BroadcastReceiver {
    private static final String LOGTAG = "MixpanelAPI.GCMReceiver";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("com.google.android.c2dm.intent.REGISTRATION".equals(action)) {
            this.handleRegistrationIntent(intent);
        } else if ("com.google.android.c2dm.intent.RECEIVE".equals(action)) {
            this.handleNotificationIntent(context, intent);
        }
    }

    Intent getDefaultIntent(Context context) {
        PackageManager manager = context.getPackageManager();
        return manager.getLaunchIntentForPackage(context.getPackageName());
    }

    NotificationData readInboundIntent(Context context, Intent inboundIntent, ResourceIds iconIds) {
        ApplicationInfo appInfo;
        PackageManager manager = context.getPackageManager();
        String message = inboundIntent.getStringExtra("mp_message");
        String iconName = inboundIntent.getStringExtra("mp_icnm");
        String uriString = inboundIntent.getStringExtra("mp_cta");
        CharSequence notificationTitle = inboundIntent.getStringExtra("mp_title");
        if (message == null) {
            return null;
        }
        int notificationIcon = -1;
        if (null != iconName && iconIds.knownIdName(iconName)) {
            notificationIcon = iconIds.idFromName(iconName);
        }
        try {
            appInfo = manager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            appInfo = null;
        }
        if (notificationIcon == -1 && null != appInfo) {
            notificationIcon = appInfo.icon;
        }
        if (notificationIcon == -1) {
            notificationIcon = 17301651;
        }
        if (null == notificationTitle && null != appInfo) {
            notificationTitle = manager.getApplicationLabel(appInfo);
        }
        if (null == notificationTitle) {
            notificationTitle = "A message for you";
        }
        Intent notificationIntent = this.buildNotificationIntent(context, uriString);
        return new NotificationData(notificationIcon, notificationTitle, message, notificationIntent);
    }

    private Intent buildNotificationIntent(Context context, String uriString) {
        Uri uri = null;
        if (null != uriString) {
            uri = Uri.parse((String)uriString);
        }
        Intent ret = null == uri ? this.getDefaultIntent(context) : new Intent("android.intent.action.VIEW", uri);
        return ret;
    }

    private Notification buildNotification(Context context, Intent inboundIntent, ResourceIds iconIds) {
        NotificationData notificationData = this.readInboundIntent(context, inboundIntent, iconIds);
        if (null == notificationData) {
            return null;
        }
        if (MPConfig.DEBUG) {
            Log.d((String)LOGTAG, (String)("MP GCM notification received: " + notificationData.message));
        }
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)notificationData.intent, (int)0x8000000);
        Notification notification = Build.VERSION.SDK_INT >= 16 ? this.makeNotificationSDK16OrHigher(context, contentIntent, notificationData) : (Build.VERSION.SDK_INT >= 11 ? this.makeNotificationSDK11OrHigher(context, contentIntent, notificationData) : this.makeNotificationSDKLessThan11(context, contentIntent, notificationData));
        return notification;
    }

    private void handleRegistrationIntent(Intent intent) {
        final String registration = intent.getStringExtra("registration_id");
        if (intent.getStringExtra("error") != null) {
            Log.e((String)LOGTAG, (String)("Error when registering for GCM: " + intent.getStringExtra("error")));
        } else if (registration != null) {
            if (MPConfig.DEBUG) {
                Log.d((String)LOGTAG, (String)("Registering GCM ID: " + registration));
            }
            MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                @Override
                public void process(MixpanelAPI api) {
                    api.getPeople().setPushRegistrationId(registration);
                }
            });
        } else if (intent.getStringExtra("unregistered") != null) {
            if (MPConfig.DEBUG) {
                Log.d((String)LOGTAG, (String)"Unregistering from GCM");
            }
            MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                @Override
                public void process(MixpanelAPI api) {
                    api.getPeople().clearPushRegistrationId();
                }
            });
        }
    }

    private void handleNotificationIntent(Context context, Intent intent) {
        MPConfig config = MPConfig.getInstance(context);
        String resourcePackage = config.getResourcePackageName();
        if (null == resourcePackage) {
            resourcePackage = context.getPackageName();
        }
        ResourceReader.Drawables drawableIds = new ResourceReader.Drawables(resourcePackage, context);
        Context applicationContext = context.getApplicationContext();
        Notification notification = this.buildNotification(applicationContext, intent, drawableIds);
        if (null != notification) {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.notify(0, notification);
        }
    }

    @TargetApi(value=9)
    private Notification makeNotificationSDKLessThan11(Context context, PendingIntent intent, NotificationData notificationData) {
        Notification n = new Notification(notificationData.icon, (CharSequence)notificationData.message, System.currentTimeMillis());
        n.flags |= 0x10;
        n.setLatestEventInfo(context, notificationData.title, (CharSequence)notificationData.message, intent);
        return n;
    }

    @TargetApi(value=11)
    private Notification makeNotificationSDK11OrHigher(Context context, PendingIntent intent, NotificationData notificationData) {
        Notification.Builder builder = new Notification.Builder(context).setSmallIcon(notificationData.icon).setTicker((CharSequence)notificationData.message).setWhen(System.currentTimeMillis()).setContentTitle(notificationData.title).setContentText((CharSequence)notificationData.message).setContentIntent(intent);
        Notification n = builder.getNotification();
        n.flags |= 0x10;
        return n;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=16)
    private Notification makeNotificationSDK16OrHigher(Context context, PendingIntent intent, NotificationData notificationData) {
        Notification.Builder builder = new Notification.Builder(context).setSmallIcon(notificationData.icon).setTicker((CharSequence)notificationData.message).setWhen(System.currentTimeMillis()).setContentTitle(notificationData.title).setContentText((CharSequence)notificationData.message).setContentIntent(intent).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)notificationData.message));
        Notification n = builder.build();
        n.flags |= 0x10;
        return n;
    }

    static class NotificationData {
        public final int icon;
        public final CharSequence title;
        public final String message;
        public final Intent intent;

        private NotificationData(int anIcon, CharSequence aTitle, String aMessage, Intent anIntent) {
            this.icon = anIcon;
            this.title = aTitle;
            this.message = aMessage;
            this.intent = anIntent;
        }
    }
}

