/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.mixpanel.android.R;
import com.mixpanel.android.mpmetrics.AnalyticsMessages;
import com.mixpanel.android.mpmetrics.BackgroundCapture;
import com.mixpanel.android.mpmetrics.ConfigurationChecker;
import com.mixpanel.android.mpmetrics.DecideMessages;
import com.mixpanel.android.mpmetrics.InAppFragment;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelActivityLifecycleCallbacks;
import com.mixpanel.android.mpmetrics.OnMixpanelUpdatesReceivedListener;
import com.mixpanel.android.mpmetrics.PersistentIdentity;
import com.mixpanel.android.mpmetrics.SharedPreferencesLoader;
import com.mixpanel.android.mpmetrics.SuperPropertyUpdate;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.mpmetrics.SurveyCallbacks;
import com.mixpanel.android.mpmetrics.Tweak;
import com.mixpanel.android.mpmetrics.Tweaks;
import com.mixpanel.android.mpmetrics.UpdateDisplayState;
import com.mixpanel.android.surveys.SurveyActivity;
import com.mixpanel.android.util.ActivityImageUtils;
import com.mixpanel.android.viewcrawler.TrackingDebug;
import com.mixpanel.android.viewcrawler.UpdatesFromMixpanel;
import com.mixpanel.android.viewcrawler.ViewCrawler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelAPI {
    public static final String VERSION = "4.5.4-RC2";
    private final Context mContext;
    private final AnalyticsMessages mMessages;
    private final MPConfig mConfig;
    private final String mToken;
    private final PeopleImpl mPeople;
    private final UpdatesFromMixpanel mUpdatesFromMixpanel;
    private final PersistentIdentity mPersistentIdentity;
    private final UpdatesListener mUpdatesListener;
    private final TrackingDebug mTrackingDebug;
    private final DecideMessages mDecideMessages;
    private final Map<String, String> mDeviceInfo;
    private final Map<String, Long> mEventTimings;
    private static final Map<String, Map<Context, MixpanelAPI>> sInstanceMap = new HashMap<String, Map<Context, MixpanelAPI>>();
    private static final SharedPreferencesLoader sPrefsLoader = new SharedPreferencesLoader();
    private static final Tweaks sSharedTweaks = new Tweaks();
    private static Future<SharedPreferences> sReferrerPrefs;
    private static final String LOGTAG = "MixpanelAPI.API";
    private static final String APP_LINKS_LOGTAG = "MixpanelAPI.AL";
    private static final String ENGAGE_DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";

    public static Tweak<String> stringTweak(String tweakName, String defaultValue) {
        return sSharedTweaks.stringTweak(tweakName, defaultValue);
    }

    public static Tweak<Boolean> booleanTweak(String tweakName, boolean defaultValue) {
        return sSharedTweaks.booleanTweak(tweakName, defaultValue);
    }

    public static Tweak<Double> doubleTweak(String tweakName, double defaultValue) {
        return sSharedTweaks.doubleTweak(tweakName, defaultValue);
    }

    public static Tweak<Float> floatTweak(String tweakName, float defaultValue) {
        return sSharedTweaks.floatTweak(tweakName, defaultValue);
    }

    public static Tweak<Long> longTweak(String tweakName, long defaultValue) {
        return sSharedTweaks.longTweak(tweakName, defaultValue);
    }

    public static Tweak<Integer> intTweak(String tweakName, int defaultValue) {
        return sSharedTweaks.intTweak(tweakName, defaultValue);
    }

    public static Tweak<Short> shortTweak(String tweakName, short defaultValue) {
        return sSharedTweaks.shortTweak(tweakName, defaultValue);
    }

    public static Tweak<Byte> byteTweak(String tweakName, byte defaultValue) {
        return sSharedTweaks.byteTweak(tweakName, defaultValue);
    }

    MixpanelAPI(Context context, Future<SharedPreferences> referrerPreferences, String token) {
        this.mContext = context;
        this.mToken = token;
        this.mEventTimings = new HashMap<String, Long>();
        this.mPeople = new PeopleImpl();
        this.mConfig = this.getConfig();
        HashMap<String, String> deviceInfo = new HashMap<String, String>();
        deviceInfo.put("$android_lib_version", VERSION);
        deviceInfo.put("$android_os", "Android");
        deviceInfo.put("$android_os_version", Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE);
        deviceInfo.put("$android_manufacturer", Build.MANUFACTURER == null ? "UNKNOWN" : Build.MANUFACTURER);
        deviceInfo.put("$android_brand", Build.BRAND == null ? "UNKNOWN" : Build.BRAND);
        deviceInfo.put("$android_model", Build.MODEL == null ? "UNKNOWN" : Build.MODEL);
        try {
            PackageManager manager = this.mContext.getPackageManager();
            PackageInfo info = manager.getPackageInfo(this.mContext.getPackageName(), 0);
            deviceInfo.put("$android_app_version", info.versionName);
            deviceInfo.put("$android_app_version_code", Integer.toString(info.versionCode));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)LOGTAG, (String)"Exception getting app version name", (Throwable)e);
        }
        this.mDeviceInfo = Collections.unmodifiableMap(deviceInfo);
        this.mUpdatesFromMixpanel = this.constructUpdatesFromMixpanel(context, token);
        this.mTrackingDebug = this.constructTrackingDebug();
        this.mPersistentIdentity = this.getPersistentIdentity(context, referrerPreferences, token);
        this.mUpdatesListener = this.constructUpdatesListener();
        this.mDecideMessages = this.constructDecideUpdates(token, this.mUpdatesListener, this.mUpdatesFromMixpanel);
        String decideId = this.mPersistentIdentity.getPeopleDistinctId();
        if (null == decideId) {
            decideId = this.mPersistentIdentity.getEventsDistinctId();
        }
        this.mDecideMessages.setDistinctId(decideId);
        this.mMessages = this.getAnalyticsMessages();
        this.mMessages.installDecideCheck(this.mDecideMessages);
        this.registerMixpanelActivityLifecycleCallbacks();
        if (this.sendAppOpen()) {
            this.track("$app_open", null);
        }
        this.mUpdatesFromMixpanel.startUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MixpanelAPI getInstance(Context context, String token) {
        if (null == token || null == context) {
            return null;
        }
        Map<String, Map<Context, MixpanelAPI>> map = sInstanceMap;
        synchronized (map) {
            MixpanelAPI instance;
            Map<Context, MixpanelAPI> instances;
            Context appContext = context.getApplicationContext();
            if (null == sReferrerPrefs) {
                sReferrerPrefs = sPrefsLoader.loadPreferences(context, "com.mixpanel.android.mpmetrics.ReferralInfo", null);
            }
            if (null == (instances = sInstanceMap.get(token))) {
                instances = new HashMap<Context, MixpanelAPI>();
                sInstanceMap.put(token, instances);
            }
            if (null == (instance = instances.get(appContext)) && ConfigurationChecker.checkBasicConfiguration(appContext)) {
                instance = new MixpanelAPI(appContext, sReferrerPrefs, token);
                MixpanelAPI.registerAppLinksListeners(context, instance);
                instances.put(appContext, instance);
            }
            MixpanelAPI.checkIntentForInboundAppLink(context);
            return instance;
        }
    }

    @Deprecated
    public static void setFlushInterval(Context context, long milliseconds) {
        Log.i((String)LOGTAG, (String)"MixpanelAPI.setFlushInterval is deprecated. Calling is now a no-op.\n    To set a custom Mixpanel flush interval for your application, add\n    <meta-data android:name=\"com.mixpanel.android.MPConfig.FlushInterval\" android:value=\"YOUR_INTERVAL\" />\n    to the <application> section of your AndroidManifest.xml.");
    }

    @Deprecated
    public static void enableFallbackServer(Context context, boolean enableIfTrue) {
        Log.i((String)LOGTAG, (String)"MixpanelAPI.enableFallbackServer is deprecated. This call is a no-op.\n    To enable fallback in your application, add\n    <meta-data android:name=\"com.mixpanel.android.MPConfig.DisableFallback\" android:value=\"false\" />\n    to the <application> section of your AndroidManifest.xml.");
    }

    public void alias(String alias, String original) {
        if (original == null) {
            original = this.getDistinctId();
        }
        if (alias.equals(original)) {
            Log.w((String)LOGTAG, (String)("Attempted to alias identical distinct_ids " + alias + ". Alias message will not be sent."));
            return;
        }
        try {
            JSONObject j = new JSONObject();
            j.put("alias", (Object)alias);
            j.put("original", (Object)original);
            this.track("$create_alias", j);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Failed to alias", (Throwable)e);
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void identify(String distinctId) {
        PersistentIdentity persistentIdentity = this.mPersistentIdentity;
        synchronized (persistentIdentity) {
            this.mPersistentIdentity.setEventsDistinctId(distinctId);
            String decideId = this.mPersistentIdentity.getPeopleDistinctId();
            if (null == decideId) {
                decideId = this.mPersistentIdentity.getEventsDistinctId();
            }
            this.mDecideMessages.setDistinctId(decideId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeEvent(String eventName) {
        long writeTime = System.currentTimeMillis();
        Map<String, Long> map = this.mEventTimings;
        synchronized (map) {
            this.mEventTimings.put(eventName, writeTime);
        }
    }

    public void trackMap(String eventName, Map<String, Object> properties) {
        if (null == properties) {
            this.track(eventName, null);
        } else {
            try {
                this.track(eventName, new JSONObject(properties));
            }
            catch (NullPointerException e) {
                Log.w((String)LOGTAG, (String)"Can't have null keys in the properties of trackMap!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(String eventName, JSONObject properties) {
        Long eventBegin;
        Map<String, Long> map = this.mEventTimings;
        synchronized (map) {
            eventBegin = this.mEventTimings.get(eventName);
            this.mEventTimings.remove(eventName);
        }
        try {
            JSONObject messageProps = new JSONObject();
            Map<String, String> referrerProperties = this.mPersistentIdentity.getReferrerProperties();
            for (Map.Entry<String, String> entry : referrerProperties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                messageProps.put(key, (Object)value);
            }
            this.mPersistentIdentity.addSuperPropertiesToObject(messageProps);
            double timeSecondsDouble = (double)System.currentTimeMillis() / 1000.0;
            long timeSeconds = (long)timeSecondsDouble;
            messageProps.put("time", timeSeconds);
            messageProps.put("distinct_id", (Object)this.getDistinctId());
            if (null != eventBegin) {
                double eventBeginDouble = (double)eventBegin.longValue() / 1000.0;
                double secondsElapsed = timeSecondsDouble - eventBeginDouble;
                messageProps.put("$duration", secondsElapsed);
            }
            if (null != properties) {
                Iterator propIter = properties.keys();
                while (propIter.hasNext()) {
                    String key = (String)propIter.next();
                    messageProps.put(key, properties.get(key));
                }
            }
            AnalyticsMessages.EventDescription eventDescription = new AnalyticsMessages.EventDescription(eventName, messageProps, this.mToken);
            this.mMessages.eventsMessage(eventDescription);
            if (null != this.mTrackingDebug) {
                this.mTrackingDebug.reportTrack(eventName);
            }
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)("Exception tracking event " + eventName), (Throwable)e);
        }
    }

    public void track(String eventName) {
        this.track(eventName, null);
    }

    public void flush() {
        this.mMessages.postToServer();
    }

    public JSONObject getSuperProperties() {
        JSONObject ret = new JSONObject();
        this.mPersistentIdentity.addSuperPropertiesToObject(ret);
        return ret;
    }

    public String getDistinctId() {
        return this.mPersistentIdentity.getEventsDistinctId();
    }

    public void registerSuperPropertiesMap(Map<String, Object> superProperties) {
        if (null == superProperties) {
            Log.e((String)LOGTAG, (String)"registerSuperPropertiesMap does not accept null properties");
            return;
        }
        try {
            this.registerSuperProperties(new JSONObject(superProperties));
        }
        catch (NullPointerException e) {
            Log.w((String)LOGTAG, (String)"Can't have null keys in the properties of registerSuperPropertiesMap!");
        }
    }

    public void registerSuperProperties(JSONObject superProperties) {
        this.mPersistentIdentity.registerSuperProperties(superProperties);
    }

    public void unregisterSuperProperty(String superPropertyName) {
        this.mPersistentIdentity.unregisterSuperProperty(superPropertyName);
    }

    public void registerSuperPropertiesOnceMap(Map<String, Object> superProperties) {
        if (null == superProperties) {
            Log.e((String)LOGTAG, (String)"registerSuperPropertiesOnceMap does not accept null properties");
            return;
        }
        try {
            this.registerSuperPropertiesOnce(new JSONObject(superProperties));
        }
        catch (NullPointerException e) {
            Log.w((String)LOGTAG, (String)"Can't have null keys in the properties of registerSuperPropertiesOnce!");
        }
    }

    public void registerSuperPropertiesOnce(JSONObject superProperties) {
        this.mPersistentIdentity.registerSuperPropertiesOnce(superProperties);
    }

    public void clearSuperProperties() {
        this.mPersistentIdentity.clearSuperProperties();
    }

    public void updateSuperProperties(SuperPropertyUpdate update) {
        this.mPersistentIdentity.updateSuperProperties(update);
    }

    public People getPeople() {
        return this.mPeople;
    }

    public void reset() {
        this.mPersistentIdentity.clearPreferences();
    }

    public Map<String, String> getDeviceInfo() {
        return this.mDeviceInfo;
    }

    @Deprecated
    public void logPosts() {
        Log.i((String)LOGTAG, (String)"MixpanelAPI.logPosts() is deprecated.\n    To get verbose debug level logging, add\n    <meta-data android:name=\"com.mixpanel.android.MPConfig.EnableDebugLogging\" value=\"true\" />\n    to the <application> section of your AndroidManifest.xml.");
    }

    @TargetApi(value=16)
    void registerMixpanelActivityLifecycleCallbacks() {
        if (Build.VERSION.SDK_INT >= 16 && this.mConfig.getAutoShowMixpanelUpdates()) {
            if (this.mContext.getApplicationContext() instanceof Application) {
                Application app = (Application)this.mContext.getApplicationContext();
                app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new MixpanelActivityLifecycleCallbacks(this));
            } else {
                Log.i((String)LOGTAG, (String)"Context is not an Application, Mixpanel will not automatically show surveys, in-app notifications, or A/B test experiments.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void allInstances(InstanceProcessor processor) {
        Map<String, Map<Context, MixpanelAPI>> map = sInstanceMap;
        synchronized (map) {
            for (Map<Context, MixpanelAPI> contextInstances : sInstanceMap.values()) {
                for (MixpanelAPI instance : contextInstances.values()) {
                    processor.process(instance);
                }
            }
        }
    }

    AnalyticsMessages getAnalyticsMessages() {
        return AnalyticsMessages.getInstance(this.mContext);
    }

    MPConfig getConfig() {
        return MPConfig.getInstance(this.mContext);
    }

    PersistentIdentity getPersistentIdentity(Context context, Future<SharedPreferences> referrerPreferences, String token) {
        SharedPreferencesLoader.OnPrefsLoadedListener listener = new SharedPreferencesLoader.OnPrefsLoadedListener(){

            @Override
            public void onPrefsLoaded(SharedPreferences preferences) {
                JSONArray records = PersistentIdentity.waitingPeopleRecordsForSending(preferences);
                if (null != records) {
                    MixpanelAPI.this.sendAllPeopleRecords(records);
                }
            }
        };
        String prefsName = "com.mixpanel.android.mpmetrics.MixpanelAPI_" + token;
        Future<SharedPreferences> storedPreferences = sPrefsLoader.loadPreferences(context, prefsName, listener);
        return new PersistentIdentity(referrerPreferences, storedPreferences);
    }

    DecideMessages constructDecideUpdates(String token, DecideMessages.OnNewResultsListener listener, UpdatesFromMixpanel updatesFromMixpanel) {
        return new DecideMessages(token, listener, updatesFromMixpanel);
    }

    UpdatesListener constructUpdatesListener() {
        if (Build.VERSION.SDK_INT < 16) {
            Log.i((String)LOGTAG, (String)"Surveys and Notifications are not supported on this Android OS Version");
            return new UnsupportedUpdatesListener();
        }
        return new SupportedUpdatesListener();
    }

    UpdatesFromMixpanel constructUpdatesFromMixpanel(Context context, String token) {
        if (Build.VERSION.SDK_INT < 16) {
            Log.i((String)LOGTAG, (String)"Web Configuration, A/B Testing, and Dynamic Tweaks are not supported on this Android OS Version");
            return new UnsupportedUpdatesFromMixpanel(sSharedTweaks);
        }
        return new ViewCrawler(this.mContext, this.mToken, this, sSharedTweaks);
    }

    TrackingDebug constructTrackingDebug() {
        if (this.mUpdatesFromMixpanel instanceof ViewCrawler) {
            return (TrackingDebug)((Object)this.mUpdatesFromMixpanel);
        }
        return null;
    }

    boolean sendAppOpen() {
        return !this.mConfig.getDisableAppOpenEvent();
    }

    private void recordPeopleMessage(JSONObject message) {
        if (message.has("$distinct_id")) {
            this.mMessages.peopleMessage(message);
        } else {
            this.mPersistentIdentity.storeWaitingPeopleRecord(message);
        }
    }

    private void pushWaitingPeopleRecord() {
        JSONArray records = this.mPersistentIdentity.waitingPeopleRecordsForSending();
        if (null != records) {
            this.sendAllPeopleRecords(records);
        }
    }

    private void sendAllPeopleRecords(JSONArray records) {
        for (int i = 0; i < records.length(); ++i) {
            try {
                JSONObject message = records.getJSONObject(i);
                this.mMessages.peopleMessage(message);
                continue;
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)"Malformed people record stored pending identity, will not send it.", (Throwable)e);
            }
        }
    }

    private static void registerAppLinksListeners(Context context, final MixpanelAPI mixpanel) {
        try {
            Class<?> clazz = Class.forName("android.support.v4.content.LocalBroadcastManager");
            Method methodGetInstance = clazz.getMethod("getInstance", Context.class);
            Method methodRegisterReceiver = clazz.getMethod("registerReceiver", BroadcastReceiver.class, IntentFilter.class);
            Object localBroadcastManager = methodGetInstance.invoke(null, context);
            methodRegisterReceiver.invoke(localBroadcastManager, new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    JSONObject properties = new JSONObject();
                    Bundle args = intent.getBundleExtra("event_args");
                    if (args != null) {
                        for (String key : args.keySet()) {
                            try {
                                properties.put(key, args.get(key));
                            }
                            catch (JSONException e) {
                                Log.e((String)MixpanelAPI.APP_LINKS_LOGTAG, (String)("failed to add key \"" + key + "\" to properties for tracking bolts event"), (Throwable)e);
                            }
                        }
                    }
                    mixpanel.track("$" + intent.getStringExtra("event_name"), properties);
                }
            }, new IntentFilter("com.parse.bolts.measurement_event"));
        }
        catch (InvocationTargetException e) {
            Log.d((String)APP_LINKS_LOGTAG, (String)"Failed to invoke LocalBroadcastManager.registerReceiver() -- App Links tracking will not be enabled due to this exception", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Log.d((String)APP_LINKS_LOGTAG, (String)("To enable App Links tracking android.support.v4 must be installed: " + e.getMessage()));
        }
        catch (NoSuchMethodException e) {
            Log.d((String)APP_LINKS_LOGTAG, (String)("To enable App Links tracking android.support.v4 must be installed: " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            Log.d((String)APP_LINKS_LOGTAG, (String)("App Links tracking will not be enabled due to this exception: " + e.getMessage()));
        }
    }

    private static void checkIntentForInboundAppLink(Context context) {
        if (context instanceof Activity) {
            try {
                Class<?> clazz = Class.forName("bolts.AppLinks");
                Intent intent = ((Activity)context).getIntent();
                Method getTargetUrlFromInboundIntent = clazz.getMethod("getTargetUrlFromInboundIntent", Context.class, Intent.class);
                getTargetUrlFromInboundIntent.invoke(null, context, intent);
            }
            catch (InvocationTargetException e) {
                Log.d((String)APP_LINKS_LOGTAG, (String)"Failed to invoke bolts.AppLinks.getTargetUrlFromInboundIntent() -- Unable to detect inbound App Links", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                Log.d((String)APP_LINKS_LOGTAG, (String)("Please install the Bolts library >= 1.1.2 to track App Links: " + e.getMessage()));
            }
            catch (NoSuchMethodException e) {
                Log.d((String)APP_LINKS_LOGTAG, (String)("Please install the Bolts library >= 1.1.2 to track App Links: " + e.getMessage()));
            }
            catch (IllegalAccessException e) {
                Log.d((String)APP_LINKS_LOGTAG, (String)("Unable to detect inbound App Links: " + e.getMessage()));
            }
        } else {
            Log.d((String)APP_LINKS_LOGTAG, (String)"Context is not an instance of Activity. To detect inbound App Links, pass an instance of an Activity to getInstance.");
        }
    }

    private class UnsupportedUpdatesFromMixpanel
    implements UpdatesFromMixpanel {
        private final Tweaks mTweaks;

        public UnsupportedUpdatesFromMixpanel(Tweaks tweaks) {
            this.mTweaks = tweaks;
        }

        @Override
        public void startUpdates() {
        }

        @Override
        public void setEventBindings(JSONArray bindings) {
        }

        @Override
        public void setVariants(JSONArray variants) {
        }

        @Override
        public Tweaks getTweaks() {
            return this.mTweaks;
        }
    }

    private class SupportedUpdatesListener
    implements UpdatesListener,
    Runnable {
        private final Set<OnMixpanelUpdatesReceivedListener> mListeners = new HashSet<OnMixpanelUpdatesReceivedListener>();
        private final Executor mExecutor = Executors.newSingleThreadExecutor();

        private SupportedUpdatesListener() {
        }

        @Override
        public void onNewResults() {
            this.mExecutor.execute(this);
        }

        @Override
        public synchronized void addOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener listener) {
            if (MixpanelAPI.this.mDecideMessages.hasUpdatesAvailable()) {
                this.onNewResults();
            }
            this.mListeners.add(listener);
        }

        @Override
        public synchronized void removeOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener listener) {
            this.mListeners.remove(listener);
        }

        @Override
        public synchronized void run() {
            for (OnMixpanelUpdatesReceivedListener listener : this.mListeners) {
                listener.onMixpanelUpdatesReceived();
            }
        }
    }

    private class UnsupportedUpdatesListener
    implements UpdatesListener {
        private UnsupportedUpdatesListener() {
        }

        @Override
        public void onNewResults() {
        }

        @Override
        public void addOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener listener) {
        }

        @Override
        public void removeOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener listener) {
        }
    }

    private static interface UpdatesListener
    extends DecideMessages.OnNewResultsListener {
        public void addOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener var1);

        public void removeOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener var1);
    }

    private class PeopleImpl
    implements People {
        private PeopleImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void identify(String distinctId) {
            PersistentIdentity persistentIdentity = MixpanelAPI.this.mPersistentIdentity;
            synchronized (persistentIdentity) {
                MixpanelAPI.this.mPersistentIdentity.setPeopleDistinctId(distinctId);
                MixpanelAPI.this.mDecideMessages.setDistinctId(distinctId);
            }
            MixpanelAPI.this.pushWaitingPeopleRecord();
        }

        @Override
        public void setMap(Map<String, Object> properties) {
            if (null == properties) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"setMap does not accept null properties");
                return;
            }
            try {
                this.set(new JSONObject(properties));
            }
            catch (NullPointerException e) {
                Log.w((String)MixpanelAPI.LOGTAG, (String)"Can't have null keys in the properties of setMap!");
            }
        }

        @Override
        public void set(JSONObject properties) {
            try {
                JSONObject sendProperties = new JSONObject(MixpanelAPI.this.mDeviceInfo);
                Iterator iter = properties.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    sendProperties.put(key, properties.get(key));
                }
                JSONObject message = this.stdPeopleMessage("$set", sendProperties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception setting people properties", (Throwable)e);
            }
        }

        @Override
        public void set(String property, Object value) {
            try {
                this.set(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"set", (Throwable)e);
            }
        }

        @Override
        public void setOnceMap(Map<String, Object> properties) {
            if (null == properties) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"setOnceMap does not accept null properties");
                return;
            }
            try {
                this.setOnce(new JSONObject(properties));
            }
            catch (NullPointerException e) {
                Log.w((String)MixpanelAPI.LOGTAG, (String)"Can't have null keys in the properties setOnceMap!");
            }
        }

        @Override
        public void setOnce(JSONObject properties) {
            try {
                JSONObject message = this.stdPeopleMessage("$set_once", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception setting people properties");
            }
        }

        @Override
        public void setOnce(String property, Object value) {
            try {
                this.setOnce(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"set", (Throwable)e);
            }
        }

        @Override
        public void increment(Map<String, ? extends Number> properties) {
            JSONObject json = new JSONObject(properties);
            try {
                JSONObject message = this.stdPeopleMessage("$add", json);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception incrementing properties", (Throwable)e);
            }
        }

        @Override
        public void merge(String property, JSONObject updates) {
            JSONObject mergeMessage = new JSONObject();
            try {
                mergeMessage.put(property, (Object)updates);
                JSONObject message = this.stdPeopleMessage("$merge", mergeMessage);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception merging a property", (Throwable)e);
            }
        }

        @Override
        public void increment(String property, double value) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put(property, value);
            this.increment(map);
        }

        @Override
        public void append(String name, Object value) {
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, value);
                JSONObject message = this.stdPeopleMessage("$append", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception appending a property", (Throwable)e);
            }
        }

        @Override
        public void union(String name, JSONArray value) {
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, (Object)value);
                JSONObject message = this.stdPeopleMessage("$union", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception unioning a property");
            }
        }

        @Override
        public void unset(String name) {
            try {
                JSONArray names = new JSONArray();
                names.put((Object)name);
                JSONObject message = this.stdPeopleMessage("$unset", names);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception unsetting a property", (Throwable)e);
            }
        }

        @Override
        @Deprecated
        public void checkForSurvey(SurveyCallbacks callbacks) {
            Log.i((String)MixpanelAPI.LOGTAG, (String)"MixpanelAPI.checkForSurvey is deprecated. Calling is now a no-op.\n    to query surveys, call MixpanelAPI.getPeople().getSurveyIfAvailable()");
        }

        @Override
        @Deprecated
        public void checkForSurvey(SurveyCallbacks callbacks, Activity parentActivity) {
            Log.i((String)MixpanelAPI.LOGTAG, (String)"MixpanelAPI.checkForSurvey is deprecated. Calling is now a no-op.\n    to query surveys, call MixpanelAPI.getPeople().getSurveyIfAvailable()");
        }

        @Override
        public InAppNotification getNotificationIfAvailable() {
            return MixpanelAPI.this.mDecideMessages.getNotification(MixpanelAPI.this.mConfig.getTestMode());
        }

        @Override
        public void trackNotificationSeen(InAppNotification notif) {
            if (notif == null) {
                return;
            }
            this.trackNotification("$campaign_delivery", notif);
            People people = MixpanelAPI.this.getPeople().withIdentity(this.getDistinctId());
            SimpleDateFormat dateFormat = new SimpleDateFormat(MixpanelAPI.ENGAGE_DATE_FORMAT_STRING, Locale.US);
            JSONObject notifProperties = notif.getCampaignProperties();
            try {
                notifProperties.put("$time", (Object)dateFormat.format(new Date()));
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception trying to track an in-app notification seen", (Throwable)e);
            }
            people.append("$campaigns", notif.getId());
            people.append("$notifications", notifProperties);
        }

        @Override
        public Survey getSurveyIfAvailable() {
            return MixpanelAPI.this.mDecideMessages.getSurvey(MixpanelAPI.this.mConfig.getTestMode());
        }

        @Override
        @Deprecated
        public void showSurvey(Survey survey, Activity parent) {
            this.showGivenOrAvailableSurvey(survey, parent);
        }

        @Override
        public void showSurveyIfAvailable(Activity parent) {
            if (Build.VERSION.SDK_INT < 16) {
                return;
            }
            this.showGivenOrAvailableSurvey(null, parent);
        }

        @Override
        public void showSurveyById(int id2, Activity parent) {
            Survey s = MixpanelAPI.this.mDecideMessages.getSurvey(id2, MixpanelAPI.this.mConfig.getTestMode());
            if (s != null) {
                this.showGivenOrAvailableSurvey(s, parent);
            }
        }

        @Override
        public void showNotificationIfAvailable(Activity parent) {
            if (Build.VERSION.SDK_INT < 16) {
                return;
            }
            this.showGivenOrAvailableNotification(null, parent);
        }

        @Override
        public void showNotificationById(int id2, Activity parent) {
            InAppNotification notif = MixpanelAPI.this.mDecideMessages.getNotification(id2, MixpanelAPI.this.mConfig.getTestMode());
            this.showGivenNotification(notif, parent);
        }

        @Override
        public void showGivenNotification(InAppNotification notif, Activity parent) {
            if (notif != null) {
                this.showGivenOrAvailableNotification(notif, parent);
            }
        }

        @Override
        public void trackNotification(String eventName, InAppNotification notif) {
            MixpanelAPI.this.track(eventName, notif.getCampaignProperties());
        }

        @Override
        public void joinExperimentIfAvailable() {
            JSONArray variants = MixpanelAPI.this.mDecideMessages.getVariants();
            if (null != variants) {
                MixpanelAPI.this.mUpdatesFromMixpanel.setVariants(variants);
            }
        }

        @Override
        public void trackCharge(double amount, JSONObject properties) {
            Date now = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat(MixpanelAPI.ENGAGE_DATE_FORMAT_STRING, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                JSONObject transactionValue = new JSONObject();
                transactionValue.put("$amount", amount);
                transactionValue.put("$time", (Object)dateFormat.format(now));
                if (null != properties) {
                    Iterator iter = properties.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        transactionValue.put(key, properties.get(key));
                    }
                }
                this.append("$transactions", transactionValue);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception creating new charge", (Throwable)e);
            }
        }

        @Override
        public void clearCharges() {
            this.unset("$transactions");
        }

        @Override
        public void deleteUser() {
            try {
                JSONObject message = this.stdPeopleMessage("$delete", JSONObject.NULL);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception deleting a user");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPushRegistrationId(String registrationId) {
            PersistentIdentity persistentIdentity = MixpanelAPI.this.mPersistentIdentity;
            synchronized (persistentIdentity) {
                if (MixpanelAPI.this.mPersistentIdentity.getPeopleDistinctId() == null) {
                    return;
                }
                MixpanelAPI.this.mPersistentIdentity.storePushId(registrationId);
                JSONArray ids = new JSONArray();
                ids.put((Object)registrationId);
                this.union("$android_devices", ids);
            }
        }

        @Override
        public void clearPushRegistrationId() {
            MixpanelAPI.this.mPersistentIdentity.clearPushId();
            this.set("$android_devices", new JSONArray());
        }

        @Override
        public void initPushHandling(String senderID) {
            if (!ConfigurationChecker.checkPushConfiguration(MixpanelAPI.this.mContext)) {
                Log.i((String)MixpanelAPI.LOGTAG, (String)"Can't register for push notification services. Push notifications will not work.");
                Log.i((String)MixpanelAPI.LOGTAG, (String)("See log tagged " + ConfigurationChecker.LOGTAG + " above for details."));
            } else {
                final String pushId = MixpanelAPI.this.mPersistentIdentity.getPushId();
                if (pushId == null) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        this.registerForPushIdAPI21AndUp(senderID);
                    } else {
                        this.registerForPushIdAPI19AndOlder(senderID);
                    }
                } else {
                    MixpanelAPI.allInstances(new InstanceProcessor(){

                        @Override
                        public void process(MixpanelAPI api) {
                            if (MPConfig.DEBUG) {
                                Log.v((String)MixpanelAPI.LOGTAG, (String)("Using existing pushId " + pushId));
                            }
                            api.getPeople().setPushRegistrationId(pushId);
                        }
                    });
                }
            }
        }

        @Override
        public String getDistinctId() {
            return MixpanelAPI.this.mPersistentIdentity.getPeopleDistinctId();
        }

        @Override
        public People withIdentity(final String distinctId) {
            if (null == distinctId) {
                return null;
            }
            return new PeopleImpl(){

                @Override
                public String getDistinctId() {
                    return distinctId;
                }

                @Override
                public void identify(String distinctId2) {
                    throw new RuntimeException("This MixpanelPeople object has a fixed, constant distinctId");
                }
            };
        }

        @Override
        public void addOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener listener) {
            MixpanelAPI.this.mUpdatesListener.addOnMixpanelUpdatesReceivedListener(listener);
        }

        @Override
        public void removeOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener listener) {
            MixpanelAPI.this.mUpdatesListener.removeOnMixpanelUpdatesReceivedListener(listener);
        }

        private JSONObject stdPeopleMessage(String actionType, Object properties) throws JSONException {
            JSONObject dataObj = new JSONObject();
            String distinctId = this.getDistinctId();
            dataObj.put(actionType, properties);
            dataObj.put("$token", (Object)MixpanelAPI.this.mToken);
            dataObj.put("$time", System.currentTimeMillis());
            if (null != distinctId) {
                dataObj.put("$distinct_id", (Object)distinctId);
            }
            return dataObj;
        }

        @TargetApi(value=21)
        private void registerForPushIdAPI21AndUp(String senderID) {
            MixpanelAPI.this.mMessages.registerForGCM(senderID);
        }

        @TargetApi(value=19)
        private void registerForPushIdAPI19AndOlder(String senderID) {
            try {
                if (MPConfig.DEBUG) {
                    Log.v((String)MixpanelAPI.LOGTAG, (String)"Registering a new push id");
                }
                Intent registrationIntent = new Intent("com.google.android.c2dm.intent.REGISTER");
                registrationIntent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)MixpanelAPI.this.mContext, (int)0, (Intent)new Intent(), (int)0));
                registrationIntent.putExtra("sender", senderID);
                MixpanelAPI.this.mContext.startService(registrationIntent);
            }
            catch (SecurityException e) {
                Log.w((String)MixpanelAPI.LOGTAG, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void showGivenOrAvailableSurvey(Survey surveyOrNull, final Activity parent) {
            if (Build.VERSION.SDK_INT < 16) {
                if (MPConfig.DEBUG) {
                    Log.v((String)MixpanelAPI.LOGTAG, (String)"Will not show survey, os version is too low.");
                }
                return;
            }
            if (!ConfigurationChecker.checkSurveyActivityAvailable(parent.getApplicationContext())) {
                if (MPConfig.DEBUG) {
                    Log.v((String)MixpanelAPI.LOGTAG, (String)"Will not show survey, application isn't configured appropriately.");
                }
                return;
            }
            BackgroundCapture.OnBackgroundCapturedListener listener = null;
            ReentrantLock lock = UpdateDisplayState.getLockObject();
            lock.lock();
            try {
                if (UpdateDisplayState.hasCurrentProposal()) {
                    return;
                }
                Survey toShow = surveyOrNull;
                if (null == toShow) {
                    toShow = this.getSurveyIfAvailable();
                }
                if (null == toShow) {
                    return;
                }
                final UpdateDisplayState.DisplayState.SurveyState surveyDisplay = new UpdateDisplayState.DisplayState.SurveyState(toShow);
                final int intentId = UpdateDisplayState.proposeDisplay(surveyDisplay, this.getDistinctId(), MixpanelAPI.this.mToken);
                if (intentId <= 0) {
                    Log.e((String)MixpanelAPI.LOGTAG, (String)"DisplayState Lock is in an inconsistent state! Please report this issue to Mixpanel");
                    return;
                }
                listener = new BackgroundCapture.OnBackgroundCapturedListener(){

                    @Override
                    public void onBackgroundCaptured(Bitmap bitmapCaptured, int highlightColorCaptured) {
                        surveyDisplay.setBackground(bitmapCaptured);
                        surveyDisplay.setHighlightColor(highlightColorCaptured);
                        Intent surveyIntent = new Intent(parent.getApplicationContext(), SurveyActivity.class);
                        surveyIntent.addFlags(0x10000000);
                        surveyIntent.addFlags(131072);
                        surveyIntent.putExtra("com.mixpanel.android.surveys.SurveyActivity.INTENT_ID_KEY", intentId);
                        parent.startActivity(surveyIntent);
                    }
                };
            }
            finally {
                lock.unlock();
            }
            BackgroundCapture.captureBackground(parent, listener);
        }

        private void showGivenOrAvailableNotification(final InAppNotification notifOrNull, final Activity parent) {
            if (Build.VERSION.SDK_INT < 16) {
                if (MPConfig.DEBUG) {
                    Log.v((String)MixpanelAPI.LOGTAG, (String)"Will not show notifications, os version is too low.");
                }
                return;
            }
            parent.runOnUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @TargetApi(value=16)
                public void run() {
                    ReentrantLock lock = UpdateDisplayState.getLockObject();
                    lock.lock();
                    try {
                        if (UpdateDisplayState.hasCurrentProposal()) {
                            if (MPConfig.DEBUG) {
                                Log.v((String)MixpanelAPI.LOGTAG, (String)"DisplayState is locked, will not show notifications.");
                            }
                            return;
                        }
                        InAppNotification toShow = notifOrNull;
                        if (null == toShow) {
                            toShow = PeopleImpl.this.getNotificationIfAvailable();
                        }
                        if (null == toShow) {
                            if (MPConfig.DEBUG) {
                                Log.v((String)MixpanelAPI.LOGTAG, (String)"No notification available, will not show.");
                            }
                            return;
                        }
                        InAppNotification.Type inAppType = toShow.getType();
                        if (inAppType == InAppNotification.Type.TAKEOVER && !ConfigurationChecker.checkSurveyActivityAvailable(parent.getApplicationContext())) {
                            if (MPConfig.DEBUG) {
                                Log.v((String)MixpanelAPI.LOGTAG, (String)"Application is not configured to show takeover notifications, none will be shown.");
                            }
                            return;
                        }
                        int highlightColor = ActivityImageUtils.getHighlightColorFromBackground(parent);
                        UpdateDisplayState.DisplayState.InAppNotificationState proposal = new UpdateDisplayState.DisplayState.InAppNotificationState(toShow, highlightColor);
                        int intentId = UpdateDisplayState.proposeDisplay(proposal, PeopleImpl.this.getDistinctId(), MixpanelAPI.this.mToken);
                        if (intentId <= 0) {
                            Log.e((String)MixpanelAPI.LOGTAG, (String)"DisplayState Lock in inconsistent state! Please report this issue to Mixpanel");
                            return;
                        }
                        switch (inAppType) {
                            case MINI: {
                                UpdateDisplayState claimed = UpdateDisplayState.claimDisplayState(intentId);
                                if (null == claimed) {
                                    if (MPConfig.DEBUG) {
                                        Log.v((String)MixpanelAPI.LOGTAG, (String)"Notification's display proposal was already consumed, no notification will be shown.");
                                    }
                                    return;
                                }
                                InAppFragment inapp = new InAppFragment();
                                inapp.setDisplayState(MixpanelAPI.this, intentId, (UpdateDisplayState.DisplayState.InAppNotificationState)claimed.getDisplayState());
                                inapp.setRetainInstance(true);
                                if (MPConfig.DEBUG) {
                                    Log.v((String)MixpanelAPI.LOGTAG, (String)"Attempting to show mini notification.");
                                }
                                FragmentTransaction transaction = parent.getFragmentManager().beginTransaction();
                                transaction.setCustomAnimations(0, R.anim.com_mixpanel_android_slide_down);
                                transaction.add(0x1020002, (Fragment)inapp);
                                transaction.commit();
                                break;
                            }
                            case TAKEOVER: {
                                if (MPConfig.DEBUG) {
                                    Log.v((String)MixpanelAPI.LOGTAG, (String)"Sending intent for takeover notification.");
                                }
                                Intent intent = new Intent(parent.getApplicationContext(), SurveyActivity.class);
                                intent.addFlags(0x10000000);
                                intent.addFlags(131072);
                                intent.putExtra("com.mixpanel.android.surveys.SurveyActivity.INTENT_ID_KEY", intentId);
                                parent.startActivity(intent);
                                break;
                            }
                            default: {
                                Log.e((String)MixpanelAPI.LOGTAG, (String)("Unrecognized notification type " + (Object)((Object)inAppType) + " can't be shown"));
                            }
                        }
                        if (!MixpanelAPI.this.mConfig.getTestMode()) {
                            PeopleImpl.this.trackNotificationSeen(toShow);
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
            });
        }
    }

    static interface InstanceProcessor {
        public void process(MixpanelAPI var1);
    }

    public static interface People {
        public void identify(String var1);

        public void set(String var1, Object var2);

        public void setMap(Map<String, Object> var1);

        public void set(JSONObject var1);

        public void setOnce(String var1, Object var2);

        public void setOnceMap(Map<String, Object> var1);

        public void setOnce(JSONObject var1);

        public void increment(String var1, double var2);

        public void merge(String var1, JSONObject var2);

        public void increment(Map<String, ? extends Number> var1);

        public void append(String var1, Object var2);

        public void union(String var1, JSONArray var2);

        public void unset(String var1);

        public void trackCharge(double var1, JSONObject var3);

        public void clearCharges();

        public void deleteUser();

        public void initPushHandling(String var1);

        public void setPushRegistrationId(String var1);

        public void clearPushRegistrationId();

        public String getDistinctId();

        public void showSurveyIfAvailable(Activity var1);

        public void showNotificationIfAvailable(Activity var1);

        public void joinExperimentIfAvailable();

        public void showGivenNotification(InAppNotification var1, Activity var2);

        public void trackNotification(String var1, InAppNotification var2);

        public Survey getSurveyIfAvailable();

        public InAppNotification getNotificationIfAvailable();

        public void trackNotificationSeen(InAppNotification var1);

        public void showSurveyById(int var1, Activity var2);

        public void showNotificationById(int var1, Activity var2);

        public People withIdentity(String var1);

        public void addOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener var1);

        public void removeOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener var1);

        @Deprecated
        public void showSurvey(Survey var1, Activity var2);

        @Deprecated
        public void checkForSurvey(SurveyCallbacks var1);

        @Deprecated
        public void checkForSurvey(SurveyCallbacks var1, Activity var2);
    }
}

