/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.R;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.util.Log;
import android.util.SparseArray;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.viewcrawler.Caller;
import com.mixpanel.android.viewcrawler.PropertyDescription;
import com.mixpanel.android.viewcrawler.ViewSnapshot;
import com.mixpanel.android.viewcrawler.ViewVisitor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EditProtocol {
    private final Map<String, Integer> mIdNameToId = new HashMap<String, Integer>();
    private final SparseArray<String> mIdToIdName = new SparseArray();
    private static final Class[] NO_PARAMS = new Class[0];
    private static final List<ViewVisitor.PathElement> NEVER_MATCH_PATH = Collections.EMPTY_LIST;
    private static final String LOGTAG = "MixpanelAPI.EditProtocol";

    public EditProtocol(Context context) {
        this.buildIdMap(context);
    }

    public ViewVisitor readEventBinding(JSONObject source, ViewVisitor.OnVisitedListener listener) throws BadInstructionsException {
        try {
            JSONArray pathDesc = source.getJSONArray("path");
            List<ViewVisitor.PathElement> path = this.readPath(pathDesc, this.mIdNameToId);
            if (path.size() == 0) {
                throw new BadInstructionsException("Path selector was empty.");
            }
            String eventName = source.getString("event_name");
            String eventType = source.getString("event_type");
            if ("click".equals(eventType)) {
                return new ViewVisitor.AddListenerVisitor(path, eventName, listener);
            }
            if ("detected".equals(eventType)) {
                return new ViewVisitor.ViewDetectorVisitor(path, eventName, listener);
            }
            throw new BadInstructionsException("Mixpanel can't track event type \"" + eventType + "\"");
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't interpret instructions due to JSONException", (Exception)((Object)e));
        }
    }

    public ViewVisitor readEdit(JSONObject source) throws BadInstructionsException {
        try {
            Class<?> targetClass;
            JSONArray pathDesc = source.getJSONArray("path");
            List<ViewVisitor.PathElement> path = this.readPath(pathDesc, this.mIdNameToId);
            if (path.size() == 0) {
                throw new BadInstructionsException("Path selector was empty.");
            }
            ViewVisitor.PathElement pathEnd = path.get(path.size() - 1);
            String targetClassName = pathEnd.viewClassName;
            try {
                targetClass = Class.forName(targetClassName);
            }
            catch (ClassNotFoundException e) {
                throw new BadInstructionsException("Can't find class for visit path: " + targetClassName, e);
            }
            PropertyDescription prop = this.readPropertyDescription(targetClass, source.getJSONObject("property"));
            JSONArray argsAndTypes = source.getJSONArray("args");
            Object[] methodArgs = new Object[argsAndTypes.length()];
            for (int i = 0; i < argsAndTypes.length(); ++i) {
                JSONArray argPlusType = argsAndTypes.getJSONArray(i);
                Object jsonArg = argPlusType.get(0);
                String argType = argPlusType.getString(1);
                methodArgs[i] = this.convertArgument(jsonArg, argType);
            }
            Caller mutator = prop.makeMutator(methodArgs);
            if (null == mutator) {
                throw new BadInstructionsException("Can't update a read-only property " + prop.name + " (add a mutator to make this work)");
            }
            return new ViewVisitor.PropertySetVisitor(path, mutator, prop.accessor);
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't interpret instructions due to JSONException", (Exception)((Object)e));
        }
    }

    public ViewSnapshot readSnapshotConfig(JSONObject source) throws BadInstructionsException {
        ArrayList<PropertyDescription> properties = new ArrayList<PropertyDescription>();
        try {
            JSONObject config = source.getJSONObject("config");
            JSONArray classes = config.getJSONArray("classes");
            for (int classIx = 0; classIx < classes.length(); ++classIx) {
                JSONObject classDesc = classes.getJSONObject(classIx);
                String targetClassName = classDesc.getString("name");
                Class<?> targetClass = Class.forName(targetClassName);
                JSONArray propertyDescs = classDesc.getJSONArray("properties");
                for (int i = 0; i < propertyDescs.length(); ++i) {
                    JSONObject propertyDesc = propertyDescs.getJSONObject(i);
                    PropertyDescription desc = this.readPropertyDescription(targetClass, propertyDesc);
                    properties.add(desc);
                }
            }
            return new ViewSnapshot(properties, this.mIdToIdName);
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't read snapshot configuration", (Exception)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new BadInstructionsException("Can't resolve types for snapshot configuration", e);
        }
    }

    List<ViewVisitor.PathElement> readPath(JSONArray pathDesc, Map<String, Integer> idNameToId) throws JSONException {
        ArrayList<ViewVisitor.PathElement> path = new ArrayList<ViewVisitor.PathElement>();
        for (int i = 0; i < pathDesc.length(); ++i) {
            int targetId;
            JSONObject targetView = pathDesc.getJSONObject(i);
            String targetViewClass = targetView.optString("view_class", null);
            int targetIndex = targetView.optInt("index", -1);
            String targetTag = targetView.optString("tag", null);
            int targetExplicitId = targetView.optInt("id", -1);
            String targetIdName = targetView.optString("mp_id_name", null);
            try {
                targetId = this.reconcileIdsInPath(targetExplicitId, targetIdName, idNameToId);
            }
            catch (ImpossibleToMatchException e) {
                return NEVER_MATCH_PATH;
            }
            path.add(new ViewVisitor.PathElement(targetViewClass, targetIndex, targetId, targetTag));
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int reconcileIdsInPath(int explicitId, String idName, Map<String, Integer> idNameToId) throws ImpossibleToMatchException {
        int idFromName;
        if (null != idName) {
            if (!idNameToId.containsKey(idName)) {
                Log.e((String)LOGTAG, (String)("Path element contains an id name not known to the system. No views will be matched.\nMake sure that you're not stripping your packages R class out with proguard.\nid name was \"" + idName + "\""));
                throw new ImpossibleToMatchException();
            }
            idFromName = idNameToId.get(idName);
        } else {
            idFromName = -1;
        }
        if (-1 != idFromName && -1 != explicitId && idFromName != explicitId) {
            Log.e((String)LOGTAG, (String)"Path contains both a named and an explicit id, and they don't match. No views will be matched.");
            throw new ImpossibleToMatchException();
        }
        if (-1 != idFromName) {
            return idFromName;
        }
        return explicitId;
    }

    private void buildIdMap(Context context) {
        String namespacedName;
        int value;
        String name;
        Class<?> fieldType;
        int modifiers;
        Field field;
        int i;
        Field[] fields;
        MPConfig config = MPConfig.getInstance(context.getApplicationContext());
        this.mIdNameToId.clear();
        this.mIdToIdName.clear();
        try {
            Class<R.id> platformIdClass = R.id.class;
            fields = platformIdClass.getFields();
            for (i = 0; i < fields.length; ++i) {
                field = fields[i];
                modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || (fieldType = field.getType()) != Integer.TYPE) continue;
                name = field.getName();
                value = field.getInt(null);
                namespacedName = "android:" + name;
                this.mIdNameToId.put(namespacedName, value);
                this.mIdToIdName.put(value, (Object)namespacedName);
            }
        }
        catch (IllegalAccessException e) {
            Log.e((String)LOGTAG, (String)"Can't read built-in id names from platform library", (Throwable)e);
        }
        try {
            Class<?> internalPlatformIdClass = Class.forName("com.android.internal.R$id");
            fields = internalPlatformIdClass.getFields();
            for (i = 0; i < fields.length; ++i) {
                field = fields[i];
                modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || (fieldType = field.getType()) != Integer.TYPE) continue;
                name = field.getName();
                value = field.getInt(null);
                namespacedName = "android:internal:" + name;
                this.mIdNameToId.put(namespacedName, value);
                this.mIdToIdName.put(value, (Object)namespacedName);
            }
        }
        catch (ClassNotFoundException e) {
            if (MPConfig.DEBUG) {
                throw new RuntimeException("Android internal class not available or accessible", e);
            }
        }
        catch (IllegalAccessException e) {
            Log.e((String)LOGTAG, (String)"Can't read platform id class names from library", (Throwable)e);
        }
        String resourcePackage = config.getResourcePackageName();
        if (null == resourcePackage) {
            resourcePackage = context.getPackageName();
        }
        String rIdClassName = resourcePackage + ".R$id";
        try {
            Class<?> rIdClass = Class.forName(rIdClassName);
            Field[] fields2 = rIdClass.getFields();
            for (int i2 = 0; i2 < fields2.length; ++i2) {
                Class<?> fieldType2;
                Field field2 = fields2[i2];
                int modifiers2 = field2.getModifiers();
                if (!Modifier.isStatic(modifiers2) || (fieldType2 = field2.getType()) != Integer.TYPE) continue;
                String name2 = field2.getName();
                int value2 = field2.getInt(null);
                this.mIdNameToId.put(name2, value2);
                this.mIdToIdName.put(value2, (Object)name2);
            }
        }
        catch (ClassNotFoundException e) {
            Log.w((String)LOGTAG, (String)("Can't load names for Android view ids from class " + rIdClassName + ", ids by name will not be available in the events editor."));
            Log.i((String)LOGTAG, (String)"You may be missing a Resources class for your package due to your proguard configuration, or you may be using an applicationId in your build that isn't the same as the package declared in your AndroidManifest.xml file.\nIf you're using proguard, you can fix this issue by adding the following to your proguard configuration:\n\n-keep class **.R$* {\n    <fields>;\n}\n\nIf you're not using proguard, or if your proguard configuration already contains the directive above, you can add the following to your AndroidManifest.xml file to explicity point the Mixpanel library to the appropriate library for your resources class:\n\n<meta-data android:name=\"com.mixpanel.android.MPConfig.ResourcePackageName\" android:value=\"YOUR_PACKAGE_NAME\" />\n\nwhere YOUR_PACKAGE_NAME is the same string you use for the \"package\" attribute in your <manifest> tag.");
        }
        catch (IllegalAccessException e) {
            Log.e((String)LOGTAG, (String)"Can't read id names for local resources");
        }
    }

    private PropertyDescription readPropertyDescription(Class targetClass, JSONObject propertyDesc) throws BadInstructionsException {
        try {
            String mutatorName;
            String propName = propertyDesc.getString("name");
            Caller accessor = null;
            if (propertyDesc.has("get")) {
                JSONObject accessorConfig = propertyDesc.getJSONObject("get");
                String accessorName = accessorConfig.getString("selector");
                String accessorResultTypeName = accessorConfig.getJSONObject("result").getString("type");
                Class<?> accessorResultType = Class.forName(accessorResultTypeName);
                accessor = new Caller(accessorName, NO_PARAMS, accessorResultType);
            }
            if (propertyDesc.has("set")) {
                JSONObject mutatorConfig = propertyDesc.getJSONObject("set");
                mutatorName = mutatorConfig.getString("selector");
            } else {
                mutatorName = null;
            }
            return new PropertyDescription(propName, targetClass, accessor, mutatorName);
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't read property JSON", (Exception)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new BadInstructionsException("Can't read property JSON, relevant arg/return class not found", e);
        }
    }

    private Object convertArgument(Object jsonArgument, String type) throws BadInstructionsException {
        try {
            if ("java.lang.CharSequence".equals(type)) {
                return (String)jsonArgument;
            }
            if ("boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                return (Boolean)jsonArgument;
            }
            if ("int".equals(type) || "java.lang.Integer".equals(type)) {
                return ((Number)jsonArgument).intValue();
            }
            if ("float".equals(type) || "java.lang.Float".equals(type)) {
                return Float.valueOf(((Number)jsonArgument).floatValue());
            }
            if ("android.graphics.Bitmap".equals(type)) {
                byte[] bytes = Base64.decode((String)((String)jsonArgument), (int)0);
                return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
            }
            throw new BadInstructionsException("Don't know how to interpret type " + type + " (arg was " + jsonArgument + ")");
        }
        catch (ClassCastException e) {
            throw new BadInstructionsException("Couldn't interpret <" + jsonArgument + "> as " + type);
        }
    }

    private static class ImpossibleToMatchException
    extends Exception {
        private ImpossibleToMatchException() {
        }
    }

    public static class BadInstructionsException
    extends Exception {
        public BadInstructionsException(String message) {
            super(message);
        }

        public BadInstructionsException(String message, Exception e) {
            super(message, e);
        }
    }
}

