/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.surveys;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.widget.ImageView;

public class FadingImageView
extends ImageView {
    private Paint mGradientPaint;
    private Matrix mGradientMatrix;
    private Shader mGradientShader;

    public FadingImageView(Context context) {
        super(context);
        this.initFadingImageView();
    }

    public FadingImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initFadingImageView();
    }

    public FadingImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initFadingImageView();
    }

    protected void onDraw(Canvas canvas) {
        Rect clip = canvas.getClipBounds();
        int restoreTo = canvas.saveLayer(0.0f, 0.0f, (float)clip.width(), (float)clip.height(), null, 31);
        super.onDraw(canvas);
        int height = this.getHeight();
        int width = this.getWidth();
        this.mGradientMatrix.setScale(1.0f, (float)height);
        this.mGradientShader.setLocalMatrix(this.mGradientMatrix);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, this.mGradientPaint);
        canvas.restoreToCount(restoreTo);
    }

    private void initFadingImageView() {
        this.mGradientPaint = new Paint();
        this.mGradientMatrix = new Matrix();
        this.mGradientShader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, new int[]{-16777216, -16777216, -452984832, 0}, new float[]{0.0f, 0.7f, 0.8f, 1.0f}, Shader.TileMode.CLAMP);
        this.mGradientPaint.setShader(this.mGradientShader);
        this.mGradientPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
    }
}

