/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Survey {
    private final JSONObject mDescription;
    private final int mId;
    private final int mCollectionId;
    private final List<Question> mQuestions;

    Survey(JSONObject description) throws BadSurveyException {
        try {
            this.mDescription = description;
            this.mId = description.getInt("id");
            JSONArray collectionsJArray = description.getJSONArray("collections");
            JSONObject collection0 = collectionsJArray.getJSONObject(0);
            this.mCollectionId = collection0.getInt("id");
            JSONArray questionsJArray = description.getJSONArray("questions");
            if (questionsJArray.length() == 0) {
                throw new BadSurveyException("Survey has no questions.");
            }
            ArrayList<Question> questionsList = new ArrayList<Question>(questionsJArray.length());
            for (int i = 0; i < questionsJArray.length(); ++i) {
                JSONObject q = questionsJArray.getJSONObject(i);
                questionsList.add(new Question(q));
            }
            this.mQuestions = Collections.unmodifiableList(questionsList);
        }
        catch (JSONException e) {
            throw new BadSurveyException("Survey JSON was unexpected or bad", e);
        }
    }

    String toJSON() {
        return this.mDescription.toString();
    }

    public int getId() {
        return this.mId;
    }

    public int getCollectionId() {
        return this.mCollectionId;
    }

    public List<Question> getQuestions() {
        return this.mQuestions;
    }

    public class Question {
        private final int mQuestionId;
        private final String mQuestionType;
        private final String mPrompt;
        private final List<String> mChoices;

        private Question(JSONObject question) throws JSONException, BadSurveyException {
            JSONObject extraData;
            this.mQuestionId = question.getInt("id");
            this.mQuestionType = question.getString("type").intern();
            this.mPrompt = question.getString("prompt");
            List choicesList = Collections.emptyList();
            if (question.has("extra_data") && (extraData = question.getJSONObject("extra_data")).has("$choices")) {
                JSONArray choices = extraData.getJSONArray("$choices");
                choicesList = new ArrayList(choices.length());
                for (int i = 0; i < choices.length(); ++i) {
                    choicesList.add(choices.getString(i));
                }
            }
            this.mChoices = Collections.unmodifiableList(choicesList);
            if (this.getType() == QuestionType.MULTIPLE_CHOICE && this.mChoices.size() == 0) {
                throw new BadSurveyException("Question is multiple choice but has no answers:" + question.toString());
            }
        }

        public int getId() {
            return this.mQuestionId;
        }

        public String getPrompt() {
            return this.mPrompt;
        }

        public List<String> getChoices() {
            return this.mChoices;
        }

        public QuestionType getType() {
            if (QuestionType.MULTIPLE_CHOICE.toString().equals(this.mQuestionType)) {
                return QuestionType.MULTIPLE_CHOICE;
            }
            if (QuestionType.TEXT.toString().equals(this.mQuestionType)) {
                return QuestionType.TEXT;
            }
            return QuestionType.UNKNOWN;
        }
    }

    public static enum QuestionType {
        UNKNOWN,
        MULTIPLE_CHOICE,
        TEXT;


        public String toString() {
            if (MULTIPLE_CHOICE == this) {
                return "multiple_choice";
            }
            if (TEXT == this) {
                return "text";
            }
            return "*unknown_type*";
        }
    }

    static class BadSurveyException
    extends Exception {
        private static final long serialVersionUID = 4858739193395706341L;

        public BadSurveyException(String detailMessage) {
            super(detailMessage);
        }

        public BadSurveyException(String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
        }
    }
}

