/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;
import com.mixpanel.android.mpmetrics.AnalyticsMessages;
import com.mixpanel.android.mpmetrics.BackgroundCapture;
import com.mixpanel.android.mpmetrics.ConfigurationChecker;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelActivityLifecycleCallbacks;
import com.mixpanel.android.mpmetrics.PersistentProperties;
import com.mixpanel.android.mpmetrics.SharedPreferencesLoader;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.mpmetrics.SurveyCallbacks;
import com.mixpanel.android.mpmetrics.SurveyState;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelAPI {
    public static final String VERSION = "4.0.1";
    private static final String LOGTAG = "MixpanelAPI";
    private static final String ENGAGE_DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";
    private final Context mContext;
    private final AnalyticsMessages mMessages;
    private final String mToken;
    private final PeopleImpl mPeople;
    private final PersistentProperties mPersistentProperties;
    private final Object mCachedSurveyAssetsLock = new Object();
    private int mCachedSurveyActivityHashcode = -1;
    private Bitmap mCachedSurveyBitmap;
    private int mCachedSurveyHighlightColor;
    private final ExpiringLock checkForSurveysLock = new ExpiringLock(10000L);
    private static final Map<String, Map<Context, MixpanelAPI>> sInstanceMap = new HashMap<String, Map<Context, MixpanelAPI>>();
    private static final SharedPreferencesLoader sPrefsLoader = new SharedPreferencesLoader();
    private static Future<SharedPreferences> sReferrerPrefs;

    MixpanelAPI(Context context, Future<SharedPreferences> referrerPreferences, String token) {
        this.mContext = context;
        this.mToken = token;
        this.mPeople = new PeopleImpl();
        this.mMessages = this.getAnalyticsMessages();
        SharedPreferencesLoader.OnPrefsLoadedListener listener = new SharedPreferencesLoader.OnPrefsLoadedListener(){

            @Override
            public void onPrefsLoaded(SharedPreferences preferences) {
                JSONArray records = PersistentProperties.waitingPeopleRecordsForSending(preferences);
                if (null != records) {
                    MixpanelAPI.this.sendAllPeopleRecords(records);
                }
            }
        };
        Future<SharedPreferences> storedPreferences = sPrefsLoader.loadPreferences(context, "com.mixpanel.android.mpmetrics.MixpanelAPI_" + token, listener);
        this.mPersistentProperties = new PersistentProperties(referrerPreferences, storedPreferences);
        this.registerMixpanelActivityLifecycleCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MixpanelAPI getInstance(Context context, String token) {
        if (null == token || null == context) {
            return null;
        }
        Map<String, Map<Context, MixpanelAPI>> map = sInstanceMap;
        synchronized (map) {
            MixpanelAPI instance;
            Map<Context, MixpanelAPI> instances;
            Context appContext = context.getApplicationContext();
            if (null == sReferrerPrefs) {
                sReferrerPrefs = sPrefsLoader.loadPreferences(context, "com.mixpanel.android.mpmetrics.ReferralInfo", null);
            }
            if (null == (instances = sInstanceMap.get(token))) {
                instances = new HashMap<Context, MixpanelAPI>();
                sInstanceMap.put(token, instances);
            }
            if (null == (instance = instances.get(appContext))) {
                instance = new MixpanelAPI(appContext, sReferrerPrefs, token);
                instances.put(appContext, instance);
            }
            return instance;
        }
    }

    @Deprecated
    public static void setFlushInterval(Context context, long milliseconds) {
        Log.i((String)LOGTAG, (String)"MixpanelAPI.setFlushInterval is deprecated.\n    To set a custom Mixpanel flush interval for your application, add\n    <meta-data android:name=\"com.mixpanel.android.MPConfig.FlushInterval\" android:value=\"YOUR_INTERVAL\" />\n    to the <application> section of your AndroidManifest.xml.");
        AnalyticsMessages msgs = AnalyticsMessages.getInstance(context);
        msgs.setFlushInterval(milliseconds);
    }

    @Deprecated
    public static void enableFallbackServer(Context context, boolean enableIfTrue) {
        Log.i((String)LOGTAG, (String)"MixpanelAPI.enableFallbackServer is deprecated.\n    To disable fallback in your application, add\n    <meta-data android:name=\"com.mixpanel.android.MPConfig.DisableFallback\" android:value=\"true\" />\n    to the <application> section of your AndroidManifest.xml.");
        AnalyticsMessages msgs = AnalyticsMessages.getInstance(context);
        msgs.setDisableFallback(!enableIfTrue);
    }

    public void identify(String distinctId) {
        this.mPersistentProperties.setEventsDistinctId(distinctId);
    }

    public void track(String eventName, JSONObject properties) {
        try {
            String key;
            JSONObject messageProps = new JSONObject();
            Map<String, String> referrerProperties = this.mPersistentProperties.getReferrerProperties();
            for (Map.Entry<String, String> entry : referrerProperties.entrySet()) {
                key = entry.getKey();
                String value = entry.getValue();
                messageProps.put(key, (Object)value);
            }
            JSONObject superProperties = this.mPersistentProperties.getSuperProperties();
            Iterator superIter = superProperties.keys();
            while (superIter.hasNext()) {
                key = (String)superIter.next();
                messageProps.put(key, superProperties.get(key));
            }
            long time = System.currentTimeMillis() / 1000L;
            messageProps.put("time", time);
            messageProps.put("distinct_id", (Object)this.getDistinctId());
            if (null != properties) {
                Iterator propIter = properties.keys();
                while (propIter.hasNext()) {
                    String key2 = (String)propIter.next();
                    messageProps.put(key2, properties.get(key2));
                }
            }
            AnalyticsMessages.EventDescription eventDTO = new AnalyticsMessages.EventDescription(eventName, messageProps, this.mToken);
            this.mMessages.eventsMessage(eventDTO);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)("Exception tracking event " + eventName), (Throwable)e);
        }
    }

    public void flush() {
        this.mMessages.postToServer();
    }

    public String getDistinctId() {
        return this.mPersistentProperties.getEventsDistinctId();
    }

    public void registerSuperProperties(JSONObject superProperties) {
        this.mPersistentProperties.registerSuperProperties(superProperties);
    }

    public void unregisterSuperProperty(String superPropertyName) {
        this.mPersistentProperties.unregisterSuperProperty(superPropertyName);
    }

    public void registerSuperPropertiesOnce(JSONObject superProperties) {
        this.mPersistentProperties.registerSuperPropertiesOnce(superProperties);
    }

    public void clearSuperProperties() {
        this.mPersistentProperties.clearSuperProperties();
    }

    public People getPeople() {
        return this.mPeople;
    }

    public void logPosts() {
        this.mMessages.logPosts();
    }

    @TargetApi(value=14)
    void registerMixpanelActivityLifecycleCallbacks() {
        if (Build.VERSION.SDK_INT >= 14 && MPConfig.readConfig(this.mContext).getAutoCheckForSurveys() && this.mContext.getApplicationContext() instanceof Application) {
            Application app = (Application)this.mContext.getApplicationContext();
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new MixpanelActivityLifecycleCallbacks(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void allInstances(InstanceProcessor processor) {
        Map<String, Map<Context, MixpanelAPI>> map = sInstanceMap;
        synchronized (map) {
            for (Map<Context, MixpanelAPI> contextInstances : sInstanceMap.values()) {
                for (MixpanelAPI instance : contextInstances.values()) {
                    processor.process(instance);
                }
            }
        }
    }

    AnalyticsMessages getAnalyticsMessages() {
        return AnalyticsMessages.getInstance(this.mContext);
    }

    void clearPreferences() {
        this.mPersistentProperties.clearPreferences();
    }

    private void recordPeopleMessage(JSONObject message) {
        if (message.has("$distinct_id")) {
            this.mMessages.peopleMessage(message);
        } else {
            this.mPersistentProperties.storeWaitingPeopleRecord(message);
        }
    }

    private void pushWaitingPeopleRecord() {
        JSONArray records = this.mPersistentProperties.waitingPeopleRecordsForSending();
        if (null != records) {
            this.sendAllPeopleRecords(records);
        }
    }

    private void sendAllPeopleRecords(JSONArray records) {
        for (int i = 0; i < records.length(); ++i) {
            try {
                JSONObject message = records.getJSONObject(i);
                this.mMessages.peopleMessage(message);
                continue;
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)"Malformed people record stored pending identity, will not send it.", (Throwable)e);
            }
        }
    }

    private static class ExpiringLock {
        private final ReentrantLock reentrantLock = new ReentrantLock();
        private boolean locked;
        private long time;
        private final long timeoutMillis;

        private ExpiringLock(long timeoutInMillis) {
            this.timeoutMillis = timeoutInMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquire() {
            if (this.reentrantLock.tryLock()) {
                try {
                    if (this.time > 0L && System.currentTimeMillis() - this.time > this.timeoutMillis) {
                        this.release();
                    }
                    if (!this.locked) {
                        this.time = System.currentTimeMillis();
                        this.locked = true;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.reentrantLock.unlock();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.reentrantLock.tryLock()) {
                try {
                    this.locked = false;
                    this.time = 0L;
                }
                finally {
                    this.reentrantLock.unlock();
                }
            }
        }
    }

    private class PeopleImpl
    implements People {
        private PeopleImpl() {
        }

        @Override
        public void identify(String distinctId) {
            MixpanelAPI.this.mPersistentProperties.setPeopleDistinctId(distinctId);
            MixpanelAPI.this.pushWaitingPeopleRecord();
        }

        @Override
        public void set(JSONObject properties) {
            try {
                JSONObject message = this.stdPeopleMessage("$set", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception setting people properties", (Throwable)e);
            }
        }

        @Override
        public void set(String property, Object value) {
            try {
                this.set(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"set", (Throwable)e);
            }
        }

        @Override
        public void setOnce(JSONObject properties) {
            try {
                JSONObject message = this.stdPeopleMessage("$set_once", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception setting people properties");
            }
        }

        @Override
        public void setOnce(String property, Object value) {
            try {
                this.setOnce(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"set", (Throwable)e);
            }
        }

        @Override
        public void increment(Map<String, ? extends Number> properties) {
            JSONObject json = new JSONObject(properties);
            try {
                JSONObject message = this.stdPeopleMessage("$add", json);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception incrementing properties", (Throwable)e);
            }
        }

        @Override
        public void increment(String property, double value) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put(property, value);
            this.increment(map);
        }

        @Override
        public void append(String name, Object value) {
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, value);
                JSONObject message = this.stdPeopleMessage("$append", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception appending a property", (Throwable)e);
            }
        }

        @Override
        public void union(String name, JSONArray value) {
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, (Object)value);
                JSONObject message = this.stdPeopleMessage("$union", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception unioning a property");
            }
        }

        @Override
        public void unset(String name) {
            try {
                JSONArray names = new JSONArray();
                names.put((Object)name);
                JSONObject message = this.stdPeopleMessage("$unset", names);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception unsetting a property", (Throwable)e);
            }
        }

        @Override
        public void checkForSurvey(final SurveyCallbacks callbacks) {
            if (MixpanelAPI.this.checkForSurveysLock.acquire()) {
                String checkToken = MixpanelAPI.this.mToken;
                String checkDistinctId = this.getDistinctId();
                SurveyCallbacks callbackWrapper = new SurveyCallbacks(){

                    @Override
                    public void foundSurvey(Survey s) {
                        callbacks.foundSurvey(s);
                        MixpanelAPI.this.checkForSurveysLock.release();
                    }
                };
                if (null == callbacks) {
                    Log.i((String)MixpanelAPI.LOGTAG, (String)"Skipping survey check, because callback is null.");
                    return;
                }
                if (null == checkDistinctId) {
                    Log.i((String)MixpanelAPI.LOGTAG, (String)"Skipping survey check, because user has not yet been identified.");
                    return;
                }
                if (Build.VERSION.SDK_INT < 10) {
                    Log.i((String)MixpanelAPI.LOGTAG, (String)"Surveys not supported on OS older than API 10, reporting null.");
                    callbacks.foundSurvey(null);
                    return;
                }
                AnalyticsMessages.SurveyCheck surveyCheck = new AnalyticsMessages.SurveyCheck(callbackWrapper, checkDistinctId, checkToken);
                MixpanelAPI.this.mMessages.checkForSurveys(surveyCheck);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkForSurvey(final SurveyCallbacks callbacks, final Activity parentActivity) {
            Object object = MixpanelAPI.this.mCachedSurveyAssetsLock;
            synchronized (object) {
                MixpanelAPI.this.mCachedSurveyBitmap = null;
                MixpanelAPI.this.mCachedSurveyHighlightColor = -1;
                MixpanelAPI.this.mCachedSurveyActivityHashcode = -1;
            }
            this.checkForSurvey(new SurveyCallbacks(){

                @Override
                public void foundSurvey(final Survey survey) {
                    BackgroundCapture.captureBackground(parentActivity, new BackgroundCapture.OnBackgroundCapturedListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void OnBackgroundCaptured(Bitmap bitmapCaptured, int highlightColorCaptured) {
                            Object object = MixpanelAPI.this.mCachedSurveyAssetsLock;
                            synchronized (object) {
                                MixpanelAPI.this.mCachedSurveyBitmap = bitmapCaptured;
                                MixpanelAPI.this.mCachedSurveyHighlightColor = highlightColorCaptured;
                                MixpanelAPI.this.mCachedSurveyActivityHashcode = parentActivity.hashCode();
                            }
                            callbacks.foundSurvey(survey);
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void showSurvey(final Survey s, final Activity parent) {
            if (Build.VERSION.SDK_INT < 10) {
                return;
            }
            if (!ConfigurationChecker.checkSurveyActivityAvailable(parent.getApplicationContext())) {
                return;
            }
            Bitmap useBitmap = null;
            int useHighlightColor = -1;
            Object object = MixpanelAPI.this.mCachedSurveyAssetsLock;
            synchronized (object) {
                if (parent.hashCode() == MixpanelAPI.this.mCachedSurveyActivityHashcode) {
                    useBitmap = MixpanelAPI.this.mCachedSurveyBitmap;
                    useHighlightColor = MixpanelAPI.this.mCachedSurveyHighlightColor;
                }
                MixpanelAPI.this.mCachedSurveyBitmap = null;
                MixpanelAPI.this.mCachedSurveyHighlightColor = -1;
                MixpanelAPI.this.mCachedSurveyActivityHashcode = -1;
            }
            if (null != useBitmap) {
                SurveyState.proposeSurvey(s, parent, this.getDistinctId(), MixpanelAPI.this.mToken, useBitmap, useHighlightColor);
            } else {
                BackgroundCapture.captureBackground(parent, new BackgroundCapture.OnBackgroundCapturedListener(){

                    @Override
                    public void OnBackgroundCaptured(Bitmap bitmapCaptured, int highlightColorCaptured) {
                        SurveyState.proposeSurvey(s, parent, PeopleImpl.this.getDistinctId(), MixpanelAPI.this.mToken, bitmapCaptured, highlightColorCaptured);
                    }
                });
            }
        }

        @Override
        public void trackCharge(double amount, JSONObject properties) {
            Date now = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat(MixpanelAPI.ENGAGE_DATE_FORMAT_STRING);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                JSONObject transactionValue = new JSONObject();
                transactionValue.put("$amount", amount);
                transactionValue.put("$time", (Object)dateFormat.format(now));
                if (null != properties) {
                    Iterator iter = properties.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        transactionValue.put(key, properties.get(key));
                    }
                }
                this.append("$transactions", transactionValue);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception creating new charge", (Throwable)e);
            }
        }

        @Override
        public void clearCharges() {
            this.unset("$transactions");
        }

        @Override
        public void deleteUser() {
            try {
                JSONObject message = this.stdPeopleMessage("$delete", JSONObject.NULL);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception deleting a user");
            }
        }

        @Override
        public void setPushRegistrationId(String registrationId) {
            if (this.getDistinctId() == null) {
                return;
            }
            MixpanelAPI.this.mPersistentProperties.storePushId(registrationId);
            try {
                this.union("$android_devices", new JSONArray("[" + registrationId + "]"));
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"set push registration id error", (Throwable)e);
            }
        }

        @Override
        public void clearPushRegistrationId() {
            MixpanelAPI.this.mPersistentProperties.clearPushId();
            this.set("$android_devices", new JSONArray());
        }

        @Override
        public void initPushHandling(String senderID) {
            if (!ConfigurationChecker.checkPushConfiguration(MixpanelAPI.this.mContext)) {
                Log.i((String)MixpanelAPI.LOGTAG, (String)"Can't start push notification service. Push notifications will not work.");
                Log.i((String)MixpanelAPI.LOGTAG, (String)("See log tagged " + ConfigurationChecker.LOGTAG + " above for details."));
            } else {
                final String pushId = MixpanelAPI.this.mPersistentProperties.getPushId();
                if (pushId == null) {
                    try {
                        Intent registrationIntent = new Intent("com.google.android.c2dm.intent.REGISTER");
                        registrationIntent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)MixpanelAPI.this.mContext, (int)0, (Intent)new Intent(), (int)0));
                        registrationIntent.putExtra("sender", senderID);
                        MixpanelAPI.this.mContext.startService(registrationIntent);
                    }
                    catch (SecurityException e) {
                        Log.w((String)MixpanelAPI.LOGTAG, (Throwable)e);
                    }
                } else {
                    MixpanelAPI.allInstances(new InstanceProcessor(){

                        @Override
                        public void process(MixpanelAPI api) {
                            api.getPeople().setPushRegistrationId(pushId);
                        }
                    });
                }
            }
        }

        @Override
        public String getDistinctId() {
            return MixpanelAPI.this.mPersistentProperties.getPeopleDistinctId();
        }

        @Override
        public People withIdentity(final String distinctId) {
            if (null == distinctId) {
                return null;
            }
            return new PeopleImpl(){

                @Override
                public String getDistinctId() {
                    return distinctId;
                }

                @Override
                public void identify(String distinctId2) {
                    throw new RuntimeException("This MixpanelPeople object has a fixed, constant distinctId");
                }
            };
        }

        public JSONObject stdPeopleMessage(String actionType, Object properties) throws JSONException {
            JSONObject dataObj = new JSONObject();
            String distinctId = this.getDistinctId();
            dataObj.put(actionType, properties);
            dataObj.put("$token", (Object)MixpanelAPI.this.mToken);
            dataObj.put("$time", System.currentTimeMillis());
            if (null != distinctId) {
                dataObj.put("$distinct_id", (Object)this.getDistinctId());
            }
            return dataObj;
        }
    }

    static interface InstanceProcessor {
        public void process(MixpanelAPI var1);
    }

    public static interface People {
        public void identify(String var1);

        public void set(String var1, Object var2);

        public void set(JSONObject var1);

        public void setOnce(String var1, Object var2);

        public void setOnce(JSONObject var1);

        public void increment(String var1, double var2);

        public void increment(Map<String, ? extends Number> var1);

        public void append(String var1, Object var2);

        public void union(String var1, JSONArray var2);

        public void unset(String var1);

        public void trackCharge(double var1, JSONObject var3);

        public void clearCharges();

        public void deleteUser();

        public void initPushHandling(String var1);

        public void setPushRegistrationId(String var1);

        public void clearPushRegistrationId();

        public String getDistinctId();

        public void checkForSurvey(SurveyCallbacks var1);

        public void checkForSurvey(SurveyCallbacks var1, Activity var2);

        public void showSurvey(Survey var1, Activity var2);

        public People withIdentity(String var1);
    }
}

