/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.surveys;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.mixpanel.android.R;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.mpmetrics.SurveyState;
import com.mixpanel.android.surveys.CardCarouselLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class SurveyActivity
extends Activity {
    private MixpanelAPI mMixpanel;
    private View mPreviousButton;
    private View mNextButton;
    private TextView mProgressTextView;
    private CardCarouselLayout mCardHolder;
    private SurveyState mSurveyState;
    private int mCurrentQuestion = 0;
    private int mIntentId = -1;
    private static final String CURRENT_QUESTION_BUNDLE_KEY = "com.mixpanel.android.surveys.SurveyActivity.CURRENT_QUESTION_BUNDLE_KEY";
    private static final String SURVEY_STATE_BUNDLE_KEY = "com.mixpanel.android.surveys.SurveyActivity.SURVEY_STATE_BUNDLE_KEY";
    private static final String LOGTAG = "MixpanelAPI";
    private static final int GRAY_30PERCENT = Color.argb((int)255, (int)90, (int)90, (int)90);

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        SurveyState saved = null;
        if (null != savedInstanceState) {
            saved = (SurveyState)savedInstanceState.getParcelable(SURVEY_STATE_BUNDLE_KEY);
        }
        this.mIntentId = this.getIntent().getIntExtra("intentID", Integer.MAX_VALUE);
        this.mSurveyState = SurveyState.claimSurveyState(saved, this.mIntentId);
        if (null == this.mSurveyState) {
            Log.e((String)LOGTAG, (String)"Survey intent received, but no survey was found.");
            this.finish();
            return;
        }
        if (null != savedInstanceState) {
            this.mCurrentQuestion = savedInstanceState.getInt(CURRENT_QUESTION_BUNDLE_KEY, 0);
        }
        this.setContentView(R.layout.com_mixpanel_android_activity_survey);
        Bitmap background = this.mSurveyState.getBackground();
        if (null == background) {
            View contentView = this.findViewById(R.id.com_mixpanel_android_activity_survey_id);
            contentView.setBackgroundColor(GRAY_30PERCENT);
        } else {
            this.getWindow().setBackgroundDrawable((Drawable)new BitmapDrawable(this.getResources(), background));
        }
        this.mPreviousButton = this.findViewById(R.id.com_mixpanel_android_button_previous);
        this.mNextButton = this.findViewById(R.id.com_mixpanel_android_button_next);
        this.mProgressTextView = (TextView)this.findViewById(R.id.com_mixpanel_android_progress_text);
        this.mCardHolder = (CardCarouselLayout)this.findViewById(R.id.com_mixpanel_android_question_card_holder);
        this.mCardHolder.setOnQuestionAnsweredListener(new CardCarouselLayout.OnQuestionAnsweredListener(){

            @Override
            public void onQuestionAnswered(Survey.Question question, String answer) {
                SurveyActivity.this.saveAnswer(question, answer);
                SurveyActivity.this.goToNextQuestion();
            }
        });
        Survey survey = this.mSurveyState.getSurvey();
        String answerDistinctId = this.mSurveyState.getDistinctId();
        if (null == answerDistinctId) {
            Log.i((String)LOGTAG, (String)"Can't show a survey to a user with no distinct id set");
            this.finish();
            return;
        }
        this.mMixpanel = MixpanelAPI.getInstance((Context)this, this.mSurveyState.getToken());
        MixpanelAPI.People people = this.mMixpanel.getPeople().withIdentity(answerDistinctId);
        people.append("$surveys", survey.getId());
        people.append("$collections", survey.getCollectionId());
        this.mMixpanel.flush();
        this.showQuestion(this.mCurrentQuestion);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    protected void onDestroy() {
        if (null != this.mMixpanel) {
            if (null != this.mSurveyState) {
                Survey survey = this.mSurveyState.getSurvey();
                List<Survey.Question> questionList = survey.getQuestions();
                String answerDistinctId = this.mSurveyState.getDistinctId();
                MixpanelAPI.People people = this.mMixpanel.getPeople().withIdentity(answerDistinctId);
                people.append("$responses", survey.getCollectionId());
                SurveyState.AnswerMap answers = this.mSurveyState.getAnswers();
                for (Survey.Question question : questionList) {
                    String answerString = answers.get(question.getId());
                    if (null == answerString) continue;
                    try {
                        JSONObject answerJson = new JSONObject();
                        answerJson.put("$survey_id", survey.getId());
                        answerJson.put("$collection_id", survey.getCollectionId());
                        answerJson.put("$question_id", question.getId());
                        answerJson.put("$question_type", (Object)question.getType().toString());
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                        answerJson.put("$time", (Object)dateFormat.format(new Date()));
                        answerJson.put("$value", (Object)answerString);
                        people.append("$answers", answerJson);
                    }
                    catch (JSONException e) {
                        Log.e((String)LOGTAG, (String)"Couldn't record user's answer.", (Throwable)e);
                    }
                }
            }
            this.mMixpanel.flush();
        }
        SurveyState.releaseSurvey(this.mIntentId);
        super.onDestroy();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(CURRENT_QUESTION_BUNDLE_KEY, this.mCurrentQuestion);
        outState.putParcelable(SURVEY_STATE_BUNDLE_KEY, (Parcelable)this.mSurveyState);
    }

    public void onBackPressed() {
        if (this.mCurrentQuestion > 0) {
            this.goToPreviousQuestion();
        } else {
            super.onBackPressed();
        }
    }

    public void goToPreviousQuestion(View v) {
        this.goToPreviousQuestion();
    }

    public void goToNextQuestion(View v) {
        this.goToNextQuestion();
    }

    public void completeSurvey(View v) {
        this.completeSurvey();
    }

    private void goToPreviousQuestion() {
        if (this.mCurrentQuestion > 0) {
            this.showQuestion(this.mCurrentQuestion - 1);
        } else {
            this.completeSurvey();
        }
    }

    private void goToNextQuestion() {
        int surveySize = this.mSurveyState.getSurvey().getQuestions().size();
        if (this.mCurrentQuestion < surveySize - 1) {
            this.showQuestion(this.mCurrentQuestion + 1);
        } else {
            this.completeSurvey();
        }
    }

    private void showQuestion(int idx) {
        List<Survey.Question> questions = this.mSurveyState.getSurvey().getQuestions();
        if (0 == idx || questions.size() == 0) {
            this.mPreviousButton.setEnabled(false);
        } else {
            this.mPreviousButton.setEnabled(true);
        }
        if (idx >= questions.size() - 1) {
            this.mNextButton.setEnabled(false);
        } else {
            this.mNextButton.setEnabled(true);
        }
        int oldQuestion = this.mCurrentQuestion;
        this.mCurrentQuestion = idx;
        Survey.Question question = questions.get(idx);
        SurveyState.AnswerMap answers = this.mSurveyState.getAnswers();
        String answerValue = answers.get(question.getId());
        try {
            if (oldQuestion < idx) {
                this.mCardHolder.moveTo(question, answerValue, CardCarouselLayout.Direction.FORWARD);
            } else if (oldQuestion > idx) {
                this.mCardHolder.moveTo(question, answerValue, CardCarouselLayout.Direction.BACKWARD);
            } else {
                this.mCardHolder.replaceTo(question, answerValue);
            }
        }
        catch (CardCarouselLayout.UnrecognizedAnswerTypeException e) {
            this.goToNextQuestion();
            return;
        }
        if (questions.size() > 1) {
            this.mProgressTextView.setText((CharSequence)("" + (idx + 1) + " of " + questions.size()));
        } else {
            this.mProgressTextView.setText((CharSequence)"");
        }
    }

    private void saveAnswer(Survey.Question question, String answer) {
        SurveyState.AnswerMap answers = this.mSurveyState.getAnswers();
        answers.put(question.getId(), answer.toString());
    }

    private void completeSurvey() {
        this.finish();
    }
}

