/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;
import com.mixpanel.android.mpmetrics.AnalyticsMessages;
import com.mixpanel.android.mpmetrics.BackgroundCapture;
import com.mixpanel.android.mpmetrics.ConfigurationChecker;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelActivityLifecycleCallbacks;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.mpmetrics.SurveyCallbacks;
import com.mixpanel.android.mpmetrics.SurveyState;
import com.mixpanel.android.mpmetrics.WaitingPeopleRecord;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelAPI {
    public static final String VERSION = "4.0.0-RC2";
    private static final String LOGTAG = "MixpanelAPI";
    private static final String ENGAGE_DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";
    private static Map<String, Map<Context, MixpanelAPI>> sInstanceMap = new HashMap<String, Map<Context, MixpanelAPI>>();
    private final Context mContext;
    private final AnalyticsMessages mMessages;
    private final String mToken;
    private final PeopleImpl mPeople;
    private final SharedPreferences mStoredPreferences;
    private final Object mCachedSurveyAssetsLock = new Object();
    private int mCachedSurveyActivityHashcode = -1;
    private Bitmap mCachedSurveyBitmap;
    private int mCachedSurveyHighlightColor;
    private JSONObject mSuperProperties;
    private String mEventsDistinctId;
    private String mPeopleDistinctId;
    private WaitingPeopleRecord mWaitingPeopleRecord;
    private final ExpiringLock checkForSurveysLock = new ExpiringLock(10000L);

    MixpanelAPI(Context context, String token) {
        this.mContext = context;
        this.mToken = token;
        this.mPeople = new PeopleImpl();
        this.mMessages = this.getAnalyticsMessages();
        this.mStoredPreferences = context.getSharedPreferences("com.mixpanel.android.mpmetrics.MixpanelAPI_" + token, 0);
        this.readSuperProperties();
        this.readIdentities();
        this.registerMixpanelActivityLifecycleCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MixpanelAPI getInstance(Context context, String token) {
        if (null == token || null == context) {
            return null;
        }
        Map<String, Map<Context, MixpanelAPI>> map = sInstanceMap;
        synchronized (map) {
            MixpanelAPI instance;
            Context appContext = context.getApplicationContext();
            Map<Context, MixpanelAPI> instances = sInstanceMap.get(token);
            if (null == instances) {
                instances = new HashMap<Context, MixpanelAPI>();
                sInstanceMap.put(token, instances);
            }
            if (null == (instance = instances.get(appContext))) {
                instance = new MixpanelAPI(appContext, token);
                instances.put(appContext, instance);
            }
            return instance;
        }
    }

    @Deprecated
    public static void setFlushInterval(Context context, long milliseconds) {
        Log.i((String)LOGTAG, (String)"MixpanelAPI.setFlushInterval is deprecated.\n    To set a custom Mixpanel flush interval for your application, add\n    <meta-data android:name=\"com.mixpanel.android.MPConfig.FlushInterval\" android:value=\"YOUR_INTERVAL\" />\n    to the <application> section of your AndroidManifest.xml.");
        AnalyticsMessages msgs = AnalyticsMessages.getInstance(context);
        msgs.setFlushInterval(milliseconds);
    }

    @Deprecated
    public static void enableFallbackServer(Context context, boolean enableIfTrue) {
        Log.i((String)LOGTAG, (String)"MixpanelAPI.enableFallbackServer is deprecated.\n    To disable fallback in your application, add\n    <meta-data android:name=\"com.mixpanel.android.MPConfig.DisableFallback\" android:value=\"true\" />\n    to the <application> section of your AndroidManifest.xml.");
        AnalyticsMessages msgs = AnalyticsMessages.getInstance(context);
        msgs.setDisableFallback(!enableIfTrue);
    }

    public void identify(String distinctId) {
        this.mEventsDistinctId = distinctId;
        this.writeIdentities();
    }

    public void track(String eventName, JSONObject properties) {
        Log.d((String)LOGTAG, (String)("track " + eventName));
        try {
            if (properties == null) {
                properties = new JSONObject();
            }
            long time = System.currentTimeMillis() / 1000L;
            if (!properties.has("time")) {
                properties.put("time", time);
            }
            Iterator iter = this.mSuperProperties.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (properties.has(key)) continue;
                properties.put(key, this.mSuperProperties.get(key));
            }
            String eventsId = this.getDistinctId();
            if (eventsId != null && !properties.has("distinct_id")) {
                properties.put("distinct_id", (Object)eventsId);
            }
            AnalyticsMessages.EventDTO eventDTO = new AnalyticsMessages.EventDTO(eventName, properties, this.mToken);
            this.mMessages.eventsMessage(eventDTO);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)("Exception tracking event " + eventName), (Throwable)e);
        }
    }

    public void flush() {
        Log.d((String)LOGTAG, (String)"flushEvents");
        this.mMessages.postToServer();
    }

    public String getDistinctId() {
        return this.mEventsDistinctId;
    }

    public void registerSuperProperties(JSONObject superProperties) {
        Log.d((String)LOGTAG, (String)"registerSuperProperties");
        Iterator iter = superProperties.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            try {
                this.mSuperProperties.put(key, superProperties.get(key));
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)"Exception registering super property.", (Throwable)e);
            }
        }
        this.storeSuperProperties();
    }

    public void unregisterSuperProperty(String superPropertyName) {
        this.mSuperProperties.remove(superPropertyName);
        this.storeSuperProperties();
    }

    public void registerSuperPropertiesOnce(JSONObject superProperties) {
        Log.d((String)LOGTAG, (String)"registerSuperPropertiesOnce");
        Iterator iter = superProperties.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (this.mSuperProperties.has(key)) continue;
            try {
                this.mSuperProperties.put(key, superProperties.get(key));
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)"Exception registering super property.", (Throwable)e);
            }
        }
        this.storeSuperProperties();
    }

    public void clearSuperProperties() {
        Log.d((String)LOGTAG, (String)"clearSuperProperties");
        this.mSuperProperties = new JSONObject();
    }

    public People getPeople() {
        return this.mPeople;
    }

    public void logPosts() {
        this.mMessages.logPosts();
    }

    void registerMixpanelActivityLifecycleCallbacks() {
        if (Build.VERSION.SDK_INT >= 14 && MPConfig.readConfig(this.mContext).getAutoCheckForSurveys()) {
            Log.d((String)LOGTAG, (String)"OS version is >= 14");
            if (this.mContext.getApplicationContext() instanceof Application) {
                Log.d((String)LOGTAG, (String)"Context is instanceof Application, registering MixpanelActivityLifecycleCallbacks");
                Application app = (Application)this.mContext.getApplicationContext();
                app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new MixpanelActivityLifecycleCallbacks(this));
            } else {
                Log.d((String)LOGTAG, (String)"Context is NOT instanceof Application, auto show surveys will be disabled.");
            }
        } else {
            Log.d((String)LOGTAG, (String)"OS version is < 14, auto show surveys will be disabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void allInstances(InstanceProcessor processor) {
        Map<String, Map<Context, MixpanelAPI>> map = sInstanceMap;
        synchronized (map) {
            for (Map<Context, MixpanelAPI> contextInstances : sInstanceMap.values()) {
                for (MixpanelAPI instance : contextInstances.values()) {
                    processor.process(instance);
                }
            }
        }
    }

    AnalyticsMessages getAnalyticsMessages() {
        return AnalyticsMessages.getInstance(this.mContext);
    }

    void clearPreferences() {
        SharedPreferences.Editor prefsEdit = this.mStoredPreferences.edit();
        prefsEdit.clear().commit();
        this.readSuperProperties();
        this.readIdentities();
    }

    private void pushWaitingPeopleRecord() {
        if (this.mWaitingPeopleRecord != null && this.mPeopleDistinctId != null) {
            JSONObject sets = this.mWaitingPeopleRecord.setMessage();
            Map<String, Double> adds = this.mWaitingPeopleRecord.incrementMessage();
            List<JSONObject> appends = this.mWaitingPeopleRecord.appendMessages();
            this.getPeople().set(sets);
            this.getPeople().increment(adds);
            for (JSONObject appendPairs : appends) {
                Iterator keysIter = appendPairs.keys();
                while (keysIter.hasNext()) {
                    try {
                        String key = (String)keysIter.next();
                        Object appendVal = appendPairs.get(key);
                        this.getPeople().append(key, appendVal);
                    }
                    catch (JSONException e) {
                        Log.e((String)LOGTAG, (String)"Couldn't send stored append", (Throwable)e);
                    }
                }
            }
        }
        this.mWaitingPeopleRecord = null;
        this.writeIdentities();
    }

    private void readSuperProperties() {
        String props = this.mStoredPreferences.getString("super_properties", "{}");
        Log.d((String)LOGTAG, (String)("Loading Super Properties " + props));
        try {
            this.mSuperProperties = new JSONObject(props);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Cannot parse stored superProperties");
            this.mSuperProperties = new JSONObject();
            this.storeSuperProperties();
        }
    }

    private void storeSuperProperties() {
        String props = this.mSuperProperties.toString();
        Log.d((String)LOGTAG, (String)("Storing Super Properties " + props));
        SharedPreferences.Editor prefsEditor = this.mStoredPreferences.edit();
        prefsEditor.putString("super_properties", props);
        prefsEditor.commit();
    }

    private void readIdentities() {
        this.mEventsDistinctId = this.mStoredPreferences.getString("events_distinct_id", null);
        this.mPeopleDistinctId = this.mStoredPreferences.getString("people_distinct_id", null);
        this.mWaitingPeopleRecord = null;
        String storedWaitingRecord = this.mStoredPreferences.getString("waiting_people_record", null);
        if (storedWaitingRecord != null) {
            try {
                this.mWaitingPeopleRecord = new WaitingPeopleRecord();
                this.mWaitingPeopleRecord.readFromJSONString(storedWaitingRecord);
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)("Could not interpret waiting people JSON record " + storedWaitingRecord));
            }
        }
        if (this.mEventsDistinctId == null) {
            this.mEventsDistinctId = UUID.randomUUID().toString();
            this.writeIdentities();
        }
        if (this.mWaitingPeopleRecord != null && this.mPeopleDistinctId != null) {
            this.pushWaitingPeopleRecord();
        }
    }

    private void writeIdentities() {
        SharedPreferences.Editor prefsEditor = this.mStoredPreferences.edit();
        prefsEditor.putString("events_distinct_id", this.mEventsDistinctId);
        prefsEditor.putString("people_distinct_id", this.mPeopleDistinctId);
        if (this.mWaitingPeopleRecord == null) {
            prefsEditor.remove("waiting_people_record");
        } else {
            prefsEditor.putString("waiting_people_record", this.mWaitingPeopleRecord.toJSONString());
        }
        prefsEditor.commit();
    }

    private static class ExpiringLock {
        private final ReentrantLock reentrantLock = new ReentrantLock();
        private boolean locked;
        private long time;
        private final long timeoutMillis;

        private ExpiringLock(long timeoutInMillis) {
            this.timeoutMillis = timeoutInMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquire() {
            if (this.reentrantLock.tryLock()) {
                try {
                    if (this.time > 0L && System.currentTimeMillis() - this.time > this.timeoutMillis) {
                        Log.d((String)MixpanelAPI.LOGTAG, (String)"The previous survey lock has timed out, releasing...");
                        this.release();
                    }
                    if (!this.locked) {
                        this.time = System.currentTimeMillis();
                        this.locked = true;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.reentrantLock.unlock();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.reentrantLock.tryLock()) {
                try {
                    this.locked = false;
                    this.time = 0L;
                }
                finally {
                    this.reentrantLock.unlock();
                }
            }
        }
    }

    private class PeopleImpl
    implements People {
        private PeopleImpl() {
        }

        @Override
        public void identify(String distinctId) {
            MixpanelAPI.this.mPeopleDistinctId = distinctId;
            MixpanelAPI.this.writeIdentities();
            if (MixpanelAPI.this.mWaitingPeopleRecord != null) {
                MixpanelAPI.this.pushWaitingPeopleRecord();
            }
        }

        @Override
        public void set(JSONObject properties) {
            Log.d((String)MixpanelAPI.LOGTAG, (String)("set " + properties.toString()));
            try {
                if (this.getDistinctId() == null) {
                    if (MixpanelAPI.this.mWaitingPeopleRecord == null) {
                        MixpanelAPI.this.mWaitingPeopleRecord = new WaitingPeopleRecord();
                    }
                    MixpanelAPI.this.mWaitingPeopleRecord.setOnWaitingPeopleRecord(properties);
                    MixpanelAPI.this.writeIdentities();
                } else {
                    JSONObject message = this.stdPeopleMessage("$set", properties);
                    MixpanelAPI.this.mMessages.peopleMessage(message);
                }
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception setting people properties");
            }
        }

        @Override
        public void set(String property, Object value) {
            try {
                this.set(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"set", (Throwable)e);
            }
        }

        @Override
        public void increment(Map<String, ? extends Number> properties) {
            JSONObject json = new JSONObject(properties);
            Log.d((String)MixpanelAPI.LOGTAG, (String)("increment " + json.toString()));
            try {
                if (this.getDistinctId() == null) {
                    if (MixpanelAPI.this.mWaitingPeopleRecord == null) {
                        MixpanelAPI.this.mWaitingPeopleRecord = new WaitingPeopleRecord();
                    }
                    MixpanelAPI.this.mWaitingPeopleRecord.incrementToWaitingPeopleRecord(properties);
                } else {
                    JSONObject message = this.stdPeopleMessage("$add", json);
                    MixpanelAPI.this.mMessages.peopleMessage(message);
                }
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception incrementing properties", (Throwable)e);
            }
        }

        @Override
        public void increment(String property, double value) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put(property, value);
            this.increment(map);
        }

        @Override
        public void append(String name, Object value) {
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, value);
                this.append(properties);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception appending a property", (Throwable)e);
            }
        }

        @Override
        public void checkForSurvey(SurveyCallbacks callbacks) {
            Log.d((String)MixpanelAPI.LOGTAG, (String)"Checking for surveys...");
            if (MixpanelAPI.this.checkForSurveysLock.acquire()) {
                Log.d((String)MixpanelAPI.LOGTAG, (String)"Acquired checkForSurvey lock...");
                String checkToken = MixpanelAPI.this.mToken;
                String checkDistinctId = this.getDistinctId();
                final SurveyCallbacks checkCallbacks = callbacks;
                SurveyCallbacks callbackWrapper = new SurveyCallbacks(){

                    @Override
                    public void foundSurvey(Survey s) {
                        checkCallbacks.foundSurvey(s);
                        MixpanelAPI.this.checkForSurveysLock.release();
                    }
                };
                if (null == callbacks) {
                    Log.i((String)MixpanelAPI.LOGTAG, (String)"Skipping survey check, because callback is null.");
                    return;
                }
                if (null == checkDistinctId) {
                    Log.i((String)MixpanelAPI.LOGTAG, (String)"Skipping survey check, because user has not yet been identified.");
                    return;
                }
                if (Build.VERSION.SDK_INT < 10) {
                    Log.i((String)MixpanelAPI.LOGTAG, (String)"Surveys not supported on OS older than API 10, reporting null.");
                    callbacks.foundSurvey(null);
                    return;
                }
                AnalyticsMessages.SurveyCheck surveyCheck = new AnalyticsMessages.SurveyCheck(callbackWrapper, checkDistinctId, checkToken);
                MixpanelAPI.this.mMessages.checkForSurveys(surveyCheck);
            } else {
                Log.d((String)MixpanelAPI.LOGTAG, (String)"Survey check lock already held");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkForSurvey(final SurveyCallbacks callbacks, final Activity parentActivity) {
            Object object = MixpanelAPI.this.mCachedSurveyAssetsLock;
            synchronized (object) {
                MixpanelAPI.this.mCachedSurveyBitmap = null;
                MixpanelAPI.this.mCachedSurveyHighlightColor = -1;
                MixpanelAPI.this.mCachedSurveyActivityHashcode = -1;
            }
            this.checkForSurvey(new SurveyCallbacks(){

                @Override
                public void foundSurvey(final Survey survey) {
                    BackgroundCapture.captureBackground(parentActivity, new BackgroundCapture.OnBackgroundCapturedListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void OnBackgroundCaptured(Bitmap bitmapCaptured, int highlightColorCaptured) {
                            Object object = MixpanelAPI.this.mCachedSurveyAssetsLock;
                            synchronized (object) {
                                MixpanelAPI.this.mCachedSurveyBitmap = bitmapCaptured;
                                MixpanelAPI.this.mCachedSurveyHighlightColor = highlightColorCaptured;
                                MixpanelAPI.this.mCachedSurveyActivityHashcode = parentActivity.hashCode();
                            }
                            callbacks.foundSurvey(survey);
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void showSurvey(final Survey s, final Activity parent) {
            if (Build.VERSION.SDK_INT < 10) {
                return;
            }
            Bitmap useBitmap = null;
            int useHighlightColor = -1;
            Object object = MixpanelAPI.this.mCachedSurveyAssetsLock;
            synchronized (object) {
                if (parent.hashCode() == MixpanelAPI.this.mCachedSurveyActivityHashcode) {
                    useBitmap = MixpanelAPI.this.mCachedSurveyBitmap;
                    useHighlightColor = MixpanelAPI.this.mCachedSurveyHighlightColor;
                }
                MixpanelAPI.this.mCachedSurveyBitmap = null;
                MixpanelAPI.this.mCachedSurveyHighlightColor = -1;
                MixpanelAPI.this.mCachedSurveyActivityHashcode = -1;
            }
            if (null != useBitmap) {
                SurveyState.proposeSurvey(s, parent, this.getDistinctId(), MixpanelAPI.this.mToken, useBitmap, useHighlightColor);
            } else {
                BackgroundCapture.captureBackground(parent, new BackgroundCapture.OnBackgroundCapturedListener(){

                    @Override
                    public void OnBackgroundCaptured(Bitmap bitmapCaptured, int highlightColorCaptured) {
                        SurveyState.proposeSurvey(s, parent, PeopleImpl.this.getDistinctId(), MixpanelAPI.this.mToken, bitmapCaptured, highlightColorCaptured);
                    }
                });
            }
        }

        @Override
        public void trackCharge(double amount, JSONObject properties) {
            Date now = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat(MixpanelAPI.ENGAGE_DATE_FORMAT_STRING);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                JSONObject transactionValue = new JSONObject();
                transactionValue.put("$amount", amount);
                transactionValue.put("$time", (Object)dateFormat.format(now));
                if (null != properties) {
                    Iterator iter = properties.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        transactionValue.put(key, properties.get(key));
                    }
                }
                this.append("$transactions", transactionValue);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception creating new charge", (Throwable)e);
            }
        }

        @Override
        public void clearCharges() {
            JSONArray empty = new JSONArray();
            this.set("$transactions", empty);
        }

        @Override
        public void deleteUser() {
            Log.d((String)MixpanelAPI.LOGTAG, (String)"delete");
            if (this.getDistinctId() == null) {
                return;
            }
            try {
                JSONObject message = this.stdPeopleMessage("$add", null);
                MixpanelAPI.this.mMessages.peopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception deleting a user");
            }
        }

        @Override
        public void setPushRegistrationId(String registrationId) {
            Log.d((String)MixpanelAPI.LOGTAG, (String)("setting push registration id: " + registrationId));
            if (this.getDistinctId() == null) {
                return;
            }
            MixpanelAPI.this.mStoredPreferences.edit().putString("push_id", registrationId).commit();
            try {
                JSONObject registrationInfo = new JSONObject().put("$android_devices", (Object)new JSONArray("[" + registrationId + "]"));
                JSONObject message = this.stdPeopleMessage("$union", registrationInfo);
                MixpanelAPI.this.mMessages.peopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"set push registration id error", (Throwable)e);
            }
        }

        @Override
        public void clearPushRegistrationId() {
            Log.d((String)MixpanelAPI.LOGTAG, (String)"removing push registration id");
            MixpanelAPI.this.mStoredPreferences.edit().remove("push_id").commit();
            this.set("$android_devices", new JSONArray());
        }

        @Override
        public void initPushHandling(String senderID) {
            Log.d((String)MixpanelAPI.LOGTAG, (String)"initPushHandling");
            if (!ConfigurationChecker.checkPushConfiguration(MixpanelAPI.this.mContext)) {
                Log.i((String)MixpanelAPI.LOGTAG, (String)"Can't start push notification service. Push notifications will not work.");
                Log.i((String)MixpanelAPI.LOGTAG, (String)("See log tagged " + ConfigurationChecker.LOGTAG + " above for details."));
            } else {
                final String pushId = this.getPushId();
                if (pushId == null) {
                    Log.d((String)MixpanelAPI.LOGTAG, (String)"Registering a new push id");
                    try {
                        Intent registrationIntent = new Intent("com.google.android.c2dm.intent.REGISTER");
                        registrationIntent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)MixpanelAPI.this.mContext, (int)0, (Intent)new Intent(), (int)0));
                        registrationIntent.putExtra("sender", senderID);
                        MixpanelAPI.this.mContext.startService(registrationIntent);
                    }
                    catch (SecurityException e) {
                        Log.w((String)MixpanelAPI.LOGTAG, (Throwable)e);
                    }
                } else {
                    MixpanelAPI.allInstances(new InstanceProcessor(){

                        @Override
                        public void process(MixpanelAPI api) {
                            Log.d((String)MixpanelAPI.LOGTAG, (String)("Using existing pushId " + pushId));
                            api.getPeople().setPushRegistrationId(pushId);
                        }
                    });
                }
            }
        }

        @Override
        public String getDistinctId() {
            return MixpanelAPI.this.mPeopleDistinctId;
        }

        void append(JSONObject properties) {
            try {
                if (this.getDistinctId() == null) {
                    if (MixpanelAPI.this.mWaitingPeopleRecord == null) {
                        MixpanelAPI.this.mWaitingPeopleRecord = new WaitingPeopleRecord();
                    }
                    MixpanelAPI.this.mWaitingPeopleRecord.appendToWaitingPeopleRecord(properties);
                } else {
                    JSONObject message = this.stdPeopleMessage("$append", properties);
                    MixpanelAPI.this.mMessages.peopleMessage(message);
                }
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Can't create append message", (Throwable)e);
            }
        }

        @Override
        public People withIdentity(final String distinctId) {
            if (null == distinctId) {
                return null;
            }
            return new PeopleImpl(){

                @Override
                public String getDistinctId() {
                    return distinctId;
                }

                @Override
                public void identify(String distinctId2) {
                    throw new RuntimeException("This MixpanelPeople object has a fixed, constant distinctId");
                }
            };
        }

        public String getPushId() {
            return MixpanelAPI.this.mStoredPreferences.getString("push_id", null);
        }

        public JSONObject stdPeopleMessage(String actionType, JSONObject properties) throws JSONException {
            JSONObject dataObj = new JSONObject();
            dataObj.put(actionType, (Object)properties);
            dataObj.put("$token", (Object)MixpanelAPI.this.mToken);
            dataObj.put("$distinct_id", (Object)this.getDistinctId());
            dataObj.put("$time", System.currentTimeMillis());
            return dataObj;
        }
    }

    static interface InstanceProcessor {
        public void process(MixpanelAPI var1);
    }

    public static interface People {
        public void identify(String var1);

        public void set(String var1, Object var2);

        public void set(JSONObject var1);

        public void increment(String var1, double var2);

        public void increment(Map<String, ? extends Number> var1);

        public void append(String var1, Object var2);

        public void trackCharge(double var1, JSONObject var3);

        public void clearCharges();

        public void deleteUser();

        public void initPushHandling(String var1);

        public void setPushRegistrationId(String var1);

        public void clearPushRegistrationId();

        public String getDistinctId();

        public void checkForSurvey(SurveyCallbacks var1);

        public void checkForSurvey(SurveyCallbacks var1, Activity var2);

        public void showSurvey(Survey var1, Activity var2);

        public People withIdentity(String var1);
    }
}

