/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.surveys;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.mixpanel.android.R;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.surveys.CardCarouselLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class SurveyActivity
extends Activity {
    private MixpanelAPI mMixpanel;
    private View mPreviousButton;
    private View mNextButton;
    private Survey mSurvey;
    private String mDistinctId;
    private String mToken;
    private TextView mProgressTextView;
    private CardCarouselLayout mCardHolder;
    private AnswerMap mAnswers;
    private int mCurrentQuestion = 0;
    private static final String SAVED_CURRENT_QUESTION = "com.mixpanel.android.surveys.SurveyActivity.mCurrentQuestion";
    private static final String SAVED_ANSWERS = "com.mixpanel.android.surveys.SurveyActivity.mAnswers";
    private static final String LOGTAG = "MixpanelAPI";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAnswers = new AnswerMap();
        if (null != savedInstanceState) {
            this.mCurrentQuestion = savedInstanceState.getInt(SAVED_CURRENT_QUESTION, 0);
            AnswerMap savedAnswers = (AnswerMap)savedInstanceState.getParcelable(SAVED_ANSWERS);
            if (null != savedAnswers) {
                this.mAnswers = savedAnswers;
            }
        }
        this.mDistinctId = this.getIntent().getStringExtra("distinctId");
        this.mToken = this.getIntent().getStringExtra("token");
        String surveyJsonStr = this.getIntent().getStringExtra("surveyJson");
        byte[] backgroundCompressed = this.getIntent().getByteArrayExtra("backgroundCompressed");
        int highlightColor = this.getIntent().getIntExtra("highlightColor", -1);
        this.setContentView(R.layout.com_mixpanel_android_activity_survey);
        if (null != backgroundCompressed) {
            Bitmap background = BitmapFactory.decodeByteArray((byte[])backgroundCompressed, (int)0, (int)backgroundCompressed.length);
            this.getWindow().setBackgroundDrawable((Drawable)new BitmapDrawable(this.getResources(), background));
        } else {
            View contentView = this.findViewById(R.id.com_mixpanel_android_activity_survey_id);
            contentView.setBackgroundColor(Color.argb((int)255, (int)90, (int)90, (int)90));
        }
        this.mPreviousButton = this.findViewById(R.id.com_mixpanel_android_button_previous);
        this.mNextButton = this.findViewById(R.id.com_mixpanel_android_button_next);
        this.mProgressTextView = (TextView)this.findViewById(R.id.com_mixpanel_android_progress_text);
        this.mCardHolder = (CardCarouselLayout)this.findViewById(R.id.com_mixpanel_android_question_card_holder);
        this.mCardHolder.setOnQuestionAnsweredListener(new CardCarouselLayout.OnQuestionAnsweredListener(){

            @Override
            public void onQuestionAnswered(Survey.Question question, String answer) {
                SurveyActivity.this.saveAnswer(question, answer);
                SurveyActivity.this.goToNextQuestion();
            }
        });
        this.mMixpanel = MixpanelAPI.getInstance((Context)this, this.mToken);
        this.mMixpanel.getPeople().identify(this.mDistinctId);
        try {
            this.mSurvey = new Survey(new JSONObject(surveyJsonStr));
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)("Unable to parse survey json: " + surveyJsonStr), (Throwable)e);
        }
        this.showQuestion(this.mCurrentQuestion);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(SAVED_CURRENT_QUESTION, this.mCurrentQuestion);
        outState.putParcelable(SAVED_ANSWERS, (Parcelable)this.mAnswers);
    }

    public void onBackPressed() {
        if (this.mCurrentQuestion > 0) {
            this.goToPreviousQuestion();
        } else {
            super.onBackPressed();
        }
    }

    public void goToPreviousQuestion(View v) {
        this.goToPreviousQuestion();
    }

    public void goToNextQuestion(View v) {
        this.goToNextQuestion();
    }

    public void completeSurvey(View v) {
        this.completeSurvey();
    }

    protected void onDestroy() {
        this.mMixpanel.flush();
        super.onDestroy();
    }

    private void goToPreviousQuestion() {
        if (this.mCurrentQuestion > 0) {
            this.showQuestion(this.mCurrentQuestion - 1);
        } else {
            this.completeSurvey();
        }
    }

    private void goToNextQuestion() {
        if (this.mCurrentQuestion < this.mSurvey.getQuestions().size() - 1) {
            this.showQuestion(this.mCurrentQuestion + 1);
        } else {
            this.completeSurvey();
        }
    }

    private void showQuestion(int idx) {
        List<Survey.Question> questions = this.mSurvey.getQuestions();
        if (0 == idx || questions.size() == 0) {
            this.mPreviousButton.setEnabled(false);
        } else {
            this.mPreviousButton.setEnabled(true);
        }
        if (idx >= questions.size() - 1) {
            this.mNextButton.setEnabled(false);
        } else {
            this.mNextButton.setEnabled(true);
        }
        int oldQuestion = this.mCurrentQuestion;
        this.mCurrentQuestion = idx;
        Survey.Question question = questions.get(idx);
        String answerValue = (String)this.mAnswers.get(question.getId());
        try {
            if (oldQuestion < idx) {
                this.mCardHolder.moveTo(question, answerValue, CardCarouselLayout.Direction.FORWARD);
            } else if (oldQuestion > idx) {
                this.mCardHolder.moveTo(question, answerValue, CardCarouselLayout.Direction.BACKWARD);
            } else {
                this.mCardHolder.replaceTo(question, answerValue);
            }
        }
        catch (CardCarouselLayout.UnrecognizedAnswerTypeException e) {
            this.goToNextQuestion();
            return;
        }
        this.mProgressTextView.setText((CharSequence)("" + (idx + 1) + " of " + this.mSurvey.getQuestions().size()));
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private void saveAnswer(Survey.Question question, String answer) {
        this.mAnswers.put(question.getId(), answer.toString());
        this.mMixpanel.getPeople().append("$responses", this.mSurvey.getCollectionId());
        try {
            JSONObject answerJson = new JSONObject();
            answerJson.put("$survey_id", this.mSurvey.getId());
            answerJson.put("$collection_id", this.mSurvey.getCollectionId());
            answerJson.put("$question_id", question.getId());
            answerJson.put("$question_type", (Object)question.getType().toString());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            answerJson.put("$time", (Object)dateFormat.format(new Date()));
            answerJson.put("$value", (Object)answer.toString());
            this.mMixpanel.getPeople().append("$answers", answerJson);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Couldn't record user's answer.", (Throwable)e);
        }
        this.mMixpanel.flush();
    }

    private void completeSurvey() {
        this.finish();
    }

    public static class AnswerMap
    extends HashMap<Integer, String>
    implements Parcelable {
        public static final Parcelable.Creator<AnswerMap> CREATOR = new Parcelable.Creator<AnswerMap>(){

            public AnswerMap createFromParcel(Parcel in) {
                Bundle read = new Bundle();
                AnswerMap ret = new AnswerMap();
                read.readFromParcel(in);
                for (String kString : read.keySet()) {
                    Integer kInt = Integer.valueOf(kString);
                    ret.put(kInt, read.getString(kString));
                }
                return ret;
            }

            public AnswerMap[] newArray(int size) {
                return new AnswerMap[size];
            }
        };
        private static final long serialVersionUID = -2359922757820889025L;

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            Bundle out = new Bundle();
            for (Map.Entry entry : this.entrySet()) {
                String keyString = Integer.toString((Integer)entry.getKey());
                out.putString(keyString, (String)entry.getValue());
            }
            dest.writeBundle(out);
        }
    }
}

