/*
 * Decompiled with CFR 0.152.
 */
package com.mitchtalmadge.asciidata.table;

import com.mitchtalmadge.asciidata.table.formats.TableFormatAbstract;
import com.mitchtalmadge.asciidata.table.formats.UTF8TableFormat;

public class ASCIITable {
    private final String[] headers;
    private final String[][] data;
    private final int columnsCount;
    private final int[] columnWidths;
    private final int emptyWidth;
    private final String emptyMessage = "(empty)";
    private String nullValue = "";
    private TableFormatAbstract tableFormat = new UTF8TableFormat();

    public static ASCIITable fromData(String[] headers, String[][] data) {
        if (headers == null) {
            throw new IllegalArgumentException("The table headers array is null.");
        }
        if (headers.length == 0) {
            throw new IllegalArgumentException("No headers were supplied.");
        }
        if (data == null) {
            data = new String[0][0];
        }
        return new ASCIITable(headers, data);
    }

    private ASCIITable(String[] headers, String[][] data) {
        this.headers = headers;
        this.data = data;
        this.columnsCount = headers.length;
        this.columnWidths = new int[this.columnsCount];
        for (int row = 0; row < data.length + 1; ++row) {
            String[] rowData;
            String[] stringArray = rowData = row == 0 ? headers : data[row - 1];
            if (rowData.length != this.columnsCount) {
                throw new IllegalArgumentException("The number of columns in row " + (row - 1) + " (" + rowData.length + ") do not match the number of headers (" + this.columnsCount + ")");
            }
            for (int column = 0; column < this.columnsCount; ++column) {
                for (String rowDataLine : this.nullSafeData(rowData[column]).split("\\n")) {
                    this.columnWidths[column] = Math.max(this.columnWidths[column], rowDataLine.length());
                }
            }
        }
        int emptyWidth = 3 * (this.columnsCount - 1);
        for (int columnWidth : this.columnWidths) {
            emptyWidth += columnWidth;
        }
        this.emptyWidth = emptyWidth;
        if (emptyWidth < "(empty)".length()) {
            int n = this.columnsCount - 1;
            this.columnWidths[n] = this.columnWidths[n] + ("(empty)".length() - emptyWidth);
        }
    }

    public ASCIITable withTableFormat(TableFormatAbstract tableFormat) {
        this.tableFormat = tableFormat;
        return this;
    }

    public ASCIITable withNullValue(String nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        this.appendHorizontalDivider(output, this.tableFormat.getTopLeftCorner(), this.tableFormat.getHorizontalBorderFill(true, false), this.tableFormat.getTopEdgeBorderDivider(), this.tableFormat.getTopRightCorner());
        this.appendRow(output, this.headers);
        if (this.data.length == 0) {
            this.appendHorizontalDivider(output, this.tableFormat.getLeftEdgeBorderDivider(true), this.tableFormat.getHorizontalBorderFill(false, true), this.tableFormat.getCross(true, true), this.tableFormat.getRightEdgeBorderDivider(true));
            output.append(this.tableFormat.getVerticalBorderFill(true)).append(ASCIITable.pad(this.emptyWidth, "(empty)")).append(this.tableFormat.getVerticalBorderFill(true)).append('\n');
            this.appendHorizontalDivider(output, this.tableFormat.getBottomLeftCorner(), this.tableFormat.getHorizontalBorderFill(true, false), this.tableFormat.getHorizontalBorderFill(true, false), this.tableFormat.getBottomRightCorner());
            return output.toString();
        }
        for (int row = 0; row < this.data.length; ++row) {
            if (row == 0) {
                this.appendHorizontalDivider(output, this.tableFormat.getLeftEdgeBorderDivider(true), this.tableFormat.getHorizontalBorderFill(false, true), this.tableFormat.getCross(true, false), this.tableFormat.getRightEdgeBorderDivider(true));
            } else {
                this.appendHorizontalDivider(output, this.tableFormat.getLeftEdgeBorderDivider(false), this.tableFormat.getHorizontalBorderFill(false, false), this.tableFormat.getCross(false, false), this.tableFormat.getRightEdgeBorderDivider(false));
            }
            this.appendRow(output, this.data[row]);
        }
        this.appendHorizontalDivider(output, this.tableFormat.getBottomLeftCorner(), this.tableFormat.getHorizontalBorderFill(true, false), this.tableFormat.getBottomEdgeBorderDivider(), this.tableFormat.getBottomRightCorner());
        return output.toString();
    }

    private void appendRow(StringBuilder output, String[] data) {
        int rowHeight = 0;
        for (int column = 0; column < this.columnsCount; ++column) {
            int cellHeight = this.nullSafeData(data[column]).split("\\n").length;
            rowHeight = Math.max(rowHeight, cellHeight);
        }
        for (int line = 0; line < rowHeight; ++line) {
            for (int column = 0; column < this.columnsCount; ++column) {
                output.append(this.tableFormat.getVerticalBorderFill(column == 0));
                String[] cellLines = this.nullSafeData(data[column]).split("\\n");
                String cellLine = line < cellLines.length ? cellLines[line] : "";
                output.append(ASCIITable.pad(this.columnWidths[column], cellLine));
            }
            output.append(this.tableFormat.getVerticalBorderFill(true)).append('\n');
        }
    }

    private String nullSafeData(String data) {
        return data == null ? this.nullValue : data;
    }

    private void appendHorizontalDivider(StringBuilder output, char left, char fill, char middle, char right) {
        for (int column = 0; column < this.columnsCount; ++column) {
            output.append(column == 0 ? left : middle);
            output.append(ASCIITable.pad(this.columnWidths[column], "").replace(' ', fill));
        }
        output.append(right).append('\n');
    }

    private static String pad(int width, String data) {
        return String.format(" %1$-" + width + "s ", data);
    }
}

