/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node.expression;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.node.expression.BinaryExpression;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.util.Collection;
import java.util.Map;

public class ContainsExpression
extends BinaryExpression<Boolean> {
    @Override
    public Boolean evaluate(PebbleTemplateImpl self, EvaluationContext context) throws PebbleException {
        Object leftValue = this.getLeftExpression().evaluate(self, context);
        if (leftValue == null) {
            return false;
        }
        Object rightValue = this.getRightExpression().evaluate(self, context);
        if (leftValue instanceof Collection) {
            if (rightValue instanceof Collection) {
                return ((Collection)leftValue).containsAll((Collection)rightValue);
            }
            return ((Collection)leftValue).contains(rightValue);
        }
        if (leftValue instanceof Map) {
            return ((Map)leftValue).containsKey(rightValue);
        }
        if (leftValue.getClass().isArray()) {
            return ContainsExpression.arrayContains(leftValue, rightValue);
        }
        if (leftValue instanceof String) {
            return String.valueOf(leftValue).contains(String.valueOf(rightValue));
        }
        throw new IllegalArgumentException("Contains operator can only be used on Collections, Maps and arrays. Actual type was: " + leftValue.getClass().getName());
    }

    private static boolean arrayContains(Object input, Object value) {
        if (input instanceof Object[]) {
            return ContainsExpression.containsObject((Object[])input, value);
        }
        if (input instanceof boolean[]) {
            return ContainsExpression.containsBoolean((boolean[])input, value);
        }
        if (input instanceof byte[]) {
            return ContainsExpression.containsByte((byte[])input, value);
        }
        if (input instanceof char[]) {
            return ContainsExpression.containsChar((char[])input, value);
        }
        if (input instanceof double[]) {
            return ContainsExpression.containsDouble((double[])input, value);
        }
        if (input instanceof float[]) {
            return ContainsExpression.containsFloat((float[])input, value);
        }
        if (input instanceof int[]) {
            return ContainsExpression.containsInt((int[])input, value);
        }
        if (input instanceof long[]) {
            return ContainsExpression.containsLong((long[])input, value);
        }
        return ContainsExpression.containsShort((short[])input, value);
    }

    private static boolean containsObject(Object[] array, Object value) {
        for (Object o : array) {
            if (value != o && (value == null || !value.equals(o))) continue;
            return true;
        }
        return false;
    }

    private static boolean containsBoolean(boolean[] array, Object value) {
        if (!(value instanceof Boolean)) {
            return false;
        }
        for (boolean b : array) {
            if (b != (Boolean)value) continue;
            return true;
        }
        return false;
    }

    private static boolean containsByte(byte[] array, Object value) {
        if (!(value instanceof Byte)) {
            return false;
        }
        for (byte b : array) {
            if (b != (Byte)value) continue;
            return true;
        }
        return false;
    }

    private static boolean containsChar(char[] array, Object value) {
        if (!(value instanceof Character)) {
            return false;
        }
        for (char c : array) {
            if (c != ((Character)value).charValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean containsDouble(double[] array, Object value) {
        if (!(value instanceof Double)) {
            return false;
        }
        for (double d : array) {
            if (d != (Double)value) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFloat(float[] array, Object value) {
        if (!(value instanceof Float)) {
            return false;
        }
        for (float f : array) {
            if (f != ((Float)value).floatValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean containsInt(int[] array, Object value) {
        if (!(value instanceof Integer)) {
            return false;
        }
        for (int i : array) {
            if (i != (Integer)value) continue;
            return true;
        }
        return false;
    }

    private static boolean containsLong(long[] array, Object value) {
        if (!(value instanceof Long)) {
            return false;
        }
        for (long l : array) {
            if (l != (Long)value) continue;
            return true;
        }
        return false;
    }

    private static boolean containsShort(short[] array, Object value) {
        if (!(value instanceof Short)) {
            return false;
        }
        for (short s : array) {
            if (s != (Short)value) continue;
            return true;
        }
        return false;
    }
}

