/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.okhttp.internal.connection;

import com.mistyrain.okhttp.Interceptor;
import com.mistyrain.okhttp.OkHttpClient;
import com.mistyrain.okhttp.Request;
import com.mistyrain.okhttp.Response;
import com.mistyrain.okhttp.internal.connection.RealConnection;
import com.mistyrain.okhttp.internal.connection.StreamAllocation;
import com.mistyrain.okhttp.internal.http.HttpStream;
import com.mistyrain.okhttp.internal.http.RealInterceptorChain;
import java.io.IOException;

public final class ConnectInterceptor
implements Interceptor {
    public final OkHttpClient client;

    public ConnectInterceptor(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Request request = realChain.request();
        StreamAllocation streamAllocation = realChain.streamAllocation();
        boolean doExtensiveHealthChecks = !request.method().equals("GET");
        HttpStream httpStream = streamAllocation.newStream(this.client, doExtensiveHealthChecks);
        RealConnection connection = streamAllocation.connection();
        return realChain.proceed(request, streamAllocation, httpStream, connection);
    }
}

