/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.okhttp;

import com.mistyrain.okhttp.Call;
import com.mistyrain.okhttp.Callback;
import com.mistyrain.okhttp.HttpUrl;
import com.mistyrain.okhttp.Interceptor;
import com.mistyrain.okhttp.OkHttpClient;
import com.mistyrain.okhttp.Request;
import com.mistyrain.okhttp.Response;
import com.mistyrain.okhttp.internal.NamedRunnable;
import com.mistyrain.okhttp.internal.cache.CacheInterceptor;
import com.mistyrain.okhttp.internal.connection.ConnectInterceptor;
import com.mistyrain.okhttp.internal.connection.StreamAllocation;
import com.mistyrain.okhttp.internal.http.BridgeInterceptor;
import com.mistyrain.okhttp.internal.http.CallServerInterceptor;
import com.mistyrain.okhttp.internal.http.RealInterceptorChain;
import com.mistyrain.okhttp.internal.http.RetryAndFollowUpInterceptor;
import com.mistyrain.okhttp.internal.platform.Platform;
import java.io.IOException;
import java.util.ArrayList;

public class RealCall
implements Call {
    private final OkHttpClient client;
    private final RetryAndFollowUpInterceptor retryAndFollowUpInterceptor;
    private boolean executed;
    Request originalRequest;

    protected RealCall(OkHttpClient client, Request originalRequest) {
        this.client = client;
        this.originalRequest = originalRequest;
        this.retryAndFollowUpInterceptor = new RetryAndFollowUpInterceptor(client);
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute() throws IOException {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        try {
            this.client.dispatcher().executed(this);
            Response result = this.getResponseWithInterceptorChain();
            if (result == null) {
                throw new IOException("Canceled");
            }
            Response response = result;
            return response;
        }
        finally {
            this.client.dispatcher().finished(this);
        }
    }

    synchronized void setForWebSocket() {
        if (this.executed) {
            throw new IllegalStateException("Already Executed");
        }
        this.retryAndFollowUpInterceptor.setForWebSocket(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Callback responseCallback) {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.client.dispatcher().enqueue(new AsyncCall(responseCallback));
    }

    @Override
    public void cancel() {
        this.retryAndFollowUpInterceptor.cancel();
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isCanceled() {
        return this.retryAndFollowUpInterceptor.isCanceled();
    }

    StreamAllocation streamAllocation() {
        return this.retryAndFollowUpInterceptor.streamAllocation();
    }

    private String toLoggableString() {
        String string = this.retryAndFollowUpInterceptor.isCanceled() ? "canceled call" : "call";
        return string + " to " + this.redactedUrl();
    }

    HttpUrl redactedUrl() {
        return this.originalRequest.url().resolve("/...");
    }

    private Response getResponseWithInterceptorChain() throws IOException {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        interceptors.addAll(this.client.interceptors());
        interceptors.add(this.retryAndFollowUpInterceptor);
        interceptors.add(new BridgeInterceptor(this.client.cookieJar()));
        interceptors.add(new CacheInterceptor(this.client.internalCache()));
        interceptors.add(new ConnectInterceptor(this.client));
        if (!this.retryAndFollowUpInterceptor.isForWebSocket()) {
            interceptors.addAll(this.client.networkInterceptors());
        }
        interceptors.add(new CallServerInterceptor(this.retryAndFollowUpInterceptor.isForWebSocket()));
        RealInterceptorChain chain = new RealInterceptorChain(interceptors, null, null, null, 0, this.originalRequest);
        return chain.proceed(this.originalRequest);
    }

    final class AsyncCall
    extends NamedRunnable {
        private final Callback responseCallback;

        private AsyncCall(Callback responseCallback) {
            super("OkHttp %s", RealCall.this.redactedUrl().toString());
            this.responseCallback = responseCallback;
        }

        String host() {
            return RealCall.this.originalRequest.url().host();
        }

        Request request() {
            return RealCall.this.originalRequest;
        }

        RealCall get() {
            return RealCall.this;
        }

        @Override
        protected void execute() {
            boolean signalledCallback = false;
            try {
                Response response = RealCall.this.getResponseWithInterceptorChain();
                if (RealCall.this.retryAndFollowUpInterceptor.isCanceled()) {
                    signalledCallback = true;
                    this.responseCallback.onFailure(RealCall.this, new IOException("Canceled"));
                } else {
                    signalledCallback = true;
                    this.responseCallback.onResponse(RealCall.this, response);
                }
            }
            catch (IOException e) {
                if (signalledCallback) {
                    Platform.get().log(4, "Callback failure for " + RealCall.this.toLoggableString(), e);
                } else {
                    this.responseCallback.onFailure(RealCall.this, e);
                }
            }
            finally {
                RealCall.this.client.dispatcher().finished(this);
            }
        }
    }
}

