/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.http.utils;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.mistyrain.http.builder.OKHttpFileBuilder;
import com.mistyrain.http.builder.OKHttpGetBuilder;
import com.mistyrain.http.builder.OKHttpPostBuilder;
import com.mistyrain.http.builder.OKHttpPostFormBuilder;
import com.mistyrain.http.builder.OKHttpPostStringBuilder;
import com.mistyrain.http.callback.Callback;
import com.mistyrain.http.cookie.BaseCookieJar;
import com.mistyrain.http.https.HttpsUtils;
import com.mistyrain.http.request.RequestCall;
import com.mistyrain.okhttp.Call;
import com.mistyrain.okhttp.CookieJar;
import com.mistyrain.okhttp.OkHttpClient;
import com.mistyrain.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class OkHttpUtils {
    public static final String TAG = OkHttpUtils.class.getSimpleName();
    public static final long DEFAULT_MILLISECONDS = 10000L;
    private static OkHttpUtils mInstance;
    private OkHttpClient mOkHttpClient;
    private Handler mDelivery;
    private boolean debug;
    private String tag;

    private OkHttpUtils() {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.cookieJar((CookieJar)new BaseCookieJar());
        this.mDelivery = new Handler(Looper.getMainLooper());
        okHttpClientBuilder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        this.mOkHttpClient = okHttpClientBuilder.build();
    }

    public OkHttpUtils debug(String tag) {
        this.debug = true;
        this.tag = tag;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpUtils getInstance() {
        if (mInstance != null) return mInstance;
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            if (mInstance != null) return mInstance;
            mInstance = new OkHttpUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public Handler getDelivery() {
        return this.mDelivery;
    }

    public OkHttpClient getOkHttpClient() {
        return this.mOkHttpClient;
    }

    public OKHttpGetBuilder get() {
        return new OKHttpGetBuilder();
    }

    public OKHttpPostStringBuilder postString() {
        return new OKHttpPostStringBuilder();
    }

    public OKHttpFileBuilder file() {
        return new OKHttpFileBuilder();
    }

    public OKHttpPostBuilder post() {
        return new OKHttpPostBuilder();
    }

    public OKHttpPostFormBuilder postFrom() {
        return new OKHttpPostFormBuilder();
    }

    public void execute(RequestCall requestCall, Callback callback) {
        if (this.debug) {
            if (TextUtils.isEmpty((CharSequence)this.tag)) {
                this.tag = TAG;
            }
            Log.d((String)this.tag, (String)("{method:" + requestCall.getRequest().method() + ", detail:" + requestCall.getOkHttpRequest().toString() + "}"));
        }
        if (callback == null) {
            callback = Callback.CALLBACK_DEFAULT;
        }
        final Callback finalCallback = callback;
        requestCall.getCall().enqueue(new com.mistyrain.okhttp.Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpUtils.this.sendFailResultCallback(call, e, finalCallback);
            }

            public void onResponse(Call call, Response response) {
                if (response.code() >= 400 && response.code() <= 599) {
                    try {
                        OkHttpUtils.this.sendFailResultCallback(call, response, new RuntimeException(response.body().string()), finalCallback);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                try {
                    Object o = finalCallback.parseNetworkResponse(response);
                    OkHttpUtils.this.sendSuccessResultCallback(o, finalCallback);
                }
                catch (Exception e) {
                    OkHttpUtils.this.sendFailResultCallback(call, response, e, finalCallback);
                }
            }
        });
    }

    public void sendFailResultCallback(final Call call, final Response response, final Exception e, final Callback callback) {
        if (callback == null) {
            return;
        }
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                callback.onError(call, response, e);
                callback.onAfter();
            }
        });
    }

    public void sendFailResultCallback(final Call call, final Exception e, final Callback callback) {
        if (callback == null) {
            return;
        }
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                callback.onError(call, e);
                callback.onAfter();
            }
        });
    }

    public void sendSuccessResultCallback(final Object object, final Callback callback) {
        if (callback == null) {
            return;
        }
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                callback.onResponse(object);
                callback.onAfter();
            }
        });
    }

    public void cancelTag(Object tag) {
        for (Call call : this.mOkHttpClient.dispatcher().queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : this.mOkHttpClient.dispatcher().runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    public void setCertificates(InputStream ... certificates) {
        this.mOkHttpClient = this.getOkHttpClient().newBuilder().sslSocketFactory(HttpsUtils.getSslSocketFactory(certificates, null, null)).build();
    }

    public void setConnectTimeout(int timeout, TimeUnit units) {
        this.mOkHttpClient = this.getOkHttpClient().newBuilder().connectTimeout((long)timeout, units).build();
    }
}

