/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.http.request;

import com.mistyrain.http.body.CountingRequestBody;
import com.mistyrain.http.callback.Callback;
import com.mistyrain.http.config.FileInput;
import com.mistyrain.http.request.OKHttpRequest;
import com.mistyrain.http.utils.OkHttpUtils;
import com.mistyrain.okhttp.FormBody;
import com.mistyrain.okhttp.Headers;
import com.mistyrain.okhttp.MediaType;
import com.mistyrain.okhttp.MultipartBody;
import com.mistyrain.okhttp.Request;
import com.mistyrain.okhttp.RequestBody;
import java.io.File;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

public class OKHttpPostRequest
extends OKHttpRequest {
    private List<FileInput> files;

    public OKHttpPostRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, List<FileInput> files) {
        super(url, tag, params, headers);
        this.files = files;
    }

    @Override
    protected RequestBody buildRequestBody() {
        if (this.files == null || this.files.isEmpty()) {
            FormBody.Builder builder = new FormBody.Builder();
            this.addParams(builder);
            return builder.build();
        }
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        this.addParams(builder);
        for (int i = 0; i < this.files.size(); ++i) {
            FileInput fileInput = this.files.get(i);
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)this.guessMimeType(fileInput.file.getName())), (File)fileInput.file);
            builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + fileInput.key + "\"; filename=\"" + fileInput.file.getName() + "\""}), fileBody);
        }
        return builder.build();
    }

    @Override
    protected RequestBody wrapRequestBody(RequestBody requestBody, final Callback callback) {
        if (callback == null) {
            return requestBody;
        }
        CountingRequestBody countingRequestBody = new CountingRequestBody(requestBody, new CountingRequestBody.Listener(){

            @Override
            public void onRequestProgress(final long bytesWritten, final long contentLength) {
                OkHttpUtils.getInstance().getDelivery().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.inProgress((float)bytesWritten * 1.0f / (float)contentLength);
                    }
                });
            }
        });
        return countingRequestBody;
    }

    @Override
    protected Request buildRequest(Request.Builder builder, RequestBody requestBody) {
        return builder.post(requestBody).build();
    }

    private String guessMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = fileNameMap.getContentTypeFor(path);
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    private void addParams(MultipartBody.Builder builder) {
        if (this.params != null && !this.params.isEmpty()) {
            for (String key : this.params.keySet()) {
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + key + "\""}), RequestBody.create(null, (String)((String)this.params.get(key))));
            }
        }
    }

    private void addParams(FormBody.Builder builder) {
        if (this.params == null || this.params.isEmpty()) {
            builder.add("1", "1");
            return;
        }
        for (String key : this.params.keySet()) {
            builder.add(key, (String)this.params.get(key));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.files != null) {
            for (FileInput file : this.files) {
                sb.append(file.toString() + "  ");
            }
        }
        return sb.toString();
    }
}

