/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.http.builder;

import com.mistyrain.http.builder.OKHttpRequestBuilder;
import com.mistyrain.http.request.OKHttpGetRequest;
import com.mistyrain.http.request.RequestCall;
import com.mistyrain.logger.LogProxy;
import java.util.LinkedHashMap;
import java.util.Map;

public class OKHttpGetBuilder
extends OKHttpRequestBuilder {
    private final String TAG = OKHttpGetBuilder.class.getSimpleName();

    @Override
    public RequestCall build() {
        if (this.params != null) {
            this.url = this.appendParams(this.url, this.params);
        }
        LogProxy.d((String)this.TAG, (String)this.url);
        return new OKHttpGetRequest(this.url, this.tag, this.params, this.headers).build();
    }

    private String appendParams(String url, Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        sb.append(url + "?");
        if (params != null && !params.isEmpty()) {
            for (String key : params.keySet()) {
                sb.append(key).append("=").append(params.get(key)).append("&");
            }
        }
        sb = sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public OKHttpGetBuilder url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public OKHttpGetBuilder tag(Object tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public OKHttpGetBuilder params(Map<String, String> params) {
        this.params = params;
        return this;
    }

    @Override
    public OKHttpGetBuilder addParams(String key, String val) {
        if (this.params == null) {
            this.params = new LinkedHashMap();
        }
        this.params.put(key, val);
        return this;
    }

    @Override
    public OKHttpGetBuilder headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    @Override
    public OKHttpGetBuilder addHeader(String key, String val) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap();
        }
        this.headers.put(key, val);
        return this;
    }
}

