/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.logger;

import com.mistyrain.logger.Logger;

public class LogProxy {
    private static boolean isDebug = true;
    private static String prefixName = "";

    public static void setDebugMode(boolean debug) {
        isDebug = debug;
    }

    public static void setPrefixName(String prefixName) {
        LogProxy.prefixName = prefixName;
    }

    private static String getLogTag(String tag) {
        return String.format("%s[%s]", prefixName, tag);
    }

    public static void d(String tag, String msg) {
        if (isDebug) {
            Logger.d(LogProxy.getLogTag(tag) + msg);
        }
    }

    public static void e(String tag, String msg) {
        if (isDebug) {
            Logger.e(LogProxy.getLogTag(tag) + msg, new Object[0]);
        }
    }

    public static void i(String tag, String msg) {
        if (isDebug) {
            Logger.i(LogProxy.getLogTag(tag) + msg, new Object[0]);
        }
    }

    public static void w(String tag, String msg) {
        if (isDebug) {
            Logger.w(LogProxy.getLogTag(tag) + msg, new Object[0]);
        }
    }

    public static void json(String msg) {
        if (isDebug) {
            Logger.json(msg);
        }
    }

    public static void xml(String msg) {
        if (isDebug) {
            Logger.xml(msg);
        }
    }

    public static void setGlobalTag(String tag) {
        if (isDebug) {
            Logger.init(tag);
        }
    }
}

