/*
 * Decompiled with CFR 0.152.
 */
package com.miquido.securitylib.modules;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.util.Base64;
import androidx.annotation.StringRes;
import com.miquido.securitylib.modules.SecurityModule;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/miquido/securitylib/modules/TamperProtectionModule;", "Lcom/miquido/securitylib/modules/SecurityModule;", "context", "Landroid/content/Context;", "apkSignature", "", "(Landroid/content/Context;I)V", "checkAppSignature", "", "appSignature", "", "execute", "", "callback", "Lkotlin/Function0;", "securitylib_release"})
public final class TamperProtectionModule
implements SecurityModule {
    private final Context context;
    private final int apkSignature;

    private final boolean checkAppSignature(String appSignature) {
        boolean success = true;
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 64);
            for (Signature signature : packageInfo.signatures) {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                String currentSignature = Base64.encodeToString((byte[])md.digest(), (int)0);
                if (!Intrinsics.areEqual((Object)appSignature, (Object)currentSignature)) continue;
                success = false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return success;
    }

    @Override
    public void execute(@Nullable Function0<Unit> callback) {
        block1: {
            String string = this.context.getString(this.apkSignature);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.getString(apkSignature)");
            if (!this.checkAppSignature(string)) break block1;
            Function0<Unit> function0 = callback;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
        }
    }

    public TamperProtectionModule(@NotNull Context context, @StringRes int apkSignature) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.apkSignature = apkSignature;
    }
}

