package com.miquido.securitylib.modules

import android.util.Log
import com.miquido.securitylib.SecurityLib

internal class LogsModule : SecurityModule {

    override fun execute(callback: (() -> Unit)?) {
        try {
            if (Class.forName("timber.log.Timber") == null) {
                throw IllegalStateException()
            }
        } catch (ex: Exception) {
            Log.e(SecurityLib.TAG, "No timber use found. Please consider using it.")
            callback?.invoke()
        }
    }


}
