package com.miquido.securitylib.modules

import android.content.Context
import com.miquido.securitylib.util.EmulatorDetector

internal class EmulatorModule(private val context: Context) : SecurityModule {
    private val emulatorDetector: EmulatorDetector = EmulatorDetector.with(context)

    override fun execute(callback: (() -> Unit)?) {
        emulatorDetector.detect(object : EmulatorDetector.OnEmulatorDetectorListener {
            override fun onResult(isEmulator: Boolean) {
                if (isEmulator) {
                    callback?.invoke()
                }
            }
        })
    }
}
