package com.miquido.securitylib.modules

import android.content.Context

internal class ApkModule(private val context: Context) : SecurityModule {

    private val trustedVendors = mutableSetOf(PLAY_STORE_APP_ID, AMAZON_STORE_APP_ID)

    fun addTrustedApkVendor(packageName: String) {
        trustedVendors.add(packageName)
    }

    override fun execute(callback: (() -> Unit)?) {
        val installer = context.packageManager.getInstallerPackageName(context.packageName)
        if (installer != null && trustedVendors.contains(installer)) {
            return
        }
        callback?.invoke()
    }

    companion object {
        private const val PLAY_STORE_APP_ID = "com.android.vending"
        private const val AMAZON_STORE_APP_ID = "com.amazon.venezia"
    }
}
