package com.miquido.securitylib

import android.app.Activity
import android.content.Context
import android.webkit.WebView
import androidx.annotation.StringRes
import com.miquido.securitylib.modules.ApkModule
import com.miquido.securitylib.modules.DebugModule
import com.miquido.securitylib.modules.EmulatorModule
import com.miquido.securitylib.modules.LogsModule
import com.miquido.securitylib.modules.PrngModule
import com.miquido.securitylib.modules.TamperProtectionModule
import com.miquido.securitylib.modules.WebViewModule
import com.miquido.securitylib.modules.WindowModule

class SecurityLib(private val context: Context) {

    private val apkModule = ApkModule(context)
    private val emulatorModule = EmulatorModule(context)
    private val debugModule = DebugModule(context)
    private val logsModule = LogsModule()
    private val prngModule = PrngModule()
    private val webViewModule = WebViewModule()
    private val windowModule = WindowModule()

    init {
        //todo run primary modules
    }

    fun checkApkSource(callback: Callback, vararg extraTrustedSources: String) = apply {
        extraTrustedSources.forEach { apkModule.addTrustedApkVendor(it) }
        apkModule.execute(callback)
    }

    fun checkEmulator(callback: Callback) = apply {
        emulatorModule.execute(callback)
    }

    fun checkTimber(callback: Callback?) = apply {
        logsModule.execute(callback)
    }

    fun usePrngFix() = apply {
        prngModule.execute()
    }

    fun checkApkSignature(@StringRes apkSignature: Int, callback: Callback) = apply {
        TamperProtectionModule(context, apkSignature).execute(callback)
    }

    fun checkIsDebug(callback: Callback?) = apply {
        debugModule.execute(callback)
    }

    fun setWindowFlagSecure(activity: Activity) = apply {
        windowModule.setWindowFlagSecure(activity)
    }

    fun disableRiskyWebViewSettings(webView: WebView) = apply {
        webViewModule.disableRiskySettings(webView)
    }

    companion object {
        const val TAG: String = "SecurityLib"
    }

}
typealias Callback = () -> Unit
