/*
 * Decompiled with CFR 0.152.
 */
package com.miquido.securitylib.util;

import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;

public final class PRNGFixes {
    private static final int VERSION_CODE_JELLY_BEAN = 16;
    private static final int VERSION_CODE_JELLY_BEAN_MR2 = 18;
    private static final byte[] BUILD_FINGERPRINT_AND_DEVICE_SERIAL = PRNGFixes.getBuildFingerprintAndDeviceSerial();

    private PRNGFixes() {
    }

    public static void apply() {
        PRNGFixes.applyOpenSSLFix();
        PRNGFixes.installLinuxPRNGSecureRandom();
    }

    private static void applyOpenSSLFix() throws SecurityException {
        if (Build.VERSION.SDK_INT < 16 || Build.VERSION.SDK_INT > 18) {
            return;
        }
        try {
            Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_seed", byte[].class).invoke(null, new Object[]{PRNGFixes.generateSeed()});
            int bytesRead = (Integer)Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_load_file", String.class, Long.TYPE).invoke(null, "/dev/urandom", 1024);
            if (bytesRead != 1024) {
                throw new IOException("Unexpected number of bytes read from Linux PRNG: " + bytesRead);
            }
        }
        catch (Exception e) {
            throw new SecurityException("Failed to seed OpenSSL PRNG", e);
        }
    }

    private static void installLinuxPRNGSecureRandom() throws SecurityException {
        SecureRandom rng2;
        SecureRandom rng1;
        if (Build.VERSION.SDK_INT > 18) {
            return;
        }
        Provider[] secureRandomProviders = Security.getProviders("SecureRandom.SHA1PRNG");
        if (secureRandomProviders == null || secureRandomProviders.length < 1 || !LinuxPRNGSecureRandomProvider.class.equals(secureRandomProviders[0].getClass())) {
            Security.insertProviderAt(new LinuxPRNGSecureRandomProvider(), 1);
        }
        if (!LinuxPRNGSecureRandomProvider.class.equals((rng1 = new SecureRandom()).getProvider().getClass())) {
            throw new SecurityException("new SecureRandom() backed by wrong Provider: " + rng1.getProvider().getClass());
        }
        try {
            rng2 = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("SHA1PRNG not available", e);
        }
        if (!LinuxPRNGSecureRandomProvider.class.equals(rng2.getProvider().getClass())) {
            throw new SecurityException("SecureRandom.getInstance(\"SHA1PRNG\") backed by wrong Provider: " + rng2.getProvider().getClass());
        }
    }

    private static byte[] generateSeed() {
        try {
            ByteArrayOutputStream seedBuffer = new ByteArrayOutputStream();
            DataOutputStream seedBufferOut = new DataOutputStream(seedBuffer);
            seedBufferOut.writeLong(System.currentTimeMillis());
            seedBufferOut.writeLong(System.nanoTime());
            seedBufferOut.writeInt(Process.myPid());
            seedBufferOut.writeInt(Process.myUid());
            seedBufferOut.write(BUILD_FINGERPRINT_AND_DEVICE_SERIAL);
            seedBufferOut.close();
            return seedBuffer.toByteArray();
        }
        catch (IOException e) {
            throw new SecurityException("Failed to generate seed", e);
        }
    }

    private static String getDeviceSerialNumber() {
        try {
            return (String)Build.class.getField("SERIAL").get(null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static byte[] getBuildFingerprintAndDeviceSerial() {
        String serial;
        StringBuilder result = new StringBuilder();
        String fingerprint = Build.FINGERPRINT;
        if (fingerprint != null) {
            result.append(fingerprint);
        }
        if ((serial = PRNGFixes.getDeviceSerialNumber()) != null) {
            result.append(serial);
        }
        try {
            return result.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
    }

    public static class LinuxPRNGSecureRandom
    extends SecureRandomSpi {
        private static final File URANDOM_FILE = new File("/dev/urandom");
        private static final Object sLock = new Object();
        private static DataInputStream sUrandomIn;
        private static OutputStream sUrandomOut;
        private boolean mSeeded;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineSetSeed(byte[] bytes) {
            try {
                OutputStream out;
                Object object = sLock;
                synchronized (object) {
                    out = this.getUrandomOutputStream();
                }
                out.write(bytes);
                out.flush();
            }
            catch (IOException e) {
                Log.w((String)PRNGFixes.class.getSimpleName(), (String)("Failed to mix seed into " + URANDOM_FILE));
            }
            finally {
                this.mSeeded = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineNextBytes(byte[] bytes) {
            if (!this.mSeeded) {
                this.engineSetSeed(PRNGFixes.generateSeed());
            }
            try {
                DataInputStream in;
                Object object = sLock;
                synchronized (object) {
                    in = this.getUrandomInputStream();
                }
                object = in;
                synchronized (object) {
                    in.readFully(bytes);
                }
            }
            catch (IOException e) {
                throw new SecurityException("Failed to read from " + URANDOM_FILE, e);
            }
        }

        @Override
        protected byte[] engineGenerateSeed(int size) {
            byte[] seed = new byte[size];
            this.engineNextBytes(seed);
            return seed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DataInputStream getUrandomInputStream() {
            Object object = sLock;
            synchronized (object) {
                if (sUrandomIn == null) {
                    try {
                        sUrandomIn = new DataInputStream(new FileInputStream(URANDOM_FILE));
                    }
                    catch (IOException e) {
                        throw new SecurityException("Failed to open " + URANDOM_FILE + " for reading", e);
                    }
                }
                return sUrandomIn;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OutputStream getUrandomOutputStream() throws IOException {
            Object object = sLock;
            synchronized (object) {
                if (sUrandomOut == null) {
                    sUrandomOut = new FileOutputStream(URANDOM_FILE);
                }
                return sUrandomOut;
            }
        }
    }

    private static class LinuxPRNGSecureRandomProvider
    extends Provider {
        public LinuxPRNGSecureRandomProvider() {
            super("LinuxPRNG", 1.0, "A Linux-specific random number provider that uses /dev/urandom");
            this.put("SecureRandom.SHA1PRNG", LinuxPRNGSecureRandom.class.getName());
            this.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
        }
    }
}

