/*
 * Decompiled with CFR 0.152.
 */
package com.miquido.securitylib.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 +2\u00020\u0001:\u0003+,-B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\fJ\u0014\u0010\u0011\u001a\u00020\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\b\u0010\u0014\u001a\u00020\u0006H\u0002J\b\u0010\u0015\u001a\u00020\u0006H\u0002J#\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0006H\u0002J\b\u0010\u001c\u001a\u00020\u0006H\u0002J\b\u0010\u001d\u001a\u00020\u0006H\u0002J\b\u0010\u001e\u001a\u00020\u0006H\u0002J\b\u0010\u001f\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"J\u001a\u0010#\u001a\u0004\u0018\u00010\f2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\fH\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\fH\u0002J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006."}, d2={"Lcom/miquido/securitylib/util/EmulatorDetector;", "", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isCheckPackage", "", "isDebug", "isSupportTelePhony", "()Z", "mListPackageName", "Ljava/util/ArrayList;", "", "packageNameList", "", "getPackageNameList", "()Ljava/util/List;", "addPackageName", "pPackageName", "pListPackageName", "checkAdvanced", "checkBasic", "checkFiles", "targets", "", "type", "([Ljava/lang/String;Ljava/lang/String;)Z", "checkIp", "checkPackageName", "checkQEmuDrivers", "checkQEmuProps", "detect", "", "pOnEmulatorDetectorListener", "Lcom/miquido/securitylib/util/EmulatorDetector$OnEmulatorDetectorListener;", "getProp", "context", "property", "log", "str", "setCheckPackage", "chkPackage", "setDebug", "Companion", "OnEmulatorDetectorListener", "Property", "securitylib_release"})
@TargetApi(value=14)
public final class EmulatorDetector {
    private boolean isDebug;
    private boolean isCheckPackage;
    private final ArrayList<String> mListPackageName;
    private final Context mContext;
    private static final String[] GENY_FILES;
    private static final String[] QEMU_DRIVERS;
    private static final String[] PIPES;
    private static final String[] X86_FILES;
    private static final String[] ANDY_FILES;
    private static final String[] NOX_FILES;
    private static final Property[] PROPERTIES;
    private static final String IP = "10.0.2.15";
    private static final int MIN_PROPERTIES_THRESHOLD = 5;
    @SuppressLint(value={"StaticFieldLeak"})
    private static EmulatorDetector mEmulatorDetector;
    public static final Companion Companion;

    @NotNull
    public final List<String> getPackageNameList() {
        return this.mListPackageName;
    }

    private final boolean isSupportTelePhony() {
        PackageManager packageManager = this.mContext.getPackageManager();
        boolean isSupport = packageManager.hasSystemFeature("android.hardware.telephony");
        this.log("Supported TelePhony: " + isSupport);
        return isSupport;
    }

    @NotNull
    public final EmulatorDetector setDebug(boolean isDebug) {
        this.isDebug = isDebug;
        return this;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    public final boolean isCheckPackage() {
        return this.isCheckPackage;
    }

    @NotNull
    public final EmulatorDetector setCheckPackage(boolean chkPackage) {
        this.isCheckPackage = chkPackage;
        return this;
    }

    @NotNull
    public final EmulatorDetector addPackageName(@NotNull String pPackageName) {
        Intrinsics.checkParameterIsNotNull((Object)pPackageName, (String)"pPackageName");
        this.mListPackageName.add(pPackageName);
        return this;
    }

    @NotNull
    public final EmulatorDetector addPackageName(@NotNull List<String> pListPackageName) {
        Intrinsics.checkParameterIsNotNull(pListPackageName, (String)"pListPackageName");
        this.mListPackageName.addAll((Collection<String>)pListPackageName);
        return this;
    }

    public final void detect(@Nullable OnEmulatorDetectorListener pOnEmulatorDetectorListener) {
        new Thread(new Runnable(this, pOnEmulatorDetectorListener){
            final /* synthetic */ EmulatorDetector this$0;
            final /* synthetic */ OnEmulatorDetectorListener $pOnEmulatorDetectorListener;

            public final void run() {
                block0: {
                    boolean isEmulator = EmulatorDetector.access$detect(this.this$0);
                    EmulatorDetector.access$log(this.this$0, "This System is Emulator: " + isEmulator);
                    OnEmulatorDetectorListener onEmulatorDetectorListener = this.$pOnEmulatorDetectorListener;
                    if (onEmulatorDetectorListener == null) break block0;
                    onEmulatorDetectorListener.onResult(isEmulator);
                }
            }
            {
                this.this$0 = emulatorDetector;
                this.$pOnEmulatorDetectorListener = onEmulatorDetectorListener;
            }
        }).start();
    }

    private final boolean detect() {
        boolean result = false;
        this.log(Companion.getDeviceInfo());
        result = this.checkBasic();
        this.log("Check basic " + result);
        if (!result) {
            result = this.checkAdvanced();
            this.log("Check Advanced " + result);
        }
        if (!result) {
            result = this.checkPackageName();
            this.log("Check Package Name " + result);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean checkBasic() {
        v0 = Build.FINGERPRINT;
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"Build.FINGERPRINT");
        if (StringsKt.startsWith$default((String)v0, (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v1 = Build.MODEL;
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"Build.MODEL");
        if (StringsKt.contains$default((CharSequence)v1, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v2 = Build.MODEL;
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"Build.MODEL");
        v3 = var2_1 = v2;
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v4 = v3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)v4, (CharSequence)"droid4x", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v5 = Build.MODEL;
        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"Build.MODEL");
        if (StringsKt.contains$default((CharSequence)v5, (CharSequence)"Emulator", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v6 = Build.MODEL;
        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"Build.MODEL");
        if (StringsKt.contains$default((CharSequence)v6, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v7 = Build.MANUFACTURER;
        Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"Build.MANUFACTURER");
        if (StringsKt.contains$default((CharSequence)v7, (CharSequence)"Genymotion", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)Build.HARDWARE, (Object)"goldfish") || Intrinsics.areEqual((Object)Build.HARDWARE, (Object)"vbox86") || Intrinsics.areEqual((Object)Build.PRODUCT, (Object)"sdk") || Intrinsics.areEqual((Object)Build.PRODUCT, (Object)"google_sdk") || Intrinsics.areEqual((Object)Build.PRODUCT, (Object)"sdk_x86") || Intrinsics.areEqual((Object)Build.PRODUCT, (Object)"vbox86p")) ** GOTO lbl-1000
        v8 = Build.BOARD;
        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"Build.BOARD");
        v9 = var2_1 = v8;
        if (v9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v10 = v9.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)v10, (CharSequence)"nox", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v11 = Build.BOOTLOADER;
        Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"Build.BOOTLOADER");
        v12 = var2_1 = v11;
        if (v12 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v13 = v12.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)v13, (CharSequence)"nox", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v14 = Build.HARDWARE;
        Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"Build.HARDWARE");
        v15 = var2_1 = v14;
        if (v15 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v16 = v15.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)v16, (CharSequence)"nox", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v17 = Build.PRODUCT;
        Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"Build.PRODUCT");
        v18 = var2_1 = v17;
        if (v18 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v19 = v18.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v19, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)v19, (CharSequence)"nox", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v20 = Build.SERIAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)v20, (String)"Build.SERIAL");
        v21 = var2_1 = v20;
        if (v21 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v22 = v21.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v22, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)v22, (CharSequence)"nox", (boolean)false, (int)2, null)) lbl-1000:
        // 11 sources

        {
            v23 = true;
        } else {
            v23 = result = false;
        }
        if (result) {
            return true;
        }
        v24 = Build.BRAND;
        Intrinsics.checkExpressionValueIsNotNull((Object)v24, (String)"Build.BRAND");
        if (!StringsKt.startsWith$default((String)v24, (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v25 = Build.DEVICE;
        Intrinsics.checkExpressionValueIsNotNull((Object)v25, (String)"Build.DEVICE");
        if (StringsKt.startsWith$default((String)v25, (String)"generic", (boolean)false, (int)2, null)) {
            v26 = true;
        } else lbl-1000:
        // 2 sources

        {
            v26 = false;
        }
        if (result |= v26) {
            return true;
        }
        return result |= Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT);
    }

    private final boolean checkAdvanced() {
        return this.checkFiles(GENY_FILES, "Geny") || this.checkFiles(ANDY_FILES, "Andy") || this.checkFiles(NOX_FILES, "Nox") || this.checkQEmuDrivers() || this.checkFiles(PIPES, "Pipes") || this.checkIp() || this.checkQEmuProps() && this.checkFiles(X86_FILES, "X86");
    }

    private final boolean checkPackageName() {
        if (!this.isCheckPackage || this.mListPackageName.isEmpty()) {
            return false;
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        for (String pkgName : this.mListPackageName) {
            List resolveInfos;
            Intent tryIntent = packageManager.getLaunchIntentForPackage(pkgName);
            if (tryIntent == null || (resolveInfos = packageManager.queryIntentActivities(tryIntent, 65536)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private final boolean checkQEmuDrivers() {
        for (File drivers_file : new File[]{new File("/proc/tty/drivers"), new File("/proc/cpuinfo")}) {
            if (!drivers_file.exists() || !drivers_file.canRead()) continue;
            byte[] data = new byte[1024];
            try {
                FileInputStream is = new FileInputStream(drivers_file);
                is.read(data);
                is.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String driver_data = new String(data, Charsets.UTF_8);
            for (String known_qemu_driver : QEMU_DRIVERS) {
                if (!StringsKt.contains$default((CharSequence)driver_data, (CharSequence)known_qemu_driver, (boolean)false, (int)2, null)) continue;
                this.log("Check QEmuDrivers is detected");
                return true;
            }
        }
        return false;
    }

    private final boolean checkFiles(String[] targets, String type) {
        for (String pipe : targets) {
            File qemu_file = new File(pipe);
            if (!qemu_file.exists()) continue;
            this.log("Check " + type + " is detected");
            return true;
        }
        return false;
    }

    private final boolean checkQEmuProps() {
        int found_props = 0;
        for (Property property : PROPERTIES) {
            String property_value = this.getProp(this.mContext, property.getName());
            if (property.getSeek_value() == null && property_value != null) {
                ++found_props;
            }
            if (property.getSeek_value() == null) continue;
            String string = property_value;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            CharSequence charSequence = string;
            String string2 = property.getSeek_value();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
            ++found_props;
        }
        if (found_props >= MIN_PROPERTIES_THRESHOLD) {
            this.log("Check QEmuProps is detected");
            return true;
        }
        return false;
    }

    private final boolean checkIp() {
        boolean ipDetected = false;
        if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.INTERNET") == 0) {
            Object re;
            Object in;
            String[] args = new String[]{"/system/bin/netcfg"};
            StringBuilder stringBuilder = new StringBuilder();
            try {
                Process process;
                ProcessBuilder builder = new ProcessBuilder(Arrays.copyOf(args, args.length));
                builder.directory(new File("/system/bin/"));
                builder.redirectErrorStream(true);
                Process process2 = process = builder.start();
                Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"process");
                in = process2.getInputStream();
                re = new byte[1024];
                while (((InputStream)in).read((byte[])re) != -1) {
                    StringBuilder stringBuilder2 = stringBuilder;
                    String string = new String((byte[])re, Charsets.UTF_8);
                    stringBuilder2.append(string);
                }
                ((InputStream)in).close();
            }
            catch (Exception builder) {
                // empty catch block
            }
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stringBuilder.toString()");
            String netData = string;
            this.log("netcfg data -> " + netData);
            if (!TextUtils.isEmpty((CharSequence)netData)) {
                String[] array;
                List list;
                Collection $receiver$iv;
                in = netData;
                re = "\n";
                re = new Regex((String)re);
                int n = 0;
                in = re.split((CharSequence)in, n);
                if (!$receiver$iv.isEmpty()) {
                    ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        CharSequence charSequence = it;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $receiver$iv = list;
                Collection collection = $receiver$iv;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                for (String lan : array = stringArray) {
                    if (!StringsKt.contains$default((CharSequence)lan, (CharSequence)"wlan0", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)lan, (CharSequence)"tunl0", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)lan, (CharSequence)"eth0", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)lan, (CharSequence)IP, (boolean)false, (int)2, null)) continue;
                    ipDetected = true;
                    this.log("Check IP is detected");
                    break;
                }
            }
        }
        return ipDetected;
    }

    private final String getProp(Context context, String property) {
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> systemProperties = classLoader.loadClass("android.os.SystemProperties");
            Method get = systemProperties.getMethod("get", String.class);
            Object[] params = new Object[]{property};
            Object object = get.invoke(systemProperties, Arrays.copyOf(params, params.length));
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            return (String)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final void log(String str) {
        if (this.isDebug) {
            Log.d((String)this.getClass().getName(), (String)str);
        }
    }

    private EmulatorDetector(Context mContext) {
        this.mContext = mContext;
        this.isCheckPackage = true;
        this.mListPackageName = new ArrayList();
        this.mListPackageName.add("com.google.android.launcher.layouts.genymotion");
        this.mListPackageName.add("com.bluestacks");
        this.mListPackageName.add("com.bignox.app");
    }

    static {
        Companion = new Companion(null);
        GENY_FILES = new String[]{"/dev/socket/genyd", "/dev/socket/baseband_genyd"};
        QEMU_DRIVERS = new String[]{"goldfish"};
        PIPES = new String[]{"/dev/socket/qemud", "/dev/qemu_pipe"};
        X86_FILES = new String[]{"ueventd.android_x86.rc", "x86.prop", "ueventd.ttVM_x86.rc", "init.ttVM_x86.rc", "fstab.ttVM_x86", "fstab.vbox86", "init.vbox86.rc", "ueventd.vbox86.rc"};
        ANDY_FILES = new String[]{"fstab.andy", "ueventd.andy.rc"};
        NOX_FILES = new String[]{"fstab.nox", "init.nox.rc", "ueventd.nox.rc"};
        PROPERTIES = new Property[]{new Property("init.svc.qemud", null), new Property("init.svc.qemu-props", null), new Property("qemu.hw.mainkeys", null), new Property("qemu.sf.fake_camera", null), new Property("qemu.sf.lcd_density", null), new Property("ro.bootloader", "unknown"), new Property("ro.bootmode", "unknown"), new Property("ro.hardware", "goldfish"), new Property("ro.kernel.android.qemud", null), new Property("ro.kernel.qemu.gles", null), new Property("ro.kernel.qemu", "1"), new Property("ro.product.device", "generic"), new Property("ro.product.model", "sdk"), new Property("ro.product.name", "sdk"), new Property("ro.serialno", null)};
        IP = IP;
        MIN_PROPERTIES_THRESHOLD = 5;
    }

    public static final /* synthetic */ boolean access$detect(EmulatorDetector $this) {
        return $this.detect();
    }

    public static final /* synthetic */ void access$log(EmulatorDetector $this, @NotNull String str) {
        $this.log(str);
    }

    public /* synthetic */ EmulatorDetector(@NotNull Context mContext, DefaultConstructorMarker $constructor_marker) {
        this(mContext);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/miquido/securitylib/util/EmulatorDetector$OnEmulatorDetectorListener;", "", "onResult", "", "isEmulator", "", "securitylib_release"})
    public static interface OnEmulatorDetectorListener {
        public void onResult(boolean var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/miquido/securitylib/util/EmulatorDetector$Property;", "", "name", "", "seek_value", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getSeek_value", "setSeek_value", "securitylib_release"})
    private static final class Property {
        @NotNull
        private String name;
        @Nullable
        private String seek_value;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @Nullable
        public final String getSeek_value() {
            return this.seek_value;
        }

        public final void setSeek_value(@Nullable String string) {
            this.seek_value = string;
        }

        public Property(@NotNull String name, @Nullable String seek_value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.name = name;
            this.seek_value = seek_value;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/miquido/securitylib/util/EmulatorDetector$Companion;", "", "()V", "ANDY_FILES", "", "", "[Ljava/lang/String;", "GENY_FILES", "IP", "MIN_PROPERTIES_THRESHOLD", "", "NOX_FILES", "PIPES", "PROPERTIES", "Lcom/miquido/securitylib/util/EmulatorDetector$Property;", "[Lcom/miquido/securitylib/util/EmulatorDetector$Property;", "QEMU_DRIVERS", "X86_FILES", "deviceInfo", "getDeviceInfo", "()Ljava/lang/String;", "mEmulatorDetector", "Lcom/miquido/securitylib/util/EmulatorDetector;", "with", "pContext", "Landroid/content/Context;", "securitylib_release"})
    public static final class Companion {
        @NotNull
        public final EmulatorDetector with(@Nullable Context pContext) {
            if (pContext == null) {
                throw (Throwable)new IllegalArgumentException("Context must not be null.");
            }
            if (mEmulatorDetector == null) {
                Context context = pContext.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"pContext.applicationContext");
                mEmulatorDetector = new EmulatorDetector(context, null);
            }
            EmulatorDetector emulatorDetector = mEmulatorDetector;
            if (emulatorDetector == null) {
                Intrinsics.throwNpe();
            }
            return emulatorDetector;
        }

        @NotNull
        public final String getDeviceInfo() {
            return "Build.PRODUCT: " + Build.PRODUCT + "\n" + "Build.MANUFACTURER: " + Build.MANUFACTURER + "\n" + "Build.BRAND: " + Build.BRAND + "\n" + "Build.DEVICE: " + Build.DEVICE + "\n" + "Build.MODEL: " + Build.MODEL + "\n" + "Build.HARDWARE: " + Build.HARDWARE + "\n" + "Build.FINGERPRINT: " + Build.FINGERPRINT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

