/*
 * Decompiled with CFR 0.152.
 */
package com.miquido.securitylib;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.StringRes;
import android.webkit.WebView;
import com.miquido.securitylib.modules.ApkModule;
import com.miquido.securitylib.modules.DebugModule;
import com.miquido.securitylib.modules.EmulatorModule;
import com.miquido.securitylib.modules.LogsModule;
import com.miquido.securitylib.modules.PrngModule;
import com.miquido.securitylib.modules.SecurityModule;
import com.miquido.securitylib.modules.TamperProtectionModule;
import com.miquido.securitylib.modules.WebViewModule;
import com.miquido.securitylib.modules.WindowModule;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0013\u001a\u00020\u00002\b\b\u0001\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J-\u0010\u0019\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\"\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u001e\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0016\u0010\u001f\u001a\u00020\u00182\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017J\u0016\u0010 \u001a\u00020\u00002\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/miquido/securitylib/SecurityLib;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "apkModule", "Lcom/miquido/securitylib/modules/ApkModule;", "debugModule", "Lcom/miquido/securitylib/modules/DebugModule;", "emulatorModule", "Lcom/miquido/securitylib/modules/EmulatorModule;", "logsModule", "Lcom/miquido/securitylib/modules/LogsModule;", "prngModule", "Lcom/miquido/securitylib/modules/PrngModule;", "webViewModule", "Lcom/miquido/securitylib/modules/WebViewModule;", "windowModule", "Lcom/miquido/securitylib/modules/WindowModule;", "checkApkSignature", "apkSignature", "", "callback", "Lkotlin/Function0;", "", "checkApkSource", "extraTrustedSources", "", "", "(Lkotlin/jvm/functions/Function0;[Ljava/lang/String;)Lcom/miquido/securitylib/SecurityLib;", "checkEmulator", "checkIsDebug", "checkTimber", "disableRiskyWebViewSettings", "webView", "Landroid/webkit/WebView;", "setWindowFlagSecure", "activity", "Landroid/app/Activity;", "usePrngFix", "Companion", "securitylib_release"})
public final class SecurityLib {
    private final ApkModule apkModule;
    private final EmulatorModule emulatorModule;
    private final DebugModule debugModule;
    private final LogsModule logsModule;
    private final PrngModule prngModule;
    private final WebViewModule webViewModule;
    private final WindowModule windowModule;
    private final Context context;
    @NotNull
    public static final String TAG = "SecurityLib";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SecurityLib checkApkSource(@NotNull Function0<Unit> callback, String ... extraTrustedSources) {
        String[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Intrinsics.checkParameterIsNotNull((Object)extraTrustedSources, (String)"extraTrustedSources");
        String[] stringArray = $receiver$iv = extraTrustedSources;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = stringArray[i];
            this.apkModule.addTrustedApkVendor(it);
        }
        this.apkModule.execute(callback);
        return this;
    }

    @NotNull
    public final SecurityLib checkEmulator(@NotNull Function0<Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.emulatorModule.execute(callback);
        return this;
    }

    @NotNull
    public final SecurityLib checkTimber(@Nullable Function0<Unit> callback) {
        this.logsModule.execute(callback);
        return this;
    }

    @NotNull
    public final SecurityLib usePrngFix() {
        SecurityModule.DefaultImpls.execute$default(this.prngModule, null, 1, null);
        return this;
    }

    @NotNull
    public final SecurityLib checkApkSignature(@StringRes int apkSignature, @NotNull Function0<Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new TamperProtectionModule(this.context, apkSignature).execute(callback);
        return this;
    }

    public final void checkIsDebug(@Nullable Function0<Unit> callback) {
        this.debugModule.execute(callback);
    }

    @NotNull
    public final SecurityLib setWindowFlagSecure(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        this.windowModule.setWindowFlagSecure(activity);
        return this;
    }

    @NotNull
    public final SecurityLib disableRiskyWebViewSettings(@NotNull WebView webView) {
        Intrinsics.checkParameterIsNotNull((Object)webView, (String)"webView");
        this.webViewModule.disableRiskySettings(webView);
        return this;
    }

    public SecurityLib(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.apkModule = new ApkModule(this.context);
        this.emulatorModule = new EmulatorModule(this.context);
        this.debugModule = new DebugModule(this.context);
        this.logsModule = new LogsModule();
        this.prngModule = new PrngModule();
        this.webViewModule = new WebViewModule();
        this.windowModule = new WindowModule();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/miquido/securitylib/SecurityLib$Companion;", "", "()V", "TAG", "", "securitylib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

