package com.miquido.securitylib.modules

import android.content.Context
import android.content.pm.PackageManager
import android.support.annotation.StringRes
import android.util.Base64
import java.security.MessageDigest

internal class TamperProtectionModule(private val context: Context, @StringRes private val apkSignature : Int) : SecurityModule {
    private fun checkAppSignature(appSignature: String): Boolean {
        var success = true
        try {
            val packageInfo = context.packageManager
                    .getPackageInfo(context.packageName, PackageManager.GET_SIGNATURES)

            for (signature in packageInfo.signatures) {
                val md = MessageDigest.getInstance("SHA")
                md.update(signature.toByteArray())

                val currentSignature = Base64.encodeToString(md.digest(), Base64.DEFAULT)

                //compare signatures
                if (appSignature == currentSignature) {
                    success = false
                }
            }
        } catch (e: Exception) {
            return false
        }
        return success
    }

    override fun execute(callback: (() -> Unit)?) {
        if(checkAppSignature(context.getString(apkSignature))) {
            callback?.invoke()
        }
    }
}