package com.miquido.securitylib.modules

import android.content.Context
import android.content.pm.ApplicationInfo
import android.os.Debug

internal class DebugModule(private val context : Context) : SecurityModule {

    override fun execute(callback: (() -> Unit)?) {
        val isDebuggable =  ( 0 != ( context.applicationInfo.flags and ApplicationInfo.FLAG_DEBUGGABLE ) )
        val isDebuggerAttached = Debug.isDebuggerConnected()
        if(isDebuggable || isDebuggerAttached) {
            callback?.invoke()
        }
    }
}