package com.miquido.securitylib

import android.app.Activity
import android.content.Context
import android.support.annotation.StringRes
import android.webkit.WebView
import com.miquido.securitylib.modules.*

class SecurityLib(private val context : Context) {

    private val apkModule = ApkModule(context)
    private val emulatorModule = EmulatorModule(context)
    private val debugModule = DebugModule(context)
    private val logsModule = LogsModule()
    private val prngModule = PrngModule()
    private val webViewModule = WebViewModule()
    private val windowModule = WindowModule()

    init {
        //todo run primary modules
    }

    fun checkApkSource(callback: (() -> Unit), vararg extraTrustedSources : String) : SecurityLib {
        extraTrustedSources.forEach { apkModule.addTrustedApkVendor(it) }
        apkModule.execute(callback)
        return this
    }

    fun checkEmulator(callback: (() -> Unit)) : SecurityLib {
        emulatorModule.execute(callback)
        return this
    }

    fun checkTimber(callback: (() -> Unit)?) : SecurityLib {
        logsModule.execute(callback)
        return this
    }

    fun usePrngFix() : SecurityLib {
        prngModule.execute()
        return this
    }

    fun checkApkSignature(@StringRes apkSignature : Int, callback: (() -> Unit)) : SecurityLib {
        TamperProtectionModule(context, apkSignature).execute(callback)
        return this
    }

    fun checkIsDebug(callback: (() -> Unit)?) {
        debugModule.execute(callback)
    }

    fun setWindowFlagSecure(activity : Activity) : SecurityLib {
        windowModule.setWindowFlagSecure(activity)
        return this
    }

    fun disableRiskyWebViewSettings(webView : WebView) : SecurityLib {
        webViewModule.disableRiskySettings(webView)
        return this
    }

    companion object {
        const val TAG : String = "SecurityLib"
    }

}