/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.adapter.rewardadapter;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.mintegral.adapter.common.AdapterTools;
import com.mintegral.adapter.manager.MintegralHandlerManager;
import com.mintegral.adapter.rewardadapter.MediationRewardVideoEventForwarder;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGRewardVideoHandler;
import com.mintegral.msdk.system.a;
import com.mintegral.msdk.video.bt.module.b.g;
import java.util.Map;
import org.json.JSONObject;

public class MTGToAdmobRewardVideoAdapter
implements MediationRewardedVideoAdAdapter {
    private String TAG = "MTGToAdmobRewardVideoAdapter";
    private MTGRewardVideoHandler mMvRewardVideoHandler;
    private String mAPPID = "";
    private String mAPPKey = "";
    private String mRewardUnitId = "";
    private String mRewardId = "";
    private String mUserId = "";
    private String mPlacementId = "";
    static boolean hasInitMintegralSDK;
    private Context mContext;
    private MediationRewardedVideoAdListener mMediationRewardedVideoAdListener;
    private MediationRewardVideoEventForwarder mediationRewardVideoEventForwarder;

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
    }

    private void parseAuthority(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
    }

    private void parseServiceString(String serviceString) {
        if (TextUtils.isEmpty((CharSequence)serviceString)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(serviceString);
            String appId = jsonObject.optString("appId");
            String appKey = jsonObject.optString("appKey");
            String unitId = jsonObject.optString("unitId");
            String rewardId = jsonObject.optString("rewardId");
            String placementId = jsonObject.optString("placementId");
            if (!TextUtils.isEmpty((CharSequence)appId)) {
                this.mAPPID = appId;
            }
            if (!TextUtils.isEmpty((CharSequence)appKey)) {
                this.mAPPKey = appKey;
            }
            if (!TextUtils.isEmpty((CharSequence)unitId)) {
                this.mRewardUnitId = unitId;
            }
            if (!TextUtils.isEmpty((CharSequence)rewardId)) {
                this.mRewardId = rewardId;
            }
            if (!TextUtils.isEmpty((CharSequence)placementId)) {
                this.mPlacementId = placementId;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize(Context context, MediationAdRequest mediationAdRequest, String s, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle1) {
        this.mContext = context;
        this.mMediationRewardedVideoAdListener = mediationRewardedVideoAdListener;
        String serviceString = bundle.getString("parameter");
        this.parseServiceString(serviceString);
        if (bundle1 != null && !TextUtils.isEmpty((CharSequence)bundle1.getCharSequence("userId"))) {
            this.mUserId = bundle1.getCharSequence("userId").toString();
        }
        if (TextUtils.isEmpty((CharSequence)this.mAPPID) || TextUtils.isEmpty((CharSequence)this.mAPPKey)) {
            mediationRewardedVideoAdListener.onInitializationFailed((MediationRewardedVideoAdAdapter)this, 1);
            return;
        }
        AdapterTools.addChannel();
        this.initSDK(context);
        if (!(context instanceof Activity)) {
            mediationRewardedVideoAdListener.onInitializationFailed((MediationRewardedVideoAdAdapter)this, 1);
            return;
        }
        mediationRewardedVideoAdListener.onInitializationSucceeded((MediationRewardedVideoAdAdapter)this);
        this.mediationRewardVideoEventForwarder = new MediationRewardVideoEventForwarder(this.mMediationRewardedVideoAdListener, this);
    }

    private void initSDK(Context context) {
        if (!hasInitMintegralSDK) {
            a sdk = MIntegralSDKFactory.getMIntegralSDK();
            Map map = sdk.getMTGConfigurationMap(this.mAPPID, this.mAPPKey);
            sdk.init(map, context.getApplicationContext());
            hasInitMintegralSDK = true;
            Log.e((String)this.TAG, (String)("hasInitMintegralSDK:" + hasInitMintegralSDK));
        }
    }

    public boolean isInitialized() {
        return this.mMvRewardVideoHandler != null;
    }

    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle1) {
        if (this.mContext != null) {
            String serviceString = bundle.getString("parameter");
            this.parseServiceString(serviceString);
            this.mMvRewardVideoHandler = MintegralHandlerManager.getInstance().getMTGRewardVideoHandler(this.mRewardUnitId);
            if (this.mMvRewardVideoHandler == null) {
                this.mMvRewardVideoHandler = new MTGRewardVideoHandler((Context)((Activity)this.mContext), this.mPlacementId, this.mRewardUnitId);
                MintegralHandlerManager.getInstance().addMTGRewardVideoHandler(this.mRewardUnitId, this.mMvRewardVideoHandler);
            }
            if (this.mMvRewardVideoHandler != null) {
                this.mMvRewardVideoHandler.setRewardVideoListener((g)this.mediationRewardVideoEventForwarder);
                this.mMvRewardVideoHandler.load();
            }
        }
    }

    public void showVideo() {
        this.mMvRewardVideoHandler.show(this.mRewardId, this.mUserId);
    }

    public boolean canShow() {
        if (this.mMvRewardVideoHandler != null) {
            return this.mMvRewardVideoHandler.isReady();
        }
        return false;
    }
}

