/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.adapter.interstitialvideoanativedapter;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitial;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitialListener;
import com.mintegral.adapter.common.AdapterTools;
import com.mintegral.adapter.manager.MintegralHandlerManager;
import com.mintegral.msdk.interstitialvideo.out.InterstitialVideoListener;
import com.mintegral.msdk.interstitialvideo.out.MTGInterstitialVideoHandler;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.system.a;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class MintegralCustomEventInterstitialVideoNative
implements CustomEventInterstitial,
InterstitialVideoListener {
    private MTGInterstitialVideoHandler mInterstitialHandler;
    private String mAppId = "";
    private String mAppKey = "";
    private String mUnitId = "";
    private String mRewardId = "";
    private String mPackageName = "";
    private String mPlacementId = "";
    private static String TAG = MintegralCustomEventInterstitialVideoNative.class.getSimpleName();
    private CustomEventInterstitialListener mCustomEventInterstitialListener;
    private static boolean hasInitMintegralSDK = false;

    public void requestInterstitialAd(Context context, CustomEventInterstitialListener customEventInterstitialListener, String s, MediationAdRequest mediationAdRequest, Bundle bundle) {
        Log.e((String)TAG, (String)"hasInitMintegralSDK:requestInterstitialAd\u3002");
        this.mCustomEventInterstitialListener = customEventInterstitialListener;
        this.parseServer(context, s);
        this.parseBunld(bundle);
        if (TextUtils.isEmpty((CharSequence)this.mAppId) || TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            if (customEventInterstitialListener != null) {
                customEventInterstitialListener.onAdFailedToLoad(1);
            }
            return;
        }
        if (!hasInitMintegralSDK) {
            AdapterTools.addChannel();
            a sdk = MIntegralSDKFactory.getMIntegralSDK();
            Map map = sdk.getMTGConfigurationMap(this.mAppId, this.mAppKey);
            sdk.init(map, context.getApplicationContext());
            hasInitMintegralSDK = true;
            Log.e((String)TAG, (String)("hasInitMintegralSDK:" + hasInitMintegralSDK));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("unit_id", this.mUnitId);
        if (context instanceof Activity) {
            this.mInterstitialHandler = MintegralHandlerManager.getInstance().getMTGInterstitialVideoHandler(this.mUnitId);
            if (this.mInterstitialHandler == null) {
                this.mInterstitialHandler = new MTGInterstitialVideoHandler((Context)((Activity)context), this.mPlacementId, this.mUnitId);
                MintegralHandlerManager.getInstance().addMTGInterstitialVideoHandler(this.mUnitId, this.mInterstitialHandler);
            }
            if (this.mInterstitialHandler != null) {
                this.mInterstitialHandler.setRewardVideoListener((InterstitialVideoListener)this);
            }
        } else {
            return;
        }
        this.mInterstitialHandler.load();
    }

    private void parseServer(Context context, String s) {
        if (!TextUtils.isEmpty((CharSequence)s)) {
            try {
                JSONObject jo = new JSONObject(s);
                if (jo != null) {
                    String appId = jo.getString("appId");
                    String appKey = jo.getString("appKey");
                    String unitId = jo.getString("unitId");
                    String placementId = jo.optString("placementId");
                    if (!TextUtils.isEmpty((CharSequence)appId)) {
                        this.mAppId = appId;
                    }
                    if (!TextUtils.isEmpty((CharSequence)appKey)) {
                        this.mAppKey = appKey;
                    }
                    if (!TextUtils.isEmpty((CharSequence)unitId)) {
                        this.mUnitId = unitId;
                    }
                    if (!TextUtils.isEmpty((CharSequence)placementId)) {
                        this.mPlacementId = placementId;
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)"", (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void parseBunld(Bundle bundle) {
        if (bundle != null && bundle.get("packageName") != null) {
            this.mPackageName = bundle.get("packageName").toString();
        }
    }

    public void showInterstitial() {
        this.mInterstitialHandler.show();
    }

    public void onDestroy() {
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onVideoLoadSuccess(String placementID, String s) {
        this.mCustomEventInterstitialListener.onAdLoaded();
    }

    public void onVideoLoadFail(String s) {
        this.mCustomEventInterstitialListener.onAdFailedToLoad(3);
    }

    public void onAdShow() {
        this.mCustomEventInterstitialListener.onAdOpened();
    }

    public void onAdClose(boolean isCompleteView) {
        this.mCustomEventInterstitialListener.onAdClosed();
    }

    public void onShowFail(String s) {
    }

    public void onVideoAdClicked(String placementID, String s) {
        this.mCustomEventInterstitialListener.onAdClicked();
    }

    public void onLoadSuccess(String placementID, String s) {
    }

    public void onEndcardShow(String placementID, String s) {
    }

    public void onVideoComplete(String placementID, String s) {
    }

    public void onAdCloseWithIVReward(boolean b, int i) {
    }
}

