/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.adapter.nativeadapter;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventNative;
import com.google.android.gms.ads.mediation.customevent.CustomEventNativeListener;
import com.mintegral.adapter.common.AdapterTools;
import com.mintegral.adapter.nativeadapter.CustomNativeEventForwarder;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MtgNativeHandler;
import com.mintegral.msdk.out.NativeListener;
import com.mintegral.msdk.system.a;
import java.util.Map;
import org.json.JSONObject;

public class MintegralCustomEventNative
implements CustomEventNative {
    private String appId = "";
    private String appKey = "";
    private String unitId = "";
    private MtgNativeHandler mNativeHandle;
    private String userId = "";
    private NativeMediationAdRequest nativeMediationAdRequest;
    private static boolean hasInitMintegralSDK = false;

    public void requestNativeAd(Context context, CustomEventNativeListener customEventNativeListener, String s, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle) {
        this.parseServer(context, s);
        this.parseNativeMediation(nativeMediationAdRequest);
        if (!hasInitMintegralSDK) {
            this.initMobvistaSDK(context);
            hasInitMintegralSDK = true;
        }
        this.loadMintegralAds(context, customEventNativeListener);
    }

    public void onDestroy() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    private void parseServer(Context context, String s) {
        if (!TextUtils.isEmpty((CharSequence)s)) {
            try {
                JSONObject jo = new JSONObject(s);
                if (jo != null) {
                    this.appId = jo.getString("appId");
                    this.appKey = jo.getString("appKey");
                    this.unitId = jo.getString("unitId");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parseNativeMediation(NativeMediationAdRequest nativeMediationAdRequest) {
        this.nativeMediationAdRequest = nativeMediationAdRequest;
    }

    private void initMobvistaSDK(Context context) {
        a sdk = MIntegralSDKFactory.getMIntegralSDK();
        if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.appKey)) {
            return;
        }
        Map map = sdk.getMTGConfigurationMap(this.appId, this.appKey);
        AdapterTools.addChannel();
        sdk.init(map, context);
    }

    private void loadMintegralAds(Context context, CustomEventNativeListener customEventNativeListener) {
        Map properties = MtgNativeHandler.getNativeProperties((String)this.unitId);
        properties.put("ad_num", 1);
        this.mNativeHandle = new MtgNativeHandler(properties, context);
        this.mNativeHandle.addTemplate(new NativeListener.Template(2, 1));
        this.mNativeHandle.setAdListener((NativeListener.NativeAdListener)new CustomNativeEventForwarder(customEventNativeListener, this.nativeMediationAdRequest, this.mNativeHandle, context));
        this.mNativeHandle.load();
    }
}

