/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.adapter.banneradapter;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventBanner;
import com.google.android.gms.ads.mediation.customevent.CustomEventBannerListener;
import com.mintegral.adapter.banneradapter.MintegralCustomBannerEventForwarder;
import com.mintegral.adapter.common.AdapterTools;
import com.mintegral.msdk.out.BannerAdListener;
import com.mintegral.msdk.out.BannerSize;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGBannerView;
import com.mintegral.msdk.system.a;
import java.util.Map;
import org.json.JSONObject;

public class MintegralCustomEventBanner
implements CustomEventBanner {
    private String appId = "";
    private String appKey = "";
    private String unitId = "";
    private String packageName = "";
    private MTGBannerView mtgBannerView;
    private static boolean hasInitSDK = false;
    private static final String TAG = "Banner";

    public void requestBannerAd(Context context, CustomEventBannerListener customEventBannerListener, String s, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle) {
        Log.e((String)TAG, (String)"requestBannerAd: ");
        this.parseServer(context, s);
        if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.appKey) || TextUtils.isEmpty((CharSequence)this.unitId)) {
            if (customEventBannerListener != null) {
                customEventBannerListener.onAdFailedToLoad(1);
            }
            return;
        }
        if (!hasInitSDK) {
            this.initSDK(context);
        }
        this.loadAds(context, customEventBannerListener, adSize);
    }

    public void onDestroy() {
        Log.e((String)TAG, (String)"onDes ");
        if (this.mtgBannerView != null) {
            Log.e((String)TAG, (String)"onDestroy: ");
            this.mtgBannerView.release();
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    private void parseServer(Context context, String s) {
        if (!TextUtils.isEmpty((CharSequence)s)) {
            try {
                JSONObject jo = new JSONObject(s);
                if (jo != null) {
                    this.appId = jo.getString("appId");
                    this.appKey = jo.getString("appKey");
                    this.unitId = jo.getString("unitId");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initSDK(Context context) {
        a sdk = MIntegralSDKFactory.getMIntegralSDK();
        Map map = sdk.getMTGConfigurationMap(this.appId, this.appKey);
        if (!TextUtils.isEmpty((CharSequence)this.packageName)) {
            map.put("applicationID", this.packageName);
        }
        AdapterTools.addChannel();
        sdk.init(map, context);
        hasInitSDK = true;
    }

    private void parseBunld(Bundle bundle) {
        if (bundle.get("packageName") != null) {
            this.packageName = bundle.get("packageName").toString();
        }
    }

    private void loadAds(Context context, CustomEventBannerListener customEventBannerListener, AdSize adSize) {
        int width = adSize.getWidth();
        int height = adSize.getHeight();
        Log.d((String)TAG, (String)("loadAds: adsize " + width + " " + height));
        final int w = adSize.getWidthInPixels(context);
        final int h = adSize.getHeightInPixels(context);
        this.mtgBannerView = new MTGBannerView(context);
        this.mtgBannerView.setVisibility(8);
        this.mtgBannerView.init(new BannerSize(5, width, height), this.unitId);
        this.mtgBannerView.setBannerAdListener((BannerAdListener)new MintegralCustomBannerEventForwarder(customEventBannerListener, this.mtgBannerView));
        this.mtgBannerView.load();
        this.mtgBannerView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ViewGroup.LayoutParams lp = MintegralCustomEventBanner.this.mtgBannerView.getLayoutParams();
                lp.width = w;
                lp.height = h;
                MintegralCustomEventBanner.this.mtgBannerView.setLayoutParams(lp);
            }
        });
    }
}

